/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.ide.configurations.yaml.highlighting;

import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.microservices.jvm.config.hints.HintReferenceBase;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import io.ktor.ide.configurations.meta.key.reference.value.env.KtorEnvVariableReference;
import io.ktor.ide.configurations.yaml.YamlConfigUtilsKt;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLHighlighter;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\"\u0010\u0010\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lio/ktor/ide/configurations/yaml/highlighting/KtorYamlAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "<init>", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "annotateSequence", "yamlSequence", "Lorg/jetbrains/yaml/psi/YAMLSequence;", "annotateValue", "yamlScalar", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "doAnnotate", "range", "Lcom/intellij/openapi/util/TextRange;", "key", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "intellij.ktor.starter"})
public final class KtorYamlAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!(element instanceof YAMLKeyValue) || !YamlConfigUtilsKt.isInsideKtorYamlFile(element)) {
            return;
        }
        YAMLValue yamlValue = ((YAMLKeyValue)element).getValue();
        YAMLValue yAMLValue = yamlValue;
        if (yAMLValue instanceof YAMLScalar) {
            this.annotateValue((YAMLScalar)yamlValue, holder);
        } else if (yAMLValue instanceof YAMLSequence) {
            this.annotateSequence((YAMLSequence)yamlValue, holder);
        }
    }

    private final void annotateSequence(YAMLSequence yamlSequence, AnnotationHolder holder) {
        for (YAMLSequenceItem item : yamlSequence.getItems()) {
            YAMLScalar value;
            YAMLValue yAMLValue = item.getValue();
            if ((yAMLValue instanceof YAMLScalar ? (YAMLScalar)yAMLValue : null) == null) continue;
            value = value;
            this.annotateValue(value, holder);
        }
    }

    private final void annotateValue(YAMLScalar yamlScalar, AnnotationHolder holder) {
        int elementOffset = yamlScalar.getNode().getStartOffset();
        PsiReference[] psiReferenceArray = yamlScalar.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        PsiReference[] references = psiReferenceArray;
        Set annotatedOffsets = new LinkedHashSet();
        for (PsiReference reference : references) {
            TextRange highlightTextRange;
            Pair pair;
            PsiReference psiReference = reference;
            if (psiReference instanceof KtorEnvVariableReference) {
                pair = TuplesKt.to((Object)YAMLHighlighter.SCALAR_TEXT, (Object)((KtorEnvVariableReference)reference).getEnvVariable().getFullTextRange());
            } else {
                if (!(psiReference instanceof HintReferenceBase)) continue;
                pair = TuplesKt.to((Object)((HintReferenceBase)reference).getTextAttributesKey(), (Object)((HintReferenceBase)reference).getRangeInElement());
            }
            Pair pair2 = pair;
            TextAttributesKey key = (TextAttributesKey)pair2.component1();
            TextRange range = (TextRange)pair2.component2();
            Intrinsics.checkNotNullExpressionValue((Object)range.shiftRight(elementOffset), (String)"shiftRight(...)");
            if (!annotatedOffsets.add(highlightTextRange.getStartOffset())) continue;
            this.doAnnotate(holder, highlightTextRange, key);
        }
    }

    private final void doAnnotate(AnnotationHolder holder, TextRange range, TextAttributesKey key) {
        if (range.isEmpty() || key == null) {
            return;
        }
        AnnotationBuilder annotationBuilder = holder.newSilentAnnotation(HighlightSeverity.INFORMATION);
        Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder, (String)"newSilentAnnotation(...)");
        AnnotationBuilder annotationBuilder2 = annotationBuilder;
        annotationBuilder2.range(range).textAttributes(key).create();
    }
}

