/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.ide.fus;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IComponentStoreKt;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.Project;
import io.ktor.ide.fus.KtorOpenEvent;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\f\u0010\u001e\u001a\u00020\u0016*\u00020\u001cH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/ktor/ide/fus/KtorProjectOpenerCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "utmSourceList", "", "", "utmMediumList", "utmCampaignList", "UTM_SOURCE", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "UTM_MEDIUM", "UTM_CAMPAIGN", "KTOR_PROJECT_OPENED_FROM_WEBSITE", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "requiresReadAccess", "", "getGroup", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "getReceiptFile", "Ljava/nio/file/Path;", "readReceiptFile", "Lio/ktor/ide/fus/KtorOpenEvent;", "receiptPath", "toMetricEvent", "intellij.ktor.starter"})
@SourceDebugExtension(value={"SMAP\nKtorProjectOpenerCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorProjectOpenerCollector.kt\nio/ktor/ide/fus/KtorProjectOpenerCollector\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,92:1\n96#2:93\n*S KotlinDebug\n*F\n+ 1 KtorProjectOpenerCollector.kt\nio/ktor/ide/fus/KtorProjectOpenerCollector\n*L\n76#1:93\n*E\n"})
public final class KtorProjectOpenerCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("ktor.project.opener", 4, null, 4, null);
    @NotNull
    private final List<String> utmSourceList;
    @NotNull
    private final List<String> utmMediumList;
    @NotNull
    private final List<String> utmCampaignList;
    @NotNull
    private final StringEventField UTM_SOURCE;
    @NotNull
    private final StringEventField UTM_MEDIUM;
    @NotNull
    private final StringEventField UTM_CAMPAIGN;
    @NotNull
    private final EventId3<String, String, String> KTOR_PROJECT_OPENED_FROM_WEBSITE;

    public KtorProjectOpenerCollector() {
        Object[] objectArray = new String[]{"google", "twitter", "facebook", "linkedin", "instagram", "youtube.com", "newsletter", "reddit", "kotlinlang.org", "other"};
        this.utmSourceList = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"social", "referral", "cpc", "email", "banner", "conference", "organic", "integration", "other"};
        this.utmMediumList = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"ktor3-wave2", "organic", "other"};
        this.utmCampaignList = CollectionsKt.listOf((Object[])objectArray);
        this.UTM_SOURCE = EventFields.String((String)"utm_source", this.utmSourceList);
        this.UTM_MEDIUM = EventFields.String((String)"utm_medium", this.utmMediumList);
        this.UTM_CAMPAIGN = EventFields.String((String)"utm_campaign", this.utmCampaignList);
        this.KTOR_PROJECT_OPENED_FROM_WEBSITE = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"project.opened.from.website", (EventField)((EventField)this.UTM_SOURCE), (EventField)((EventField)this.UTM_MEDIUM), (EventField)((EventField)this.UTM_CAMPAIGN), null, (int)16, null);
    }

    protected boolean requiresReadAccess() {
        return true;
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path path = this.getReceiptFile(project);
        if (path == null) {
            return SetsKt.emptySet();
        }
        Path receiptFile = path;
        KtorOpenEvent ktorOpenEvent = this.readReceiptFile(receiptFile);
        if (ktorOpenEvent == null) {
            return SetsKt.emptySet();
        }
        KtorOpenEvent wizardReceipt = ktorOpenEvent;
        return SetsKt.setOf((Object)this.toMetricEvent(wizardReceipt));
    }

    private final Path getReceiptFile(Project project) {
        IComponentStore iComponentStore = IComponentStoreKt.getStateStore((ComponentManager)((ComponentManager)project));
        IProjectStore projectStore = iComponentStore instanceof IProjectStore ? (IProjectStore)iComponentStore : null;
        Object object = projectStore;
        if (object == null || (object = object.getDirectoryStorePath()) == null) {
            return null;
        }
        Object projectFileDir = object;
        return projectFileDir.resolve("receipt.json");
    }

    private final KtorOpenEvent readReceiptFile(Path receiptPath) {
        Object object;
        Object object2 = this;
        try {
            KtorOpenEvent ktorOpenEvent;
            KtorProjectOpenerCollector $this$readReceiptFile_u24lambda_u241 = object2;
            boolean bl = false;
            if (!Files.isReadable(receiptPath)) {
                ktorOpenEvent = null;
            } else {
                Json json;
                String text = PathsKt.readText$default((Path)receiptPath, null, (int)1, null);
                Json this_$iv = json = JsonKt.Json$default(null, KtorProjectOpenerCollector::readReceiptFile$lambda$1$lambda$0, (int)1, null);
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                ktorOpenEvent = (KtorOpenEvent)this_$iv.decodeFromString((DeserializationStrategy)KtorOpenEvent.Companion.serializer(), text);
            }
            object = Result.constructor-impl(ktorOpenEvent);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        KtorOpenEvent ktorOpenEvent = (KtorOpenEvent)(Result.isFailure-impl((Object)object2) ? null : object2);
        if (ktorOpenEvent != null) {
            Files.deleteIfExists(receiptPath);
        }
        return ktorOpenEvent;
    }

    private final MetricEvent toMetricEvent(KtorOpenEvent $this$toMetricEvent) {
        KtorOpenEvent.Parameters parameters = $this$toMetricEvent.getSpec().getParameters();
        String utmSource = parameters.component1();
        String utmMedium = parameters.component2();
        String utmCampaign = parameters.component3();
        return this.KTOR_PROJECT_OPENED_FROM_WEBSITE.metric((Object)utmSource, (Object)utmMedium, (Object)utmCampaign);
    }

    private static final Unit readReceiptFile$lambda$1$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        return Unit.INSTANCE;
    }
}

