/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.ide.initializr.plugins.markdown;

import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/ktor/ide/initializr/plugins/markdown/KtorVerticalLayout;", "Lcom/intellij/util/ui/AbstractLayoutManager;", "myOffset", "", "myWidth", "<init>", "(II)V", "myFillComponents", "", "Ljava/awt/Component;", "myFillHorizontalComponents", "myMaxComponents", "", "addLayoutComponent", "", "component", "constraints", "", "removeLayoutComponent", "preferredLayoutSize", "Ljava/awt/Dimension;", "parent", "Ljava/awt/Container;", "layoutContainer", "Companion", "intellij.ktor.starter"})
public final class KtorVerticalLayout
extends AbstractLayoutManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int myOffset;
    private final int myWidth;
    @NotNull
    private final Set<Component> myFillComponents;
    @NotNull
    private final Set<Component> myFillHorizontalComponents;
    @NotNull
    private final Map<Component, Integer> myMaxComponents;
    @NotNull
    public static final String FILL = "fill";
    @NotNull
    public static final String FILL_HORIZONTAL = "fill_h";

    public KtorVerticalLayout(int myOffset, int myWidth) {
        this.myOffset = myOffset;
        this.myWidth = myWidth;
        this.myFillComponents = new HashSet();
        this.myFillHorizontalComponents = new HashSet();
        this.myMaxComponents = new HashMap();
    }

    public /* synthetic */ KtorVerticalLayout(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        this(n, n2);
    }

    public void addLayoutComponent(@NotNull Component component, @Nullable Object constraints) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (Intrinsics.areEqual((Object)FILL, (Object)constraints)) {
            this.myFillComponents.add(component);
        } else if (Intrinsics.areEqual((Object)FILL_HORIZONTAL, (Object)constraints)) {
            this.myFillHorizontalComponents.add(component);
        } else if (constraints instanceof Integer) {
            this.myMaxComponents.put(component, (Integer)constraints);
        }
    }

    public void removeLayoutComponent(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.myFillComponents.remove(component);
        this.myFillHorizontalComponents.remove(component);
    }

    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        int width = 0;
        int height = 0;
        int count = parent.getComponentCount();
        int visibleCount = 0;
        for (int i2 = 0; i2 < count; ++i2) {
            Component component = parent.getComponent(i2);
            if (!component.isVisible()) continue;
            Dimension size = component.getPreferredSize();
            width = Math.max(width, size.width);
            height += size.height;
            ++visibleCount;
        }
        if (visibleCount > 1) {
            height += (visibleCount - 1) * this.myOffset;
        }
        Dimension size = new Dimension(this.myWidth > 0 ? this.myWidth : width, height);
        JBInsets.addTo((Dimension)size, (Insets)parent.getInsets());
        return size;
    }

    public void layoutContainer(@NotNull Container parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Insets insets = parent.getInsets();
        int width = parent.getWidth() - insets.left - insets.right;
        int height = parent.getHeight() - insets.bottom - insets.top;
        int y = insets.top;
        int count = parent.getComponentCount();
        for (int i2 = 0; i2 < count; ++i2) {
            Component component = parent.getComponent(i2);
            if (!component.isVisible()) continue;
            Dimension size = component.getPreferredSize();
            int componentWidth = 0;
            int componentHeight = 0;
            if (this.myFillComponents.contains(component)) {
                componentWidth = width;
                componentHeight = height;
            } else if (this.myFillHorizontalComponents.contains(component)) {
                componentWidth = width;
                componentHeight = Math.min(height, size.height);
            } else {
                componentWidth = Math.min(width, size.width);
                componentHeight = Math.min(height, size.height);
                Integer maxWidth = this.myMaxComponents.get(component);
                if (maxWidth != null) {
                    int n = maxWidth;
                    componentWidth = Math.min(componentWidth, n);
                }
            }
            component.setBounds(insets.left, y, componentWidth, componentHeight);
            y += size.height + this.myOffset;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/ktor/ide/initializr/plugins/markdown/KtorVerticalLayout$Companion;", "", "<init>", "()V", "FILL", "", "FILL_HORIZONTAL", "intellij.ktor.starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

