/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.ide.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import io.ktor.ide.KtorLibraryUtilKt;
import io.ktor.ide.KtorStarterBundle;
import io.ktor.ide.KtorStarterIcons;
import io.ktor.ide.actions.swagger.KtorGenerateOpenApiAction;
import io.ktor.ide.inspections.KtorOpenApiInspectionKt;
import io.ktor.ide.utils.KotlinResolveKt;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\u000f"}, d2={"Lio/ktor/ide/inspections/KtorOpenApiInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "hasKtorLibraryAndNoOpenApi", "module", "Lcom/intellij/openapi/module/Module;", "KtorSwaggerMethodsVisitor", "KtorSwaggerQuickFix", "intellij.ktor.starter"})
public final class KtorOpenApiInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        if (this.hasKtorLibraryAndNoOpenApi(GenericPsiUtils.getModule((PsiElement)((PsiElement)psiFile)))) {
            psiElementVisitor = (PsiElementVisitor)new KtorSwaggerMethodsVisitor(holder);
        } else {
            PsiElementVisitor psiElementVisitor2 = PsiElementVisitor.EMPTY_VISITOR;
            psiElementVisitor = psiElementVisitor2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor2, (String)"EMPTY_VISITOR");
        }
        return psiElementVisitor;
    }

    private final boolean hasKtorLibraryAndNoOpenApi(Module module) {
        return module != null && KtorLibraryUtilKt.hasKtorServerLibrary(module) && !KtorGenerateOpenApiAction.Companion.openApiFileExists(module);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/ktor/ide/inspections/KtorOpenApiInspection$KtorSwaggerMethodsVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "visitCallExpression", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isOpenApiPluginCall", "", "intellij.ktor.starter"})
    @SourceDebugExtension(value={"SMAP\nKtorOpenApiInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorOpenApiInspection.kt\nio/ktor/ide/inspections/KtorOpenApiInspection$KtorSwaggerMethodsVisitor\n+ 2 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 3 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n*L\n1#1,73:1\n28#2,2:74\n36#3,13:76\n*S KotlinDebug\n*F\n+ 1 KtorOpenApiInspection.kt\nio/ktor/ide/inspections/KtorOpenApiInspection$KtorSwaggerMethodsVisitor\n*L\n58#1:74,2\n58#1:76,13\n*E\n"})
    private static final class KtorSwaggerMethodsVisitor
    extends KtVisitorVoid {
        @NotNull
        private final ProblemsHolder holder;

        public KtorSwaggerMethodsVisitor(@NotNull ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        public void visitCallExpression(@NotNull KtCallExpression callExpression) {
            Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
            if (this.isOpenApiPluginCall(callExpression) || KtorLibraryUtilKt.isEmbeddedServerCall(callExpression)) {
                KtExpression ktExpression = callExpression.getCalleeExpression();
                Intrinsics.checkNotNull((Object)ktExpression);
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new KtorSwaggerQuickFix()};
                this.holder.registerProblem((PsiElement)ktExpression, KtorStarterBundle.INSTANCE.message("ktor.generate.openapi.inspection", new Object[0]), localQuickFixArray);
            }
        }

        public void visitNamedFunction(@NotNull KtNamedFunction function) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            if (KtorLibraryUtilKt.isApplicationExtension(function)) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new KtorSwaggerQuickFix()};
                this.holder.registerProblem((PsiElement)function, KtorStarterBundle.INSTANCE.message("ktor.generate.openapi.inspection", new Object[0]), localQuickFixArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean isOpenApiPluginCall(KtCallExpression callExpression) {
            boolean bl;
            boolean $i$f$analyze = false;
            Project project = ((KtElement)callExpression).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KaSessionProvider this_$iv$iv = KaSessionProvider.Companion.getInstance(project);
            boolean $i$f$analyze2 = false;
            KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)callExpression);
            this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)callExpression);
            try {
                boolean bl2;
                Object lock$iv$iv;
                Object object = lock$iv$iv = new Object();
                synchronized (object) {
                    boolean bl3 = false;
                    KaSession $this$isOpenApiPluginCall_u24lambda_u240 = analysisSession$iv$iv;
                    boolean bl4 = false;
                    bl2 = KotlinResolveKt.isOneOfAcceptedFunction($this$isOpenApiPluginCall_u24lambda_u240, (KtCallElement)callExpression, KtorOpenApiInspectionKt.access$getSWAGGER_METHODS_FQNAMES$p());
                }
                bl = bl2;
            }
            finally {
                this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)callExpression);
            }
            return bl;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lio/ktor/ide/inspections/KtorOpenApiInspection$KtorSwaggerQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/openapi/util/Iconable;", "<init>", "()V", "getFamilyName", "", "getIcon", "Ljavax/swing/Icon;", "flags", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "startInWriteAction", "", "intellij.ktor.starter"})
    private static final class KtorSwaggerQuickFix
    implements LocalQuickFix,
    Iconable {
        @NotNull
        public String getFamilyName() {
            return KtorStarterBundle.INSTANCE.message("ktor.generate.openapi.inspection", new Object[0]);
        }

        @NotNull
        public Icon getIcon(int flags) {
            Icon icon = KtorStarterIcons.Ktor;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Ktor");
            return icon;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            PsiElement psiElement = descriptor.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
            Module module = GenericPsiUtils.getModule((PsiElement)psiElement);
            if (module == null) {
                return;
            }
            Module module2 = module;
            KtorGenerateOpenApiAction.Companion.generateOpenApiAndShowNotifications(module2);
        }

        public boolean startInWriteAction() {
            return false;
        }
    }
}

