/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.ide.kotlin.completions;

import com.intellij.buildsystem.model.DeclaredDependency;
import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.buildsystem.model.unified.UnifiedDependencyRepository;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.externalSystem.DependencyModifierService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.externalSystem.autoimport.ProjectRefreshAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import io.ktor.ide.KtorDisposableService;
import io.ktor.ide.KtorStarterBundle;
import io.ktor.ide.KtorStarterIcons;
import io.ktor.ide.KtorUtilsKt;
import io.ktor.ide.plugins.add.KtorPluginsUtilsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B(\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000f\b\u0002\u0010\u0006\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010 \u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010!\u001a\u00020\u0005H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020(H\u0016J\u001e\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030-H\u0004J&\u0010.\u001a\u00020#2\u0006\u0010/\u001a\u0002002\u0006\u0010\u0002\u001a\u00020\u00032\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0002J\u0018\u00102\u001a\u0002032\u0006\u0010*\u001a\u00020+2\u0006\u00104\u001a\u000205H\u0002J\"\u00106\u001a\u0004\u0018\u0001072\u0006\u0010/\u001a\u0002002\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u0018\u00108\u001a\u00020#2\u0006\u00109\u001a\u00020:2\u0006\u0010/\u001a\u000200H\u0002J(\u0010;\u001a\u00020#2\u0006\u0010/\u001a\u0002002\u0006\u0010<\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020\u0005H\u0002J,\u0010?\u001a\u00020#2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030-2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010*\u001a\u00020+H\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0006\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014R\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014R\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000fR\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u0014\u00a8\u0006A"}, d2={"Lio/ktor/ide/kotlin/completions/KtorCompletionBaseLookupElement;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "text", "", "description", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Ljava/lang/String;Ljava/lang/String;)V", "getFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "setFile", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "getText", "()Ljava/lang/String;", "getDescription", "imports", "", "getImports", "()Ljava/util/List;", "dependencies", "Lcom/intellij/buildsystem/model/unified/UnifiedDependency;", "getDependencies", "repositories", "Lcom/intellij/buildsystem/model/unified/UnifiedDependencyRepository;", "getRepositories", "codeToAdd", "getCodeToAdd", "calculateStartOffset", "", "tailOffset", "calculateEndOffset", "getLookupString", "renderElement", "", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "handleInsert", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "reformatAfterInsertion", "project", "Lcom/intellij/openapi/project/Project;", "filePointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "addTemplates", "document", "Lcom/intellij/openapi/editor/Document;", "templatesToAdd", "addDependencies", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "addCode", "Lorg/jetbrains/kotlin/psi/KtExpression;", "updateFile", "manager", "Lcom/intellij/psi/PsiDocumentManager;", "replaceText", "startOffset", "endOffset", "replacement", "fixImports", "getTemplatesToAdd", "intellij.ktor.starter"})
@SourceDebugExtension(value={"SMAP\nKtorCompletionBaseLookupElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorCompletionBaseLookupElement.kt\nio/ktor/ide/kotlin/completions/KtorCompletionBaseLookupElement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,180:1\n1863#2,2:181\n1863#2:183\n2632#2,3:184\n1864#2:187\n1863#2,2:190\n66#3,2:188\n*S KotlinDebug\n*F\n+ 1 KtorCompletionBaseLookupElement.kt\nio/ktor/ide/kotlin/completions/KtorCompletionBaseLookupElement\n*L\n94#1:181,2\n110#1:183\n111#1:184,3\n110#1:187\n171#1:190,2\n154#1:188,2\n*E\n"})
public abstract class KtorCompletionBaseLookupElement
extends LookupElement {
    @NotNull
    private KtFile file;
    @NotNull
    private final String text;
    @Nullable
    private final String description;
    @NotNull
    private final List<String> templatesToAdd;

    public KtorCompletionBaseLookupElement(@NotNull KtFile file, @NotNull String text, @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.file = file;
        this.text = text;
        this.description = description;
        this.templatesToAdd = CollectionsKt.emptyList();
    }

    public /* synthetic */ KtorCompletionBaseLookupElement(KtFile ktFile, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        this(ktFile, string, string2);
    }

    @NotNull
    protected final KtFile getFile() {
        return this.file;
    }

    protected final void setFile(@NotNull KtFile ktFile) {
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"<set-?>");
        this.file = ktFile;
    }

    @NotNull
    protected final String getText() {
        return this.text;
    }

    @Nullable
    protected final String getDescription() {
        return this.description;
    }

    @NotNull
    public abstract List<String> getImports();

    @NotNull
    public abstract List<UnifiedDependency> getDependencies();

    @NotNull
    public abstract List<UnifiedDependencyRepository> getRepositories();

    @Nullable
    public abstract String getCodeToAdd();

    public int calculateStartOffset(int tailOffset, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return tailOffset - text.length();
    }

    public int calculateEndOffset(int tailOffset, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return tailOffset;
    }

    @NotNull
    public String getLookupString() {
        return this.text;
    }

    public void renderElement(@NotNull LookupElementPresentation presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        presentation.setIcon(KtorStarterIcons.Ktor);
        presentation.setTypeText(this.description);
        super.renderElement(presentation);
    }

    public void handleInsert(@NotNull InsertionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Editor editor2 = context.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        Project project = editor3.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Document document = editor3.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        KtExpression addedExpression = this.addCode(document2, project2, context.getTailOffset());
        if (addedExpression != null && !((Collection)this.getTemplatesToAdd()).isEmpty()) {
            KtFile ktFile = addedExpression.getContainingKtFile();
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
            KtFile file = ktFile;
            this.addTemplates(document2, file, this.getTemplatesToAdd());
        }
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)this.file));
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        SmartPsiElementPointer filePointer = smartPsiElementPointer;
        boolean needsReimport = this.addDependencies(project2, editor3);
        if (needsReimport && !ApplicationManager.getApplication().isUnitTestMode()) {
            ProjectRefreshAction.Manager.INSTANCE.refreshProject(project2);
            KtorPluginsUtilsKt.onProjectImportFinished(project2, KtorDisposableService.Companion.projectDisposable(project2), (Function0<Unit>)((Function0)() -> KtorCompletionBaseLookupElement.handleInsert$lambda$0(this, project2, filePointer)));
        } else {
            this.reformatAfterInsertion(project2, (SmartPsiElementPointer<KtFile>)filePointer);
        }
    }

    protected final void reformatAfterInsertion(@NotNull Project project, @NotNull SmartPsiElementPointer<KtFile> filePointer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(filePointer, (String)"filePointer");
        this.fixImports(filePointer, this.getImports(), project);
        new ReformatCodeProcessor((PsiFile)this.file, false).run();
        new OptimizeImportsProcessor(this.file.getProject(), (PsiFile)this.file).run();
    }

    private final void addTemplates(Document document, KtFile file, List<String> templatesToAdd) {
        Iterable $this$forEach$iv = templatesToAdd;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            document.insertString(PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)file)), (CharSequence)it);
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file.getProject());
        documentManager.commitDocument(document);
        Intrinsics.checkNotNull((Object)documentManager);
        this.updateFile(documentManager, document);
    }

    private final boolean addDependencies(Project project, Editor editor2) {
        Module module = GenericPsiUtils.getModule((PsiElement)((PsiElement)this.file));
        if (module == null) {
            return false;
        }
        Module module2 = module;
        DependencyModifierService dependencyService = DependencyModifierService.Companion.getInstance(project);
        List declaredDependencies = dependencyService.declaredDependencies(module2);
        Ref.IntRef addedCount = new Ref.IntRef();
        Iterable $this$forEach$iv = this.getDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            UnifiedDependency dependency;
            block7: {
                dependency = (UnifiedDependency)element$iv;
                boolean bl2 = false;
                Iterable $this$none$iv = declaredDependencies;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv2 : $this$none$iv) {
                        DeclaredDependency it = (DeclaredDependency)element$iv2;
                        boolean bl3 = false;
                        if (!(Intrinsics.areEqual((Object)it.getCoordinates().getGroupId(), (Object)dependency.getCoordinates().getGroupId()) && Intrinsics.areEqual((Object)it.getCoordinates().getArtifactId(), (Object)dependency.getCoordinates().getArtifactId()))) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            dependencyService.addDependency(module2, dependency);
            int n = addedCount.element;
            addedCount.element = n + 1;
        }
        for (UnifiedDependencyRepository repository : this.getRepositories()) {
            dependencyService.addRepository(module2, repository);
        }
        if (addedCount.element == 0) {
            return false;
        }
        ApplicationManager.getApplication().invokeLater(() -> KtorCompletionBaseLookupElement.addDependencies$lambda$4(editor2, addedCount));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final KtExpression addCode(Document document, Project project, int tailOffset) {
        KtExpression ktExpression;
        if (this.getCodeToAdd() == null) {
            return null;
        }
        int startOffset = this.calculateStartOffset(tailOffset, this.text);
        int endOffset = this.calculateEndOffset(tailOffset, this.text);
        String string = this.getCodeToAdd();
        Intrinsics.checkNotNull((Object)string);
        this.replaceText(document, startOffset, endOffset, string);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitDocument(document);
        Intrinsics.checkNotNull((Object)documentManager);
        this.updateFile(documentManager, document);
        PsiElement psiElement = this.file.findElementAt(startOffset);
        if (psiElement != null) {
            void $this$parentOfType_u24default$iv;
            PsiElement psiElement2 = psiElement;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            ktExpression = (KtExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtExpression.class, (boolean)true);
        } else {
            ktExpression = null;
        }
        return ktExpression;
    }

    private final void updateFile(PsiDocumentManager manager, Document document) {
        PsiFile psiFile = manager.getPsiFile(document);
        KtFile ktFile = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile == null) {
            return;
        }
        this.file = ktFile;
        KtorUtilsKt.commitAndUnblockDocument((PsiFile)this.file);
    }

    private final void replaceText(Document document, int startOffset, int endOffset, String replacement) {
        document.replaceString(startOffset, endOffset, (CharSequence)replacement);
    }

    private final void fixImports(SmartPsiElementPointer<KtFile> filePointer, List<String> imports, Project project) {
        PsiFile[] psiFileArray = new PsiFile[]{filePointer.getElement()};
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])psiFileArray).run(() -> KtorCompletionBaseLookupElement.fixImports$lambda$6(filePointer, project, imports));
    }

    @NotNull
    public List<String> getTemplatesToAdd() {
        return this.templatesToAdd;
    }

    private static final Unit handleInsert$lambda$0(KtorCompletionBaseLookupElement this$0, Project $project, SmartPsiElementPointer $filePointer) {
        this$0.reformatAfterInsertion($project, (SmartPsiElementPointer<KtFile>)$filePointer);
        return Unit.INSTANCE;
    }

    private static final void addDependencies$lambda$4(Editor $editor, Ref.IntRef $addedCount) {
        Object[] objectArray = new Object[]{$addedCount.element};
        HintManager.getInstance().showInformationHint($editor, KtorStarterBundle.INSTANCE.message("ktor.plugin.add.status.dependencies.added", objectArray));
    }

    private static final void fixImports$lambda$6(SmartPsiElementPointer $filePointer, Project $project, List $imports) {
        KtFile file = (KtFile)$filePointer.getElement();
        KtFile ktFile = file;
        if (ktFile == null || (ktFile = ktFile.getImportList()) == null) {
            return;
        }
        KtFile importsList = ktFile;
        KtPsiFactory factory = new KtPsiFactory($project, true);
        Iterable $this$forEach$iv = $imports;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string = (String)element$iv;
            boolean bl = false;
            ImportPath importPath = ImportPath.Companion.fromString(string);
            KtImportDirective importDirective = factory.createImportDirective(importPath);
            importsList.add((PsiElement)importDirective);
        }
    }
}

