/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.microservices;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.javascript.microservices.JsRequestBodyDetectionKt;
import com.intellij.javascript.microservices.RequestBodyDeclaration;
import com.intellij.lang.javascript.json.JSJsonLikePsiWalker;
import com.intellij.microservices.oas.OasSpecificationProvider;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.UrlPathReference;
import com.intellij.microservices.url.references.UrlPathReferenceUnifiedPomTarget;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.impl.JsonCachedValues;
import com.jetbrains.jsonSchema.impl.JsonSchemaCompletionContributor;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/javascript/microservices/JavaScriptHttpBodyCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "<init>", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "getSchemas", "Lkotlin/sequences/Sequence;", "Lcom/intellij/openapi/vfs/VirtualFile;", "psiElement", "Lcom/intellij/psi/PsiElement;", "intellij.javascript.langInjection"})
public final class JavaScriptHttpBodyCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement position = psiElement;
        Sequence rootSchemas = SequencesKt.mapNotNull(this.getSchemas(position), arg_0 -> JavaScriptHttpBodyCompletionContributor.fillCompletionVariants$lambda$0(position, arg_0));
        boolean stop = JSJsonLikePsiWalker.INSTANCE_ARRAY_ALLOWED.isName(position) == ThreeState.YES;
        for (JsonSchemaObject rootSchema : rootSchemas) {
            JsonSchemaCompletionContributor.Companion.doCompletion(parameters, result2, rootSchema, stop);
        }
    }

    private final Sequence<VirtualFile> getSchemas(PsiElement psiElement) {
        Sequence<RequestBodyDeclaration> bodyDeclarations = JsRequestBodyDetectionKt.findBodyDeclarations(psiElement);
        return SequencesKt.flatMap(bodyDeclarations, JavaScriptHttpBodyCompletionContributor::getSchemas$lambda$3);
    }

    private static final JsonSchemaObject fillCompletionVariants$lambda$0(PsiElement $position, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return JsonCachedValues.getSchemaObject((VirtualFile)it, (Project)$position.getProject());
    }

    private static final VirtualFile getSchemas$lambda$3$lambda$2$lambda$1(UrlTargetInfo $target, List $prefix, OasSpecificationProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getOasSpecificationFile($target, $prefix);
    }

    private static final Sequence getSchemas$lambda$3$lambda$2(List $prefix, UrlTargetInfo target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return SequencesKt.mapNotNull((Sequence)OasSpecificationProvider.EP_NAME.lazySequence(), arg_0 -> JavaScriptHttpBodyCompletionContributor.getSchemas$lambda$3$lambda$2$lambda$1(target, $prefix, arg_0));
    }

    private static final Sequence getSchemas$lambda$3(RequestBodyDeclaration requestBodyDeclaration) {
        Intrinsics.checkNotNullParameter((Object)requestBodyDeclaration, (String)"<destruct>");
        UrlPathReference urlPathReference = requestBodyDeclaration.component1();
        List<String> prefix = requestBodyDeclaration.component2();
        UrlPathReferenceUnifiedPomTarget urlPathReferenceUnifiedPomTarget = urlPathReference.getUnifiedPomTarget();
        if (urlPathReferenceUnifiedPomTarget == null) {
            return SequencesKt.emptySequence();
        }
        UrlPathReferenceUnifiedPomTarget urlPathReferenceUnifiedPomTarget2 = urlPathReferenceUnifiedPomTarget;
        return SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)urlPathReferenceUnifiedPomTarget2.getResolvedTargets()), arg_0 -> JavaScriptHttpBodyCompletionContributor.getSchemas$lambda$3$lambda$2(prefix, arg_0));
    }
}

