/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.lang.javascript.JavaScriptFrontBackBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public enum JSLanguageFeature {
    E4X("js.language.feature.xml.tags"),
    FOR_EACH("js.language.feature.for.each.statements"),
    FOR_OF("js.language.feature.for.of.loops"),
    LET_DEFINITIONS("js.language.feature.let.definitions"),
    CONST_DEFINITIONS("js.language.feature.const.definitions"),
    YIELD_GENERATORS("js.language.feature.generators"),
    DESTRUCTURING_ASSIGNMENT("js.language.feature.destructuring.assignments"),
    DESTRUCTURING_PARAMETERS("js.language.feature.destructuring.parameters"),
    ACCESSORS("js.language.feature.getters.and.setters"),
    ARROW_FUNCTIONS("js.language.feature.arrow.functions"),
    REST_PARAMETERS("js.language.feature.rest.parameters"),
    GENERICS("js.language.feature.generics"),
    IMPORT_DECLARATIONS("js.language.feature.es6.import.declarations"),
    EXPORT_DECLARATIONS("js.language.feature.es6.export.declarations"),
    CLASSES("js.language.feature.classes"),
    INTERFACES("js.language.feature.interfaces"),
    ANNOTATIONS("js.language.feature.annotations"),
    TYPES("js.language.feature.types"),
    ASYNC_AWAIT("js.language.feature.async.await"),
    BINARY_AND_OCTAL_LITERALS("js.language.feature.binary.0b.and.new.octal.0o.literals"),
    SHORTHAND_PROPERTY_NAMES("js.language.feature.shorthand.property.names"),
    COMPUTED_PROPERTY_NAMES("js.language.feature.computed.property.names"),
    METHOD_DEFINITION_SHORTHANDS("js.language.feature.method.definition.shorthands"),
    STRING_TEMPLATES("js.language.feature.string.templates"),
    OPTIONAL_CATCH_BINDING("js.language.feature.optional.catch.bindings"),
    BIND_EXPRESSIONS("js.language.feature.bind.expressions"),
    UNICODE_ESCAPES_WITH_BRACES("js.language.feature.unicode.escapes.with.braces"),
    TRAILING_FUNCTION_COMMA("js.language.feature.trailing.commas.in.function.parameter.lists.and.calls"),
    BIG_INT("js.language.feature.arbitrary.precision.integers"),
    OPTIONAL_CHAINING_OPERATOR("js.language.feature.optional.chaining.operator"),
    VISIBILITY_MODIFIERS("js.language.feature.class.member.visibility.modifiers"),
    PRIVATE_SHARP_SYNTAX("js.language.feature.ecmascript.syntax.for.private.members"),
    THROW_EXPRESSIONS("js.language.feature.throw.expressions"),
    DECORATOR_DECLARATIONS("js.language.feature.decorator.declarations"),
    PIPE_EXPRESSIONS("js.language.feature.pipe.expressions"),
    PARAMETER_INITIALIZERS("js.language.feature.default.parameter.values"),
    REFERENCE_NAMESPACE("js.language.feature.reference.namespace"),
    NULLISH_COALESCING("js.language.feature.nullish.coalescing"),
    ENUMS("js.language.feature.enums");

    private final String myKey;

    private JSLanguageFeature(String description) {
        this.myKey = description;
    }

    public String toString() {
        return this.getName();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string = JavaScriptFrontBackBundle.message(this.myKey, new Object[0]);
        if (string == null) {
            JSLanguageFeature.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/dialects/JSLanguageFeature", "getName"));
    }
}

