/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.ecmascript6.parsing.ES6ExpressionParser;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptParserBundle;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSArrowFunctionDetector;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructureLeaf;
import com.intellij.lang.javascript.parsing.modifiers.JSUnorderedModifiersStructure;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTupleType;
import com.intellij.lang.javascript.psi.stubs.TypeScriptFunctionSignatureStub;
import com.intellij.lang.javascript.psi.stubs.TypeScriptPropertySignatureStub;
import com.intellij.lang.javascript.psi.stubs.TypeScriptSingleTypeStub;
import com.intellij.lang.javascript.psi.stubs.TypeScriptTupleTypeStub;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class TypeScriptPsiTypeParser<P extends ES6Parser>
extends JSPsiTypeParser<P> {
    protected static final Logger LOG = Logger.getInstance(TypeScriptPsiTypeParser.class);
    private static final TokenSet NON_REFERENCE_PRIMITIVE_TYPES = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.VOID_KEYWORD, JSTokenTypes.ANY_KEYWORD, JSTokenTypes.SYMBOL_KEYWORD, JSTokenTypes.NEVER_KEYWORD, JSTokenTypes.UNKNOWN_KEYWORD, JSTokenTypes.OBJECT_TYPE_KEYWORD, JSTokenTypes.MIXED_KEYWORD, JSTokenTypes.NULL_KEYWORD, JSTokenTypes.INTRINSIC_KEYWORD});
    private static final Key<Boolean> IS_CONDITIONAL_TYPE_ALLOWED = Key.create((String)"conditional.type.allowed");
    protected static final Predicate<PsiBuilder> AFTER_TYPE_MEMBER_MODIFIERS_PREDICATE = builder2 -> {
        IElementType type = builder2.getTokenType();
        if (type == null || type == JSTokenTypes.COMMA || type == JSTokenTypes.SEMICOLON || type == JSTokenTypes.QUEST || type == JSTokenTypes.COLON || type == JSTokenTypes.LPAR) {
            return false;
        }
        return !TypeScriptPsiTypeParser.hasLineTerminatorBefore(builder2);
    };
    private static final JSModifiersStructure TYPE_MEMBER_MODIFIERS = new JSModifiersStructureLeaf(JSTokenTypes.READONLY_KEYWORD);
    private static final JSModifiersStructure TYPE_PARAMETER_MODIFIERS_STRUCTURE = new JSUnorderedModifiersStructure(TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.CONST_KEYWORD, JSTokenTypes.IN_KEYWORD, JSTokenTypes.OUT_KEYWORD}));
    private final Predicate<PsiBuilder> AFTER_TYPE_PARAMETER_MODIFIERS_PREDICATE = builder2 -> this.isIdentifierToken(builder2.getTokenType());

    public TypeScriptPsiTypeParser(P parser2) {
        super(parser2);
    }

    @Override
    protected boolean parseQualifiedTypeNameTail(PsiBuilder.Marker expr) {
        expr.drop();
        return this.tryParseTypeArgumentList(false, false, false);
    }

    @Override
    public boolean tryParseType() {
        if (this.builder.getTokenType() == JSTokenTypes.COLON) {
            this.builder.advanceLexer();
            return this.parseType();
        }
        return false;
    }

    @Override
    protected boolean parseAfterDotInQualifiedTypeNameRest(boolean allowStar, @NotNull Ref<PsiBuilder.Marker> marker, @NotNull IElementType separator) {
        IElementType type;
        if (marker == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(0);
        }
        if (separator == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(1);
        }
        if ((type = this.builder.getTokenType()) == JSTokenTypes.LT) {
            return true;
        }
        return super.parseAfterDotInQualifiedTypeNameRest(allowStar, marker, separator);
    }

    @Override
    public boolean parseType() {
        PsiBuilder.Marker mark = this.builder.mark();
        if (!this.parseInUnionOrIntersectionType(true, true, true)) {
            mark.drop();
            return false;
        }
        if (this.builder.getTokenType() == JSTokenTypes.EXTENDS_KEYWORD && !TypeScriptPsiTypeParser.hasLineTerminatorBefore(this.builder) && this.isConditionalTypeAllowed()) {
            this.builder.advanceLexer();
            boolean result2 = this.parseConditionalType();
            mark.done(TypeScriptStubElementTypes.CONDITIONAL_TYPE);
            return result2;
        }
        mark.drop();
        return true;
    }

    private boolean parseConditionalType() {
        boolean extendsType = this.parseTypeWithConditionalTypeAllowed(false);
        if (!extendsType) {
            return false;
        }
        if (this.builder.getTokenType() != JSTokenTypes.QUEST) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.question", new Object[0]));
            return false;
        }
        this.builder.advanceLexer();
        boolean trueType = this.parseTypeWithConditionalTypeAllowed(true);
        if (!trueType) {
            return false;
        }
        if (this.builder.getTokenType() != JSTokenTypes.COLON) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.colon", new Object[0]));
            return false;
        }
        this.builder.advanceLexer();
        return this.parseTypeWithConditionalTypeAllowed(true);
    }

    protected boolean parseInUnionOrIntersectionType(boolean expectedUnion, boolean isTopLevel, boolean functionTypeAllowedByContext) {
        boolean result2;
        int typeCounter = 0;
        PsiBuilder.Marker unionTypeMarker = this.builder.mark();
        do {
            if (this.canAdvanceSeparator(expectedUnion)) {
                this.builder.advanceLexer();
            }
            boolean bl = expectedUnion ? this.parseInUnionOrIntersectionType(false, isTopLevel && typeCounter == 1, functionTypeAllowedByContext) : (result2 = this.parseUnionOrIntersectionComponent(this.isFunctionTypeAllowed(isTopLevel && ++typeCounter == 1, functionTypeAllowedByContext)));
        } while (result2 && this.isValidSeparator(expectedUnion));
        if (typeCounter == 1) {
            unionTypeMarker.drop();
        } else {
            unionTypeMarker.done(TypeScriptStubElementTypes.UNION_OR_INTERSECTION_TYPE);
        }
        return result2;
    }

    protected boolean canAdvanceSeparator(boolean expectedUnion) {
        IElementType separator = this.builder.getTokenType();
        return separator == JSTokenTypes.OR || separator == JSTokenTypes.AND;
    }

    protected boolean isValidSeparator(boolean expectedUnion) {
        IElementType type = this.builder.getTokenType();
        return expectedUnion ? type == JSTokenTypes.OR : type == JSTokenTypes.AND;
    }

    protected boolean isFunctionTypeAllowed(boolean isFirstComponent, boolean allowedByContext) {
        return isFirstComponent && allowedByContext;
    }

    protected boolean parseUnionOrIntersectionComponent(boolean functionTypeAllowed) {
        IElementType type = this.builder.getTokenType();
        if (type == JSTokenTypes.KEYOF_KEYWORD) {
            return this.advanceTypeKeywordAndNestedType((IElementType)TypeScriptElementTypes.TYPE_OPERATOR_TYPE);
        }
        if (type == JSTokenTypes.AWAITED_KEYWORD) {
            return this.advanceTypeKeywordAndNestedType((IElementType)TypeScriptStubElementTypes.AWAITED_TYPE);
        }
        if (type == JSTokenTypes.INFER_KEYWORD && this.parseInferType()) {
            return true;
        }
        Boolean wasConditionalTypeAllowed = (Boolean)this.builder.getUserData(IS_CONDITIONAL_TYPE_ALLOWED);
        this.builder.putUserData(IS_CONDITIONAL_TYPE_ALLOWED, (Object)true);
        boolean result2 = this.parseDistinctType(functionTypeAllowed, true);
        this.builder.putUserData(IS_CONDITIONAL_TYPE_ALLOWED, (Object)wasConditionalTypeAllowed);
        return result2;
    }

    private boolean parseInferType() {
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        IElementType type = this.builder.getTokenType();
        if (!this.isIdentifierToken(type)) {
            marker.rollbackTo();
            return false;
        }
        this.builder.advanceLexer();
        this.tryParseConstraintOfInferType();
        marker.done(TypeScriptStubElementTypes.INFER_TYPE);
        return true;
    }

    private void tryParseConstraintOfInferType() {
        if (this.builder.getTokenType() != JSTokenTypes.EXTENDS_KEYWORD) {
            return;
        }
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        this.parseTypeWithConditionalTypeAllowed(false);
        if (!this.isConditionalTypeAllowed() || this.builder.getTokenType() != JSTokenTypes.QUEST) {
            marker.drop();
        } else {
            marker.rollbackTo();
        }
    }

    private boolean parseTypeWithConditionalTypeAllowed(boolean isConditionalTypeAllowed) {
        Boolean wasConditionalTypeAllowed = (Boolean)this.builder.getUserData(IS_CONDITIONAL_TYPE_ALLOWED);
        this.builder.putUserData(IS_CONDITIONAL_TYPE_ALLOWED, (Object)isConditionalTypeAllowed);
        boolean result2 = this.parseType();
        this.builder.putUserData(IS_CONDITIONAL_TYPE_ALLOWED, (Object)wasConditionalTypeAllowed);
        return result2;
    }

    private boolean isConditionalTypeAllowed() {
        return !Boolean.FALSE.equals(this.builder.getUserData(IS_CONDITIONAL_TYPE_ALLOWED));
    }

    protected boolean advanceTypeKeywordAndNestedType(IElementType type) {
        PsiBuilder.Marker marker = this.builder.mark();
        this.builder.advanceLexer();
        boolean result2 = this.parseUnionOrIntersectionComponent(true);
        marker.done(type);
        return result2;
    }

    protected boolean parseDistinctType(boolean functionTypeAllowed, boolean readonlyTypeAllowed) {
        boolean result2;
        IElementType type = this.builder.getTokenType();
        PsiBuilder.Marker typeMarker = this.builder.mark();
        PsiBuilder.Marker attListMarker = null;
        if (type == JSTokenTypes.READONLY_KEYWORD) {
            if (readonlyTypeAllowed) {
                boolean parsed = false;
                PsiBuilder.Marker beforeAttrList = this.builder.mark();
                attListMarker = this.builder.mark();
                this.builder.advanceLexer();
                attListMarker.done(JSStubElementTypes.ATTRIBUTE_LIST);
                PsiBuilder.Marker markerForArrayPostfix = this.builder.mark();
                if (this.builder.getTokenType() == JSTokenTypes.LBRACKET) {
                    PsiBuilder.Marker mark = this.builder.mark();
                    boolean tupleParsed = this.doParseTupleType();
                    if (tupleParsed) {
                        if (!this.areArrayBracketsFollowing()) {
                            mark.drop();
                            markerForArrayPostfix.drop();
                            markerForArrayPostfix = null;
                            beforeAttrList.done(this.getTupleTypeElementType());
                            beforeAttrList = null;
                            attListMarker = null;
                        } else {
                            mark.done(this.getTupleTypeElementType());
                        }
                        parsed = true;
                    } else {
                        mark.drop();
                    }
                } else {
                    boolean parsedType = this.parseDistinctType(false, false);
                    if (parsedType && this.validateReadonlyTail()) {
                        parsed = true;
                    }
                }
                if (beforeAttrList != null) {
                    beforeAttrList.drop();
                }
                if (!parsed) {
                    markerForArrayPostfix.drop();
                    attListMarker.rollbackTo();
                    attListMarker = null;
                    result2 = this.parseNamedOrThisType();
                } else {
                    if (markerForArrayPostfix != null) {
                        typeMarker.drop();
                        typeMarker = markerForArrayPostfix;
                    }
                    result2 = true;
                }
            } else {
                result2 = this.parseNamedOrThisType();
            }
        } else {
            result2 = this.parseDistinctTypeNoSuffix(functionTypeAllowed);
        }
        if (readonlyTypeAllowed) {
            result2 &= this.parseSuffixType(typeMarker, attListMarker);
        } else {
            typeMarker.drop();
        }
        return result2;
    }

    protected boolean parseDistinctTypeNoSuffix(boolean functionTypeAllowed) {
        IElementType type = this.builder.getTokenType();
        if (type == JSTokenTypes.LPAR) {
            return this.parseFunctionOrParenthesizedType(functionTypeAllowed);
        }
        if (type == JSTokenTypes.NEW_KEYWORD || type == JSTokenTypes.LT || this.isAbstractNew(type)) {
            return this.parseFunctionType();
        }
        if (type == JSTokenTypes.LBRACE) {
            return this.isStartOfMappedType() ? this.parseMappedType() : this.parseObjectType();
        }
        if (type == JSTokenTypes.LBRACKET) {
            return this.parseTupleType();
        }
        if (type == JSTokenTypes.IMPORT_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.parseImportTypeInner();
            marker.done(this.getSingleTypeElementType());
            return true;
        }
        if (type == JSTokenTypes.TYPEOF_KEYWORD) {
            if (this.builder.lookAhead(1) == JSTokenTypes.IMPORT_KEYWORD) {
                PsiBuilder.Marker marker = this.builder.mark();
                this.builder.advanceLexer();
                this.parseImportTypeInner();
                marker.done(this.getSingleTypeElementType());
            } else {
                PsiBuilder.Marker marker = this.builder.mark();
                this.builder.advanceLexer();
                this.parseTypeOfInnerExpression();
                marker.done(TypeScriptStubElementTypes.TYPEOF_TYPE);
            }
            return true;
        }
        if (type == JSTokenTypes.THIS_KEYWORD && this.builder.lookAhead(1) != JSTokenTypes.IS_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            marker.done(TypeScriptStubElementTypes.THIS_TYPE);
            return true;
        }
        if (type == JSTokenTypes.THIS_KEYWORD || type == JSTokenTypes.ASSERTS_KEYWORD || NON_REFERENCE_PRIMITIVE_TYPES.contains(type) || this.isIdentifierToken(type)) {
            return this.parseNamedOrThisType();
        }
        if (JSTokenTypes.STRING_LITERALS.contains(type)) {
            this.parseSingleTokenLiteralType((IElementType)TypeScriptStubElementTypes.STRING_LITERAL_TYPE);
            return true;
        }
        if (type == JSTokenTypes.BACKQUOTE) {
            if (this.builder.lookAhead(1) == JSTokenTypes.STRING_TEMPLATE_PART && this.builder.lookAhead(2) == JSTokenTypes.BACKQUOTE && this.allowSingleTemplateLiteralInType()) {
                this.parseStringTemplateAsTypeLiteral();
                return true;
            }
            return this.parseTemplateLiteralType();
        }
        if (type == JSTokenTypes.NUMERIC_LITERAL || type == JSTokenTypes.MINUS && this.builder.lookAhead(1) == JSTokenTypes.NUMERIC_LITERAL) {
            PsiBuilder.Marker literalTypeMark = this.builder.mark();
            PsiBuilder.Marker prefixMark = null;
            if (type == JSTokenTypes.MINUS) {
                prefixMark = this.builder.mark();
                this.builder.advanceLexer();
            }
            PsiBuilder.Marker expressionMarker = this.builder.mark();
            this.builder.advanceLexer();
            expressionMarker.done(JSStubElementTypes.LITERAL_EXPRESSION);
            if (prefixMark != null) {
                prefixMark.done(JSElementTypes.PREFIX_EXPRESSION);
            }
            literalTypeMark.done(TypeScriptStubElementTypes.NUMBER_LITERAL_TYPE);
            return true;
        }
        if (JSTokenTypes.BOOLEAN_LITERALS.contains(type)) {
            this.parseSingleTokenLiteralType((IElementType)TypeScriptStubElementTypes.BOOLEAN_LITERAL_TYPE);
            return true;
        }
        if (type == JSTokenTypes.FUNCTION_KEYWORD) {
            return this.parseJSDocFunctionType();
        }
        if (type == JSTokenTypes.EXCL || type == JSTokenTypes.MULT || type == JSTokenTypes.QUEST) {
            return this.parseJSDocAnyOrDecoratedType();
        }
        this.builder.error(this.getTypeNameExpectedMessage());
        return false;
    }

    protected boolean parseFunctionOrParenthesizedType(boolean functionTypeAllowed) {
        boolean result2;
        boolean isFunctionType;
        boolean bl = isFunctionType = functionTypeAllowed && this.isFunctionTypeExpected();
        if (isFunctionType) {
            result2 = this.parseFunctionType();
        } else {
            PsiBuilder.Marker parenthesized = this.builder.mark();
            this.builder.advanceLexer();
            result2 = this.parseType();
            if (this.builder.getTokenType() == JSTokenTypes.RPAR) {
                this.builder.advanceLexer();
            } else {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.rparen", new Object[0]));
                result2 = false;
            }
            parenthesized.done(TypeScriptElementTypes.PARENTHESIZED_TYPE);
        }
        return result2;
    }

    private boolean parseJSDocAnyOrDecoratedType() {
        PsiBuilder.Marker mark = this.builder.mark();
        IElementType startToken = this.builder.getTokenType();
        this.builder.advanceLexer();
        if (startToken == JSTokenTypes.MULT) {
            mark.done(this.getSingleTypeElementType());
            return true;
        }
        boolean result2 = this.parseDistinctType(false, false);
        if (result2 || startToken == JSTokenTypes.EXCL) {
            mark.done(TypeScriptStubElementTypes.JSDOC_DECORATED_TYPE);
            return result2;
        }
        mark.rollbackTo();
        mark = this.builder.mark();
        this.builder.advanceLexer();
        mark.done(this.getSingleTypeElementType());
        return true;
    }

    protected boolean parseJSDocFunctionType() {
        PsiBuilder.Marker mark = this.builder.mark();
        this.builder.advanceLexer();
        IElementType token = this.builder.getTokenType();
        if (token == JSTokenTypes.LPAR) {
            boolean success;
            block8: {
                this.builder.advanceLexer();
                success = true;
                if (this.builder.getTokenType() != JSTokenTypes.RPAR) {
                    while (true) {
                        if (!this.parseJSDocFunctionTypeParameter()) {
                            success = false;
                            break block8;
                        }
                        IElementType type = this.builder.getTokenType();
                        if (type == JSTokenTypes.RPAR) {
                            this.builder.advanceLexer();
                            break block8;
                        }
                        if (type != JSTokenTypes.COMMA) break;
                        this.builder.advanceLexer();
                    }
                    success = false;
                } else {
                    PsiBuilder.Marker emptyMarker = this.builder.mark();
                    emptyMarker.done((IElementType)JSStubElementTypes.EMPTY_EXPRESSION);
                    this.builder.advanceLexer();
                }
            }
            if (!success) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.type", new Object[0]));
                mark.done(TypeScriptStubElementTypes.JSDOC_FUNCTION_TYPE);
                return true;
            }
            token = this.builder.getTokenType();
        }
        if (token == JSTokenTypes.COLON) {
            this.builder.advanceLexer();
            this.parseType();
        }
        mark.done(TypeScriptStubElementTypes.JSDOC_FUNCTION_TYPE);
        return true;
    }

    public boolean parseJSDocFunctionTypeParameter() {
        IElementType next;
        PsiBuilder.Marker mark = this.builder.mark();
        IElementType type = this.builder.getTokenType();
        if (type == JSTokenTypes.DOT_DOT_DOT) {
            this.builder.advanceLexer();
            IElementType afterDotDotDot = this.builder.getTokenType();
            if (afterDotDotDot == JSTokenTypes.RPAR || afterDotDotDot == JSTokenTypes.COMMA || this.builder.eof()) {
                mark.done(TypeScriptStubElementTypes.JSDOC_FUNCTION_TYPE_PARAMETER);
                return true;
            }
        } else if (type == JSTokenTypes.NEW_KEYWORD || type == JSTokenTypes.THIS_KEYWORD) {
            this.builder.advanceLexer();
            IElementType afterKind = this.builder.getTokenType();
            if (afterKind == JSTokenTypes.COLON) {
                this.builder.advanceLexer();
            } else {
                mark.done(TypeScriptStubElementTypes.JSDOC_FUNCTION_TYPE_PARAMETER);
                return true;
            }
        }
        if (this.isIdentifierToken(this.builder.getTokenType())) {
            if (this.builder.lookAhead(1) == JSTokenTypes.COLON) {
                if (this.isPossibleTypePrefxiWithColon()) {
                    this.builder.advanceLexer();
                    this.builder.advanceLexer();
                }
            } else if (this.builder.lookAhead(1) == JSTokenTypes.QUEST && this.builder.lookAhead(2) == JSTokenTypes.COLON) {
                this.builder.advanceLexer();
                this.builder.advanceLexer();
                this.builder.advanceLexer();
            }
        }
        boolean result2 = this.parseType();
        if (this.builder.getTokenType() == JSTokenTypes.COMMA && this.isIdentifierToken(next = this.builder.lookAhead(1))) {
            PsiBuilder.Marker temp = this.builder.mark();
            this.builder.advanceLexer();
            if ("optional".equals(this.builder.getTokenText())) {
                this.builder.remapCurrentToken(JSTokenTypes.QUEST);
                this.builder.advanceLexer();
                temp.drop();
            } else {
                temp.rollbackTo();
            }
        }
        if (this.builder.getTokenType() == JSTokenTypes.QUEST || this.builder.getTokenType() == JSTokenTypes.EQ) {
            this.builder.advanceLexer();
            IElementType valueCandidate = this.builder.getTokenType();
            if (this.isIdentifierToken(valueCandidate) || valueCandidate == JSTokenTypes.STRING_LITERAL || valueCandidate == JSTokenTypes.TRUE_KEYWORD || valueCandidate == JSTokenTypes.FALSE_KEYWORD || valueCandidate == JSTokenTypes.NULL_KEYWORD || valueCandidate == JSTokenTypes.UNDEFINED_KEYWORD) {
                this.builder.advanceLexer();
            }
        }
        mark.done(TypeScriptStubElementTypes.JSDOC_FUNCTION_TYPE_PARAMETER);
        return result2;
    }

    private boolean isPossibleTypePrefxiWithColon() {
        return this.builder.getTokenType() != JSTokenTypes.MODULE_KEYWORD && !"event".equals(this.builder.getTokenText()) && !"external".equals(this.builder.getTokenText());
    }

    private boolean validateReadonlyTail() {
        PsiBuilder.Marker indexerTailMarker = null;
        boolean parsedIndexerTail = true;
        boolean lastIsIndexer = false;
        while (this.builder.getTokenType() == JSTokenTypes.LBRACKET) {
            if (indexerTailMarker == null) {
                indexerTailMarker = this.builder.mark();
            }
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.RBRACKET) {
                this.builder.advanceLexer();
                lastIsIndexer = true;
                continue;
            }
            lastIsIndexer = false;
            parsedIndexerTail = this.parseType();
            if (!parsedIndexerTail) break;
            if (this.builder.getTokenType() != JSTokenTypes.RBRACKET) {
                parsedIndexerTail = false;
                break;
            }
            this.builder.advanceLexer();
        }
        if (indexerTailMarker != null) {
            indexerTailMarker.rollbackTo();
        }
        return parsedIndexerTail && lastIsIndexer;
    }

    private void parseStringTemplateAsTypeLiteral() {
        PsiBuilder.Marker mMarker = this.builder.mark();
        PsiBuilder.Marker expressionMarker = this.builder.mark();
        this.builder.advanceLexer();
        this.builder.advanceLexer();
        this.builder.advanceLexer();
        expressionMarker.done(JSStubElementTypes.STRING_TEMPLATE_EXPRESSION);
        mMarker.done(TypeScriptStubElementTypes.STRING_LITERAL_TYPE);
    }

    private boolean parseTemplateLiteralType() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.BACKQUOTE);
        boolean parsedSomething = false;
        PsiBuilder.Marker templateLiteralType = this.builder.mark();
        this.builder.advanceLexer();
        while (this.builder.getTokenType() != JSTokenTypes.BACKQUOTE) {
            if (this.builder.eof()) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.missing.back.quote", new Object[0]));
                templateLiteralType.done((IElementType)TypeScriptStubElementTypes.TEMPLATE_LITERAL_TYPE);
                return parsedSomething;
            }
            if (this.builder.getTokenType() == JSTokenTypes.STRING_TEMPLATE_PART) {
                this.builder.advanceLexer();
            } else if (this.builder.getTokenType() == JSTokenTypes.DOLLAR) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
                    this.builder.advanceLexer();
                    if (!this.parseType()) {
                        this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.type.name", new Object[0]));
                    }
                    TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.RBRACE, "javascript.parser.message.expected.rbrace");
                }
            } else {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.missing.back.quote", new Object[0]));
                this.builder.advanceLexer();
            }
            parsedSomething = true;
        }
        TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.BACKQUOTE, "javascript.parser.message.missing.back.quote");
        templateLiteralType.done((IElementType)TypeScriptStubElementTypes.TEMPLATE_LITERAL_TYPE);
        return true;
    }

    protected boolean allowSingleTemplateLiteralInType() {
        return true;
    }

    private boolean areArrayBracketsFollowing() {
        return this.builder.getTokenType() == JSTokenTypes.LBRACKET && this.builder.lookAhead(1) == JSTokenTypes.RBRACKET;
    }

    private boolean parseNamedOrThisType() {
        boolean result2;
        boolean isAssert = this.builder.getTokenType() == JSTokenTypes.ASSERTS_KEYWORD;
        IElementType lookAhead = this.builder.lookAhead(isAssert ? 2 : 1);
        if (lookAhead == JSTokenTypes.IS_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            if (isAssert) {
                this.builder.advanceLexer();
            }
            PsiBuilder.Marker innerMarker = this.builder.mark();
            this.builder.advanceLexer();
            innerMarker.done(JSElementTypes.REFERENCE_EXPRESSION);
            if (!TypeScriptPsiTypeParser.hasLineTerminatorBefore(this.builder)) {
                result2 = this.parseTypePredicate(marker);
            } else {
                marker.rollbackTo();
                result2 = this.parseSingleOrPrimitiveType();
            }
        } else if (isAssert) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            PsiBuilder.Marker innerMarker = this.builder.mark();
            this.builder.advanceLexer();
            innerMarker.done(JSElementTypes.REFERENCE_EXPRESSION);
            marker.done(TypeScriptStubElementTypes.TYPE_PREDICATE);
            result2 = true;
        } else {
            boolean isUniqueSymbol = false;
            if (this.isIdentifierToken(lookAhead) && "unique".equals(this.builder.getTokenText())) {
                PsiBuilder.Marker mark = this.builder.mark();
                this.builder.advanceLexer();
                if (!"symbol".equals(this.builder.getTokenText())) {
                    mark.rollbackTo();
                } else {
                    this.builder.advanceLexer();
                    mark.done(this.getSingleTypeElementType());
                    isUniqueSymbol = true;
                }
            }
            result2 = isUniqueSymbol || this.parseSingleOrPrimitiveType();
        }
        return result2;
    }

    protected boolean parseTypeOfInnerExpression() {
        if (this.builder.getTokenType() == JSTokenTypes.THIS_KEYWORD) {
            PsiBuilder.Marker marker = this.builder.mark();
            ((ES6Parser)this.myJavaScriptParser).buildTokenElement(JSElementTypes.THIS_EXPRESSION);
            if (this.builder.getTokenType() == JSTokenTypes.DOT && this.builder.lookAhead(1) == JSTokenTypes.PRIVATE_KEYWORD) {
                this.builder.advanceLexer();
                this.builder.advanceLexer();
                marker.done(JSElementTypes.REFERENCE_EXPRESSION);
                marker = marker.precede();
            }
            if (!this.parseQualifiedTypeNameRest(false, marker)) {
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
                return false;
            }
            return true;
        }
        if (!this.parseQualifiedTypeName()) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
            return false;
        }
        return true;
    }

    private void parseImportTypeInner() {
        PsiBuilder.Marker expr = this.builder.mark();
        PsiBuilder.Marker call = this.builder.mark();
        ((ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parseImportCall(call);
        if (!this.parseQualifiedTypeNameRest(false, expr)) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.expression", new Object[0]));
        }
    }

    protected final boolean parseSuffixType(@NotNull PsiBuilder.Marker typeMarker) {
        if (typeMarker == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(2);
        }
        return this.parseSuffixType(typeMarker, null);
    }

    protected boolean parseSuffixType(@NotNull PsiBuilder.Marker typeMarker, @Nullable PsiBuilder.Marker attributeListMarker) {
        if (typeMarker == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(3);
        }
        boolean result2 = true;
        while (this.canContinueParsingArray()) {
            this.builder.advanceLexer();
            if (this.isStartOfType()) {
                this.parseType();
                if (this.builder.getTokenType() != JSTokenTypes.RBRACKET) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.rbracket", new Object[0]));
                    result2 = false;
                    break;
                }
                this.builder.advanceLexer();
                typeMarker.done(TypeScriptStubElementTypes.INDEXED_ACCESS_TYPE);
            } else {
                if (this.builder.getTokenType() != JSTokenTypes.RBRACKET) {
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.rbracket", new Object[0]));
                    result2 = false;
                    break;
                }
                this.builder.advanceLexer();
                if (attributeListMarker != null && !this.canContinueParsingArray()) {
                    typeMarker.drop();
                    attributeListMarker.precede().done(TypeScriptStubElementTypes.ARRAY_TYPE);
                    return true;
                }
                typeMarker.done(TypeScriptStubElementTypes.ARRAY_TYPE);
            }
            typeMarker = typeMarker.precede();
        }
        typeMarker.drop();
        return result2;
    }

    private boolean canContinueParsingArray() {
        return this.builder.getTokenType() == JSTokenTypes.LBRACKET && !TypeScriptPsiTypeParser.hasLineTerminatorBefore(this.builder);
    }

    private void parseSingleTokenLiteralType(@NotNull IElementType literalType) {
        if (literalType == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(4);
        }
        PsiBuilder.Marker typeMarker = this.builder.mark();
        String errorMessage = ((ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).validateLiteral();
        ((ES6Parser)this.myJavaScriptParser).buildTokenElement((IElementType)JSStubElementTypes.LITERAL_EXPRESSION);
        if (errorMessage != null) {
            this.builder.error(errorMessage);
        }
        typeMarker.done(literalType);
    }

    private boolean parseSingleOrPrimitiveType() {
        if (NON_REFERENCE_PRIMITIVE_TYPES.contains(this.builder.getTokenType())) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            marker.done(this.getSingleTypeElementType());
            return true;
        }
        return this.parserSingleType();
    }

    protected boolean parserSingleType() {
        PsiBuilder.Marker marker = this.builder.mark();
        boolean result2 = this.parseQualifiedTypeName();
        marker.done(this.getSingleTypeElementType());
        return result2;
    }

    private boolean parseTypePredicate(PsiBuilder.Marker marker) {
        this.builder.advanceLexer();
        boolean result2 = this.parseType();
        marker.done(TypeScriptStubElementTypes.TYPE_PREDICATE);
        return result2;
    }

    protected boolean isFunctionTypeExpected() {
        return this.isFunctionTypeExpected(0);
    }

    private boolean isFunctionTypeExpected(int startIndex) {
        IElementType elementTypeAfterRPar;
        IElementType elementTypeAfterLPar = this.builder.lookAhead(startIndex + 1);
        if (elementTypeAfterLPar == null || elementTypeAfterLPar == JSTokenTypes.RPAR) {
            return true;
        }
        if (elementTypeAfterLPar == JSTokenTypes.DOT_DOT_DOT) {
            return true;
        }
        if (FunctionParser.willParseDestructuringAssignment(elementTypeAfterLPar) && JSArrowFunctionDetector.INSTANCE.isArrowFunctionType(this.builder, (FunctionParser<?>)((ES6Parser)this.myJavaScriptParser).getFunctionParser())) {
            return true;
        }
        if (elementTypeAfterLPar != JSTokenTypes.THIS_KEYWORD && !this.isIdentifierToken(elementTypeAfterLPar)) {
            return false;
        }
        IElementType elementTypeAfterIdentifier = this.builder.lookAhead(startIndex + 2);
        if (this.isDefinitelyFunctionToken(elementTypeAfterIdentifier)) {
            return true;
        }
        return elementTypeAfterIdentifier == JSTokenTypes.RPAR && (elementTypeAfterRPar = this.builder.lookAhead(startIndex + 3)) == JSTokenTypes.EQGT;
    }

    protected boolean isDefinitelyFunctionToken(@Nullable IElementType elementTypeAfterIdentifier) {
        return elementTypeAfterIdentifier == JSTokenTypes.COMMA || elementTypeAfterIdentifier == JSTokenTypes.COLON || elementTypeAfterIdentifier == JSTokenTypes.QUEST;
    }

    private boolean parseFunctionType() {
        PsiBuilder.Marker marker = this.builder.mark();
        if (this.builder.getTokenType() == JSTokenTypes.ABSTRACT_KEYWORD) {
            PsiBuilder.Marker attributeList = this.builder.mark();
            this.builder.advanceLexer();
            attributeList.done(JSStubElementTypes.ATTRIBUTE_LIST);
        }
        if (this.builder.getTokenType() == JSTokenTypes.NEW_KEYWORD) {
            this.builder.advanceLexer();
        }
        boolean result2 = this.parseFunctionParameterList();
        result2 = this.parseFunctionReturnType(marker, result2);
        return result2;
    }

    private boolean isAbstractNew(@Nullable IElementType type) {
        return type == JSTokenTypes.ABSTRACT_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.NEW_KEYWORD;
    }

    protected boolean parseFunctionReturnType(PsiBuilder.Marker marker, boolean result2) {
        result2 &= TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.EQGT, "javascript.parser.message.expected.eqgt");
        marker.done(TypeScriptStubElementTypes.FUNCTION_TYPE);
        return result2 &= this.parseTypeWithConditionalTypeAllowed(true);
    }

    private boolean parseTupleType() {
        PsiBuilder.Marker marker = this.builder.mark();
        boolean result2 = this.doParseTupleType();
        marker.done(this.getTupleTypeElementType());
        return result2;
    }

    @NotNull
    protected IElementType getTupleTypeElementType() {
        JSStubElementType<TypeScriptTupleTypeStub, TypeScriptTupleType> jSStubElementType = TypeScriptStubElementTypes.TUPLE_TYPE;
        if (jSStubElementType == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(5);
        }
        return jSStubElementType;
    }

    protected boolean doParseTupleType() {
        boolean result2 = true;
        assert (this.builder.getTokenType() == JSTokenTypes.LBRACKET);
        this.builder.advanceLexer();
        boolean commaExpected = false;
        while (this.builder.getTokenType() != JSTokenTypes.RBRACKET && !this.builder.eof()) {
            if (commaExpected && !TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.COMMA, "javascript.parser.message.expected.tuple.comma.or.rbracket")) {
                result2 = false;
                break;
            }
            if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.error(this.getTypeNameExpectedMessage());
                while (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                    this.builder.advanceLexer();
                }
            }
            if (this.builder.getTokenType() == JSTokenTypes.RBRACKET) break;
            if (!this.parseTupleTypeMember()) {
                result2 = false;
                break;
            }
            commaExpected = true;
        }
        if (!TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.RBRACKET, "javascript.parser.message.expected.rbracket")) {
            result2 = false;
        }
        return result2;
    }

    private boolean parseTupleTypeMember() {
        boolean isSpread;
        PsiBuilder.Marker element = this.builder.mark();
        boolean bl = isSpread = this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT;
        if (isSpread) {
            this.builder.advanceLexer();
        }
        if (this.isTupleElementName()) {
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.QUEST) {
                this.builder.advanceLexer();
            }
            assert (this.builder.getTokenType() == JSTokenTypes.COLON);
            this.builder.advanceLexer();
            if (!this.parseType()) {
                element.drop();
                return false;
            }
        } else {
            if (!this.parseType()) {
                element.drop();
                return false;
            }
            if (!isSpread && this.builder.getTokenType() == JSTokenTypes.QUEST) {
                this.builder.advanceLexer();
            }
        }
        element.done((IElementType)TypeScriptStubElementTypes.TUPLE_MEMBER_ELEMENT);
        return true;
    }

    private boolean isTupleElementName() {
        return JSKeywordSets.IDENTIFIER_NAMES.contains(this.builder.getTokenType()) && this.isStartOfType() && this.isNextTokenColonOrQuestionColon();
    }

    private boolean isNextTokenColonOrQuestionColon() {
        IElementType type = this.builder.lookAhead(1);
        return type == JSTokenTypes.COLON || type == JSTokenTypes.QUEST && this.builder.lookAhead(2) == JSTokenTypes.COLON;
    }

    public boolean parseObjectType() {
        if (this.builder.getTokenType() != JSTokenTypes.LBRACE) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.lbrace", new Object[0]));
            return false;
        }
        return this.parseObjectType(JSTokenTypes.RBRACE, "javascript.parser.message.missing.rbrace");
    }

    public boolean parseMappedType() {
        PsiBuilder.Marker mark = this.builder.mark();
        boolean result2 = this.parseMappedTypeNoMarker();
        mark.done(TypeScriptStubElementTypes.MAPPED_TYPE);
        return result2;
    }

    protected boolean isStartOfMappedType() {
        IElementType nextToken;
        int startCheckIndex = 1;
        IElementType type = this.builder.lookAhead(1);
        if (type == JSTokenTypes.PLUS || type == JSTokenTypes.MINUS) {
            type = this.builder.lookAhead(2);
            ++startCheckIndex;
        }
        if (type == JSTokenTypes.READONLY_KEYWORD) {
            ++startCheckIndex;
        }
        if ((nextToken = this.builder.lookAhead(startCheckIndex)) == null) {
            return false;
        }
        if (nextToken != JSTokenTypes.LBRACKET) {
            return false;
        }
        IElementType afterNext = this.builder.lookAhead(startCheckIndex + 1);
        if (!this.isIdentifierToken(afterNext)) {
            return false;
        }
        return this.builder.lookAhead(startCheckIndex + 2) == JSTokenTypes.IN_KEYWORD;
    }

    protected boolean parseMappedTypeNoMarker() {
        if (!TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.LBRACE, "javascript.parser.message.expected.lbrace")) {
            return false;
        }
        IElementType tokenType = this.builder.getTokenType();
        boolean mustHaveReadonly = false;
        if (tokenType == JSTokenTypes.PLUS || tokenType == JSTokenTypes.MINUS) {
            this.builder.advanceLexer();
            mustHaveReadonly = true;
        }
        if (!mustHaveReadonly && this.builder.getTokenType() == JSTokenTypes.READONLY_KEYWORD) {
            this.builder.advanceLexer();
        }
        if (mustHaveReadonly && !TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.READONLY_KEYWORD, "javascript.parser.message.expected.readonly")) {
            return false;
        }
        if (!TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.LBRACKET, "javascript.parser.message.expected.lbracket")) {
            return false;
        }
        if (!this.parseMappedTypeParameter()) {
            return false;
        }
        if (!TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.RBRACKET, "javascript.parser.message.expected.rbracket")) {
            return false;
        }
        boolean mustHaveQuestion = false;
        tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.PLUS || tokenType == JSTokenTypes.MINUS) {
            this.builder.advanceLexer();
            mustHaveQuestion = true;
        }
        if (!mustHaveQuestion && this.builder.getTokenType() == JSTokenTypes.QUEST) {
            this.builder.advanceLexer();
        }
        if (mustHaveQuestion && !TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.QUEST, "javascript.parser.message.expected.question")) {
            return false;
        }
        this.tryParseType();
        ((StatementParser)((ES6Parser)this.myJavaScriptParser).getStatementParser()).forceCheckForSemicolon();
        return TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.RBRACE, "javascript.parser.message.expected.rbrace");
    }

    protected boolean parseMappedTypeParameter() {
        PsiBuilder.Marker parameter = this.builder.mark();
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            parameter.drop();
            return false;
        }
        this.builder.advanceLexer();
        if (!TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.IN_KEYWORD, "javascript.parser.message.expected.in")) {
            parameter.drop();
            return false;
        }
        boolean result2 = this.parseType();
        if (this.builder.getTokenType() == JSTokenTypes.AS_KEYWORD) {
            this.builder.advanceLexer();
            result2 &= this.parseType();
        }
        parameter.done(TypeScriptStubElementTypes.MAPPED_TYPE_PARAMETER);
        return result2;
    }

    protected final boolean parseObjectType(@NotNull IElementType rBraceType, @PropertyKey(resourceBundle="messages.JavaScriptParser") @PropertyKey(resourceBundle="messages.JavaScriptParser") String missingRBraceMessageKey) {
        if (rBraceType == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(6);
        }
        PsiBuilder.Marker marker = this.builder.mark();
        IElementType lBraceType = this.builder.getTokenType();
        this.builder.advanceLexer();
        while (this.builder.getTokenType() != rBraceType) {
            if (this.builder.eof() || this.builder.getTokenType() == lBraceType) {
                this.builder.error(JavaScriptParserBundle.message(missingRBraceMessageKey, new Object[0]));
                marker.done(TypeScriptStubElementTypes.OBJECT_TYPE);
                return false;
            }
            this.parseTypeMember();
        }
        this.builder.advanceLexer();
        marker.done(TypeScriptStubElementTypes.OBJECT_TYPE);
        return true;
    }

    protected boolean parseTypeMember() {
        PsiBuilder.Marker typeMember = this.builder.mark();
        ((ES6Parser)this.myJavaScriptParser).parseModifiers(TYPE_MEMBER_MODIFIERS, true, AFTER_TYPE_MEMBER_MODIFIERS_PREDICATE);
        return this.parseTypeMember(typeMember);
    }

    protected final boolean parseTypeMember(@NotNull PsiBuilder.Marker typeMember) {
        boolean result2;
        IElementType firstToken;
        if (typeMember == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(7);
        }
        if (this.isFunctionHeaderStart(firstToken = this.builder.getTokenType()) || firstToken == JSTokenTypes.NEW_KEYWORD && this.isFunctionHeaderStart(this.builder.lookAhead(1))) {
            result2 = this.parseFunctionHeaderNoMarker(typeMember, (IElementType)JSStubElementTypes.CALL_SIGNATURE);
        } else if ((firstToken == JSTokenTypes.GET_KEYWORD || firstToken == JSTokenTypes.SET_KEYWORD) && JSKeywordSets.PROPERTY_NAMES.contains(this.builder.lookAhead(1))) {
            PsiBuilder.Marker attributeList = this.builder.mark();
            this.builder.advanceLexer();
            attributeList.done(JSStubElementTypes.ATTRIBUTE_LIST);
            ((ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).advancePropertyName(this.builder.getTokenType());
            result2 = this.parseInterfaceSimplePropertyOrFunction(typeMember);
        } else if (JSKeywordSets.PROPERTY_NAMES.contains(firstToken)) {
            ((ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).advancePropertyName(firstToken);
            result2 = this.parseInterfaceSimplePropertyOrFunction(typeMember);
        } else if (firstToken == JSTokenTypes.LBRACKET) {
            if (this.isIndexSignatureProperty()) {
                result2 = this.parseIndexSignatureNoMarker(typeMember, false);
            } else {
                this.parseTypeMemberPropertyName();
                result2 = this.parseInterfaceSimplePropertyOrFunction(typeMember);
            }
        } else if (firstToken == JSTokenTypes.COLON || firstToken == JSTokenTypes.QUEST) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.type.member", new Object[0]));
            this.parseInterfaceSimplePropertyOrFunction(typeMember);
            result2 = false;
        } else {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.type.member", new Object[0]));
            this.builder.advanceLexer();
            typeMember.drop();
            result2 = false;
        }
        this.forceCheckForSemicolonOrComma();
        return result2;
    }

    protected void parseTypeMemberPropertyName() {
        ((ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parsePropertyName();
    }

    protected boolean isFunctionHeaderStart(IElementType token) {
        return token == JSTokenTypes.LPAR || token == JSTokenTypes.LT;
    }

    protected void forceCheckForSemicolonOrComma() {
        boolean checkForComma;
        boolean checkForSemicolon = ((StatementParser)((ES6Parser)this.myJavaScriptParser).getStatementParser()).checkForSemicolon();
        if (!(checkForSemicolon || (checkForComma = this.checkForComma()) || TypeScriptPsiTypeParser.hasLineTerminatorBefore(this.builder))) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.newline.or.semicolon", new Object[0]));
        }
    }

    private boolean checkForComma() {
        IElementType tokenType = this.builder.getTokenType();
        if (tokenType == JSTokenTypes.COMMA) {
            this.builder.advanceLexer();
            return true;
        }
        return false;
    }

    public boolean parseInterfaceSimplePropertyOrFunction(PsiBuilder.Marker typeMember) {
        if (this.builder.getTokenType() == JSTokenTypes.QUEST) {
            this.builder.advanceLexer();
        }
        if (this.isFunctionHeaderStart(this.builder.getTokenType())) {
            this.parseFunctionHeaderNoMarker(typeMember, this.getFunctionSignatureElementType());
        } else {
            if (this.builder.getTokenType() == JSTokenTypes.COLON) {
                this.tryParseObjectMemberType();
            }
            typeMember.done(this.getPropertySignatureElementType());
            typeMember.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        }
        return true;
    }

    @NotNull
    protected IElementType getPropertySignatureElementType() {
        JSStubElementType<TypeScriptPropertySignatureStub, TypeScriptPropertySignature> jSStubElementType = TypeScriptStubElementTypes.PROPERTY_SIGNATURE;
        if (jSStubElementType == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(8);
        }
        return jSStubElementType;
    }

    protected boolean tryParseObjectMemberType() {
        return this.tryParseType();
    }

    @NotNull
    protected IElementType getFunctionSignatureElementType() {
        JSStubElementType<TypeScriptFunctionSignatureStub, TypeScriptFunctionSignature> jSStubElementType = JSStubElementTypes.FUNCTION_SIGNATURE;
        if (jSStubElementType == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(9);
        }
        return jSStubElementType;
    }

    public boolean isIndexSignatureProperty() {
        IElementType firstToken = this.builder.getTokenType();
        if (firstToken != JSTokenTypes.LBRACKET) {
            return false;
        }
        IElementType secondToken = this.builder.lookAhead(1);
        if (!this.isIdentifierToken(secondToken)) {
            return false;
        }
        IElementType thirdToken = this.builder.lookAhead(2);
        return thirdToken == JSTokenTypes.COLON;
    }

    private boolean parseFunctionHeaderNoMarker(PsiBuilder.Marker marker, IElementType elementType) {
        if (this.builder.getTokenType() == JSTokenTypes.NEW_KEYWORD) {
            this.builder.advanceLexer();
        }
        assert (this.isFunctionHeaderStart(this.builder.getTokenType()));
        boolean result2 = this.parseFunctionParameterList();
        boolean bl = this.builder.getTokenType() != JSTokenTypes.COLON || this.tryParseType();
        marker.done(elementType);
        marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return result2 &= bl;
    }

    protected boolean parseFunctionParameterList() {
        return !((FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).parseParameterList((boolean)false).hasErrors;
    }

    public boolean parseIndexSignatureNoMarker(PsiBuilder.Marker marker, boolean checkSemicolon) {
        return TypeScriptPsiTypeParser.parseIndexSignatureNoMarker(marker, this.builder, (ES6Parser)this.myJavaScriptParser, checkSemicolon, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean parseIndexSignatureNoMarker(PsiBuilder.Marker marker, PsiBuilder builder2, ES6Parser parser2, boolean checkSemicolon, boolean requireVarName) {
        boolean result2;
        boolean hasColon;
        assert (builder2.getTokenType() == JSTokenTypes.LBRACKET);
        builder2.advanceLexer();
        boolean bl = hasColon = builder2.lookAhead(1) == JSTokenTypes.COLON;
        if (hasColon && requireVarName && !parser2.isIdentifierToken(builder2.getTokenType())) {
            builder2.error(JavaScriptParserBundle.message("javascript.parser.message.expected.name", new Object[0]));
            marker.drop();
            return false;
        }
        @Nullable FunctionParser.MethodEmptiness data = (FunctionParser.MethodEmptiness)((Object)builder2.getUserData(FunctionParser.methodsEmptinessKey));
        try {
            builder2.putUserData(FunctionParser.methodsEmptinessKey, (Object)(hasColon ? FunctionParser.MethodEmptiness.POSSIBLY : FunctionParser.MethodEmptiness.ALWAYS));
            result2 = ((FunctionParser)parser2.getFunctionParser()).parseSingleParameter(builder2.mark());
        }
        finally {
            builder2.putUserData(FunctionParser.methodsEmptinessKey, (Object)data);
        }
        if (builder2.getTokenType() != JSTokenTypes.RBRACKET) {
            builder2.error(JavaScriptParserBundle.message("javascript.parser.message.expected.rbracket", new Object[0]));
            marker.done(TypeScriptStubElementTypes.INDEX_SIGNATURE);
            marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
            return result2;
        }
        builder2.advanceLexer();
        result2 &= builder2.getTokenType() != JSTokenTypes.COLON || ((JSPsiTypeParser)parser2.getTypeParser()).tryParseType();
        if (checkSemicolon) {
            ((StatementParser)parser2.getStatementParser()).forceCheckForSemicolon();
        }
        marker.done(TypeScriptStubElementTypes.INDEX_SIGNATURE);
        marker.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        return result2;
    }

    protected boolean isStartOfType() {
        return this.isStartOfType(this.builder.getTokenType(), 0);
    }

    protected boolean isStartOfType(IElementType type, int startIndex) {
        if (type == null) {
            return false;
        }
        if (NON_REFERENCE_PRIMITIVE_TYPES.contains(type) || JSKeywordSets.PRIMITIVE_TYPES.contains(type) || JSTokenTypes.IMPORT_KEYWORD == type || JSTokenTypes.THIS_KEYWORD == type || JSTokenTypes.TYPEOF_KEYWORD == type || JSTokenTypes.NEW_KEYWORD == type || JSTokenTypes.STRING_LITERAL == type || JSTokenTypes.NUMERIC_LITERAL == type || JSTokenTypes.TRUE_KEYWORD == type || JSTokenTypes.FALSE_KEYWORD == type || JSTokenTypes.LBRACE == type || JSTokenTypes.LBRACKET == type || JSTokenTypes.LT == type || JSTokenTypes.OR == type || JSTokenTypes.AND == type || JSTokenTypes.BACKQUOTE == type) {
            return true;
        }
        if (JSTokenTypes.MINUS == type && this.builder.lookAhead(startIndex + 1) == JSTokenTypes.NUMERIC_LITERAL) {
            return true;
        }
        if (type == JSTokenTypes.LPAR) {
            if (this.isFunctionTypeExpected(startIndex)) {
                return true;
            }
            IElementType lookAheadElement = this.builder.lookAhead(startIndex + 1);
            if (lookAheadElement == JSTokenTypes.RPAR) {
                return true;
            }
            return this.isStartOfType(lookAheadElement, startIndex + 1);
        }
        return this.isIdentifierToken(type);
    }

    @Override
    public boolean tryParseTypeParameterList() {
        boolean result2 = true;
        if (this.builder.getTokenType() == JSTokenTypes.LT) {
            PsiBuilder.Marker typeParameterList = this.builder.mark();
            this.builder.advanceLexer();
            boolean first = true;
            while (this.builder.getTokenType() != JSTokenTypes.GT && !this.builder.eof()) {
                if (!first && !TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.COMMA, "javascript.parser.message.expected.comma")) {
                    typeParameterList.drop();
                    return false;
                }
                if (!first && this.builder.getTokenType() == JSTokenTypes.GT) break;
                boolean typeParameterParsed = this.parseTypeParameter();
                result2 &= typeParameterParsed;
                if (!typeParameterParsed) {
                    this.builder.advanceLexer();
                }
                first = false;
            }
            this.builder.advanceLexer();
            typeParameterList.done(TypeScriptStubElementTypes.TYPE_PARAMETER_LIST);
        }
        return result2;
    }

    public boolean parseTypeParameter() {
        if (!this.isIdentifierToken(this.builder.getTokenType()) && !JSTokenTypes.TYPE_PARAMETER_MODIFIERS.contains(this.builder.getTokenType())) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.identifier", new Object[0]));
            return false;
        }
        PsiBuilder.Marker typeParameter = this.builder.mark();
        if (JSTokenTypes.TYPE_PARAMETER_MODIFIERS.contains(this.builder.getTokenType())) {
            ((ES6Parser)this.myJavaScriptParser).parseModifiers(TYPE_PARAMETER_MODIFIERS_STRUCTURE, true, this.AFTER_TYPE_PARAMETER_MODIFIERS_PREDICATE);
        }
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSTokenTypes.EXTENDS_KEYWORD) {
            this.builder.advanceLexer();
            PsiBuilder.Marker constraint = this.builder.mark();
            this.parseType();
            constraint.done((IElementType)TypeScriptStubElementTypes.TYPE_PARAMETER_CONSTRAINT);
        }
        if (this.builder.getTokenType() == JSTokenTypes.EQ) {
            this.builder.advanceLexer();
            PsiBuilder.Marker defaultType = this.builder.mark();
            this.parseType();
            defaultType.done((IElementType)TypeScriptStubElementTypes.TYPE_PARAMETER_DEFAULT);
        }
        typeParameter.done(TypeScriptStubElementTypes.TYPE_PARAMETER);
        return true;
    }

    public boolean parseOptionalTypeArgumentListInExpression() {
        if (this.builder.getTokenType() == JSTokenTypes.LT) {
            IElementType tokenType;
            PsiBuilder.Marker marker = this.builder.mark();
            if (this.tryParseTypeArgumentList(true, false, true) && this.isAcceptableTokenTypeAfterTypeArguments(tokenType = this.builder.getTokenType())) {
                marker.drop();
                return true;
            }
            marker.rollbackTo();
        }
        return false;
    }

    protected boolean isAcceptableTokenTypeAfterTypeArguments(IElementType tokenType) {
        if (tokenType == null || tokenType == JSTokenTypes.LPAR || tokenType == JSTokenTypes.STRING_TEMPLATE_PART) {
            return true;
        }
        if (tokenType == JSTokenTypes.LT || tokenType == JSTokenTypes.GT || tokenType == JSTokenTypes.PLUS || tokenType == JSTokenTypes.MINUS) {
            return false;
        }
        if (TypeScriptPsiTypeParser.hasLineTerminatorBefore(this.builder)) {
            return true;
        }
        if (tokenType == JSTokenTypes.QUEST_QUEST || tokenType == JSTokenTypes.OROR || tokenType == JSTokenTypes.ANDAND || tokenType == JSTokenTypes.OR || tokenType == JSTokenTypes.XOR || tokenType == JSTokenTypes.AND || tokenType == JSTokenTypes.EQEQ || tokenType == JSTokenTypes.NE || tokenType == JSTokenTypes.EQEQEQ || tokenType == JSTokenTypes.NEQEQ || tokenType == JSTokenTypes.LE || tokenType == JSTokenTypes.GE || tokenType == JSTokenTypes.INSTANCEOF_KEYWORD || tokenType == JSTokenTypes.IN_KEYWORD || tokenType == JSTokenTypes.AS_KEYWORD || tokenType == JSTokenTypes.SATISFIES_KEYWORD || tokenType == JSTokenTypes.LTLT || tokenType == JSTokenTypes.GTGT || tokenType == JSTokenTypes.GTGTGT || tokenType == JSTokenTypes.MULT || tokenType == JSTokenTypes.DIV || tokenType == JSTokenTypes.PERC || tokenType == JSTokenTypes.MULTMULT) {
            return true;
        }
        if (tokenType == JSTokenTypes.SUPER_KEYWORD || tokenType == JSTokenTypes.NULL_KEYWORD || tokenType == JSTokenTypes.TRUE_KEYWORD || tokenType == JSTokenTypes.FALSE_KEYWORD || tokenType == JSTokenTypes.NUMERIC_LITERAL || tokenType == JSTokenTypes.STRING_LITERAL || tokenType == JSTokenTypes.STRING_LITERAL_PART || tokenType == JSTokenTypes.LBRACKET || tokenType == JSTokenTypes.LBRACE || tokenType == JSTokenTypes.FUNCTION_KEYWORD || tokenType == JSTokenTypes.CLASS_KEYWORD || tokenType == JSTokenTypes.NEW_KEYWORD || tokenType == JSTokenTypes.DIVEQ || tokenType == JSTokenTypes.IDENTIFIER || tokenType == JSTokenTypes.IMPORT_KEYWORD && (this.builder.lookAhead(1) == JSTokenTypes.LPAR || this.builder.lookAhead(1) == JSTokenTypes.LT || this.builder.lookAhead(1) == JSTokenTypes.DOT)) {
            return false;
        }
        return tokenType != JSTokenTypes.TILDE && tokenType != JSTokenTypes.EXCL && tokenType != JSTokenTypes.DELETE_KEYWORD && tokenType != JSTokenTypes.TYPEOF_KEYWORD && tokenType != JSTokenTypes.VOID_KEYWORD && tokenType != JSTokenTypes.PLUSPLUS && tokenType != JSTokenTypes.MINUSMINUS && tokenType != JSTokenTypes.AWAIT_KEYWORD && tokenType != JSTokenTypes.YIELD_KEYWORD && tokenType != JSTokenTypes.PRIVATE_IDENTIFIER;
    }

    @Override
    public boolean tryParseTypeArgumentList(boolean revert, boolean allowNewLine, boolean isExpression) {
        boolean result2 = true;
        if (this.builder.getTokenType() == JSTokenTypes.LT && (allowNewLine || !TypeScriptPsiTypeParser.hasLineTerminatorBefore(this.builder))) {
            PsiBuilder.Marker typeArgumentList = this.builder.mark();
            this.builder.advanceLexer();
            boolean first = true;
            while (this.builder.getTokenType() != JSTokenTypes.GT && !this.builder.eof()) {
                if (!first) {
                    if (!TypeScriptPsiTypeParser.checkMatches(this.builder, JSTokenTypes.COMMA, "javascript.parser.message.expected.comma")) {
                        if (revert) {
                            typeArgumentList.rollbackTo();
                        } else {
                            typeArgumentList.drop();
                        }
                        return false;
                    }
                    if (this.builder.getTokenType() == JSTokenTypes.GT) {
                        if (this.allowTypeArgumentsTrailingComma()) break;
                        this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.type", new Object[0]));
                        break;
                    }
                }
                if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                    if (first) {
                        first = false;
                    }
                    this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.type", new Object[0]));
                    continue;
                }
                if (!(result2 &= this.parseTypeInGenericArgument()) && revert) {
                    typeArgumentList.rollbackTo();
                    return false;
                }
                first = false;
            }
            if (isExpression) {
                ES6ExpressionParser.collapseGtAndGetPriority(true, this.builder);
            }
            if (this.builder.getTokenType() != JSTokenTypes.GT) {
                if (revert) {
                    typeArgumentList.rollbackTo();
                    return false;
                }
                this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.gt", new Object[0]));
            } else {
                this.builder.advanceLexer();
            }
            typeArgumentList.done(TypeScriptStubElementTypes.TYPE_ARGUMENT_LIST);
        }
        return result2;
    }

    protected boolean allowTypeArgumentsTrailingComma() {
        return false;
    }

    public boolean parseTypeInGenericArgument() {
        PsiBuilder.Marker outer = null;
        if (this.isIdentifierToken(this.builder.getTokenType()) && this.builder.lookAhead(1) == JSTokenTypes.EQ) {
            outer = this.builder.mark();
            this.builder.advanceLexer();
            this.builder.advanceLexer();
        }
        boolean result2 = this.parseType();
        if (outer != null) {
            outer.done(TypeScriptElementTypes.NAMED_GENERIC_ARGUMENT_TYPE);
        }
        return result2;
    }

    @Override
    public boolean parseTypeAliasType() {
        if (this.builder.getTokenType() != JSTokenTypes.EQ) {
            this.builder.error(JavaScriptParserBundle.message("javascript.parser.message.expected.equal", new Object[0]));
            return false;
        }
        this.builder.advanceLexer();
        return this.parseType();
    }

    @NotNull
    protected IElementType getSingleTypeElementType() {
        JSStubElementType<TypeScriptSingleTypeStub, TypeScriptSingleType> jSStubElementType = TypeScriptStubElementTypes.SINGLE_TYPE;
        if (jSStubElementType == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(10);
        }
        return jSStubElementType;
    }

    @Override
    @NotNull
    protected String getTypeNameExpectedMessage() {
        String string = JavaScriptParserBundle.message("javascript.parser.message.expected.typename", new Object[0]);
        if (string == null) {
            TypeScriptPsiTypeParser.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMarker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalType";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/parsing/TypeScriptPsiTypeParser";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBraceType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMember";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/parsing/TypeScriptPsiTypeParser";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTupleTypeElementType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertySignatureElementType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionSignatureElementType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleTypeElementType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeNameExpectedMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseAfterDotInQualifiedTypeNameRest";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseSuffixType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseSingleTokenLiteralType";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseObjectType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseTypeMember";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

