/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathBuilder;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathConfiguration;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathMappings;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitutionImpl;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\t\u001a\u00020\nH$J$\u0010\u001a\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u001b2\u0006\u0010\t\u001a\u00020\nH\u0004J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0002J+\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\"\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010#J3\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020(2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a2\u0006\u0002\u0010)\u00a8\u0006*"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/JSImportMapContributorBase;", "Lcom/intellij/lang/javascript/psi/resolve/JSModuleReferenceContributor;", "<init>", "()V", "getAllReferences", "", "Lcom/intellij/psi/PsiReference;", "unquotedEscapedText", "", "host", "Lcom/intellij/psi/PsiElement;", "offset", "", "provider", "Lcom/intellij/psi/PsiReferenceProvider;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;ILcom/intellij/psi/PsiReferenceProvider;)[Lcom/intellij/psi/PsiReference;", "getAdditionalDescriptors", "", "Lcom/intellij/lang/javascript/modules/imports/JSImportDescriptor;", "configuration", "Lcom/intellij/lang/ecmascript6/psi/impl/JSImportPathConfiguration;", "baseDescriptor", "isApplicable", "", "findImportMapFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "readImportMap", "Lkotlin/Pair;", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathMappings;", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathSubstitution;", "parseMap", "file", "Lcom/intellij/json/psi/JsonFile;", "resolveAsImportMap", "unquotedRefText", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;I)[Lcom/intellij/psi/PsiReference;", "resolveAsImportMapExactText", "importMapFile", "exactPath", "range", "Lcom/intellij/openapi/util/TextRange;", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "intellij.javascript.impl"})
public abstract class JSImportMapContributorBase
implements JSModuleReferenceContributor {
    @Override
    @NotNull
    public PsiReference[] getAllReferences(@NotNull String unquotedEscapedText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        Intrinsics.checkNotNullParameter((Object)unquotedEscapedText, (String)"unquotedEscapedText");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return this.resolveAsImportMap(unquotedEscapedText, host, offset);
    }

    @Override
    @NotNull
    public List<JSImportDescriptor> getAdditionalDescriptors(@NotNull JSImportPathConfiguration configuration, @NotNull JSImportDescriptor baseDescriptor) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)baseDescriptor, (String)"baseDescriptor");
        PsiElement psiElement = configuration.getPlace();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPlace(...)");
        Pair<JSModulePathMappings<JSModulePathSubstitution>, VirtualFile> pair = this.readImportMap(psiElement);
        if (pair == null) {
            return CollectionsKt.emptyList();
        }
        Pair<JSModulePathMappings<JSModulePathSubstitution>, VirtualFile> pair2 = pair;
        JSModulePathMappings pathSubstitutions = (JSModulePathMappings)pair2.component1();
        VirtualFile importMapFile = (VirtualFile)pair2.component2();
        if (pathSubstitutions.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        JSImportPathBuilder jSImportPathBuilder = JSImportPathBuilder.createBuilder(configuration);
        Intrinsics.checkNotNullExpressionValue((Object)jSImportPathBuilder, (String)"createBuilder(...)");
        JSImportPathBuilder builder2 = jSImportPathBuilder;
        List<JSImportDescriptor> list = builder2.getMappingsForBaseUrl(importMapFile.getParent(), (JSModulePathMappings<? extends JSModulePathSubstitution>)pathSubstitutions);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getMappingsForBaseUrl(...)");
        return list;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return this.findImportMapFile(host) != null;
    }

    @Nullable
    protected abstract VirtualFile findImportMapFile(@NotNull PsiElement var1);

    @Nullable
    protected final Pair<JSModulePathMappings<JSModulePathSubstitution>, VirtualFile> readImportMap(@NotNull PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        VirtualFile virtualFile = this.findImportMapFile(host);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile importMapFile = virtualFile;
        PsiFile psiFile = host.getManager().findFile(importMapFile);
        JsonFile jsonFile = psiFile instanceof JsonFile ? (JsonFile)psiFile : null;
        if (jsonFile == null) {
            return null;
        }
        JsonFile jsonMapFile = jsonFile;
        return new Pair(CachedValuesManager.getCachedValue((PsiElement)((PsiElement)jsonMapFile), () -> JSImportMapContributorBase.readImportMap$lambda$0(this, jsonMapFile)), (Object)importMapFile);
    }

    private final JSModulePathMappings<JSModulePathSubstitution> parseMap(JsonFile file) {
        JsonValue topLevelValue = file.getTopLevelValue();
        if (!(topLevelValue instanceof JsonObject)) {
            return JSModulePathMappings.Companion.empty();
        }
        JsonProperty jsonProperty = ((JsonObject)topLevelValue).findProperty("imports");
        if (jsonProperty == null || (jsonProperty = jsonProperty.getValue()) == null) {
            return JSModulePathMappings.Companion.empty();
        }
        JsonProperty importsValue = jsonProperty;
        if (!(importsValue instanceof JsonObject)) {
            return JSModulePathMappings.Companion.empty();
        }
        List result2 = new ArrayList();
        for (JsonProperty jsonProperty2 : ((JsonObject)importsValue).getPropertyList()) {
            String name;
            Intrinsics.checkNotNullExpressionValue((Object)jsonProperty2.getName(), (String)"getName(...)");
            JsonValue jsonValue = jsonProperty2.getValue();
            Object object = jsonValue instanceof JsonStringLiteral ? (JsonStringLiteral)jsonValue : null;
            if (object == null || (object = object.getValue()) == null) continue;
            Object value = object;
            result2.add(new JSModulePathSubstitutionImpl(name, (String)value){

                public boolean canStartWith() {
                    String string = this.getMappedName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMappedName(...)");
                    return StringsKt.endsWith$default((String)string, (String)"/", (boolean)false, (int)2, null);
                }
            });
        }
        return JSModulePathMappings.Companion.build(result2);
    }

    private final PsiReference[] resolveAsImportMap(String unquotedRefText, PsiElement host, int offset) {
        Pair<JSModulePathMappings<JSModulePathSubstitution>, VirtualFile> pair = this.readImportMap(host);
        if (pair == null) {
            return new PsiReference[0];
        }
        Pair<JSModulePathMappings<JSModulePathSubstitution>, VirtualFile> pair2 = pair;
        JSModulePathMappings substitutions = (JSModulePathMappings)pair2.component1();
        VirtualFile importMapFile = (VirtualFile)pair2.component2();
        if (substitutions.isEmpty()) {
            return new PsiReference[0];
        }
        Collection<String> collection = JSPathMappingsUtil.substituteMappings(unquotedRefText, substitutions);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"substituteMappings(...)");
        String string = (String)CollectionsKt.firstOrNull((Iterable)collection);
        if (string == null) {
            return new PsiReference[0];
        }
        String exactPath = string;
        TextRange textRange = TextRange.create((int)offset, (int)(offset + unquotedRefText.length()));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
        TextRange range = textRange;
        if (!Intrinsics.areEqual((Object)exactPath, (Object)unquotedRefText)) {
            return this.resolveAsImportMapExactText(importMapFile, exactPath, range, host);
        }
        return new PsiReference[0];
    }

    @NotNull
    protected PsiReference[] resolveAsImportMapExactText(@NotNull VirtualFile importMapFile, @NotNull String exactPath, @NotNull TextRange range, @NotNull PsiElement host) {
        Intrinsics.checkNotNullParameter((Object)importMapFile, (String)"importMapFile");
        Intrinsics.checkNotNullParameter((Object)exactPath, (String)"exactPath");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        String string = JSPathMappingsUtil.getStringPathRelativeBaseUrlOrSelfIfAbsolute(importMapFile.getParent(), exactPath);
        if (string == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        String file = string;
        PsiReference[] psiReferenceArray = new PsiReference[1];
        List list = CollectionsKt.listOf((Object)file);
        psiReferenceArray[0] = new JSExactFileReference(host, range, list){

            public int getWeight() {
                return JSModuleBaseReference.ModuleTypes.PATH_MAPPING.weight();
            }
        };
        return psiReferenceArray;
    }

    private static final CachedValueProvider.Result readImportMap$lambda$0(JSImportMapContributorBase this$0, JsonFile $jsonMapFile) {
        Object[] objectArray = new Object[]{$jsonMapFile};
        return new CachedValueProvider.Result(this$0.parseMap($jsonMapFile), objectArray);
    }
}

