/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index.gist;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.index.gist.BufferedExternalizer;
import com.intellij.lang.javascript.index.gist.JSDefinitionExpressionData;
import com.intellij.lang.javascript.index.gist.JSDefinitionExpressionGistProvider;
import com.intellij.lang.javascript.index.gist.JSDestructuringParameterData;
import com.intellij.lang.javascript.index.gist.JSDestructuringParameterGistProvider;
import com.intellij.lang.javascript.index.gist.JSFunctionDataGistProvider;
import com.intellij.lang.javascript.index.gist.JSParameterData;
import com.intellij.lang.javascript.index.gist.JSParameterGistProvider;
import com.intellij.lang.javascript.index.gist.JSPropertyData;
import com.intellij.lang.javascript.index.gist.JSPropertyGistProvider;
import com.intellij.lang.javascript.index.gist.JSStubElementGistProvider;
import com.intellij.lang.javascript.index.gist.JSVariableBaseData;
import com.intellij.lang.javascript.index.gist.JSVariableBaseGistProvider;
import com.intellij.lang.javascript.index.gist.ListExternalizer;
import com.intellij.lang.javascript.index.gist.StubValueMap;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.impl.JSDefinitionExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSDestructuringParameterImpl;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSFunctionCachedData;
import com.intellij.lang.javascript.psi.impl.JSParameterImpl;
import com.intellij.lang.javascript.psi.impl.JSPropertyImpl;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSGistDataOwnerStub;
import com.intellij.lang.javascript.psi.util.SoftlyCachedValue;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.GistModificationTracker;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.Reference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
public final class JSStubElementGist
implements Disposable {
    private static final Key<CachedValue<Object>> DATA_ON_PSI_KEY = Key.create((String)"js.stub.element.gist.key");
    private static final Key<SoftlyCachedValue<SoftlyCachedValue.FinalRef<StubValueMap<JSStubElementGistValue>>>> DATA_FROM_GIST_KEY = Key.create((String)"js.file.data.from.gist.key");
    private static final Logger LOG = Logger.getInstance(JSStubElementGist.class);
    private final Set<VirtualFile> myScheduledGistCalculations;
    private static final int MAX_THREADS = SystemProperties.getIntProperty((String)"idea.gist.calculation.max.threads", (int)4);
    private static final ExecutorService EXECUTOR_SERVICE = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Stub Element Gist Calculation", (int)MAX_THREADS);
    @NotNull
    private static final List<Pair<Class<? extends StubBasedPsiElementBase>, JSStubElementGistProvider>> PROVIDERS = List.of(Pair.create(JSFunctionBaseImpl.class, (Object)new JSFunctionDataGistProvider()), Pair.create(JSParameterImpl.class, (Object)new JSParameterGistProvider()), Pair.create(JSVariableBaseImpl.class, (Object)new JSVariableBaseGistProvider()), Pair.create(JSDestructuringParameterImpl.class, (Object)new JSDestructuringParameterGistProvider()), Pair.create(JSPropertyImpl.class, (Object)new JSPropertyGistProvider()), Pair.create(JSDefinitionExpressionImpl.class, (Object)new JSDefinitionExpressionGistProvider()));
    @NotNull
    public static final DataExternalizer<JSStubElementGistValue> GIST_VALUE_EXTERNALIZER = JSStubElementGist.createExternalizer();
    @NotNull
    private static final VirtualFileGist<List<StubValueMap<JSStubElementGistValue>>> GIST = GistManager.getInstance().newVirtualFileGist("js.stub.element.gist", JSFileElementType.getVersion(), new BufferedExternalizer<StubValueMap<JSStubElementGistValue>>(new ListExternalizer<StubValueMap<JSStubElementGistValue>>(StubValueMap.createExternalizer(GIST_VALUE_EXTERNALIZER))), JSStubElementGist::calculate);
    @NotNull
    private final Project myProject;

    public JSStubElementGist(@NotNull Project project) {
        if (project == null) {
            JSStubElementGist.$$$reportNull$$$0(0);
        }
        this.myScheduledGistCalculations = ConcurrentCollectionFactory.createConcurrentSet();
        this.myProject = project;
    }

    @NotNull
    public static JSStubElementGist getInstance(@NotNull Project project) {
        if (project == null) {
            JSStubElementGist.$$$reportNull$$$0(1);
        }
        JSStubElementGist jSStubElementGist = (JSStubElementGist)project.getService(JSStubElementGist.class);
        if (jSStubElementGist == null) {
            JSStubElementGist.$$$reportNull$$$0(2);
        }
        return jSStubElementGist;
    }

    @NotNull
    public JSFunctionCachedData getData(@NotNull JSFunctionBaseImpl<?> psi) {
        if (psi == null) {
            JSStubElementGist.$$$reportNull$$$0(3);
        }
        JSFunctionCachedData jSFunctionCachedData = (JSFunctionCachedData)this.getData((StubBasedPsiElementBase<?>)psi);
        if (jSFunctionCachedData == null) {
            JSStubElementGist.$$$reportNull$$$0(4);
        }
        return jSFunctionCachedData;
    }

    @NotNull
    public JSParameterData getData(@NotNull JSParameterImpl psi) {
        if (psi == null) {
            JSStubElementGist.$$$reportNull$$$0(5);
        }
        JSParameterData jSParameterData = (JSParameterData)this.getData((StubBasedPsiElementBase<?>)psi);
        if (jSParameterData == null) {
            JSStubElementGist.$$$reportNull$$$0(6);
        }
        return jSParameterData;
    }

    @NotNull
    public JSVariableBaseData getData(@NotNull JSVariableBaseImpl<?, ?> psi) {
        if (psi == null) {
            JSStubElementGist.$$$reportNull$$$0(7);
        }
        JSVariableBaseData jSVariableBaseData = (JSVariableBaseData)this.getData((StubBasedPsiElementBase<?>)psi);
        if (jSVariableBaseData == null) {
            JSStubElementGist.$$$reportNull$$$0(8);
        }
        return jSVariableBaseData;
    }

    @NotNull
    public JSDestructuringParameterData getData(@NotNull JSDestructuringParameterImpl psi) {
        if (psi == null) {
            JSStubElementGist.$$$reportNull$$$0(9);
        }
        JSDestructuringParameterData jSDestructuringParameterData = (JSDestructuringParameterData)this.getData((StubBasedPsiElementBase<?>)psi);
        if (jSDestructuringParameterData == null) {
            JSStubElementGist.$$$reportNull$$$0(10);
        }
        return jSDestructuringParameterData;
    }

    @NotNull
    public JSPropertyData getData(@NotNull JSPropertyImpl psi) {
        if (psi == null) {
            JSStubElementGist.$$$reportNull$$$0(11);
        }
        JSPropertyData jSPropertyData = (JSPropertyData)this.getData((StubBasedPsiElementBase<?>)psi);
        if (jSPropertyData == null) {
            JSStubElementGist.$$$reportNull$$$0(12);
        }
        return jSPropertyData;
    }

    @NotNull
    public JSDefinitionExpressionData getData(@NotNull JSDefinitionExpressionImpl psi) {
        if (psi == null) {
            JSStubElementGist.$$$reportNull$$$0(13);
        }
        JSDefinitionExpressionData jSDefinitionExpressionData = (JSDefinitionExpressionData)this.getData((StubBasedPsiElementBase<?>)psi);
        if (jSDefinitionExpressionData == null) {
            JSStubElementGist.$$$reportNull$$$0(14);
        }
        return jSDefinitionExpressionData;
    }

    @NotNull
    public Object getData(@NotNull StubBasedPsiElementBase<?> psi) {
        PsiFile file;
        CachedValue cachedPsiData;
        Getter calculatedDataGetter;
        if (psi == null) {
            JSStubElementGist.$$$reportNull$$$0(15);
        }
        Getter getter = calculatedDataGetter = (cachedPsiData = (CachedValue)psi.getUserData(DATA_ON_PSI_KEY)) != null ? cachedPsiData.getUpToDateOrNull() : null;
        if (calculatedDataGetter != null) {
            Object object = calculatedDataGetter.get();
            if (object == null) {
                JSStubElementGist.$$$reportNull$$$0(16);
            }
            return object;
        }
        if (JSStubElementGist.useStubElementGists()) {
            JSStubElementGistValue dataFromGist = JSStubElementGist.getUpToDateOrNullFromGist(psi);
            if (dataFromGist != null) {
                Object object = dataFromGist.myData;
                if (object == null) {
                    JSStubElementGist.$$$reportNull$$$0(17);
                }
                return object;
            }
        } else {
            StubElement stub = psi.getGreenStub();
            if (stub != null) {
                Object object = ((JSGistDataOwnerStub)stub).getGistData();
                if (object == null) {
                    JSStubElementGist.$$$reportNull$$$0(18);
                }
                return object;
            }
        }
        if (JSStubElementGist.shouldCalculateGist(file = psi.getContainingFile())) {
            VirtualFile virtualFile = JSStubElementGist.getVirtualFile(file);
            this.scheduleGistCalculation(virtualFile);
        }
        return JSStubElementGist.getDataFromPsi(psi);
    }

    @NotNull
    private static VirtualFile getVirtualFile(@NotNull PsiFile file) {
        if (file == null) {
            JSStubElementGist.$$$reportNull$$$0(19);
        }
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        if (virtualFile == null) {
            JSStubElementGist.$$$reportNull$$$0(20);
        }
        return virtualFile;
    }

    public static boolean useStubElementGists() {
        return Registry.is((String)"js.use.stub.element.gists", (boolean)true);
    }

    private static boolean shouldCalculateGist(@NotNull PsiFile file) {
        if (file == null) {
            JSStubElementGist.$$$reportNull$$$0(21);
        }
        if (!JSStubElementGist.useStubElementGists()) {
            return false;
        }
        if (!(file instanceof PsiFileImpl) || ((PsiFileImpl)file).getElementTypeForStubBuilder() == null) {
            return false;
        }
        if (file instanceof PsiCompiledFile) {
            return false;
        }
        VirtualFile virtualFile = JSStubElementGist.getVirtualFile(file);
        if (!(virtualFile instanceof NewVirtualFile)) {
            return false;
        }
        return JSStubElementGist.arePsiAndDocumentSynchronized(virtualFile, file.getProject());
    }

    private static boolean arePsiAndDocumentSynchronized(@NotNull VirtualFile file, @NotNull Project project) {
        Document document;
        if (file == null) {
            JSStubElementGist.$$$reportNull$$$0(22);
        }
        if (project == null) {
            JSStubElementGist.$$$reportNull$$$0(23);
        }
        return (document = FileDocumentManager.getInstance().getCachedDocument(file)) == null || !PsiDocumentManager.getInstance((Project)project).isUncommited(document) && !FileDocumentManager.getInstance().isDocumentUnsaved(document);
    }

    @NotNull
    private static Object getDataFromPsi(@NotNull StubBasedPsiElementBase<?> psi) {
        if (psi == null) {
            JSStubElementGist.$$$reportNull$$$0(24);
        }
        Object object = AstLoadingFilter.forceAllowTreeLoading((PsiFile)psi.getContainingFile(), () -> CachedValuesManager.getCachedValue((PsiElement)psi, DATA_ON_PSI_KEY, () -> new CachedValueProvider.Result(((JSStubElementGistProvider)JSStubElementGist.findProvider((StubBasedPsiElementBase)psi).second).calculate(psi), new Object[]{psi})));
        if (object == null) {
            JSStubElementGist.$$$reportNull$$$0(25);
        }
        return object;
    }

    @Nullable
    private static JSStubElementGistValue getUpToDateOrNullFromGist(@NotNull StubBasedPsiElementBase<?> psi) {
        StubElement stub;
        if (psi == null) {
            JSStubElementGist.$$$reportNull$$$0(26);
        }
        if ((stub = psi.getGreenStub()) == null) {
            return null;
        }
        if (!(stub instanceof ObjectStubBase)) {
            LOG.error("Unsupported class " + stub.getClass());
            return null;
        }
        int id = ((ObjectStubBase)stub).getStubId();
        PsiFile file = psi.getContainingFile();
        if (!(file instanceof PsiFileImpl)) {
            return null;
        }
        StubValueMap<JSStubElementGistValue> data = JSStubElementGist.getUpToDateOrNullGistData((PsiFileImpl)file);
        if (data == null) {
            return null;
        }
        return data.get(id, GIST_VALUE_EXTERNALIZER);
    }

    @Nullable
    private static StubValueMap<JSStubElementGistValue> getUpToDateOrNullGistData(@NotNull PsiFileImpl psiFile) {
        if (psiFile == null) {
            JSStubElementGist.$$$reportNull$$$0(27);
        }
        if (!JSStubElementGist.arePsiAndDocumentSynchronized(JSStubElementGist.getVirtualFile((PsiFile)psiFile), psiFile.getProject())) {
            psiFile.putUserData(DATA_FROM_GIST_KEY, null);
            return null;
        }
        SoftlyCachedValue.FinalRef<StubValueMap<JSStubElementGistValue>> ref2 = SoftlyCachedValue.getOrComputeOnce((UserDataHolder)psiFile, DATA_FROM_GIST_KEY, () -> {
            VirtualFile virtualFile = JSStubElementGist.getVirtualFile((PsiFile)psiFile);
            Supplier upToDateOrNullFromGist = GIST.getUpToDateOrNull(null, virtualFile);
            if (upToDateOrNullFromGist == null) {
                return new SoftlyCachedValue(SoftlyCachedValue.FinalRef.nullRef(), ModificationTracker.EVER_CHANGED);
            }
            List allRootsData = (List)upToDateOrNullFromGist.get();
            int stubRootIndex = JSStubElementGist.getStubRootIndex(psiFile);
            StubValueMap data = stubRootIndex == -1 ? null : (StubValueMap)allRootsData.get(stubRootIndex);
            GistModificationTracker gistModificationTracker = new GistModificationTracker(virtualFile);
            return new SoftlyCachedValue<SoftlyCachedValue.FinalRef<StubValueMap>>(new SoftlyCachedValue.FinalRef<StubValueMap>(data), () -> gistModificationTracker.getModificationCount() + psiFile.getModificationStamp());
        });
        return ref2 != null ? ref2.getValue() : null;
    }

    private static int getStubRootIndex(@NotNull PsiFileImpl psiFile) {
        FileViewProvider viewProvider;
        List roots;
        int i;
        if (psiFile == null) {
            JSStubElementGist.$$$reportNull$$$0(28);
        }
        if ((i = ContainerUtil.indexOf((List)(roots = StubTreeBuilder.getStubbedRootDescriptors((FileViewProvider)(viewProvider = psiFile.getViewProvider()))), root -> ((PsiFile)root.second).equals(psiFile))) == -1) {
            LOG.error(psiFile.getClass().getSimpleName() + " is not found amongst roots of " + psiFile.getName());
        }
        return i;
    }

    private void scheduleGistCalculation(@NotNull VirtualFile file) {
        if (file == null) {
            JSStubElementGist.$$$reportNull$$$0(29);
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        if (this.myScheduledGistCalculations.add(file)) {
            EXECUTOR_SERVICE.execute(() -> {
                final EmptyProgressIndicator indicator = new EmptyProgressIndicator();
                Disposable disposable = new Disposable(){

                    public void dispose() {
                        indicator.cancel();
                    }
                };
                Disposer.register((Disposable)this, (Disposable)disposable);
                ProgressManager.getInstance().runInReadActionWithWriteActionPriority(() -> {
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    this.buildGist(file);
                }, (ProgressIndicator)indicator);
                Disposer.dispose((Disposable)disposable);
            });
        }
    }

    public void dispose() {
        this.myScheduledGistCalculations.clear();
    }

    @TestOnly
    public void buildGistSync(@NotNull PsiFileImpl file) {
        if (file == null) {
            JSStubElementGist.$$$reportNull$$$0(30);
        }
        if (!JSStubElementGist.useStubElementGists()) {
            return;
        }
        if (!JSStubElementGist.shouldCalculateGist((PsiFile)file) && file.getElementTypeForStubBuilder() != null) assert (false) : file.getName();
        this.buildGist(JSStubElementGist.getVirtualFile((PsiFile)file));
    }

    private void buildGist(@NotNull VirtualFile file) {
        if (file == null) {
            JSStubElementGist.$$$reportNull$$$0(31);
        }
        if (!JSStubElementGist.arePsiAndDocumentSynchronized(file, this.myProject)) {
            return;
        }
        try (AccessToken ignored = ProjectLocator.withPreferredProject((VirtualFile)file, (Project)this.myProject);){
            GIST.getFileData(null, file);
            this.myScheduledGistCalculations.remove(file);
        }
        catch (ProcessCanceledException e) {
            this.myScheduledGistCalculations.remove(file);
            this.scheduleGistCalculation(file);
            throw e;
        }
        catch (Throwable e) {
            this.myScheduledGistCalculations.remove(file);
            throw e;
        }
    }

    @NotNull
    private static List<StubValueMap<JSStubElementGistValue>> calculate(@Nullable Project _project, @NotNull VirtualFile file) {
        Project project;
        if (file == null) {
            JSStubElementGist.$$$reportNull$$$0(32);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(MessageFormat.format("Building gist for {0}, {1} on {2}", file.getName(), file.getClass().getSimpleName(), Thread.currentThread().getName()));
        }
        if (_project != null) {
            LOG.warn("null should be passed as Project to reuse gists between projects");
        }
        if ((project = ProjectUtil.guessProjectForFile((VirtualFile)file)) == null) {
            throw new IllegalArgumentException("Cannot build gist value without project, " + file.getPath());
        }
        FileViewProvider viewProvider = PsiManager.getInstance((Project)project).findViewProvider(file);
        if (viewProvider == null) {
            throw new RuntimeException("Failed to find FileViewProvider for " + file.getPath());
        }
        List stubbedRoots = ContainerUtil.map((Collection)StubTreeBuilder.getStubbedRootDescriptors((FileViewProvider)viewProvider), p -> (PsiFileImpl)p.getSecond());
        if (stubbedRoots.isEmpty()) {
            LOG.error("Stubbed roots are empty for " + file.getPath());
        }
        return JSStubElementGist.calculateForAllRoots(stubbedRoots);
    }

    @NotNull
    private static List<StubValueMap<JSStubElementGistValue>> calculateForAllRoots(@NotNull List<PsiFileImpl> stubbedRoots) {
        if (stubbedRoots == null) {
            JSStubElementGist.$$$reportNull$$$0(33);
        }
        ArrayList<StubValueMap<JSStubElementGistValue>> result2 = new ArrayList<StubValueMap<JSStubElementGistValue>>(stubbedRoots.size());
        for (PsiFileImpl root : stubbedRoots) {
            Pair pair = root.getStubTreeOrFileElement();
            StubTree stubTree = (StubTree)pair.getFirst();
            FileElement astTree = (FileElement)pair.getSecond();
            if (astTree == null) {
                astTree = (FileElement)AstLoadingFilter.forceAllowTreeLoading((PsiFile)root, () -> root.calcTreeElement());
            }
            if (stubTree == null) {
                stubTree = root.calcStubTree();
            }
            FileElement finalAstTree = astTree;
            StubTree finalStubTree = stubTree;
            JSTypeEvaluationLocationProvider.withGistCalculation((PsiElement)root, () -> result2.add(JSStubElementGist.calculateForRoot(root, finalStubTree, finalAstTree)));
        }
        ArrayList<StubValueMap<JSStubElementGistValue>> arrayList = result2;
        if (arrayList == null) {
            JSStubElementGist.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    @NotNull
    private static StubValueMap<JSStubElementGistValue> calculateForRoot(@NotNull PsiFileImpl file, @NotNull StubTree stubTree, @NotNull FileElement astTree) {
        if (file == null) {
            JSStubElementGist.$$$reportNull$$$0(35);
        }
        if (stubTree == null) {
            JSStubElementGist.$$$reportNull$$$0(36);
        }
        if (astTree == null) {
            JSStubElementGist.$$$reportNull$$$0(37);
        }
        final ConcurrentHashMap map2 = new ConcurrentHashMap();
        file.accept((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

            @Override
            public void visitJSElement(@NotNull JSElement psi) {
                if (psi == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.visitJSElement(psi);
                if (!(psi instanceof StubBasedPsiElementBase)) {
                    return;
                }
                StubBasedPsiElementBase stubBasedPsi = (StubBasedPsiElementBase)psi;
                Pair<Byte, JSStubElementGistProvider> pair = JSStubElementGist.findProvider(stubBasedPsi);
                byte providerIndex = (Byte)pair.first;
                if (pair.second == null) {
                    return;
                }
                StubElement stub = stubBasedPsi.getGreenStub();
                if (stub == null) {
                    if (((StubBasedPsiElementBase)psi).getElementType().shouldCreateStub(psi.getNode())) {
                        LOG.error("Stub not found for " + psi + " in " + psi.getContainingFile());
                    }
                    return;
                }
                if (!(stub instanceof ObjectStubBase)) {
                    LOG.error("Unsupported class " + stub.getClass());
                    return;
                }
                ObjectStubBase objectStubBase = (ObjectStubBase)stub;
                JSStubElementGistValue data = new JSStubElementGistValue(providerIndex, JSStubElementGist.getDataFromPsi(stubBasedPsi));
                map2.put(objectStubBase.getStubId(), data);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/lang/javascript/index/gist/JSStubElementGist$2", "visitJSElement"));
            }
        });
        Reference.reachabilityFence(stubTree);
        Reference.reachabilityFence(astTree);
        return new StubValueMap<JSStubElementGistValue>(map2);
    }

    @NotNull
    private static Pair<Byte, JSStubElementGistProvider> findProvider(@NotNull StubBasedPsiElementBase psi) {
        if (psi == null) {
            JSStubElementGist.$$$reportNull$$$0(38);
        }
        JSStubElementGistProvider provider = null;
        int providerIndex = -1;
        for (int i = 0; i < PROVIDERS.size(); i = (int)((byte)(i + 1))) {
            Pair<Class<? extends StubBasedPsiElementBase>, JSStubElementGistProvider> pair = PROVIDERS.get(i);
            if (!((Class)pair.first).isInstance(psi)) continue;
            provider = (JSStubElementGistProvider)pair.second;
            providerIndex = i;
            break;
        }
        Pair pair = Pair.create((Object)((byte)providerIndex), provider);
        if (pair == null) {
            JSStubElementGist.$$$reportNull$$$0(39);
        }
        return pair;
    }

    public static byte getIndexOfProvider(@NotNull StubBasedPsiElementBase psi) {
        if (psi == null) {
            JSStubElementGist.$$$reportNull$$$0(40);
        }
        return (Byte)JSStubElementGist.findProvider((StubBasedPsiElementBase)psi).first;
    }

    @NotNull
    private static DataExternalizer<JSStubElementGistValue> createExternalizer() {
        return new DataExternalizer<JSStubElementGistValue>(){

            public void save(@NotNull DataOutput out, JSStubElementGistValue value) throws IOException {
                if (out == null) {
                    3.$$$reportNull$$$0(0);
                }
                out.writeByte(value.myProviderIndex);
                ((JSStubElementGistProvider)JSStubElementGist.PROVIDERS.get((int)value.myProviderIndex).second).save(out, value.myData);
            }

            public JSStubElementGistValue read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    3.$$$reportNull$$$0(1);
                }
                byte providerIndex = in.readByte();
                JSStubElementGistProvider provider = (JSStubElementGistProvider)JSStubElementGist.PROVIDERS.get((int)providerIndex).second;
                return new JSStubElementGistValue(providerIndex, provider.read(in));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/index/gist/JSStubElementGist$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 8, 10, 12, 14, 16, 17, 18, 20, 25, 34, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 25: 
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/gist/JSStubElementGist";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 24: 
            case 26: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 19: 
            case 21: 
            case 22: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubbedRoots";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubTree";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/gist/JSStubElementGist";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFromPsi";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateForAllRoots";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "findProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 25: 
            case 34: 
            case 39: {
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "shouldCalculateGist";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "arePsiAndDocumentSynchronized";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getDataFromPsi";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getUpToDateOrNullFromGist";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getUpToDateOrNullGistData";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getStubRootIndex";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "scheduleGistCalculation";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "buildGistSync";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "buildGist";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "calculate";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "calculateForAllRoots";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "calculateForRoot";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findProvider";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getIndexOfProvider";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 8, 10, 12, 14, 16, 17, 18, 20, 25, 34, 39 -> new IllegalStateException(string);
        };
    }

    public static final class JSStubElementGistValue {
        private final byte myProviderIndex;
        @NotNull
        private final Object myData;

        public JSStubElementGistValue(byte index, @NotNull Object data) {
            if (data == null) {
                JSStubElementGistValue.$$$reportNull$$$0(0);
            }
            this.myProviderIndex = index;
            this.myData = data;
        }

        @NotNull
        public Object getData() {
            Object object = this.myData;
            if (object == null) {
                JSStubElementGistValue.$$$reportNull$$$0(1);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/index/gist/JSStubElementGist$JSStubElementGistValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/index/gist/JSStubElementGist$JSStubElementGistValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

