/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.navigation;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.navigation.DumbAwareChooseByNameContributor;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSClassIndex;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaScriptClassContributor
extends DumbAwareChooseByNameContributor
implements GotoClassContributor {
    @Override
    public void doProcessNames(@NotNull Processor<? super String> processor, @NotNull GlobalSearchScope scope2, @Nullable IdFilter filter2) {
        FileType type;
        if (processor == null) {
            JavaScriptClassContributor.$$$reportNull$$$0(0);
        }
        if (scope2 == null) {
            JavaScriptClassContributor.$$$reportNull$$$0(1);
        }
        if ((type = FlexSupportLoader.getMxmlFileType()) != null && !FileTypeIndex.processFiles((FileType)type, (Processor)Processors.map(processor, VirtualFile::getNameWithoutExtension), (GlobalSearchScope)scope2)) {
            return;
        }
        StubIndex.getInstance().processAllKeys(JSClassIndex.KEY, key -> {
            String adjusted = !key.isEmpty() && key.charAt(0) == '^' ? key.substring(1) : key;
            return processor.process((Object)adjusted.substring(adjusted.lastIndexOf(46) + 1));
        }, scope2, filter2);
    }

    @Override
    public void doProcessElementsWithName(@NotNull String name, @NotNull Processor<? super NavigationItem> processor, @NotNull FindSymbolParameters parameters) {
        if (name == null) {
            JavaScriptClassContributor.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            JavaScriptClassContributor.$$$reportNull$$$0(3);
        }
        if (parameters == null) {
            JavaScriptClassContributor.$$$reportNull$$$0(4);
        }
        Project project = parameters.getProject();
        GlobalSearchScope scope2 = parameters.getSearchScope();
        Collection<JSQualifiedNamedElement> psiClasses = JSResolveUtil.findElementsByName(name, project, scope2);
        Iterator<JSQualifiedNamedElement> q = psiClasses.iterator();
        while (q.hasNext()) {
            JSQualifiedNamedElement element = q.next();
            if (element instanceof XmlBackedJSClass || element instanceof JSNamespaceDeclaration) continue;
            q.remove();
        }
        boolean[] fastReturn = new boolean[]{!psiClasses.isEmpty()};
        if (!ContainerUtil.process(psiClasses, processor)) {
            return;
        }
        ArrayList<JSQualifiedNamedElement> minorImportanceClasses = new ArrayList<JSQualifiedNamedElement>(psiClasses);
        ArrayList<JSQualifiedNamedElement> namespaces = new ArrayList<JSQualifiedNamedElement>(psiClasses);
        JSClassIndex.processElements(name, project, scope2, (Processor<? super JSPsiElementBase>)((Processor)base -> {
            if (base instanceof JSImplicitElement) {
                JSImplicitElement.Type type = ((JSImplicitElement)base).getType();
                if (type == JSImplicitElement.Type.Namespace) {
                    namespaces.add((JSQualifiedNamedElement)base);
                    return true;
                }
                if (((JSImplicitElement)base).hasMinorImportance()) {
                    minorImportanceClasses.add((JSQualifiedNamedElement)base);
                    return true;
                }
            }
            fastReturn[0] = true;
            return processor.process(base);
        }));
        if (fastReturn[0]) {
            return;
        }
        if (minorImportanceClasses.isEmpty() && namespaces.isEmpty()) {
            return;
        }
        HashSet<JSPsiElementBase> replacedImplicitElements = new HashSet<JSPsiElementBase>();
        for (JSPsiElementBase implicitElement : ContainerUtil.concat(namespaces, minorImportanceClasses)) {
            Collection<JSPsiElementBase> matchedElements = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(Objects.requireNonNull(implicitElement.getQualifiedName()), GlobalSearchScope.fileScope((Project)project, (VirtualFile)implicitElement.getContainingFile().getVirtualFile()));
            replacedImplicitElements.addAll(matchedElements);
        }
        replacedImplicitElements.removeAll(minorImportanceClasses);
        replacedImplicitElements.removeAll(namespaces);
        ContainerUtil.process(!replacedImplicitElements.isEmpty() ? replacedImplicitElements : minorImportanceClasses, processor);
    }

    @Nullable
    public String getQualifiedName(@NotNull NavigationItem item) {
        if (item == null) {
            JavaScriptClassContributor.$$$reportNull$$$0(5);
        }
        return null;
    }

    @Nullable
    public String getQualifiedNameSeparator() {
        return null;
    }

    @NotNull
    public Language getElementLanguage() {
        JavascriptLanguage javascriptLanguage = JavascriptLanguage.INSTANCE;
        if (javascriptLanguage == null) {
            JavaScriptClassContributor.$$$reportNull$$$0(6);
        }
        return javascriptLanguage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/navigation/JavaScriptClassContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/navigation/JavaScriptClassContributor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doProcessNames";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doProcessElementsWithName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

