/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.patterns;

import com.intellij.lang.javascript.patterns.JSElementPattern;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class JSLiteralExpressionPattern
extends JSElementPattern<JSLiteralExpression, JSLiteralExpressionPattern> {
    protected JSLiteralExpressionPattern() {
        super(JSLiteralExpression.class);
    }

    public JSLiteralExpressionPattern withStringValue(final ObjectPattern<String, ?> pattern) {
        return (JSLiteralExpressionPattern)this.with((PatternCondition)new PatternCondition<JSLiteralExpression>("jsLiteralStringValue"){

            public boolean accepts(@NotNull JSLiteralExpression jsLiteralExpression, ProcessingContext context2) {
                if (jsLiteralExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                return pattern.accepts((Object)jsLiteralExpression.getStringValue());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsLiteralExpression", "com/intellij/lang/javascript/patterns/JSLiteralExpressionPattern$1", "accepts"));
            }
        });
    }

    public JSLiteralExpressionPattern withStringValueIgnoringInterpolations(final ObjectPattern<String, ?> pattern) {
        return (JSLiteralExpressionPattern)this.with((PatternCondition)new PatternCondition<JSLiteralExpression>("jsLiteralStringValueIgnoringInterpolations"){

            public boolean accepts(@NotNull JSLiteralExpression jsLiteralExpression, ProcessingContext context2) {
                String stringValue;
                if (jsLiteralExpression == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((stringValue = jsLiteralExpression.getStringValue()) == null && jsLiteralExpression instanceof JSStringTemplateExpression) {
                    TextRange[] ranges = ((JSStringTemplateExpression)jsLiteralExpression).getStringRanges();
                    StringBuilder concatenated = new StringBuilder();
                    String text = jsLiteralExpression.getText();
                    for (TextRange range : ranges) {
                        concatenated.append(range.substring(text));
                    }
                    stringValue = concatenated.toString();
                }
                return pattern.accepts((Object)stringValue);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsLiteralExpression", "com/intellij/lang/javascript/patterns/JSLiteralExpressionPattern$2", "accepts"));
            }
        });
    }
}

