/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.ui;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceActionPanelBuilder;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetProjectsInfoRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptIDEGetProjectsInfoResponse;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServiceStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class TypeScriptServiceStructureBuilder {
    public static final @NotNull Supplier<@Nls String> STRUCTURE_NAME = JavaScriptBundle.messagePointer("typescript.compiler.structure.tab.title", new Object[0]);

    @NotNull
    public static StructurePanel registerStructureContent(@NotNull Project project, @NotNull ToolWindow toolWindow, @NotNull String helpId) {
        if (project == null) {
            TypeScriptServiceStructureBuilder.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            TypeScriptServiceStructureBuilder.$$$reportNull$$$0(1);
        }
        if (helpId == null) {
            TypeScriptServiceStructureBuilder.$$$reportNull$$$0(2);
        }
        Tree tree = new Tree();
        Disposable modelDisposable = Disposer.newDisposable();
        TypeScriptServiceStructure structure = new TypeScriptServiceStructure(new HashMap());
        StructureTreeModel treeModel = new StructureTreeModel((AbstractTreeStructure)structure, modelDisposable);
        final Runnable refresh = () -> {
            List<TypeScriptCompilerService> services = TypeScriptCompilerService.getAll(project);
            for (TypeScriptCompilerService service : services) {
                if (!service.isServiceCreated()) continue;
                service.sendCommand(new TypeScriptGetProjectsInfoRequest(), (obj, answer) -> {
                    JsonObject element = answer.getElement();
                    Gson gson = JSLanguageServiceUtil.getGson(service);
                    TypeScriptIDEGetProjectsInfoResponse response2 = (TypeScriptIDEGetProjectsInfoResponse)gson.fromJson((JsonElement)element, TypeScriptIDEGetProjectsInfoResponse.class);
                    if (response2.body == null) {
                        structure.setStructures(new HashMap());
                        tree.getEmptyText().setText(JavaScriptBundle.message("status.text.project.structure.isn.t.available", new Object[0]));
                    } else {
                        LinkedHashMap<String, TypeScriptIDEGetProjectsInfoResponse.IDEGetProjectsInfo> result2 = new LinkedHashMap<String, TypeScriptIDEGetProjectsInfoResponse.IDEGetProjectsInfo>();
                        for (TypeScriptIDEGetProjectsInfoResponse.IDEGetProjectsInfo info : response2.body) {
                            result2.put(info.projectName, info);
                        }
                        structure.setStructures(result2);
                        if (result2.isEmpty()) {
                            tree.getEmptyText().setText(JavaScriptBundle.message("status.text.service.doesn.t.contain.open.projects", new Object[0]));
                        }
                    }
                    ApplicationManager.getApplication().invokeLater(() -> treeModel.invalidateAsync());
                    return null;
                });
                break;
            }
            structure.setStructures(new HashMap());
            tree.getEmptyText().setText(JavaScriptBundle.message("status.text.refresh.required", new Object[0]));
            treeModel.invalidateAsync();
        };
        StructurePanel result2 = new StructurePanel(){

            @Override
            public void refresh() {
                refresh.run();
            }

            @Override
            public String getName() {
                return STRUCTURE_NAME.get();
            }

            public void dispose() {
            }
        };
        Disposer.register((Disposable)result2, (Disposable)modelDisposable);
        AsyncTreeModel model = new AsyncTreeModel((TreeModel)treeModel, (Disposable)result2);
        tree.setModel((TreeModel)model);
        JPanel actionPanel = JSLanguageServiceActionPanelBuilder.createToolPanel(helpId, null, null, new AnAction[]{new AnAction(AllIcons.Actions.ForceRefresh){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                refresh.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/typescript/compiler/ui/TypeScriptServiceStructureBuilder$2", "actionPerformed"));
            }
        }}, null);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(ScrollPaneFactory.createScrollPane((Component)tree));
        panel.add("West", actionPanel);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.updateUI();
        TreeUtil.installActions((JTree)tree);
        TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)tree);
        treeModel.invalidateAsync();
        ContentImpl contentImpl = new ContentImpl((JComponent)panel, STRUCTURE_NAME.get(), false);
        toolWindow.getContentManager().addContent((Content)contentImpl);
        contentImpl.setCloseable(false);
        StructurePanel structurePanel = result2;
        if (structurePanel == null) {
            TypeScriptServiceStructureBuilder.$$$reportNull$$$0(3);
        }
        return structurePanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/ui/TypeScriptServiceStructureBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/ui/TypeScriptServiceStructureBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "registerStructureContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerStructureContent";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static interface StructurePanel
    extends Disposable {
        public void refresh();

        public String getName();
    }
}

