/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.psi.impl;

import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.dynamicVariables.HttpClientDynamicVariableValue;
import com.intellij.httpClient.http.request.lexer.HttpRequestLexerDistributionDetailsService;
import com.intellij.httpClient.http.request.psi.HttpDynamicVariableArg;
import com.intellij.httpClient.http.request.psi.HttpFilePath;
import com.intellij.httpClient.http.request.psi.HttpFileVariableEscapedPart;
import com.intellij.httpClient.http.request.psi.HttpFileVariableName;
import com.intellij.httpClient.http.request.psi.HttpHeaderField;
import com.intellij.httpClient.http.request.psi.HttpHeaderFieldValue;
import com.intellij.httpClient.http.request.psi.HttpHost;
import com.intellij.httpClient.http.request.psi.HttpIncludeFilePath;
import com.intellij.httpClient.http.request.psi.HttpMethod;
import com.intellij.httpClient.http.request.psi.HttpMultipartField;
import com.intellij.httpClient.http.request.psi.HttpOutputFile;
import com.intellij.httpClient.http.request.psi.HttpOutputFilePath;
import com.intellij.httpClient.http.request.psi.HttpPathAbsolute;
import com.intellij.httpClient.http.request.psi.HttpPort;
import com.intellij.httpClient.http.request.psi.HttpQuery;
import com.intellij.httpClient.http.request.psi.HttpQueryParameter;
import com.intellij.httpClient.http.request.psi.HttpQueryParameterKey;
import com.intellij.httpClient.http.request.psi.HttpQueryParameterValue;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.httpClient.http.request.psi.HttpRequestMessage;
import com.intellij.httpClient.http.request.psi.HttpRequestMessagesGroup;
import com.intellij.httpClient.http.request.psi.HttpRequestName;
import com.intellij.httpClient.http.request.psi.HttpRequestPsiDistributionDetailsService;
import com.intellij.httpClient.http.request.psi.HttpRequestTarget;
import com.intellij.httpClient.http.request.psi.HttpScheme;
import com.intellij.httpClient.http.request.psi.HttpVariableBase;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequestPsiImplUtil {
    private static final TokenSet PATH_TOKENS = TokenSet.create((IElementType[])new IElementType[]{HttpRequestElementTypes.SEGMENT, HttpRequestElementTypes.SEPARATOR});
    private static final Condition<PsiElement> REQUEST_PATH = element -> element != null && HttpRequestPsiImplUtil.isOfType(element, PATH_TOKENS);
    private static final Condition<PsiElement> NOT_WHITESPACE = element -> !(element instanceof PsiWhiteSpace);
    private static final String DEFAULT_HTTP_METHOD = "GET";
    private static final String DEFAULT_HTTP_SCHEME = "http";
    public static final String SCHEME_SEPARATOR = "://";

    @NotNull
    public static String getHttpMethod(@NotNull HttpRequest request) {
        String defaultMethod;
        HttpScheme scheme;
        HttpMethod method;
        if (request == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(0);
        }
        if ((method = request.getMethod()) != null) {
            String string = method.getText();
            if (string == null) {
                HttpRequestPsiImplUtil.$$$reportNull$$$0(1);
            }
            return string;
        }
        HttpRequestTarget target = request.getRequestTarget();
        if (target != null && (scheme = target.getScheme()) != null && (defaultMethod = HttpRequestLexerDistributionDetailsService.getInstance().getDefaultMethod(scheme.getText(), request.getProject())) != null) {
            String string = defaultMethod;
            if (string == null) {
                HttpRequestPsiImplUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        return DEFAULT_HTTP_METHOD;
    }

    @Nullable
    public static String getHttpUrl(@NotNull HttpRequest request, @NotNull HttpRequestVariableSubstitutor substitutor2) {
        if (request == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(3);
        }
        if (substitutor2 == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(4);
        }
        String host = HttpRequestPsiImplUtil.getHttpHost(request, substitutor2);
        HttpRequestTarget target = request.getRequestTarget();
        if (target == null) {
            return StringUtil.isNotEmpty((String)host) ? HttpRequestPsiImplUtil.addSchemeIfNeeded(host, null, DEFAULT_HTTP_SCHEME) : null;
        }
        String url = HttpRequestPsiImplUtil.join(host, target.getHttpPath(substitutor2));
        String defaultScheme = HttpRequestLexerDistributionDetailsService.getInstance().getDefaultScheme(request.getHttpMethod(), request.getProject());
        return StringUtil.isNotEmpty((String)url) ? HttpRequestPsiImplUtil.addSchemeIfNeeded(url, target, defaultScheme) : null;
    }

    @Nullable
    public static String join(@Nullable String host, @Nullable String path) {
        if (StringUtil.isEmpty((String)host)) {
            return path;
        }
        if (StringUtil.isEmpty((String)path)) {
            return host;
        }
        return StringUtil.trimEnd((String)host, (char)'/') + "/" + StringUtil.trimLeading((String)path, (char)'/');
    }

    @Nullable
    @NlsSafe
    public static String getHttpHost(@NotNull HttpRequest request, @NotNull HttpRequestVariableSubstitutor substitutor2) {
        HttpRequestTarget target;
        HttpHost host;
        if (request == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(5);
        }
        if (substitutor2 == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(6);
        }
        HttpHost httpHost = host = (target = request.getRequestTarget()) != null ? target.getHost() : null;
        if (host == null) {
            HttpHeaderField field = request.getHeaderField("Host");
            return field != null ? field.getValue(substitutor2) : null;
        }
        String port = target.getPort(substitutor2);
        return substitutor2.getValue((PsiElement)host, NOT_WHITESPACE) + (String)(StringUtil.isNotEmpty((String)port) ? ":" + port : "");
    }

    @Nullable
    public static String getScheme(@NotNull HttpRequest request) {
        HttpScheme scheme;
        HttpRequestTarget target;
        if (request == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(7);
        }
        if ((target = request.getRequestTarget()) != null && (scheme = target.getScheme()) != null) {
            return scheme.getText();
        }
        String method = request.getHttpMethod();
        return HttpRequestLexerDistributionDetailsService.getInstance().getDefaultScheme(method, request.getProject());
    }

    @NotNull
    private static String addSchemeIfNeeded(@NotNull String url, @Nullable HttpRequestTarget target, @Nullable String defaultScheme) {
        HttpScheme scheme;
        if (url == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(8);
        }
        if (URLUtil.containsScheme((String)url)) {
            String string = url;
            if (string == null) {
                HttpRequestPsiImplUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        HttpScheme httpScheme = scheme = target != null ? target.getScheme() : null;
        if (scheme != null) {
            String string = scheme.getText() + SCHEME_SEPARATOR + url;
            if (string == null) {
                HttpRequestPsiImplUtil.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (defaultScheme != null) {
            String string = defaultScheme + SCHEME_SEPARATOR + url;
            if (string == null) {
                HttpRequestPsiImplUtil.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = url;
        if (string == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    public static String getPort(@NotNull HttpRequestTarget target, @NotNull HttpRequestVariableSubstitutor substitutor2) {
        HttpPort port;
        if (target == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(13);
        }
        if (substitutor2 == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(14);
        }
        return (port = target.getPort()) != null ? substitutor2.getValue((PsiElement)port) : null;
    }

    @NotNull
    public static String getHttpPath(@NotNull HttpRequestTarget target, @NotNull HttpRequestVariableSubstitutor substitutor2) {
        HttpPathAbsolute absolute;
        if (target == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(15);
        }
        if (substitutor2 == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(16);
        }
        return (absolute = target.getPathAbsolute()) != null ? absolute.getHttpPath(substitutor2) : "";
    }

    @NotNull
    public static String getHttpPath(@NotNull HttpPathAbsolute absolute, @NotNull HttpRequestVariableSubstitutor substitutor2) {
        if (absolute == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(17);
        }
        if (substitutor2 == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(18);
        }
        String string = StringUtil.trimStart((String)substitutor2.getValue((PsiElement)absolute, REQUEST_PATH), (String)"/");
        if (string == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static String getKey(@NotNull HttpQueryParameter parameter, @NotNull HttpRequestVariableSubstitutor substitutor2) {
        if (parameter == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(20);
        }
        if (substitutor2 == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(21);
        }
        HttpQueryParameterKey key = parameter.getQueryParameterKey();
        return HttpRequestPsiImplUtil.decodeQueryParameter((PsiElement)key, substitutor2);
    }

    @Nullable
    public static String getValue(@NotNull HttpQueryParameter parameter, @NotNull HttpRequestVariableSubstitutor substitutor2) {
        HttpQueryParameterValue value2;
        if (parameter == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(22);
        }
        if (substitutor2 == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(23);
        }
        return (value2 = parameter.getQueryParameterValue()) != null ? HttpRequestPsiImplUtil.decodeQueryParameter((PsiElement)value2, substitutor2) : null;
    }

    @NotNull
    private static String decodeQueryParameter(@NotNull PsiElement element, @NotNull HttpRequestVariableSubstitutor substitutor2) {
        if (element == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(24);
        }
        if (substitutor2 == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(25);
        }
        String string = URLUtil.decode((String)substitutor2.getValue(element, NOT_WHITESPACE));
        if (string == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static String getName(@NotNull HttpHeaderField field) {
        if (field == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(27);
        }
        String string = field.getHeaderFieldName().getText();
        if (string == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    public static String getValue(@NotNull HttpHeaderField field, @NotNull HttpRequestVariableSubstitutor substitutor2) {
        HttpHeaderFieldValue element;
        if (field == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(29);
        }
        if (substitutor2 == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(30);
        }
        return (element = field.getHeaderFieldValue()) != null ? substitutor2.getValue((PsiElement)element) : "";
    }

    @NotNull
    public static String getPresentablePath(@NotNull HttpFilePath filePath) {
        if (filePath == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(31);
        }
        String string = filePath.getText();
        if (string == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    public static String getPresentablePath(@NotNull HttpIncludeFilePath filePath) {
        if (filePath == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(33);
        }
        String string = filePath.getText();
        if (string == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(34);
        }
        return string;
    }

    public static PsiReference @NotNull [] getReferences(@NotNull HttpRequestName requestName) {
        HttpRequestPsiDistributionDetailsService psiDetailsService;
        if (requestName == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(35);
        }
        if ((psiDetailsService = HttpRequestPsiDistributionDetailsService.getInstance()) != null) {
            PsiReference[] psiReferenceArray = psiDetailsService.provideRequestNameReferences(requestName);
            if (psiReferenceArray == null) {
                HttpRequestPsiImplUtil.$$$reportNull$$$0(36);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(37);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public static PsiReference @NotNull [] getReferences(@NotNull HttpIncludeFilePath includeFilePath) {
        HttpRequestPsiDistributionDetailsService psiDetailsService;
        if (includeFilePath == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(38);
        }
        if ((psiDetailsService = HttpRequestPsiDistributionDetailsService.getInstance()) != null) {
            PsiReference[] psiReferenceArray = psiDetailsService.provideRunFilePathReferences(includeFilePath);
            if (psiReferenceArray == null) {
                HttpRequestPsiImplUtil.$$$reportNull$$$0(39);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(40);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @NotNull
    public static String getName(@NotNull HttpRequestName requestName) {
        if (requestName == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(41);
        }
        String string = requestName.getText().trim().substring(1);
        if (string == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(42);
        }
        return string;
    }

    public static PsiReference @NotNull [] getReferences(@NotNull HttpFilePath filePath) {
        if (filePath == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(43);
        }
        ArrayList<PsiReference> references = new ArrayList<PsiReference>();
        HttpRequestPsiDistributionDetailsService psiDetailsService = HttpRequestPsiDistributionDetailsService.getInstance();
        if (psiDetailsService != null) {
            psiDetailsService.putFileReferences(filePath, references, true);
        }
        PsiReference[] psiReferenceArray = references.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(44);
        }
        return psiReferenceArray;
    }

    @NotNull
    public static List<HttpRequestMessage> getRequestMessages(@NotNull HttpMultipartField part) {
        HttpRequestMessagesGroup group;
        if (part == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(45);
        }
        List<HttpRequestMessage> list2 = (group = part.getRequestMessagesGroup()) != null ? group.getRequestMessageList() : ContainerUtil.emptyList();
        if (list2 == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(46);
        }
        return list2;
    }

    @Nullable
    public static HttpHeaderFieldValue getMultipartFieldDescription(@NotNull HttpMultipartField part) {
        HttpHeaderField description;
        if (part == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(47);
        }
        return (description = part.getHeaderField("Content-Disposition")) != null ? description.getHeaderFieldValue() : null;
    }

    @Nullable
    public static String getHeaderFieldOption(@NotNull HttpHeaderFieldValue value2, @NotNull String optionName) {
        if (value2 == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(48);
        }
        if (optionName == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(49);
        }
        for (PsiElement child = value2.getFirstChild(); child != null; child = child.getNextSibling()) {
            String option;
            if (!HttpRequestPsiImplUtil.isOfType(child, HttpRequestElementTypes.FIELD_VALUE) || (option = child.getText().trim()).length() <= optionName.length() + 1 || !option.startsWith(optionName) || option.charAt(optionName.length()) != '=') continue;
            return StringUtil.unquoteString((String)option.substring(optionName.length() + 1));
        }
        return null;
    }

    @NotNull
    public static String getPresentablePath(@NotNull HttpOutputFilePath filePath, @NotNull HttpRequestVariableSubstitutor substitutor2) {
        String subPath;
        if (filePath == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(50);
        }
        if (substitutor2 == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(51);
        }
        if (FileUtil.isAbsolute((String)(subPath = substitutor2.getValue((PsiElement)filePath)))) {
            String string = subPath;
            if (string == null) {
                HttpRequestPsiImplUtil.$$$reportNull$$$0(52);
            }
            return string;
        }
        String string = filePath.getContainingFile().getOriginalFile().getVirtualFile().getParent().toNioPath().resolve(subPath) + (subPath.endsWith(File.separator) ? File.separator : "");
        if (string == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(53);
        }
        return string;
    }

    public static PsiReference @NotNull [] getReferences(@NotNull HttpOutputFilePath filePath) {
        HttpRequestPsiDistributionDetailsService psiDetailsService;
        if (filePath == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(54);
        }
        if ((psiDetailsService = HttpRequestPsiDistributionDetailsService.getInstance()) != null) {
            PsiReference[] psiReferenceArray = psiDetailsService.provideOutputFileReferences(filePath);
            if (psiReferenceArray == null) {
                HttpRequestPsiImplUtil.$$$reportNull$$$0(55);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(56);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public static boolean isForce(@NotNull HttpOutputFile outputRedirectFile) {
        if (outputRedirectFile == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(57);
        }
        return HttpRequestPsiImplUtil.isOfType(outputRedirectFile.getFirstChild(), HttpRequestElementTypes.FORCE_OUTPUT_FILE_SIGN);
    }

    @Nullable
    public static HttpClientDynamicVariableValue.ParameterValue getValue(@NotNull HttpDynamicVariableArg dynamicVariableArg) {
        String text2;
        if (dynamicVariableArg == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(58);
        }
        if ((text2 = dynamicVariableArg.getText()) == null) {
            return null;
        }
        if (HttpRequestPsiImplUtil.isOfType(dynamicVariableArg.getFirstChild(), HttpRequestElementTypes.INTEGER)) {
            try {
                return new HttpClientDynamicVariableValue.ParameterValue.Integer(Integer.parseInt(text2));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (HttpRequestPsiImplUtil.isOfType(dynamicVariableArg.getFirstChild(), HttpRequestElementTypes.FLOAT)) {
            try {
                return new HttpClientDynamicVariableValue.ParameterValue.Float(Float.parseFloat(text2));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (HttpRequestPsiImplUtil.isOfType(dynamicVariableArg.getFirstChild(), HttpRequestElementTypes.STRING)) {
            String value2 = StringUtil.trimEnd((String)StringUtil.trimStart((String)text2, (String)"\""), (String)"\"");
            return new HttpClientDynamicVariableValue.ParameterValue.Str(value2);
        }
        return null;
    }

    @Nullable
    public static PsiElement getNameElement(@NotNull HttpFileVariableName fileVariableName) {
        if (fileVariableName == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(59);
        }
        return fileVariableName.getFirstChild();
    }

    public static PsiReference @NotNull [] getReferences(@NotNull HttpFileVariableName fileVariableName) {
        HttpRequestPsiDistributionDetailsService psiDetailsService;
        if (fileVariableName == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(60);
        }
        if ((psiDetailsService = HttpRequestPsiDistributionDetailsService.getInstance()) != null) {
            PsiReference[] psiReferenceArray = psiDetailsService.provideFileVariableInRunOverrideReferences(fileVariableName);
            if (psiReferenceArray == null) {
                HttpRequestPsiImplUtil.$$$reportNull$$$0(61);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(62);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @NotNull
    public static String unescape(@NotNull HttpFileVariableEscapedPart escapedPart) {
        if (escapedPart == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(63);
        }
        if (escapedPart.getText().isBlank() || !escapedPart.getText().startsWith("\\")) {
            return "";
        }
        String text2 = escapedPart.getText().substring(1);
        if ("n".equals(text2)) {
            return "\n";
        }
        if ("t".equals(text2)) {
            return "\t";
        }
        if ("r".equals(text2)) {
            return "\r";
        }
        switch (text2) {
            case "\n": 
            case "\r": 
            case "\n\r": 
            case "\\": {
                String string = text2;
                if (string == null) {
                    HttpRequestPsiImplUtil.$$$reportNull$$$0(64);
                }
                return string;
            }
        }
        if (text2.startsWith("u") && text2.length() == 5) {
            char escapedChar = (char)Integer.parseInt(text2.substring(1), 16);
            String string = Character.toString(escapedChar);
            if (string == null) {
                HttpRequestPsiImplUtil.$$$reportNull$$$0(65);
            }
            return string;
        }
        return "";
    }

    @Nullable
    public static HttpVariableBase getSingleVariable(@NotNull HttpQuery query) {
        List<HttpQueryParameter> parameters;
        if (query == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(66);
        }
        if ((parameters = query.getQueryParameterList()).size() != 1) {
            return null;
        }
        HttpQueryParameter parameter = parameters.get(0);
        if (parameter.getQueryParameterValue() != null) {
            return null;
        }
        if (parameter.getQueryParameterKey().getNextSibling() != null) {
            return null;
        }
        HttpQueryParameterKey key = parameter.getQueryParameterKey();
        PsiElement firstChild = key.getFirstChild();
        if (firstChild == null || firstChild.getNextSibling() != null) {
            return null;
        }
        if (!(firstChild instanceof HttpVariableBase)) {
            return null;
        }
        HttpVariableBase variableBase = (HttpVariableBase)firstChild;
        return variableBase;
    }

    public static boolean isOfType(@Nullable PsiElement element, @NotNull IElementType type) {
        if (type == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(67);
        }
        if (element == null) {
            return false;
        }
        ASTNode node = element.getNode();
        return node != null && node.getElementType() == type;
    }

    private static boolean isOfType(@NotNull PsiElement element, @NotNull TokenSet types) {
        ASTNode node;
        if (element == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(68);
        }
        if (types == null) {
            HttpRequestPsiImplUtil.$$$reportNull$$$0(69);
        }
        return (node = element.getNode()) != null && types.contains(node.getElementType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 9, 10, 11, 12, 19, 26, 28, 32, 34, 36, 37, 39, 40, 42, 44, 46, 52, 53, 55, 56, 61, 62, 64, 65 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 26: 
            case 28: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 61: 
            case 62: 
            case 64: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/psi/impl/HttpRequestPsiImplUtil";
                break;
            }
            case 4: 
            case 6: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 25: 
            case 30: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absolute";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 24: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 31: 
            case 33: 
            case 43: 
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 35: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestName";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeFilePath";
                break;
            }
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionName";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputRedirectFile";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicVariableArg";
                break;
            }
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileVariableName";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapedPart";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/psi/impl/HttpRequestPsiImplUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHttpMethod";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addSchemeIfNeeded";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getHttpPath";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "decodeQueryParameter";
                break;
            }
            case 28: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 32: 
            case 34: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 44: 
            case 55: 
            case 56: 
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestMessages";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "unescape";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHttpMethod";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 19: 
            case 26: 
            case 28: 
            case 32: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 61: 
            case 62: 
            case 64: 
            case 65: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHttpUrl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHttpHost";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getScheme";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addSchemeIfNeeded";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPort";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getHttpPath";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 22: 
            case 23: 
            case 29: 
            case 30: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "decodeQueryParameter";
                break;
            }
            case 27: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 31: 
            case 33: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getPresentablePath";
                break;
            }
            case 35: 
            case 38: 
            case 43: 
            case 54: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getRequestMessages";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getMultipartFieldDescription";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getHeaderFieldOption";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isForce";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getNameElement";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "unescape";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getSingleVariable";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "isOfType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 9, 10, 11, 12, 19, 26, 28, 32, 34, 36, 37, 39, 40, 42, 44, 46, 52, 53, 55, 56, 61, 62, 64, 65 -> new IllegalStateException(string);
        };
    }
}

