/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.cloud.model.bootstrap;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.spring.boot.cloud.library.SpringCloudLibraryUtil;
import com.intellij.spring.boot.cloud.model.bootstrap.SpringBootBootstrapFileSet;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.boot.model.SpringBootModelExtender;
import com.intellij.spring.boot.model.autoconfigure.SpringOrderClassSorter;
import com.intellij.spring.facet.SpringAutodetectedFileSet;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.spi.SpringSpiManager;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class SpringBootBootstrapModelExtender
implements SpringBootModelExtender {
    SpringBootBootstrapModelExtender() {
    }

    @NotNull
    public List<? extends SpringAutodetectedFileSet> getAdditionalFileSets(SpringFileSet springBootFileSet) {
        SpringFacet facet = springBootFileSet.getFacet();
        Module module = facet.getModule();
        if (!SpringCloudLibraryUtil.hasSpringCloudCommons(module)) {
            List list = Collections.emptyList();
            if (list == null) {
                SpringBootBootstrapModelExtender.$$$reportNull$$$0(0);
            }
            return list;
        }
        List bootstrapConfigs = SpringSpiManager.getInstance((Module)module).getClassesListValue(false, "org.springframework.cloud.bootstrap.BootstrapConfiguration");
        SpringOrderClassSorter sorter = new SpringOrderClassSorter(new ArrayList(new LinkedHashSet(bootstrapConfigs)));
        SpringBootBootstrapFileSet bootstrapFileSet = new SpringBootBootstrapFileSet(springBootFileSet, facet);
        ((SpringFacetConfiguration)facet.getConfiguration()).registerAutodetectedFileSet((SpringFileSet)bootstrapFileSet);
        sorter.getSortedConfigs().forEach(psiClass -> bootstrapFileSet.addFile(psiClass.getContainingFile().getVirtualFile()));
        List configFiles = SpringBootConfigurationFileService.getInstance().findConfigFiles(module, false, contributor -> contributor.accept((SpringFileSet)bootstrapFileSet));
        for (VirtualFile configFile : configFiles) {
            bootstrapFileSet.addFile(configFile);
        }
        List imports = SpringBootConfigurationFileService.getInstance().collectImports(module, configFiles);
        for (VirtualFile importedFile : imports) {
            bootstrapFileSet.addFile(importedFile);
        }
        springBootFileSet.addDependency((SpringFileSet)bootstrapFileSet);
        return new SmartList((Object)bootstrapFileSet);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/cloud/model/bootstrap/SpringBootBootstrapModelExtender", "getAdditionalFileSets"));
    }
}

