/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.lineProfiler;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.profiler.lineProfiler.data.ClassFQN;
import com.intellij.profiler.lineProfiler.data.DataExtractionKt;
import com.intellij.profiler.lineProfiler.data.LineProfilerData;
import com.intellij.profiler.lineProfiler.data.LineProfilerEventData;
import com.intellij.profiler.lineProfiler.data.LineProfilerRawData;
import com.intellij.profiler.ultimate.jfr.JFRProfilerData;
import com.intellij.profiler.ultimate.jfr.events.JfrEventGroup;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b\"R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R#\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00190\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/profiler/lineProfiler/LineProfilerState;", "", "snapshot", "Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData;", "<init>", "(Lcom/intellij/profiler/ultimate/jfr/JFRProfilerData;)V", "rawData", "Lcom/intellij/profiler/lineProfiler/data/LineProfilerRawData;", "currentGroup", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEventGroup;", "getCurrentGroup", "()Lcom/intellij/profiler/ultimate/jfr/events/JfrEventGroup;", "setCurrentGroup", "(Lcom/intellij/profiler/ultimate/jfr/events/JfrEventGroup;)V", "timeStamp", "", "getTimeStamp", "()J", "currentData", "Lcom/intellij/profiler/lineProfiler/data/LineProfilerEventData;", "getCurrentData", "()Lcom/intellij/profiler/lineProfiler/data/LineProfilerEventData;", "topLevelNames", "", "Lcom/intellij/profiler/lineProfiler/data/ClassFQN;", "", "getTopLevelNames", "()Ljava/util/Map;", "data", "Lcom/intellij/profiler/lineProfiler/data/LineProfilerData;", "calculateLineData", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "calculateLineData$intellij_profiler_lineProfiler", "intellij.profiler.lineProfiler"})
@SourceDebugExtension(value={"SMAP\nLineProfilerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineProfilerService.kt\ncom/intellij/profiler/lineProfiler/LineProfilerState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,308:1\n295#2,2:309\n1#3:311\n*S KotlinDebug\n*F\n+ 1 LineProfilerService.kt\ncom/intellij/profiler/lineProfiler/LineProfilerState\n*L\n41#1:309,2\n*E\n"})
public final class LineProfilerState {
    @Nullable
    private LineProfilerRawData rawData;
    @Nullable
    private JfrEventGroup currentGroup;
    private final long timeStamp;
    @Nullable
    private LineProfilerData data;

    /*
     * WARNING - void declaration
     */
    public LineProfilerState(@NotNull JFRProfilerData snapshot) {
        Object v1;
        block1: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
            this.rawData = DataExtractionKt.prepareData(snapshot);
            Object object = new JfrEventGroup[]{JfrEventGroup.WALL_TOTAL, JfrEventGroup.WALL_CPU, JfrEventGroup.CPU, JfrEventGroup.MEMORY};
            object = CollectionsKt.listOf((Object[])object);
            LineProfilerState lineProfilerState = this;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JfrEventGroup it = (JfrEventGroup)element$iv;
                boolean bl = false;
                LineProfilerRawData lineProfilerRawData = this.rawData;
                Intrinsics.checkNotNull((Object)lineProfilerRawData);
                if (!lineProfilerRawData.getEvents().containsKey(it)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        lineProfilerState.currentGroup = v1;
        LineProfilerRawData lineProfilerRawData = this.rawData;
        Intrinsics.checkNotNull((Object)lineProfilerRawData);
        this.timeStamp = lineProfilerRawData.getTimeStamp();
    }

    @Nullable
    public final JfrEventGroup getCurrentGroup() {
        return this.currentGroup;
    }

    public final void setCurrentGroup(@Nullable JfrEventGroup jfrEventGroup) {
        this.currentGroup = jfrEventGroup;
    }

    public final long getTimeStamp() {
        return this.timeStamp;
    }

    @Nullable
    public final LineProfilerEventData getCurrentData() {
        LineProfilerEventData lineProfilerEventData;
        JfrEventGroup jfrEventGroup = this.currentGroup;
        if (jfrEventGroup != null) {
            JfrEventGroup it = jfrEventGroup;
            boolean bl = false;
            Object object = this.data;
            lineProfilerEventData = object != null && (object = ((LineProfilerData)object).getEvents()) != null ? (LineProfilerEventData)object.get(it) : null;
        } else {
            lineProfilerEventData = null;
        }
        return lineProfilerEventData;
    }

    @NotNull
    public final Map<ClassFQN, List<ClassFQN>> getTopLevelNames() {
        Object object = this.data;
        if (object == null || (object = ((LineProfilerData)object).getTopLevelNames()) == null) {
            object = MapsKt.emptyMap();
        }
        return object;
    }

    public final void calculateLineData$intellij_profiler_lineProfiler(@NotNull ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        if (this.data != null) {
            return;
        }
        LineProfilerRawData lineProfilerRawData = this.rawData;
        Intrinsics.checkNotNull((Object)lineProfilerRawData);
        this.data = DataExtractionKt.aggregateLineData(lineProfilerRawData, progressIndicator);
        this.rawData = null;
    }
}

