/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.lineProfiler.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.profiler.lineProfiler.ProfilerLineProfilerIcons;
import com.intellij.profiler.lineProfiler.ui.HighlighterState;
import com.intellij.profiler.lineProfiler.ui.LinesViewProvider;
import com.intellij.profiler.lineProfiler.ui.UtilsKt;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\u0006\u0010\u0015\u001a\u00020\u0003J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0018\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001a\u00a8\u0006 "}, d2={"Lcom/intellij/profiler/lineProfiler/ui/LineMarker;", "Ljavax/swing/JComponent;", "originalLine", "", "isModified", "", "state", "Lcom/intellij/profiler/lineProfiler/ui/HighlighterState;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(IZLcom/intellij/profiler/lineProfiler/ui/HighlighterState;Lcom/intellij/openapi/editor/Editor;)V", "provider", "Lcom/intellij/profiler/lineProfiler/ui/LinesViewProvider;", "selected", "getSelected", "()Z", "paintComponent", "", "g", "Ljava/awt/Graphics;", "getStartX", "scale", "x", "H_GAP", "getH_GAP", "()I", "H_RIGHT_MARGIN", "getH_RIGHT_MARGIN", "V_GAP", "getV_GAP", "Companion", "intellij.profiler.lineProfiler"})
public final class LineMarker
extends JComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int originalLine;
    private final boolean isModified;
    @NotNull
    private final HighlighterState state;
    @NotNull
    private final Editor editor;
    @NotNull
    private final LinesViewProvider provider;
    private static final int FLAME_ICON_SIZE = 14;
    @NotNull
    private static final Icon FLAME_ICON;

    public LineMarker(int originalLine, boolean isModified, @NotNull HighlighterState state, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.originalLine = originalLine;
        this.isModified = isModified;
        this.state = state;
        this.editor = editor;
        this.provider = new LinesViewProvider(this.state.getLines());
    }

    private final boolean getSelected() {
        Collection collection;
        return this.state.isSelected(this.originalLine) && !((collection = (Collection)this.state.getLines().getChildrenCalls(this.originalLine)) == null || collection.isEmpty());
    }

    @Override
    protected void paintComponent(@Nullable Graphics g) {
        Icon icon;
        super.paintComponent(g);
        Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D cfr_ignored_0 = (Graphics2D)g;
        Rectangle r = this.getBounds();
        String string = this.provider.getLineText(this.originalLine);
        if (string == null) {
            return;
        }
        String text = string;
        Color color = this.provider.getBackground(this.originalLine, this.getSelected(), this.isModified);
        if (color == null) {
            return;
        }
        ((Graphics2D)g).setColor(color);
        Font font = UtilsKt.getCurrentFont(this.editor);
        ((Graphics2D)g).setFont(font);
        FontMetrics fm = this.editor.getComponent().getFontMetrics(font);
        int width = fm.stringWidth(text);
        boolean hasIcon = this.state.getLines().isFireLine(this.originalLine);
        if (hasIcon) {
            Editor editor = this.editor;
            Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
            icon = EditorUIUtil.scaleIcon((Icon)FLAME_ICON, (EditorImpl)((EditorImpl)editor));
        } else {
            icon = null;
        }
        Icon icon2 = icon;
        int iconWidth = this.scale(LineMarker.Companion.iconWidthWithGap(hasIcon));
        Rectangle roundRectangle = new Rectangle(this.getStartX(), r.y + this.getV_GAP(), width + 2 * this.getH_GAP() + iconWidth, r.height - 2 * this.getV_GAP());
        int round = ExperimentalUI.Companion.isNewUI() ? this.scale(4) : this.scale(2);
        ((Graphics2D)g).fillRoundRect(roundRectangle.x, roundRectangle.y, roundRectangle.width, roundRectangle.height, 2 * round, 2 * round);
        Icon icon3 = icon2;
        if (icon3 != null) {
            icon3.paintIcon(this.editor.getComponent(), g, roundRectangle.x + this.getH_GAP(), roundRectangle.y + roundRectangle.height / 2 - icon2.getIconHeight() / 2);
        }
        Color color2 = this.provider.getTextColor(this.originalLine, this.isModified);
        if (color2 == null) {
            return;
        }
        ((Graphics2D)g).setColor(color2);
        ((Graphics2D)g).drawString(text, roundRectangle.x + this.getH_GAP() + iconWidth, roundRectangle.y + roundRectangle.height / 2 + fm.getAscent() * 2 / 5);
    }

    public final int getStartX() {
        String string = this.provider.getLineText(this.originalLine);
        if (string == null) {
            return 0;
        }
        String text = string;
        int width = this.editor.getComponent().getFontMetrics(UtilsKt.getCurrentFont(this.editor)).stringWidth(text);
        int iconWidth = this.scale(LineMarker.Companion.iconWidthWithGap(this.state.getLines().isFireLine(this.originalLine)));
        return this.getBounds().x + this.getBounds().width - width - 2 * this.getH_GAP() - iconWidth - this.getH_RIGHT_MARGIN();
    }

    private final int scale(int x) {
        Editor editor = this.editor;
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        return JBUI.scale((int)EditorUIUtil.scaleWidth((int)x, (EditorImpl)((EditorImpl)editor)));
    }

    private final int getH_GAP() {
        return this.scale(6);
    }

    private final int getH_RIGHT_MARGIN() {
        return this.scale(6);
    }

    private final int getV_GAP() {
        return this.scale(1);
    }

    static {
        Icon icon = ProfilerLineProfilerIcons.Flame;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Flame");
        FLAME_ICON = icon;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/lineProfiler/ui/LineMarker$Companion;", "", "<init>", "()V", "FLAME_ICON_SIZE", "", "FLAME_ICON", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "iconWidthWithGap", "hasIcon", "", "calculateWidth", "provider", "Lcom/intellij/profiler/lineProfiler/ui/LinesViewProvider;", "originalLine", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.profiler.lineProfiler"})
    public static final class Companion {
        private Companion() {
        }

        private final int iconWidthWithGap(boolean hasIcon) {
            return hasIcon ? 16 : 0;
        }

        public final int calculateWidth(@NotNull LinesViewProvider provider, int originalLine, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            EditorImpl cfr_ignored_0 = (EditorImpl)editor;
            String string = provider.getLineText(originalLine);
            if (string == null) {
                return 0;
            }
            String text = string;
            Font currentFont = UtilsKt.getCurrentFont(editor);
            Font unscaledFont = currentFont.deriveFont(currentFont.getSize2D() / JBUIScale.scale((float)((EditorImpl)editor).getScale()));
            int textWidth = ((EditorImpl)editor).getComponent().getFontMetrics(unscaledFont).stringWidth(text);
            int iconWidth = this.iconWidthWithGap(provider.getLines$intellij_profiler_lineProfiler().isFireLine(originalLine));
            return textWidth + iconWidth + 12 + 4 + 6;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

