/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.lineProfiler.ui;

import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.util.RoundedCellRenderer;
import com.intellij.profiler.lineProfiler.LineProfilerBundle;
import com.intellij.profiler.lineProfiler.data.ClassAndMethodWithHits;
import com.intellij.profiler.lineProfiler.statistics.LineProfilerUsageCollector;
import com.intellij.profiler.lineProfiler.ui.HighlighterState;
import com.intellij.profiler.lineProfiler.ui.LineMarker;
import com.intellij.profiler.lineProfiler.ui.LinesViewProvider;
import com.intellij.profiler.lineProfiler.ui.MyRenderer;
import com.intellij.profiler.lineProfiler.ui.UtilsKt;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Point;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000bH\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/profiler/lineProfiler/ui/NavigationPopup;", "", "line", "", "project", "Lcom/intellij/openapi/project/Project;", "state", "Lcom/intellij/profiler/lineProfiler/ui/HighlighterState;", "<init>", "(ILcom/intellij/openapi/project/Project;Lcom/intellij/profiler/lineProfiler/ui/HighlighterState;)V", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "showPoint", "Ljava/awt/Point;", "createPopup", "show", "", "marker", "Lcom/intellij/profiler/lineProfiler/ui/LineMarker;", "gutter", "Lcom/intellij/openapi/editor/ex/EditorGutterComponentEx;", "hide", "intellij.profiler.lineProfiler"})
@SourceDebugExtension(value={"SMAP\nNavigationPopup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NavigationPopup.kt\ncom/intellij/profiler/lineProfiler/ui/NavigationPopup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1062#2:103\n1#3:104\n*S KotlinDebug\n*F\n+ 1 NavigationPopup.kt\ncom/intellij/profiler/lineProfiler/ui/NavigationPopup\n*L\n31#1:103\n*E\n"})
public final class NavigationPopup {
    private final int line;
    @NotNull
    private final Project project;
    @NotNull
    private final HighlighterState state;
    @Nullable
    private JBPopup popup;
    @Nullable
    private Point showPoint;

    public NavigationPopup(int line, @NotNull Project project, @NotNull HighlighterState state) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.line = line;
        this.project = project;
        this.state = state;
    }

    private final JBPopup createPopup() {
        List list;
        List<ClassAndMethodWithHits> list2 = this.state.getLines().getChildrenCalls(this.line);
        if (list2 != null) {
            Iterable $this$sortedByDescending$iv = list2;
            boolean $i$f$sortedByDescending = false;
            list = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ClassAndMethodWithHits it = (ClassAndMethodWithHits)b;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getHits());
                    it = (ClassAndMethodWithHits)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getHits()));
                }
            });
        } else {
            list = null;
        }
        List children = list;
        Long l = this.state.getLines().getTotalHits(this.line);
        Intrinsics.checkNotNull((Object)l);
        long totalHits = l;
        Collection $i$f$sortedByDescending = children;
        if (!(!($i$f$sortedByDescending == null || $i$f$sortedByDescending.isEmpty()))) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        LinesViewProvider provider = new LinesViewProvider(this.state.getLines());
        JBPopup jBPopup = JBPopupFactory.getInstance().createPopupChooserBuilder(children).setRenderer((ListCellRenderer)new RoundedCellRenderer((ListCellRenderer)new MyRenderer(provider, totalHits), false, 2, null)).setItemChosenCallback(arg_0 -> NavigationPopup.createPopup$lambda$2(arg_0 -> NavigationPopup.createPopup$lambda$1(this, children, arg_0), arg_0)).setAdText(LineProfilerBundle.message("select.to.navigate", new Object[0])).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup $this$createPopup_u24lambda_u243 = jBPopup;
        boolean bl = false;
        $this$createPopup_u24lambda_u243.addListener(new JBPopupListener(this){
            final /* synthetic */ NavigationPopup this$0;
            {
                this.this$0 = $receiver;
            }

            public void onClosed(LightweightWindowEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                NavigationPopup.access$getState$p(this.this$0).setCanShowTooltip(true);
            }
        });
        return jBPopup;
    }

    public final void show(@NotNull LineMarker marker, @NotNull EditorGutterComponentEx gutter) {
        Point point;
        Object object;
        block3: {
            JBPopup it;
            JBPopup jBPopup;
            block2: {
                Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
                Intrinsics.checkNotNullParameter((Object)gutter, (String)"gutter");
                object = this.popup;
                if (object == null) break block2;
                it = jBPopup = object;
                boolean bl = false;
                object = !it.isDisposed() ? jBPopup : null;
                if (object != null) break block3;
            }
            it = jBPopup = this.createPopup();
            boolean bl = false;
            this.popup = it;
            object = jBPopup;
        }
        JBPopup popup = object;
        this.showPoint = point = new Point(marker.getStartX(), marker.getBounds().y + marker.getBounds().height + JBUI.scale((int)3));
        popup.show(new RelativePoint((Component)gutter, point));
    }

    public final void hide() {
        JBPopup jBPopup = this.popup;
        if (jBPopup != null) {
            jBPopup.cancel();
        }
        this.popup = null;
    }

    private static final Unit createPopup$lambda$1(NavigationPopup this$0, List $children, ClassAndMethodWithHits element) {
        LineProfilerUsageCollector.INSTANCE.logNavigation(this$0.project, $children.size());
        Intrinsics.checkNotNull((Object)element);
        Project project = this$0.project;
        Point point = this$0.showPoint;
        Intrinsics.checkNotNull((Object)point);
        UtilsKt.navigate(element, project, point);
        this$0.state.hideNavigationPopup();
        return Unit.INSTANCE;
    }

    private static final void createPopup$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ HighlighterState access$getState$p(NavigationPopup $this) {
        return $this.state;
    }
}

