/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.lineProfiler.ui;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.project.DumbModeBlockedFunctionality;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.lineProfiler.data.ClassAndMethodWithHits;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.model.JavaMethodCall;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Font;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0001\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a8\u0006\u0010"}, d2={"formatPercent", "", "percent", "", "getCurrentFont", "Ljava/awt/Font;", "editor", "Lcom/intellij/openapi/editor/Editor;", "navigate", "", "child", "Lcom/intellij/profiler/lineProfiler/data/ClassAndMethodWithHits;", "project", "Lcom/intellij/openapi/project/Project;", "point", "Ljava/awt/Point;", "intellij.profiler.lineProfiler"})
public final class UtilsKt {
    @NlsSafe
    @NotNull
    public static final String formatPercent(float percent) {
        return MathKt.roundToInt((float)(percent * (float)100)) + "%";
    }

    @NotNull
    public static final Font getCurrentFont(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Font font = editor.getColorsScheme().getFont(EditorFontType.PLAIN);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        Font editorFont = font;
        float editorFontSize = editorFont.getSize2D();
        Font font2 = editorFont.deriveFont(Math.max(1.0f, editorFontSize - 1.0f));
        Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"deriveFont(...)");
        return font2;
    }

    public static final void navigate(@NotNull ClassAndMethodWithHits child, @NotNull Project project, @NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        JavaMethodCall call = new JavaMethodCall(child.getClazz().getPackageName(), child.getClazz().getClassName(), child.getMethod().getMethodName(), false, child.getMethod().getMethodDescriptor(), null, 40, null);
        Function0 onDumb = () -> UtilsKt.navigate$lambda$0(project);
        BaseCallStackElement baseCallStackElement = (BaseCallStackElement)call;
        RelativePoint relativePoint = RelativePoint.fromScreen((Point)point);
        Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"fromScreen(...)");
        com.intellij.profiler.UtilsKt.navigateToSourceInBackground$default((Project)project, (BaseCallStackElement)baseCallStackElement, (RelativePoint)relativePoint, (Function1)((Function1)new Function1<Continuation<? super Unit>, Object>((Object)onDumb){

            public final Object invoke(Continuation<? super Unit> $completion) {
                return UtilsKt.access$navigate$suspendConversion0((Function0)this.receiver, $completion);
            }
        }), (boolean)false, (boolean)false, null, (int)112, null);
    }

    private static final Unit navigate$lambda$0(Project $project) {
        DumbService.Companion.getInstance($project).showDumbModeNotificationForFunctionality(UltimateProfilerBundleKt.profilerMessage((String)"jfr.ui.timeline.stacktrace.navigation.not.available", (Object[])new Object[0]), DumbModeBlockedFunctionality.LineProfiler);
        return Unit.INSTANCE;
    }

    private static final /* synthetic */ Object navigate$suspendConversion0(Function0 $this$navigate_u24suspendConversion0, Continuation $completion) {
        $this$navigate_u24suspendConversion0.invoke();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$navigate$suspendConversion0(Function0 $receiver, Continuation $completion) {
        return UtilsKt.navigate$suspendConversion0($receiver, $completion);
    }
}

