/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv.ui;

import com.intellij.database.DataGridBundle;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatResolverCore;
import com.intellij.database.settings.CsvSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TableUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.table.EditorTextFieldJBTableRowRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvFormatsListComponent
implements Disposable {
    private final JBTable myTable;
    private List<CsvFormat> myOriginalFormats;
    private boolean myEditingAllowed;
    private Consumer<CsvFormat> myEditedFormatConsumer;
    private boolean myResetting;
    private final EventDispatcher<ChangeListener> myDispatcher;

    public CsvFormatsListComponent(@NotNull Disposable parent) {
        if (parent == null) {
            CsvFormatsListComponent.$$$reportNull$$$0(0);
        }
        this.myOriginalFormats = ContainerUtil.emptyList();
        this.myDispatcher = EventDispatcher.create(ChangeListener.class);
        Disposer.register((Disposable)parent, (Disposable)this);
        this.myTable = new MyTable();
        this.myTable.setShowGrid(false);
        this.myTable.setTableHeader(null);
        this.myTable.setColumnSelectionAllowed(false);
        this.myTable.getSelectionModel().setSelectionMode(0);
        this.myTable.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)10, (int)-1));
        this.myTable.setVisibleRowCount(5);
        this.installListeners();
    }

    @NotNull
    public JBTable getComponent() {
        JBTable jBTable = this.myTable;
        if (jBTable == null) {
            CsvFormatsListComponent.$$$reportNull$$$0(1);
        }
        return jBTable;
    }

    public void setNameEditingAllowed(boolean allowed) {
        this.myEditingAllowed = allowed;
    }

    @NotNull
    public List<CsvFormat> getFormats() {
        return new ArrayList<CsvFormat>(this.model().getFormats());
    }

    @Nullable
    public CsvFormat getSelected() {
        FormatsListModel model2 = this.model();
        int idx = this.getSelectedIdx();
        return idx != -1 ? model2.getFormat(idx) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(@NotNull List<CsvFormat> formats, @Nullable String nameToSelect) {
        int toSelect;
        if (formats == null) {
            CsvFormatsListComponent.$$$reportNull$$$0(2);
        }
        if ((toSelect = CsvFormat.indexOfFormatNamed(formats, (String)nameToSelect)) == -1) {
            CsvFormat selected = this.getSelected();
            toSelect = CsvFormat.indexOfFormatNamed(formats, (String)(selected != null ? selected.name : null));
        }
        toSelect = toSelect == -1 && !formats.isEmpty() ? 0 : toSelect;
        this.myResetting = true;
        try {
            FormatsListModel model2 = this.model();
            if (this.myTable.isEditing()) {
                this.myTable.getCellEditor().cancelCellEditing();
            }
            model2.setFormats(formats);
            this.select(toSelect);
            TableUtil.scrollSelectionToVisible((JTable)this.myTable);
        }
        finally {
            this.myOriginalFormats = new ArrayList<CsvFormat>(formats);
            this.myResetting = false;
            this.fireFormatsChanged();
        }
    }

    public boolean isModified(@NotNull CsvFormat format) {
        List formats;
        int idx;
        if (format == null) {
            CsvFormatsListComponent.$$$reportNull$$$0(3);
        }
        return (idx = CsvFormat.indexOfFormatNamed((List)(formats = CsvSettings.getSettings().getCsvFormats()), (String)format.name)) == -1 || !((CsvFormat)formats.get(idx)).equals((Object)format);
    }

    public void markUnmodified(@NotNull CsvFormat format) {
        int idx;
        if (format == null) {
            CsvFormatsListComponent.$$$reportNull$$$0(4);
        }
        if ((idx = CsvFormat.indexOfFormatNamed(this.myOriginalFormats, (String)format.name)) != -1) {
            this.myOriginalFormats.set(idx, format);
        }
        this.myTable.revalidate();
        this.myTable.repaint(50L);
    }

    public void addChangeListener(@NotNull ChangeListener listener2) {
        if (listener2 == null) {
            CsvFormatsListComponent.$$$reportNull$$$0(5);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void updateSelectedFormat(@NotNull CsvFormat with) {
        int selectedIdx;
        if (with == null) {
            CsvFormatsListComponent.$$$reportNull$$$0(6);
        }
        if ((selectedIdx = this.getSelectedIdx()) != -1) {
            this.model().setFormat(selectedIdx, with);
        }
    }

    public void resetFormat(@Nullable String formatName) {
        int formatIdx = CsvFormat.indexOfFormatNamed(this.model().getFormats(), (String)formatName);
        if (formatIdx == -1) {
            return;
        }
        int originalFormatIdx = CsvFormat.indexOfFormatNamed(this.myOriginalFormats, (String)formatName);
        if (originalFormatIdx == -1) {
            return;
        }
        this.model().setFormat(formatIdx, this.myOriginalFormats.get(originalFormatIdx));
    }

    @NotNull
    public CsvFormat newFormat(@NotNull CsvFormat template) {
        if (template == null) {
            CsvFormatsListComponent.$$$reportNull$$$0(7);
        }
        CsvFormat format = new CsvFormat(CsvFormatResolverCore.getNewFormatName((CsvFormat)template, this.model().getFormats()), template.dataRecord, template.headerRecord, template.rowNumbers);
        this.model().addFormat(format);
        this.select(this.model().getRowCount() - 1);
        TableUtil.scrollSelectionToVisible((JTable)this.myTable);
        CsvFormat csvFormat = format;
        if (csvFormat == null) {
            CsvFormatsListComponent.$$$reportNull$$$0(8);
        }
        return csvFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editFormatName(@NotNull CsvFormat format, @Nullable Consumer<CsvFormat> doWhenEditingIsComplete) {
        int idx;
        if (format == null) {
            CsvFormatsListComponent.$$$reportNull$$$0(9);
        }
        if ((idx = CsvFormat.indexOfFormatNamed(this.model().getFormats(), (String)format.name)) == -1) {
            throw new AssertionError();
        }
        boolean editingAllowed = this.myEditingAllowed;
        this.myEditingAllowed = true;
        try {
            if (this.myTable.editCellAt(idx, 0)) {
                this.myEditedFormatConsumer = doWhenEditingIsComplete;
                TableUtil.scrollSelectionToVisible((JTable)this.myTable);
            }
        }
        finally {
            this.myEditingAllowed = editingAllowed;
        }
    }

    public void dispose() {
    }

    private void editingComplete(int rowIdx) {
        if (this.myEditedFormatConsumer != null && rowIdx != -1) {
            this.myEditedFormatConsumer.consume((Object)this.model().getFormat(rowIdx));
            this.myEditedFormatConsumer = null;
        }
    }

    private int getSelectedIdx() {
        int idx = this.myTable.getSelectionModel().getMinSelectionIndex();
        return idx >= 0 && idx < this.myTable.getRowCount() ? idx : -1;
    }

    private void select(int idx) {
        if (idx == -1) {
            this.myTable.getSelectionModel().clearSelection();
        } else {
            this.myTable.getSelectionModel().setSelectionInterval(idx, idx);
        }
    }

    @NotNull
    private FormatsListModel model() {
        FormatsListModel formatsListModel = (FormatsListModel)this.myTable.getModel();
        if (formatsListModel == null) {
            CsvFormatsListComponent.$$$reportNull$$$0(10);
        }
        return formatsListModel;
    }

    private void fireFormatsChanged() {
        if (!this.myResetting) {
            ((ChangeListener)this.myDispatcher.getMulticaster()).formatsChanged(this);
        }
    }

    private void installListeners() {
        this.model().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                CsvFormatsListComponent.this.fireFormatsChanged();
            }
        });
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    CsvFormatsListComponent.this.fireFormatsChanged();
                }
            }
        });
        this.myTable.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                Point mouse = new Point(x, y);
                final int row = CsvFormatsListComponent.this.myTable.rowAtPoint(mouse);
                if (row == -1 || CsvFormatsListComponent.this.myTable.isEditing() || !CsvFormatsListComponent.this.myEditingAllowed) {
                    return;
                }
                JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(null, new String[]{"Edit Name"}){

                    public PopupStep<?> onChosen(String selectedValue, boolean finalChoice) {
                        if (finalChoice) {
                            CsvFormatsListComponent.this.editFormatName(CsvFormatsListComponent.this.model().getFormat(row), null);
                        }
                        return super.onChosen((Object)selectedValue, finalChoice);
                    }
                }).show(new RelativePoint(comp, mouse));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/csv/ui/CsvFormatsListComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formats";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "with";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/csv/ui/CsvFormatsListComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "newFormat";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 8: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "markUnmodified";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectedFormat";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "newFormat";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "editFormatName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 8, 10 -> new IllegalStateException(string);
        };
    }

    public static interface ChangeListener
    extends EventListener {
        public void formatsChanged(@NotNull CsvFormatsListComponent var1);
    }

    private class MyTable
    extends JBTable {
        TableCellRenderer renderer;
        TableCellEditor editor;

        MyTable() {
            super((TableModel)new FormatsListModel());
            this.renderer = new MyRenderer();
            this.editor = new MyEditor();
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            return this.renderer;
        }

        public TableCellEditor getCellEditor(int row, int column) {
            return this.editor;
        }

        public void editingStopped(ChangeEvent e) {
            int editedRowIdx = this.getEditingRow();
            super.editingStopped(e);
            CsvFormatsListComponent.this.editingComplete(editedRowIdx);
        }

        public void editingCanceled(ChangeEvent e) {
            int editedRowIdx = this.getEditingRow();
            super.editingCanceled(e);
            CsvFormatsListComponent.this.editingComplete(editedRowIdx);
        }

        public boolean isCellEditable(int row, int column) {
            return CsvFormatsListComponent.this.myEditingAllowed;
        }
    }

    private static class FormatsListModel
    extends AbstractTableModel
    implements EditableModel {
        private final List<CsvFormat> myFormats = new ArrayList<CsvFormat>();

        private FormatsListModel() {
        }

        @Override
        public int getRowCount() {
            return this.myFormats.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.myFormats.get(rowIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.myFormats.set(rowIndex, (CsvFormat)aValue);
            this.fireTableCellUpdated(rowIndex, 0);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public void addRow() {
            throw new AssertionError((Object)"Should not be called");
        }

        public void exchangeRows(int oldIndex, int newIndex) {
            CsvFormat atOld = this.myFormats.get(oldIndex);
            this.myFormats.set(oldIndex, this.myFormats.get(newIndex));
            this.fireTableCellUpdated(oldIndex, 0);
            this.myFormats.set(newIndex, atOld);
            this.fireTableCellUpdated(newIndex, 0);
        }

        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return true;
        }

        public void removeRow(int idx) {
            this.myFormats.remove(idx);
            this.fireTableRowsDeleted(idx, idx);
        }

        @NotNull
        public List<CsvFormat> getFormats() {
            List<CsvFormat> list = Collections.unmodifiableList(this.myFormats);
            if (list == null) {
                FormatsListModel.$$$reportNull$$$0(0);
            }
            return list;
        }

        @NotNull
        public CsvFormat getFormat(int idx) {
            CsvFormat csvFormat = this.myFormats.get(idx);
            if (csvFormat == null) {
                FormatsListModel.$$$reportNull$$$0(1);
            }
            return csvFormat;
        }

        public void setFormats(@NotNull List<CsvFormat> formats) {
            if (formats == null) {
                FormatsListModel.$$$reportNull$$$0(2);
            }
            this.myFormats.clear();
            this.myFormats.addAll(formats);
            this.fireTableDataChanged();
        }

        public void setFormat(int idx, @NotNull CsvFormat format) {
            if (format == null) {
                FormatsListModel.$$$reportNull$$$0(3);
            }
            this.setValueAt(format, idx, 0);
        }

        public void addFormat(@NotNull CsvFormat format) {
            if (format == null) {
                FormatsListModel.$$$reportNull$$$0(4);
            }
            this.myFormats.add(format);
            this.fireTableRowsInserted(this.myFormats.size() - 1, this.myFormats.size() - 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/csv/ui/CsvFormatsListComponent$FormatsListModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formats";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFormats";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFormat";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/csv/ui/CsvFormatsListComponent$FormatsListModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setFormats";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setFormat";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addFormat";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private final class MyEditor
    extends AbstractTableCellEditor
    implements Disposable {
        private final EditorTextField myTextField = new EditorTextField("");
        private CsvFormat myFormat;

        private MyEditor() {
            this.myTextField.setOneLineMode(true);
            this.myTextField.setFontInheritedFromLAF(true);
            this.myTextField.setSupplementary(true);
            this.myTextField.putClientProperty((Object)"JBListTable.isTableCellEditor", (Object)Boolean.TRUE);
            new DumbAwareAction(DataGridBundle.messagePointer((String)"action.CsvFormatsListComponent.stop.editing.text", (Object[])new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    MyEditor.this.stopCellEditing();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/csv/ui/CsvFormatsListComponent$MyEditor$1", "actionPerformed"));
                }
            }.registerCustomShortcutSet(CommonShortcuts.ENTER, (JComponent)this.myTextField, (Disposable)this);
            Disposer.register((Disposable)CsvFormatsListComponent.this, (Disposable)this);
        }

        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                return ((MouseEvent)e).getClickCount() >= 2;
            }
            return super.isCellEditable(e);
        }

        public Component getTableCellEditorComponent(JTable table2, Object value, boolean isSelected, int row, int column) {
            this.myFormat = (CsvFormat)value;
            this.myTextField.setText(this.myFormat.name);
            this.myTextField.selectAll();
            return this.myTextField;
        }

        public Object getCellEditorValue() {
            return new CsvFormat(this.myTextField.getText(), this.myFormat.dataRecord, this.myFormat.headerRecord, this.myFormat.id, this.myFormat.rowNumbers);
        }

        public boolean stopCellEditing() {
            CsvFormat format;
            String formatName = this.myTextField.getText();
            if (StringUtil.isEmpty((String)formatName)) {
                return false;
            }
            int idx = CsvFormat.indexOfFormatNamed(CsvFormatsListComponent.this.model().getFormats(), (String)formatName);
            CsvFormat csvFormat = format = idx != -1 ? CsvFormatsListComponent.this.model().getFormat(idx) : null;
            if (format != null && format != this.myFormat) {
                return false;
            }
            return super.stopCellEditing();
        }

        public void dispose() {
            this.myTextField.removeNotify();
        }
    }

    private class MyRenderer
    extends EditorTextFieldJBTableRowRenderer {
        MyRenderer() {
            super(null, (Disposable)CsvFormatsListComponent.this);
        }

        protected String getText(JTable table2, int row) {
            CsvFormat format = (CsvFormat)table2.getValueAt(row, 0);
            String formatName = StringUtil.notNullize((String)StringUtil.nullize((String)format.name), (String)"<unnamed format>");
            boolean modified = CsvFormatsListComponent.this.isModified(format);
            return formatName + (modified ? "*" : "");
        }
    }
}

