/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url.references;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.microservices.url.references.UrlPathReference;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\tH&J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016JN\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0018\u00c0\u0006\u0001"}, d2={"Lcom/intellij/microservices/url/references/PathSegmentHandler;", "", "render", "", "segment", "Lcom/intellij/microservices/url/UrlPath$PathSegment;", "getExactPrefix", "", "path", "Lcom/intellij/microservices/url/UrlPath;", "createInsertHandler", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "variant", "Lcom/intellij/microservices/url/UrlTargetInfo;", "hasSomethingNext", "", "createLookupElement", "context", "Lcom/intellij/microservices/url/UrlResolveRequest;", "exactPrefix", "pathToComplete", "prefix", "suffix", "intellij.microservices"})
@SourceDebugExtension(value={"SMAP\nPathSegmentHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathSegmentHandler.kt\ncom/intellij/microservices/url/references/PathSegmentHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,56:1\n1755#2,2:57\n1757#2:60\n19#3:59\n*S KotlinDebug\n*F\n+ 1 PathSegmentHandler.kt\ncom/intellij/microservices/url/references/PathSegmentHandler\n*L\n40#1:57,2\n40#1:60\n40#1:59\n*E\n"})
public interface PathSegmentHandler {
    @NotNull
    public String render(@NotNull UrlPath.PathSegment var1);

    @NotNull
    public List<UrlPath.PathSegment> getExactPrefix(@NotNull UrlPath var1);

    @NotNull
    default public InsertHandler<LookupElement> createInsertHandler(@NotNull UrlTargetInfo variant, boolean hasSomethingNext) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        return PathSegmentHandler::C;
    }

    @Nullable
    default public LookupElement createLookupElement(@NotNull UrlResolveRequest context, @NotNull List<? extends UrlPath.PathSegment> exactPrefix, @NotNull List<? extends UrlPath.PathSegment> pathToComplete, @NotNull UrlTargetInfo variant, @NotNull String prefix, @NotNull String suffix, boolean hasSomethingNext) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(exactPrefix, (String)"exactPrefix");
        Intrinsics.checkNotNullParameter(pathToComplete, (String)"pathToComplete");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        String string = CollectionsKt.joinToString$default((Iterable)exactPrefix, (CharSequence)"/", null, null, (int)0, null, arg_0 -> PathSegmentHandler.C(this, arg_0), (int)30, null);
        if (((CharSequence)string).length() == 0) {
            return null;
        }
        String string2 = prefix + string;
        String string3 = StringsKt.removePrefix((String)StringsKt.removePrefix((String)CollectionsKt.joinToString$default((Iterable)pathToComplete, (CharSequence)"/", null, null, (int)0, null, arg_0 -> PathSegmentHandler.Z(this, arg_0), (int)30, null), (CharSequence)string), (CharSequence)suffix);
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)new UrlPathReference.UrlPathLookupObject(string2), (String)(string2 + suffix)).withIcon(variant.getIcon()).withTailText(string3 + " " + HttpMethodPresentation.Companion.getHttpMethodsPresentation((Collection<String>)variant.getMethods())).withTypeText(variant.getSource()).withPsiElement(variant.getDocumentationPsiElement()).withStrikeoutness(variant.isDeprecated()).withInsertHandler(this.createInsertHandler(variant, hasSomethingNext));
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withInsertHandler(...)");
        LookupElement lookupElement = (LookupElement)lookupElementBuilder;
        if (context.getAuthorityHint() != null) {
            boolean bl;
            block7: {
                Iterable iterable = variant.getAuthorities();
                boolean bl2 = false;
                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                    bl = false;
                } else {
                    for (Object t2 : iterable) {
                        Authority authority = (Authority)t2;
                        boolean bl3 = false;
                        Authority authority2 = authority;
                        boolean bl4 = false;
                        Authority authority3 = authority2;
                        if (!(authority3 instanceof Authority.Exact)) {
                            authority3 = null;
                        }
                        Authority.Exact exact = (Authority.Exact)authority3;
                        if (!Intrinsics.areEqual((Object)(exact != null ? exact.getText() : null), (Object)context.getAuthorityHint())) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                lookupElement = PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)20.0);
            }
        }
        return lookupElement;
    }

    private static void C(InsertionContext insertionContext, LookupElement lookupElement) {
        Intrinsics.checkNotNullParameter((Object)insertionContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"<unused var>");
    }

    private static CharSequence C(PathSegmentHandler pathSegmentHandler, UrlPath.PathSegment pathSegment) {
        Intrinsics.checkNotNullParameter((Object)pathSegment, (String)"it");
        return pathSegmentHandler.render(pathSegment);
    }

    private static CharSequence Z(PathSegmentHandler pathSegmentHandler, UrlPath.PathSegment pathSegment) {
        Intrinsics.checkNotNullParameter((Object)pathSegment, (String)"it");
        return pathSegmentHandler.render(pathSegment);
    }
}

