/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.dnd;

import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.dnd.DraggedComponentsTree;
import com.intellij.openapi.graph.builder.dnd.GraphDnDSupport;
import com.intellij.openapi.graph.builder.dnd.SimpleDnDNode;
import com.intellij.openapi.graph.builder.dnd.SimpleDnDPanel;
import com.intellij.openapi.graph.builder.dnd.SimpleGraphDnDStructure;
import com.intellij.openapi.graph.builder.util.NodeFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class GraphDnDUtils {
    private GraphDnDUtils() {
    }

    public static <N, E, T> SimpleDnDPanel<T> createDnDActions(Project project, GraphBuilder<N, E> builder, GraphDnDSupport<N, T> support) {
        SimpleGraphDnDStructure simpleGraphDnDStructure = GraphDnDUtils.C(project, support);
        final SimpleDnDPanel simpleDnDPanel = new SimpleDnDPanel(simpleGraphDnDStructure, (Disposable)builder);
        DnDManager dnDManager = DnDManager.getInstance();
        dnDManager.registerSource(new MyDnDSource<N, T>(simpleDnDPanel.getTree(), support), (JComponent)simpleDnDPanel.getTree());
        dnDManager.registerTarget((DnDTarget)new MyDnDTarget<N, E, T>(builder, support){

            @Override
            public void drop(DnDEvent aEvent) {
                super.drop(aEvent);
                simpleDnDPanel.updateTree();
            }
        }, builder.getView().getJComponent());
        return simpleDnDPanel;
    }

    private static <N, T> SimpleGraphDnDStructure C(Project project, final GraphDnDSupport<N, T> graphDnDSupport) {
        final Map map = graphDnDSupport.getDnDActions();
        return new SimpleGraphDnDStructure(project){

            protected SimpleDnDNode<T>[] getChildren(Project project) {
                ArrayList<1> arrayList = new ArrayList<1>();
                for (Object k2 : map.keySet()) {
                    Pair pair = (Pair)map.get(k2);
                    arrayList.add(new SimpleDnDNode<T>(project, k2, (String)pair.getFirst(), (Icon)pair.getSecond()){

                        public boolean canStartDragging() {
                            return graphDnDSupport.canStartDragging(this.getValue());
                        }
                    });
                }
                return arrayList.toArray(new SimpleDnDNode[0]);
            }
        };
    }

    private static class MyDnDSource<N, T>
    implements DnDSource {
        private final DraggedComponentsTree myTree;
        private final GraphDnDSupport<N, T> mySupport;

        MyDnDSource(DraggedComponentsTree tree, GraphDnDSupport<N, T> support) {
            this.myTree = tree;
            this.mySupport = support;
        }

        public boolean canStartDragging(DnDAction action, @NotNull Point dragOrigin) {
            SimpleDnDNode simpleDnDNode;
            if (dragOrigin == null) {
                MyDnDSource.C(0);
            }
            return (simpleDnDNode = (SimpleDnDNode)this.myTree.getSelectedNode()) != null && this.mySupport.canStartDragging(simpleDnDNode.getValue());
        }

        public DnDDragStartBean startDragging(DnDAction action, @NotNull Point point) {
            if (point == null) {
                MyDnDSource.C(1);
            }
            return new DnDDragStartBean(((SimpleDnDNode)Objects.requireNonNull(this.myTree.getSelectedNode())).getValue());
        }

        private static /* synthetic */ void C(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dragOrigin";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "point";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/graph/builder/dnd/GraphDnDUtils$MyDnDSource";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canStartDragging";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startDragging";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyDnDTarget<N, E, T>
    implements DnDTarget {
        private final GraphBuilder<N, E> myBuilder;
        private final GraphDnDSupport<N, T> mySupport;

        private MyDnDTarget(GraphBuilder<N, E> graphBuilder, GraphDnDSupport<N, T> support) {
            this.myBuilder = graphBuilder;
            this.mySupport = support;
        }

        public boolean update(DnDEvent aEvent) {
            aEvent.setDropPossible(true);
            return false;
        }

        public void drop(DnDEvent aEvent) {
            Object object;
            Object object2 = aEvent.getAttachedObject();
            if (object2 != null && (object = this.mySupport.drop(object2)) != null) {
                String string = this.myBuilder.getGraphDataModel().getNodeName(object);
                NodeFactory.getInstance().createDraggedNode(this.myBuilder, object, string, aEvent.getPoint());
            }
        }
    }
}

