/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.threading;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.graph.threading.GraphActionExecutor;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\u0016\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J'\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\u00150\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010\u001b\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u0016\u0010\u001c\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u0016\u0010\u001d\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J'\u0010\u001e\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\u00150\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ5\u0010\u001f\u001a\u0004\u0018\u0001H\u0017\"\u0004\b\u0000\u0010\u00172\b\u0010 \u001a\u0004\u0018\u0001H\u00172\u0014\u0010\u0018\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H\u0017\u0012\u0004\u0012\u00020\u00150\u0019H\u0016\u00a2\u0006\u0002\u0010!J'\u0010\"\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u00020\u00150\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u0013\u001a\u00020&H\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u0013\u001a\u00020&H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006("}, d2={"Lcom/intellij/openapi/graph/impl/threading/EdtActionExecutor;", "Lcom/intellij/openapi/graph/threading/GraphActionExecutor;", "EdtActionExecutor", "()V", "graphDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "getGraphDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "graphExecutor", "Ljava/util/concurrent/Executor;", "getGraphExecutor", "()Ljava/util/concurrent/Executor;", "writeExecutor", "getWriteExecutor", "assertGraphThread", "", "assertReadAccess", "assertWriteAccess", "suppressRunnableReadLockAssertion", "runnable", "Lcom/intellij/util/ThrowableRunnable;", "", "suppressComputableReadLockAssertion", "T", "computable", "Lcom/intellij/openapi/util/ThrowableComputable;", "(Lcom/intellij/openapi/util/ThrowableComputable;)Ljava/lang/Object;", "runReadAction", "tryRunReadAction", "runWriteAction", "computeReadAction", "tryComputeReadAction", "defaultResult", "(Ljava/lang/Object;Lcom/intellij/openapi/util/ThrowableComputable;)Ljava/lang/Object;", "computeWriteAction", "runGraphActionAsync", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "Ljava/lang/Runnable;", "runWriteActionAsync", "intellij.platform.graph.impl"})
public final class EdtActionExecutor
implements GraphActionExecutor {
    @NotNull
    public CoroutineDispatcher getGraphDispatcher() {
        return ExecutorsKt.from((Executor)Futures.inEdt$default(null, (int)1, null));
    }

    @NotNull
    public Executor getGraphExecutor() {
        return Futures.inEdt$default(null, (int)1, null);
    }

    @NotNull
    public Executor getWriteExecutor() {
        return Futures.inWriteAction$default(null, (int)1, null);
    }

    public void assertGraphThread() {
        ThreadingAssertions.assertEventDispatchThread();
    }

    public void assertReadAccess() {
        ThreadingAssertions.softAssertReadAccess();
    }

    public void assertWriteAccess() {
        ThreadingAssertions.assertWriteAccess();
    }

    public void suppressRunnableReadLockAssertion(@NotNull ThrowableRunnable<Throwable> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        runnable.run();
    }

    public <T> T suppressComputableReadLockAssertion(@NotNull ThrowableComputable<T, Throwable> computable) {
        Intrinsics.checkNotNullParameter(computable, (String)"computable");
        return (T)computable.compute();
    }

    public void runReadAction(@NotNull ThrowableRunnable<Throwable> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        ReadAction.run(runnable);
    }

    public void tryRunReadAction(@NotNull ThrowableRunnable<Throwable> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        this.runReadAction(runnable);
    }

    public void runWriteAction(@NotNull ThrowableRunnable<Throwable> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        WriteAction.run(runnable);
    }

    public <T> T computeReadAction(@NotNull ThrowableComputable<T, Throwable> computable) {
        Intrinsics.checkNotNullParameter(computable, (String)"computable");
        return (T)ReadAction.compute(computable);
    }

    @Nullable
    public <T> T tryComputeReadAction(@Nullable T defaultResult, @NotNull ThrowableComputable<T, Throwable> computable) {
        Intrinsics.checkNotNullParameter(computable, (String)"computable");
        return this.computeReadAction(computable);
    }

    public <T> T computeWriteAction(@NotNull ThrowableComputable<T, Throwable> computable) {
        Intrinsics.checkNotNullParameter(computable, (String)"computable");
        return (T)WriteAction.compute(computable);
    }

    @NotNull
    public CompletableFuture<Void> runGraphActionAsync(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        return Futures.runInEdtAsync$default(null, (Runnable)runnable, (int)1, null);
    }

    @NotNull
    public CompletableFuture<Void> runWriteActionAsync(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        return Futures.runWriteActionAsync$default(null, (Runnable)runnable, (int)1, null);
    }
}

