/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.util;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtilRt;
import java.lang.invoke.MethodHandles;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005\u001a\u001d\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u000b\u001a\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0007\u001a\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u001a\u0016\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0013\u00a8\u0006\u0016"}, d2={"getLsp4jPosition", "Lorg/eclipse/lsp4j/Position;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "getLsp4jRange", "Lorg/eclipse/lsp4j/Range;", "length", "getOffsetInDocument", "position", "(Lcom/intellij/openapi/editor/Document;Lorg/eclipse/lsp4j/Position;)Ljava/lang/Integer;", "getRangeInDocument", "Lcom/intellij/openapi/util/TextRange;", "range", "applyTextEdits", "", "textEdits", "", "Lorg/eclipse/lsp4j/TextEdit;", "applyTextEdit", "textEdit", "intellij.platform.lsp"})
@SourceDebugExtension(value={"SMAP\nLsp4jUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lsp4jUtil.kt\ncom/intellij/platform/lsp/util/Lsp4jUtilKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n58#2:107\n36#2,2:108\n58#2:110\n36#2,2:111\n58#2:116\n36#2,2:117\n1#3:113\n1863#4,2:114\n*S KotlinDebug\n*F\n+ 1 Lsp4jUtil.kt\ncom/intellij/platform/lsp/util/Lsp4jUtilKt\n*L\n18#1:107\n18#1:108,2\n36#1:110\n36#1:111,2\n97#1:116\n97#1:117,2\n84#1:114,2\n*E\n"})
public final class Lsp4jUtilKt {
    @NotNull
    public static final Position getLsp4jPosition(@NotNull Document document, int offset) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (document instanceof DocumentWindow) {
            boolean bl = false;
            boolean bl2 = false;
            Class<?> clazz = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("DocumentWindow is not expected here. Make sure to use DocumentWindow.delegate when working with the LSP server.");
            Document document2 = ((DocumentWindow)document).getDelegate();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDelegate(...)");
            return Lsp4jUtilKt.getLsp4jPosition(document2, ((DocumentWindow)document).injectedToHost(offset));
        }
        int n2 = document.getLineNumber(offset);
        return new Position(n2, offset - document.getLineStartOffset(n2));
    }

    @NotNull
    public static final Range getLsp4jRange(@NotNull Document document, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return new Range(Lsp4jUtilKt.getLsp4jPosition(document, offset), Lsp4jUtilKt.getLsp4jPosition(document, offset + length));
    }

    @Nullable
    public static final Integer getOffsetInDocument(@NotNull Document document, @NotNull Position position) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (document instanceof DocumentWindow) {
            boolean bl = false;
            boolean bl2 = false;
            Class<?> clazz = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("DocumentWindow is not expected here. Make sure to use DocumentWindow.delegate when working with the LSP server.");
            Document document2 = ((DocumentWindow)document).getDelegate();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDelegate(...)");
            return Lsp4jUtilKt.getOffsetInDocument(document2, position);
        }
        int n2 = document.getLineCount();
        int n3 = position.getLine();
        int n4 = position.getCharacter();
        if (n3 == n2 && n4 == 0) {
            return document.getTextLength();
        }
        if (n3 < 0 || n3 >= n2 || n4 < 0) {
            return null;
        }
        int n5 = document.getLineStartOffset(n3);
        if (n3 + 1 < n2 && n4 > 0) {
            int n6 = document.getLineStartOffset(n3 + 1);
            n4 = Math.min(n4, n6 - 1 - n5);
        } else if (n3 + 1 == n2 && n4 > 0) {
            n4 = Math.min(n4, document.getTextLength() - n5);
        }
        int n7 = n5 + n4;
        boolean bl = false;
        return n7 <= document.getTextLength() ? Integer.valueOf(n7) : null;
    }

    @Nullable
    public static final TextRange getRangeInDocument(@NotNull Document document, @NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Position position = range.getStart();
        Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getStart(...)");
        Integer n2 = Lsp4jUtilKt.getOffsetInDocument(document, position);
        if (n2 == null) {
            return null;
        }
        int n3 = n2;
        Position position2 = range.getEnd();
        Intrinsics.checkNotNullExpressionValue((Object)position2, (String)"getEnd(...)");
        Integer n4 = Lsp4jUtilKt.getOffsetInDocument(document, position2);
        if (n4 == null) {
            return null;
        }
        int n5 = n4;
        if (!TextRange.isProperRange((int)n3, (int)n5)) {
            return null;
        }
        return new TextRange(n3, n5);
    }

    public static final boolean applyTextEdits(@NotNull Document document, @NotNull List<? extends TextEdit> textEdits) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter(textEdits, (String)"textEdits");
        Iterable iterable = CollectionsKt.sortedWith((Iterable)textEdits, (arg_0, arg_1) -> Lsp4jUtilKt.C(Lsp4jUtilKt::C, arg_0, arg_1));
        boolean bl = false;
        for (Object t2 : iterable) {
            TextEdit textEdit = (TextEdit)t2;
            boolean bl2 = false;
            if (Lsp4jUtilKt.applyTextEdit(document, textEdit)) continue;
            return false;
        }
        return true;
    }

    public static final boolean applyTextEdit(@NotNull Document document, @NotNull TextEdit textEdit) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)textEdit, (String)"textEdit");
        Position position = textEdit.getRange().getStart();
        Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getStart(...)");
        Integer n2 = Lsp4jUtilKt.getOffsetInDocument(document, position);
        Position position2 = textEdit.getRange().getEnd();
        Intrinsics.checkNotNullExpressionValue((Object)position2, (String)"getEnd(...)");
        Integer n3 = Lsp4jUtilKt.getOffsetInDocument(document, position2);
        if (n2 == null || n3 == null) {
            boolean bl = false;
            boolean bl2 = false;
            Class<?> clazz = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Ignoring TextEdit, its text range is outside the document text range.\ndocument.lineCount = " + document.getLineCount() + ", document.textLength = " + document.getTextLength() + ", range: " + textEdit.getRange());
            return false;
        }
        String string = StringUtilRt.convertLineSeparators((String)textEdit.getNewText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(...)");
        String string2 = string;
        document.replaceString(n2.intValue(), n3.intValue(), (CharSequence)string2);
        return true;
    }

    private static final int C(TextEdit textEdit, TextEdit textEdit2) {
        Integer n2 = textEdit2.getRange().getStart().getLine() - textEdit.getRange().getStart().getLine();
        int n3 = ((Number)n2).intValue();
        boolean bl = false;
        Integer n4 = n3 != 0 ? n2 : null;
        return n4 != null ? n4 : textEdit2.getRange().getStart().getCharacter() - textEdit.getRange().getStart().getCharacter();
    }

    private static final int C(Function2 function2, Object object, Object object2) {
        return ((Number)function2.invoke(object, object2)).intValue();
    }
}

