/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.gradle.ext.uml;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.action.ExternalSystemActionUtil;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.gradle.ext.uml.GradleDiagramCategoryManager;
import org.jetbrains.idea.gradle.ext.uml.GradleElement;
import org.jetbrains.idea.gradle.ext.uml.GradleRootElement;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public final class GradleUmlElementManager
extends AbstractDiagramElementManager<GradleElement> {
    @Nullable
    public GradleElement findInDataContext(@NotNull DataContext context) {
        Object data;
        ExternalSystemNode node;
        if (context == null) {
            GradleUmlElementManager.$$$reportNull$$$0(0);
        }
        if (!GradleUmlElementManager.shouldProvideTheDiagram(context)) {
            return null;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        if (project == null) {
            return null;
        }
        Module module = ExternalSystemActionUtil.getModule((DataContext)context);
        if (!(module != null && ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module) || (node = (ExternalSystemNode)ContainerUtil.getFirstItem((List)((List)ExternalSystemDataKeys.SELECTED_NODES.getData(context)))) == null || !((data = node.getData()) instanceof ModuleData) && !(data instanceof ProjectData))) {
            module = ModuleManager.getInstance((Project)project).findModuleByName(((Named)data).getInternalName());
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return null;
        }
        return new GradleRootElement(project, module);
    }

    private static boolean shouldProvideTheDiagram(@NotNull DataContext context) {
        VirtualFile vFile;
        if (context == null) {
            GradleUmlElementManager.$$$reportNull$$$0(1);
        }
        if ((vFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context)) != null && !GradleUmlElementManager.isGradleFile(vFile) && !vFile.isDirectory()) {
            return false;
        }
        return CommonDataKeys.EDITOR.getData(context) == null || vFile != null && GradleUmlElementManager.isGradleFile(vFile);
    }

    private static boolean isGradleFile(@NotNull VirtualFile file) {
        String fileName;
        if (file == null) {
            GradleUmlElementManager.$$$reportNull$$$0(2);
        }
        return (fileName = file.getName()).endsWith(".gradle") || fileName.endsWith(".gradle.kts");
    }

    public boolean isAcceptableAsNode(@Nullable Object element) {
        return element instanceof GradleRootElement;
    }

    @Nls
    @NotNull
    public String getElementTitle(GradleElement element, @NotNull DiagramBuilder builder) {
        DiagramNodeContentManager contentManager;
        if (builder == null) {
            GradleUmlElementManager.$$$reportNull$$$0(3);
        }
        if ((contentManager = builder.getDataModel().getNodeContentManager()).isCategoryEnabled(GradleDiagramCategoryManager.ARTIFACTS_FQN)) {
            String string = element.getQualifiedName();
            if (string == null) {
                GradleUmlElementManager.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = element.getName();
        if (string == null) {
            GradleUmlElementManager.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getElementTitle(GradleElement element) {
        String string = element.getName();
        if (string == null) {
            GradleUmlElementManager.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public SimpleColoredText getItemName(@Nullable GradleElement nodeElement, @Nullable Object nodeItem, @NotNull DiagramBuilder builder) {
        if (builder == null) {
            GradleUmlElementManager.$$$reportNull$$$0(7);
        }
        if (nodeElement != null) {
            boolean style = true;
            SimpleTextAttributes attr = new SimpleTextAttributes(1, (Color)JBColor.BLACK);
            return new SimpleColoredText(nodeElement.getName(), attr);
        }
        return null;
    }

    @Nls
    @NotNull
    public String getNodeTooltip(GradleElement element) {
        String string = element.getHtmlDescription();
        if (string == null) {
            GradleUmlElementManager.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/gradle/ext/uml/GradleUmlElementManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/gradle/ext/uml/GradleUmlElementManager";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTitle";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findInDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldProvideTheDiagram";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isGradleFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementTitle";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getItemName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 8 -> new IllegalStateException(string);
        };
    }
}

