/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.channels.SftpChannel;
import com.jetbrains.plugins.remotesdk.CheckConnectionModalTask;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0002\u001a\u001a\u0010\u0006\u001a\u00020\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0002H\u0002\u001a&\u0010\n\u001a\u00020\u000b*\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"checkConnection", "", "Lcom/intellij/ssh/ConnectionBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "checkConnectionInBackground", "doCheckConnection", "pi", "Lcom/intellij/openapi/progress/ProgressIndicator;", "connectionBuilder", "waitForConnection", "", "Ljava/util/concurrent/Future;", "Lcom/intellij/remote/RemoteSdkException;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "intellij.remoteRun"})
@JvmName(name="RemoteSdkSessionUtil")
public final class RemoteSdkSessionUtil {
    public static final void checkConnection(@NotNull ConnectionBuilder $this$checkConnection, @Nullable Project project) throws RemoteSdkException {
        Intrinsics.checkNotNullParameter((Object)$this$checkConnection, (String)"<this>");
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            RemoteSdkSessionUtil.doCheckConnection(progressIndicator, $this$checkConnection);
        } else {
            CheckConnectionModalTask task = new CheckConnectionModalTask(project, $this$checkConnection);
            ApplicationManager.getApplication().invokeAndWait(() -> RemoteSdkSessionUtil.checkConnection$lambda$0(task));
            task.checkConnectionResult();
        }
    }

    public static /* synthetic */ void checkConnection$default(ConnectionBuilder connectionBuilder, Project project, int n, Object object) throws RemoteSdkException {
        if ((n & 1) != 0) {
            project = null;
        }
        RemoteSdkSessionUtil.checkConnection(connectionBuilder, project);
    }

    public static final void checkConnectionInBackground(@NotNull ConnectionBuilder $this$checkConnectionInBackground) throws RemoteSdkException {
        Intrinsics.checkNotNullParameter((Object)$this$checkConnectionInBackground, (String)"<this>");
        RemoteSdkSessionUtil.doCheckConnection(ProgressManager.getInstance().getProgressIndicator(), $this$checkConnectionInBackground);
    }

    private static final void doCheckConnection(ProgressIndicator pi, ConnectionBuilder connectionBuilder) throws ProcessCanceledException, RemoteSdkException {
        String host = connectionBuilder.getHost();
        Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> RemoteSdkSessionUtil.doCheckConnection$lambda$1(pi, host, connectionBuilder));
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"executeOnPooledThread(...)");
        Future connectionFuture = future;
        while (!RemoteSdkSessionUtil.waitForConnection$default(connectionFuture, 100L, null, 2, null)) {
            ProgressIndicator progressIndicator = pi;
            if (progressIndicator == null) continue;
            progressIndicator.checkCanceled();
        }
    }

    private static final boolean waitForConnection(Future<RemoteSdkException> $this$waitForConnection, long timeout, TimeUnit unit) throws ProcessCanceledException, RemoteSdkException {
        try {
            RemoteSdkException exception;
            RemoteSdkException remoteSdkException = exception = $this$waitForConnection.get(timeout, unit);
            if (remoteSdkException != null) {
                throw remoteSdkException;
            }
            return true;
        }
        catch (TimeoutException e) {
            return false;
        }
        catch (InterruptedException e) {
            throw new ProcessCanceledException((Throwable)e);
        }
        catch (CancellationException e) {
            throw new ProcessCanceledException((Throwable)e);
        }
    }

    static /* synthetic */ boolean waitForConnection$default(Future future, long l, TimeUnit timeUnit, int n, Object object) throws ProcessCanceledException, RemoteSdkException {
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        return RemoteSdkSessionUtil.waitForConnection(future, l, timeUnit);
    }

    private static final void checkConnection$lambda$0(CheckConnectionModalTask $task) {
        ProgressManager.getInstance().run((Task)$task);
    }

    private static final RemoteSdkException doCheckConnection$lambda$1(ProgressIndicator $pi, String $host, ConnectionBuilder $connectionBuilder) {
        ProgressIndicator progressIndicator = $pi;
        if (progressIndicator != null) {
            Object[] objectArray = new Object[]{$host};
            progressIndicator.setText(RemoteSdkBundle.message("progress.text.connecting.to.0", objectArray));
        }
        try {
            SftpChannel channel = $connectionBuilder.openSftpChannel(60);
            channel.close();
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{$host};
            return new RemoteSdkException(RemoteSdkBundle.message("dialog.message.error.connecting.to.remote.host.0", objectArray), (Throwable)e);
        }
        return null;
    }

    public static final /* synthetic */ void access$doCheckConnection(ProgressIndicator pi, ConnectionBuilder connectionBuilder) {
        RemoteSdkSessionUtil.doCheckConnection(pi, connectionBuilder);
    }
}

