/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.injection.el;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.integration.model.xml.core.Channel;
import com.intellij.spring.integration.model.xml.core.InputOutputChannelOwner;
import com.intellij.spring.integration.model.xml.event.InboundChannelAdapter;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PayloadTypeProvider {
    PayloadTypeProvider() {
    }

    @NotNull
    static PsiType resolvePayloadType(PsiElement context) {
        PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory().createTypeByFQClassName(PayloadTypeProvider.determinePayloadType(context), context.getResolveScope());
        if (psiClassType == null) {
            PayloadTypeProvider.$$$reportNull$$$0(0);
        }
        return psiClassType;
    }

    @NotNull
    private static String determinePayloadType(PsiElement context) {
        GenericAttributeValue<List<PsiType>> datatype;
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class);
        if (xmlTag == null) {
            return "java.lang.Object";
        }
        DomElement domElement = DomUtil.getDomElement((PsiElement)xmlTag);
        if (domElement == null) {
            return "java.lang.Object";
        }
        if (domElement instanceof InboundChannelAdapter) {
            Collection eventTypes = (Collection)((InboundChannelAdapter)domElement).getEventTypes().getValue();
            PsiClass eventTypePsiClass = (PsiClass)ContainerUtil.getFirstItem((Collection)eventTypes);
            return PayloadTypeProvider.determinePsiClassType(eventTypePsiClass);
        }
        Channel channel = PayloadTypeProvider.resolveChannel(domElement);
        if (channel != null && DomUtil.hasXml(datatype = channel.getDatatype())) {
            PsiType type = (PsiType)ContainerUtil.getFirstItem((List)((List)datatype.getValue()));
            PsiClass dataTypePsiClass = PsiTypesUtil.getPsiClass((PsiType)type);
            return PayloadTypeProvider.determinePsiClassType(dataTypePsiClass);
        }
        return "java.lang.Object";
    }

    @NotNull
    private static String determinePsiClassType(@Nullable PsiClass psiClass) {
        String string = StringUtil.notNullize((String)(psiClass != null ? psiClass.getQualifiedName() : null), (String)"java.lang.Object");
        if (string == null) {
            PayloadTypeProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private static Channel resolveChannel(DomElement domElement) {
        InputOutputChannelOwner inputOutputChannelOwner = (InputOutputChannelOwner)domElement.getParentOfType(InputOutputChannelOwner.class, true);
        if (inputOutputChannelOwner == null) {
            return null;
        }
        GenericAttributeValue<SpringBeanPointer<?>> inputChannel = inputOutputChannelOwner.getInputChannel();
        if (!DomUtil.hasXml(inputChannel)) {
            return null;
        }
        SpringBeanPointer inputChannelPointer = (SpringBeanPointer)inputChannel.getValue();
        if (inputChannelPointer == null) {
            return null;
        }
        CommonSpringBean channelBean = inputChannelPointer.getSpringBean();
        if (!(channelBean instanceof Channel)) {
            return null;
        }
        return (Channel)channelBean;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/integration/injection/el/PayloadTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePayloadType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "determinePsiClassType";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

