/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.model.jam;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.integration.model.jam.IntegrationComponentScan;
import com.intellij.spring.integration.model.jam.messagingGateway.MessagingGateway;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.jam.utils.JamAnnotationTypeUtil;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MessagingGatewaysSearchUtil {
    private static final Key<CachedValue<List<CommonSpringBean>>> ALL_INTEGRATION_COMPONENT_SCANS_KEY = Key.create((String)"ALL_INTEGRATION_COMPONENT_SCANS_KEY");
    private static final Key<CachedValue<List<CommonSpringBean>>> ALL_INTEGRATION_COMPONENT_SCANS_INCLUDING_TESTS_KEY = Key.create((String)"ALL_INTEGRATION_COMPONENT_SCANS_INCLUDING_TESTS_KEY");

    public static List<CommonSpringBean> getAllMessagingGateways(@NotNull Module module, IntegrationComponentScan scan, boolean includeTests) {
        if (module == null) {
            MessagingGatewaysSearchUtil.$$$reportNull$$$0(0);
        }
        PsiFile file = scan.getContainingFile();
        assert (file != null);
        boolean isInTestSources = ProjectRootsUtil.isInTestSource((PsiFile)file) || includeTests;
        Key<CachedValue<List<CommonSpringBean>>> cachedValueKey = isInTestSources ? ALL_INTEGRATION_COMPONENT_SCANS_INCLUDING_TESTS_KEY : ALL_INTEGRATION_COMPONENT_SCANS_KEY;
        return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, cachedValueKey, () -> CachedValueProvider.Result.create(MessagingGatewaysSearchUtil.getMessagingGateways(module, isInTestSources), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
    }

    @NotNull
    public static List<CommonSpringBean> getMessagingGateways(@NotNull Module module, boolean isInTestSources) {
        if (module == null) {
            MessagingGatewaysSearchUtil.$$$reportNull$$$0(1);
        }
        GlobalSearchScope scope = SpringGlobalSearchScopes.runtime((Module)module, (boolean)isInTestSources);
        JamService jamService = JamService.getJamService((Project)module.getProject());
        SmartList messagingGateways = new SmartList();
        for (String anno : MessagingGatewaysSearchUtil.getMessagingGatewayAnnotations(module)) {
            List elements = jamService.getJamClassElements(MessagingGateway.MESSAGING_GATEWAY_JAM_KEY, anno, scope);
            for (MessagingGateway gateway : elements) {
                if (!(gateway instanceof CommonSpringBean)) continue;
                messagingGateways.add((CommonSpringBean)gateway);
            }
        }
        SmartList smartList = messagingGateways;
        if (smartList == null) {
            MessagingGatewaysSearchUtil.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    @NotNull
    public static Collection<String> getMessagingGatewayAnnotations(@Nullable Module module) {
        if (module == null) {
            Set<String> set = Collections.singleton("org.springframework.integration.annotation.MessagingGateway");
            if (set == null) {
                MessagingGatewaysSearchUtil.$$$reportNull$$$0(3);
            }
            return set;
        }
        Collection collection = JamAnnotationTypeUtil.getInstance((Module)module).getAnnotationNamesWithChildren("org.springframework.integration.annotation.MessagingGateway");
        if (collection == null) {
            MessagingGatewaysSearchUtil.$$$reportNull$$$0(4);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/integration/model/jam/MessagingGatewaysSearchUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/integration/model/jam/MessagingGatewaysSearchUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessagingGateways";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessagingGatewayAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllMessagingGateways";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMessagingGateways";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

