/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.model.xml;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.integration.model.xml.core.Chain;
import com.intellij.spring.integration.model.xml.core.ExpressionOrInnerEndpointDefinitionAware;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SpringIntegrationDynamicDomExtender {
    private static void register(DomElement containerElement, DomExtensionsRegistrar registrar) {
        XmlTag[] tags = containerElement.getXmlTag().getSubTags();
        if (tags.length == 0) {
            return;
        }
        DomFileElement fileElement = DomUtil.getFileElement((DomElement)containerElement);
        NotNullLazyValue descriptions = NotNullLazyValue.lazy(() -> fileElement.getRootElement().getGenericInfo().getCollectionChildrenDescriptions());
        DomFileDescription fileDescription = fileElement.getFileDescription();
        DomManager domManager = DomManager.getDomManager((Project)fileElement.getFile().getProject());
        block0: for (XmlTag tag : tags) {
            if (domManager.findChildrenDescription(tag, containerElement) != null) continue;
            String tagLocalName = tag.getLocalName();
            for (DomCollectionChildDescription description : (List)descriptions.getValue()) {
                String tagNamespace;
                List allowedNamespaces;
                String namespaceKey;
                String name = description.getXmlElementName();
                if (!tagLocalName.equals(name) || (namespaceKey = description.getXmlName().getNamespaceKey()) == null || !(allowedNamespaces = fileDescription.getAllowedNamespaces(namespaceKey, fileElement.getFile())).contains(tagNamespace = tag.getNamespace())) continue;
                registrar.registerCollectionChildrenExtension(description.getXmlName(), description.getType());
                continue block0;
            }
        }
    }

    public static class _ExpressionOrInnerEndpointDefinitionAware
    extends DomExtender<ExpressionOrInnerEndpointDefinitionAware> {
        public void registerExtensions(@NotNull ExpressionOrInnerEndpointDefinitionAware aware, @NotNull DomExtensionsRegistrar registrar) {
            if (aware == null) {
                _ExpressionOrInnerEndpointDefinitionAware.$$$reportNull$$$0(0);
            }
            if (registrar == null) {
                _ExpressionOrInnerEndpointDefinitionAware.$$$reportNull$$$0(1);
            }
            SpringIntegrationDynamicDomExtender.register(aware, registrar);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "aware";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "registrar";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/integration/model/xml/SpringIntegrationDynamicDomExtender$_ExpressionOrInnerEndpointDefinitionAware";
            objectArray[2] = "registerExtensions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class _Chain
    extends DomExtender<Chain> {
        public void registerExtensions(@NotNull Chain chain, @NotNull DomExtensionsRegistrar registrar) {
            if (chain == null) {
                _Chain.$$$reportNull$$$0(0);
            }
            if (registrar == null) {
                _Chain.$$$reportNull$$$0(1);
            }
            SpringIntegrationDynamicDomExtender.register(chain, registrar);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "chain";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "registrar";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/integration/model/xml/SpringIntegrationDynamicDomExtender$_Chain";
            objectArray[2] = "registerExtensions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

