/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openRewrite.run.editor;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openRewrite.OpenRewriteIcons;
import com.intellij.openRewrite.recipe.OpenRewriteRecipeDescriptor;
import com.intellij.openRewrite.recipe.OpenRewriteRecipeService;
import com.intellij.openRewrite.recipe.OpenRewriteType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J(\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0002J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openRewrite/run/editor/OpenRewriteRecipeCompletionProvider;", "Lcom/intellij/ui/TextFieldWithAutoCompletionListProvider;", "Lcom/intellij/openRewrite/recipe/OpenRewriteRecipeDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "configSupplier", "Ljava/util/function/Supplier;", "Lcom/intellij/openapi/vfs/VirtualFile;", "type", "Lcom/intellij/openRewrite/recipe/OpenRewriteType;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/function/Supplier;Lcom/intellij/openRewrite/recipe/OpenRewriteType;)V", "getLookupString", "", "item", "createLookupBuilder", "Lcom/intellij/codeInsight/lookup/LookupElementBuilder;", "getItems", "", "prefix", "cached", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "getPrefix", "text", "offset", "", "getDescriptors", "filterOutCompletingRecipe", "intellij.openRewrite"})
@SourceDebugExtension(value={"SMAP\nOpenRewriteRecipeCompletionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenRewriteRecipeCompletionProvider.kt\ncom/intellij/openRewrite/run/editor/OpenRewriteRecipeCompletionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1557#2:80\n1628#2,3:81\n774#2:84\n865#2,2:85\n774#2:87\n865#2,2:88\n*S KotlinDebug\n*F\n+ 1 OpenRewriteRecipeCompletionProvider.kt\ncom/intellij/openRewrite/run/editor/OpenRewriteRecipeCompletionProvider\n*L\n41#1:80\n41#1:81,3\n41#1:84\n41#1:85,2\n43#1:87\n43#1:88,2\n*E\n"})
public final class OpenRewriteRecipeCompletionProvider
extends TextFieldWithAutoCompletionListProvider<OpenRewriteRecipeDescriptor> {
    @NotNull
    private final Project project;
    @NotNull
    private final Supplier<VirtualFile> configSupplier;
    @NotNull
    private final OpenRewriteType type;

    public OpenRewriteRecipeCompletionProvider(@NotNull Project project, @NotNull Supplier<VirtualFile> configSupplier, @NotNull OpenRewriteType type) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(configSupplier, (String)"configSupplier");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super(null);
        this.project = project;
        this.configSupplier = configSupplier;
        this.type = type;
    }

    @NotNull
    protected String getLookupString(@NotNull OpenRewriteRecipeDescriptor item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return item.getName();
    }

    @NotNull
    public LookupElementBuilder createLookupBuilder(@NotNull OpenRewriteRecipeDescriptor item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)item.getName()).withIcon(OpenRewriteIcons.OpenRewrite);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withIcon(...)");
        LookupElementBuilder builder = lookupElementBuilder;
        if (item.getDisplayName() != null) {
            builder = builder.withLookupString(item.getDisplayName()).withTypeText(item.getDisplayName());
        }
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<OpenRewriteRecipeDescriptor> getItems(@Nullable String prefix, boolean cached, @NotNull CompletionParameters parameters) {
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object it;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        if (prefix == null) {
            return CollectionsKt.emptyList();
        }
        String string = parameters.getEditor().getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = this.filterOutCompletingRecipe(string, parameters.getOffset());
        char[] cArray = new char[]{','};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)text, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set activeRecipes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$filter$iv = this.getDescriptors();
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (OpenRewriteRecipeDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(((OpenRewriteRecipeDescriptor)it).getOptions().isEmpty() && !activeRecipes.contains(((OpenRewriteRecipeDescriptor)it).getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public String getPrefix(@NotNull String text, int offset) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int space = Math.max(StringsKt.lastIndexOf$default((CharSequence)text, (char)' ', (int)(offset - 1), (boolean)false, (int)4, null), StringsKt.lastIndexOf$default((CharSequence)text, (char)'\n', (int)(offset - 1), (boolean)false, (int)4, null)) + 1;
        int comma = StringsKt.lastIndexOf$default((CharSequence)text, (char)',', (int)(offset - 1), (boolean)false, (int)4, null) + 1;
        String string = text.substring(Math.max(space, comma), offset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private final Collection<OpenRewriteRecipeDescriptor> getDescriptors() {
        Object object = ReadAction.nonBlocking(() -> OpenRewriteRecipeCompletionProvider.getDescriptors$lambda$3(this)).executeSynchronously();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executeSynchronously(...)");
        return (Collection)object;
    }

    private final String filterOutCompletingRecipe(String text, int offset) {
        int after;
        int space = Math.max(StringsKt.lastIndexOf$default((CharSequence)text, (char)' ', (int)(offset - 1), (boolean)false, (int)4, null), StringsKt.lastIndexOf$default((CharSequence)text, (char)'\n', (int)(offset - 1), (boolean)false, (int)4, null)) + 1;
        int comma = StringsKt.lastIndexOf$default((CharSequence)text, (char)',', (int)(offset - 1), (boolean)false, (int)4, null) + 1;
        int before = Math.max(space, comma);
        String string = text.substring(0, before);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        Object result = string;
        space = Math.min(StringsKt.indexOf$default((CharSequence)text, (char)' ', (int)offset, (boolean)false, (int)4, null), StringsKt.indexOf$default((CharSequence)text, (char)'\n', (int)offset, (boolean)false, (int)4, null));
        comma = StringsKt.indexOf$default((CharSequence)text, (char)',', (int)offset, (boolean)false, (int)4, null);
        int n = space < 0 ? comma : (after = comma < 0 ? space : Math.min(comma, space));
        if (after >= 0) {
            String string2 = text.substring(after);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            result = (String)result + string2;
        }
        return result;
    }

    private static final Collection getDescriptors$lambda$3(OpenRewriteRecipeCompletionProvider this$0) {
        VirtualFile virtualFile = this$0.configSupplier.get();
        PsiFile psiFile = virtualFile == null ? null : PsiManager.getInstance((Project)this$0.project).findFile(virtualFile);
        return OpenRewriteRecipeService.Companion.getInstance(this$0.project).getDescriptors(psiFile, this$0.type);
    }
}

