/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openRewrite.yaml;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.jvm.types.JvmPrimitiveTypeKind;
import com.intellij.openRewrite.OpenRewriteBundle;
import com.intellij.openRewrite.OpenRewriteUtilKt;
import com.intellij.openRewrite.recipe.OpenRewriteOptionDescriptor;
import com.intellij.openRewrite.recipe.OpenRewriteRecipeDescriptor;
import com.intellij.openRewrite.recipe.OpenRewriteRecipeService;
import com.intellij.openRewrite.recipe.OpenRewriteType;
import com.intellij.openRewrite.yaml.OpenRewriteYamlRecipeOptionValueReferenceProvider;
import com.intellij.openRewrite.yaml.OpenRewriteYamlUtilsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openRewrite/yaml/OpenRewriteYamlRecipeInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "notConvertedToPrimitiveType", "text", "", "type", "AddOptionQuickFix", "intellij.openRewrite"})
public final class OpenRewriteYamlRecipeInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        if (!OpenRewriteUtilKt.isRecipe(psiFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return (PsiElementVisitor)new YamlPsiElementVisitor(holder, this){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ OpenRewriteYamlRecipeInspection this$0;
            {
                this.$holder = $holder;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public void visitKeyValue(YAMLKeyValue keyValue) {
                Object object;
                List requiredOptions;
                PsiElement keyElement;
                block12: {
                    block11: {
                        void $this$mapTo$iv$iv;
                        Collection collection;
                        Object item$iv$iv2;
                        YAMLValue $this$mapTo$iv$iv2;
                        void $this$map$iv;
                        OpenRewriteOptionDescriptor it;
                        void $this$filterTo$iv$iv;
                        Intrinsics.checkNotNullParameter((Object)keyValue, (String)"keyValue");
                        super.visitKeyValue(keyValue);
                        PsiElement psiElement = keyValue.getKey();
                        if (psiElement == null) {
                            return;
                        }
                        keyElement = psiElement;
                        OpenRewriteType openRewriteType = OpenRewriteYamlUtilsKt.getKeyValueType(keyValue);
                        if (openRewriteType == null) {
                            return;
                        }
                        OpenRewriteType type = openRewriteType;
                        Project project = keyValue.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        OpenRewriteRecipeService openRewriteRecipeService = OpenRewriteRecipeService.Companion.getInstance(project);
                        String string = keyValue.getKeyText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKeyText(...)");
                        OpenRewriteRecipeDescriptor openRewriteRecipeDescriptor = openRewriteRecipeService.findDescriptor(string, this.$holder.getFile(), type);
                        if (openRewriteRecipeDescriptor == null) {
                            return;
                        }
                        OpenRewriteRecipeDescriptor descriptor = openRewriteRecipeDescriptor;
                        Iterable $this$filter$iv = descriptor.getOptions();
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (OpenRewriteOptionDescriptor)element$iv$iv;
                            boolean bl = false;
                            if (!it.getRequired()) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                            it = (OpenRewriteOptionDescriptor)item$iv$iv2;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(it.getName());
                        }
                        requiredOptions = (List)destination$iv$iv;
                        if (requiredOptions.isEmpty()) {
                            return;
                        }
                        $this$mapTo$iv$iv2 = keyValue.getValue();
                        object = $this$mapTo$iv$iv2 instanceof YAMLMapping ? (YAMLMapping)$this$mapTo$iv$iv2 : null;
                        if (object == null || (object = object.getKeyValues()) == null) break block11;
                        Iterable $this$map$iv2 = (Iterable)object;
                        boolean $i$f$map2 = false;
                        item$iv$iv2 = $this$map$iv2;
                        Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo2 = false;
                        for (T item$iv$iv3 : $this$mapTo$iv$iv) {
                            void it2;
                            YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)item$iv$iv3;
                            collection = destination$iv$iv2;
                            boolean bl = false;
                            collection.add(it2.getKeyText());
                        }
                        object = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                        if (object != null) break block12;
                    }
                    object = SetsKt.emptySet();
                }
                Object existingOptions = object;
                for (String requiredOption : requiredOptions) {
                    if (existingOptions.contains(requiredOption)) continue;
                    Object[] objectArray = new Object[]{requiredOption};
                    String string = OpenRewriteBundle.message("open.rewrite.yaml.missing.required.option", objectArray);
                    objectArray = new LocalQuickFix[]{new AddOptionQuickFix(requiredOption)};
                    this.$holder.registerProblem(keyElement, string, ProblemHighlightType.ERROR, (LocalQuickFix[])objectArray);
                }
            }

            /*
             * WARNING - void declaration
             */
            public void visitScalar(YAMLScalar scalar) {
                void $this$mapTo$iv$iv;
                OpenRewriteOptionDescriptor it;
                Iterable $this$filterTo$iv$iv;
                Object object;
                block11: {
                    Intrinsics.checkNotNullParameter((Object)scalar, (String)"scalar");
                    super.visitScalar(scalar);
                    PsiReference[] psiReferenceArray = scalar.getReferences();
                    Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
                    for (Object iterator2 : (Object[])psiReferenceArray) {
                        PsiReference it2 = (PsiReference)iterator2;
                        boolean bl = false;
                        if (!(it2 instanceof OpenRewriteYamlRecipeOptionValueReferenceProvider.RecipeOptionValueReference)) continue;
                        object = iterator2;
                        break block11;
                    }
                    object = null;
                }
                PsiReference reference = (PsiReference)object;
                if (reference != null) {
                    String type;
                    OpenRewriteYamlRecipeOptionValueReferenceProvider.RecipeOptionValueReference valueReference = (OpenRewriteYamlRecipeOptionValueReferenceProvider.RecipeOptionValueReference)reference;
                    OpenRewriteOptionDescriptor openRewriteOptionDescriptor = valueReference.findRecipeOptionDescriptor();
                    if (openRewriteOptionDescriptor == null) {
                        return;
                    }
                    OpenRewriteOptionDescriptor descriptor = openRewriteOptionDescriptor;
                    PsiType psiType = descriptor.getTypePointer().getType();
                    String string = type = psiType != null ? psiType.getCanonicalText() : null;
                    if (type != null) {
                        String string2 = scalar.getTextValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTextValue(...)");
                        if (OpenRewriteYamlRecipeInspection.access$notConvertedToPrimitiveType(this.this$0, string2, type)) {
                            Object[] objectArray = new Object[]{type, scalar.getTextValue()};
                            this.$holder.registerProblem((PsiElement)scalar, OpenRewriteBundle.message("open.rewrite.unresolved.number.value", objectArray), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
                        }
                    }
                    if (!((Collection)descriptor.getValid()).isEmpty() && !descriptor.getValid().contains(scalar.getTextValue())) {
                        Object[] objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)descriptor.getValid(), (CharSequence)"|", null, null, (int)0, null, null, (int)62, null), scalar.getTextValue()};
                        this.$holder.registerProblem((PsiElement)scalar, OpenRewriteBundle.message("open.rewrite.unresolved.static.value", objectArray), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
                    }
                    return;
                }
                PsiElement parent = scalar.getParent();
                OpenRewriteType openRewriteType = OpenRewriteYamlUtilsKt.getSequenceItemType(parent);
                if (openRewriteType == null) {
                    return;
                }
                OpenRewriteType type = openRewriteType;
                Project project = scalar.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                OpenRewriteRecipeService openRewriteRecipeService = OpenRewriteRecipeService.Companion.getInstance(project);
                String string = scalar.getTextValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextValue(...)");
                OpenRewriteRecipeDescriptor openRewriteRecipeDescriptor = openRewriteRecipeService.findDescriptor(string, this.$holder.getFile(), type);
                if (openRewriteRecipeDescriptor == null) {
                    return;
                }
                OpenRewriteRecipeDescriptor descriptor = openRewriteRecipeDescriptor;
                Iterable iterable = descriptor.getOptions();
                boolean $i$f$filter = false;
                Iterable bl = iterable;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (OpenRewriteOptionDescriptor)element$iv$iv;
                    boolean bl2 = false;
                    if (!it.getRequired()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable iterable2 = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = iterable2;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    it = (OpenRewriteOptionDescriptor)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(it.getName());
                }
                List requiredOptions = (List)destination$iv$iv;
                for (String requiredOption : requiredOptions) {
                    Object[] objectArray = new Object[]{requiredOption};
                    String string3 = OpenRewriteBundle.message("open.rewrite.yaml.missing.required.option", objectArray);
                    objectArray = new LocalQuickFix[]{new AddOptionQuickFix(requiredOption)};
                    this.$holder.registerProblem((PsiElement)scalar, string3, ProblemHighlightType.ERROR, (LocalQuickFix[])objectArray);
                }
            }
        };
    }

    private final boolean notConvertedToPrimitiveType(String text, String type) {
        boolean bl;
        String string = type;
        if (Intrinsics.areEqual((Object)string, (Object)JvmPrimitiveTypeKind.BOOLEAN.getName()) || Intrinsics.areEqual((Object)string, (Object)JvmPrimitiveTypeKind.BOOLEAN.getBoxedFqn())) {
            bl = !Intrinsics.areEqual((Object)text, (Object)"true") && !Intrinsics.areEqual((Object)text, (Object)"false");
        } else if (Intrinsics.areEqual((Object)string, (Object)JvmPrimitiveTypeKind.INT.getName()) || Intrinsics.areEqual((Object)string, (Object)JvmPrimitiveTypeKind.INT.getBoxedFqn())) {
            boolean bl2;
            try {
                Integer.parseInt(text);
                bl2 = false;
            }
            catch (NumberFormatException e) {
                bl2 = true;
            }
            bl = bl2;
        } else if (Intrinsics.areEqual((Object)string, (Object)JvmPrimitiveTypeKind.LONG.getName()) || Intrinsics.areEqual((Object)string, (Object)JvmPrimitiveTypeKind.LONG.getBoxedFqn())) {
            boolean bl3;
            try {
                Long.parseLong(text);
                bl3 = false;
            }
            catch (NumberFormatException e) {
                bl3 = true;
            }
            bl = bl3;
        } else if (Intrinsics.areEqual((Object)string, (Object)JvmPrimitiveTypeKind.SHORT.getName()) || Intrinsics.areEqual((Object)string, (Object)JvmPrimitiveTypeKind.SHORT.getBoxedFqn())) {
            boolean bl4;
            try {
                Short.parseShort(text);
                bl4 = false;
            }
            catch (NumberFormatException e) {
                bl4 = true;
            }
            bl = bl4;
        } else if (Intrinsics.areEqual((Object)string, (Object)JvmPrimitiveTypeKind.FLOAT.getName()) || Intrinsics.areEqual((Object)string, (Object)JvmPrimitiveTypeKind.FLOAT.getBoxedFqn())) {
            boolean bl5;
            try {
                Float.parseFloat(text);
                bl5 = false;
            }
            catch (NumberFormatException e) {
                bl5 = true;
            }
            bl = bl5;
        } else if (Intrinsics.areEqual((Object)string, (Object)JvmPrimitiveTypeKind.DOUBLE.getName()) || Intrinsics.areEqual((Object)string, (Object)JvmPrimitiveTypeKind.DOUBLE.getBoxedFqn())) {
            boolean bl6;
            try {
                Double.parseDouble(text);
                bl6 = false;
            }
            catch (NumberFormatException e) {
                bl6 = true;
            }
            bl = bl6;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$notConvertedToPrimitiveType(OpenRewriteYamlRecipeInspection $this, String text, String type) {
        return $this.notConvertedToPrimitiveType(text, type);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openRewrite/yaml/OpenRewriteYamlRecipeInspection$AddOptionQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "option", "", "<init>", "(Ljava/lang/String;)V", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "keyValue", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "optionKeyValue", "sequenceItemScalar", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "intellij.openRewrite"})
    private static final class AddOptionQuickFix
    implements LocalQuickFix {
        @NotNull
        private final String option;

        public AddOptionQuickFix(@NotNull String option) {
            Intrinsics.checkNotNullParameter((Object)option, (String)"option");
            this.option = option;
        }

        @NotNull
        public String getFamilyName() {
            Object[] objectArray = new Object[]{this.option};
            String string = OpenRewriteBundle.message("open.rewrite.yaml.add.required.option", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            YAMLKeyValue yAMLKeyValue = YAMLElementGenerator.getInstance((Project)project).createYamlKeyValue(this.option, "");
            Intrinsics.checkNotNullExpressionValue((Object)yAMLKeyValue, (String)"createYamlKeyValue(...)");
            YAMLKeyValue optionKeyValue = yAMLKeyValue;
            PsiElement psiElement = descriptor.getPsiElement();
            PsiElement parent = psiElement.getParent();
            if (parent instanceof YAMLKeyValue) {
                this.applyFix((YAMLKeyValue)parent, optionKeyValue);
            } else if (parent instanceof YAMLSequenceItem && psiElement instanceof YAMLScalar) {
                this.applyFix((YAMLScalar)psiElement, optionKeyValue, project);
            }
        }

        private final void applyFix(YAMLKeyValue keyValue, YAMLKeyValue optionKeyValue) {
            YAMLValue value = keyValue.getValue();
            if (value instanceof YAMLMapping) {
                ((YAMLMapping)value).putKeyValue(optionKeyValue);
            } else if (value != null) {
                YAMLMapping yAMLMapping = optionKeyValue.getParentMapping();
                Intrinsics.checkNotNull((Object)yAMLMapping);
                value.replace((PsiElement)yAMLMapping);
            } else {
                YAMLMapping yAMLMapping = optionKeyValue.getParentMapping();
                Intrinsics.checkNotNull((Object)yAMLMapping);
                keyValue.setValue((YAMLValue)yAMLMapping);
            }
        }

        private final void applyFix(YAMLScalar sequenceItemScalar, YAMLKeyValue optionKeyValue, Project project) {
            YAMLKeyValue yAMLKeyValue = YAMLElementGenerator.getInstance((Project)project).createYamlKeyValue(sequenceItemScalar.getTextValue(), "dummy");
            Intrinsics.checkNotNullExpressionValue((Object)yAMLKeyValue, (String)"createYamlKeyValue(...)");
            YAMLKeyValue itemMapping = yAMLKeyValue;
            YAMLValue yAMLValue = itemMapping.getValue();
            Intrinsics.checkNotNull((Object)yAMLValue);
            YAMLMapping yAMLMapping = optionKeyValue.getParentMapping();
            Intrinsics.checkNotNull((Object)yAMLMapping);
            yAMLValue.replace((PsiElement)yAMLMapping);
            YAMLMapping yAMLMapping2 = itemMapping.getParentMapping();
            Intrinsics.checkNotNull((Object)yAMLMapping2);
            sequenceItemScalar.replace((PsiElement)yAMLMapping2);
        }
    }
}

