/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.support.processors;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.thymeleaf.lang.psi.ThymeleafReference;
import com.intellij.thymeleaf.lang.psi.ThymesELMethodCallExpression;
import com.intellij.thymeleaf.lang.psi.ThymesElExpression;
import com.intellij.thymeleaf.lang.support.ThymeleafElementProcessor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MultiResolveProcessor
extends ThymeleafElementProcessor {
    @NotNull
    private final String myHintName;
    private ThymesELMethodCallExpression myMethodResolve;
    @NotNull
    private final Set<ResolveResult> myResults;

    public MultiResolveProcessor(@NotNull ThymeleafReference reference) {
        if (reference == null) {
            MultiResolveProcessor.$$$reportNull$$$0(0);
        }
        this.myResults = new HashSet<ResolveResult>();
        this.myHintName = reference.getText();
        PsiElement element = reference.getElement();
        ThymesELMethodCallExpression methodCallExpression = (ThymesELMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, ThymesELMethodCallExpression.class);
        if (methodCallExpression != null && element.equals(methodCallExpression.getMethod())) {
            this.myMethodResolve = methodCallExpression;
        }
    }

    public ResolveResult @NotNull [] getResults() {
        ResolveResult[] resolveResultArray = this.myResults.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            MultiResolveProcessor.$$$reportNull$$$0(1);
        }
        return resolveResultArray;
    }

    @Override
    public boolean processVariable(@NotNull PsiVariable variable, @NotNull PsiSubstitutor substitutor) {
        if (variable == null) {
            MultiResolveProcessor.$$$reportNull$$$0(2);
        }
        if (substitutor == null) {
            MultiResolveProcessor.$$$reportNull$$$0(3);
        }
        if (!this.isMethodResolve() && variable.getName().equals(this.myHintName)) {
            this.myResults.add((ResolveResult)new CandidateInfo((PsiElement)variable, substitutor));
        }
        return true;
    }

    protected boolean isMethodResolve() {
        return this.myMethodResolve != null;
    }

    @Override
    public boolean processMethod(@NotNull PsiMethod psiMethod, @NotNull PsiSubstitutor substitutor) {
        if (psiMethod == null) {
            MultiResolveProcessor.$$$reportNull$$$0(4);
        }
        if (substitutor == null) {
            MultiResolveProcessor.$$$reportNull$$$0(5);
        }
        PsiParameterList parameterList = psiMethod.getParameterList();
        if (this.isMethodResolve()) {
            if (psiMethod.getName().equals(this.myHintName)) {
                List<ThymesElExpression> parameterExpressions = this.myMethodResolve.getParameterList().getElExpressionList();
                if (parameterExpressions.size() == parameterList.getParametersCount()) {
                    this.myResults.add((ResolveResult)new CandidateInfo((PsiElement)psiMethod, substitutor));
                } else {
                    int parametersCount = parameterList.getParametersCount();
                    if (parametersCount > 0 && parametersCount < parameterExpressions.size() && parameterList.getParameters()[parametersCount - 1].getType() instanceof PsiEllipsisType) {
                        this.myResults.add((ResolveResult)new CandidateInfo((PsiElement)psiMethod, substitutor));
                    }
                }
            }
        } else if (this.myHintName.equals(PropertyUtilBase.getPropertyNameByGetter((PsiMethod)psiMethod)) || this.myHintName.equals(psiMethod.getName()) && parameterList.getParametersCount() == 0) {
            this.myResults.add((ResolveResult)new CandidateInfo((PsiElement)psiMethod, substitutor));
        }
        return true;
    }

    @Override
    public boolean processPackage(@NotNull PsiPackage psiPackage) {
        if (psiPackage == null) {
            MultiResolveProcessor.$$$reportNull$$$0(6);
        }
        if (this.myHintName.equals(psiPackage.getName())) {
            this.myResults.add((ResolveResult)new CandidateInfo((PsiElement)psiPackage, PsiSubstitutor.EMPTY));
        }
        return true;
    }

    @Override
    public boolean processClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            MultiResolveProcessor.$$$reportNull$$$0(7);
        }
        if (this.myHintName.equals(psiClass.getName())) {
            this.myResults.add((ResolveResult)new CandidateInfo((PsiElement)psiClass, PsiSubstitutor.EMPTY));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/lang/support/processors/MultiResolveProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/lang/support/processors/MultiResolveProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processVariable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processMethod";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processPackage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

