/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.support.utils;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.thymeleaf.constants.ThymeleafNamespaceConstants;
import com.intellij.thymeleaf.dialects.ThymeleafDialect;
import com.intellij.thymeleaf.dialects.ThymeleafDialects;
import com.intellij.thymeleaf.lang.ThymeleafExpressionsFileType;
import com.intellij.thymeleaf.lang.injectors.ThymeleafExpressionsInjector;
import com.intellij.thymeleaf.lang.psi.ThymesElExpression;
import com.intellij.thymeleaf.lang.psi.ThymesPathTemplateSelector;
import com.intellij.thymeleaf.lang.psi.ThymesTemplateName;
import com.intellij.thymeleaf.lang.psi.ThymesTemplateNameSelectorExpression;
import com.intellij.thymeleaf.lang.psi.ThymesTemplateSelectionExpression;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ThymeleafCommonUtil {
    public static boolean hasThymeleafLibrary(Project project) {
        return JavaLibraryUtil.hasLibraryJar((Project)project, (String)"org.thymeleaf:thymeleaf");
    }

    public static String @NotNull [] getThymeleafNamespaces(@NotNull Project project) {
        if (project == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(0);
        }
        HashSet uris = new HashSet();
        for (ThymeleafDialect dialect : ThymeleafDialects.getDialects(project)) {
            ContainerUtil.addAll(uris, (Object[])dialect.getNamespaces());
        }
        String[] stringArray = ArrayUtilRt.toStringArray(uris);
        if (stringArray == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    @Nullable
    public static ThymesElExpression findObjectExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(2);
        }
        return ThymeleafCommonUtil.findParentTagExpression(expression, "object");
    }

    @NotNull
    public static Collection<ThymesElExpression> findEachExpressions(@NotNull PsiElement expression) {
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(3);
        }
        return ThymeleafCommonUtil.findAllParentTagExpressions(expression, "each");
    }

    @Nullable
    public static ThymesElExpression findFragmentExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(4);
        }
        return ThymeleafCommonUtil.findParentTagExpression(expression, "fragment");
    }

    @Nullable
    public static ThymesElExpression findFirstParentTagsExpression(@NotNull PsiElement expression, String ... attrNames) {
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(5);
        }
        if (attrNames == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(6);
        }
        CommonProcessors.FindFirstProcessor findFirst = new CommonProcessors.FindFirstProcessor();
        ThymeleafCommonUtil.processParentTagExpressions(expression, Arrays.asList(attrNames), (Processor<? super ThymesElExpression>)findFirst);
        return (ThymesElExpression)findFirst.getFoundValue();
    }

    @NotNull
    public static Collection<ThymesElExpression> findWithExpressions(@NotNull PsiElement expression) {
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(7);
        }
        return ThymeleafCommonUtil.findAllParentTagExpressions(expression, "with", true);
    }

    @Nullable
    public static ThymesElExpression findParentTagExpression(@NotNull PsiElement expression, @NotNull String attrName) {
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(8);
        }
        if (attrName == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(9);
        }
        CommonProcessors.FindFirstProcessor findFirst = new CommonProcessors.FindFirstProcessor();
        ThymeleafCommonUtil.processParentTagExpressions(expression, Collections.singleton(attrName), (Processor<? super ThymesElExpression>)findFirst);
        return (ThymesElExpression)findFirst.getFoundValue();
    }

    @NotNull
    private static Collection<ThymesElExpression> findAllParentTagExpressions(@NotNull PsiElement expression, @NotNull String attrName) {
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(10);
        }
        if (attrName == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(11);
        }
        return ThymeleafCommonUtil.findAllParentTagExpressions(expression, attrName, false);
    }

    @NotNull
    private static Collection<ThymesElExpression> findAllParentTagExpressions(@NotNull PsiElement expression, @NotNull String attrName, boolean searchInCurrentTag) {
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(12);
        }
        if (attrName == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(13);
        }
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        ThymeleafCommonUtil.processParentTagExpressions(expression, Collections.singleton(attrName), (Processor<? super ThymesElExpression>)collectProcessor, searchInCurrentTag);
        Collection collection = collectProcessor.getResults();
        if (collection == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(14);
        }
        return collection;
    }

    private static void processParentTagExpressions(@NotNull PsiElement expression, @NotNull Collection<String> attrNames, @NotNull Processor<? super ThymesElExpression> processor) {
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(15);
        }
        if (attrNames == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(17);
        }
        ThymeleafCommonUtil.processParentTagExpressions(expression, attrNames, processor, false);
    }

    private static void processParentTagExpressions(@NotNull PsiElement expression, @NotNull Collection<String> attrNames, @NotNull Processor<? super ThymesElExpression> processor, boolean searchInCurrentTag) {
        XmlTag xmlTag;
        XmlAttribute contextAttribute;
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(18);
        }
        if (attrNames == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(19);
        }
        if (processor == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(20);
        }
        if ((contextAttribute = ThymeleafCommonUtil.getContextAttribute(expression)) != null && (xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)contextAttribute, XmlTag.class)) != null) {
            XmlTag parentTag;
            XmlTag xmlTag2 = parentTag = !searchInCurrentTag && attrNames.contains(ThymeleafCommonUtil.getLocalName(contextAttribute)) ? xmlTag.getParentTag() : xmlTag;
            while (parentTag != null) {
                for (String attrName : attrNames) {
                    ThymesElExpression thymesElExpression;
                    XmlAttribute attribute = ThymeleafCommonUtil.getAttribute(attrName, parentTag);
                    if (attribute == null || (thymesElExpression = ThymeleafCommonUtil.getAttributeExpression(attribute, ThymesElExpression.class)) == null || processor.process((Object)thymesElExpression)) continue;
                    return;
                }
                parentTag = parentTag.getParentTag();
            }
        }
    }

    @Nullable
    public static XmlAttribute getContextAttribute(@NotNull PsiElement expression) {
        PsiElement context;
        PsiFile containingFile;
        if (expression == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(21);
        }
        if ((containingFile = expression.getContainingFile()) != null && (context = containingFile.getContext()) != null) {
            return (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)context, XmlAttribute.class);
        }
        return null;
    }

    private static String getLocalName(@NotNull XmlAttribute contextAttribute) {
        String attrNameHtml5;
        if (contextAttribute == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(22);
        }
        return (attrNameHtml5 = ThymeleafExpressionsInjector.getThymeleafAttrNameHtml5(contextAttribute)) != null ? attrNameHtml5 : contextAttribute.getLocalName();
    }

    @Nullable
    public static XmlAttribute getAttribute(@NotNull String attrName, @NotNull XmlTag xmlTag) {
        XmlAttribute attribute;
        if (attrName == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(23);
        }
        if (xmlTag == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(24);
        }
        if ((attribute = ThymeleafCommonUtil.findThymeleafAttribute(xmlTag, attrName)) != null) {
            return attribute;
        }
        String prefixByNamespace = ThymeleafCommonUtil.getPrefixByThymeleafNamespace(xmlTag);
        if (prefixByNamespace != null) {
            return xmlTag.getAttribute("data-" + prefixByNamespace + "-" + attrName);
        }
        return null;
    }

    @Nullable
    public static <T> T getAttributeExpression(@NotNull XmlAttribute attribute, Class<T> expressionOfType) {
        if (attribute == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(25);
        }
        Ref ref = Ref.create();
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)attribute.getProject());
        XmlAttributeValue valueElement = attribute.getValueElement();
        if (valueElement != null) {
            manager.enumerate((PsiElement)valueElement, (injectedPsi, places) -> {
                if (injectedPsi.getFileType() instanceof ThymeleafExpressionsFileType) {
                    PsiElement[] children;
                    for (PsiElement child : children = injectedPsi.getChildren()) {
                        if (!expressionOfType.isInstance(child)) continue;
                        ref.set((Object)child);
                        break;
                    }
                }
            });
        }
        return (T)ref.get();
    }

    @NotNull
    public static List<String> findIncludedTemplates(@NotNull XmlFile templateFile) {
        if (templateFile == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(26);
        }
        ArrayList<String> files = new ArrayList<String>();
        for (ThymesTemplateSelectionExpression expression : ThymeleafCommonUtil.collectTemplateSelections(templateFile)) {
            for (ThymesElExpression elExpression : expression.getElExpressionList()) {
                String nameText;
                ThymesTemplateName templateName;
                if (!(elExpression instanceof ThymesTemplateNameSelectorExpression) || (templateName = ThymeleafCommonUtil.getTemplateNameReference(((ThymesTemplateNameSelectorExpression)elExpression).getPathTemplateSelector())) == null || !StringUtil.isNotEmpty((String)(nameText = templateName.getText()))) continue;
                files.add(nameText);
            }
        }
        ArrayList<String> arrayList = files;
        if (arrayList == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(27);
        }
        return arrayList;
    }

    @Nullable
    private static ThymesTemplateName getTemplateNameReference(@Nullable ThymesPathTemplateSelector templateSelector) {
        if (templateSelector == null) {
            return null;
        }
        List<ThymesTemplateName> templateNameList = templateSelector.getTemplateNameList();
        if (templateNameList.size() > 0) {
            return templateNameList.get(templateNameList.size() - 1);
        }
        return null;
    }

    @NotNull
    private static List<ThymesTemplateSelectionExpression> collectTemplateSelections(@NotNull XmlFile templateFile) {
        if (templateFile == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(28);
        }
        final ArrayList<ThymesTemplateSelectionExpression> templateSelectExpressions = new ArrayList<ThymesTemplateSelectionExpression>();
        templateFile.acceptChildren((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
                if (attribute == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (1.isThymeleafTemplateSelectAttribute(attribute, "include") || 1.isThymeleafTemplateSelectAttribute(attribute, "replace") || 1.isThymeleafTemplateSelectAttribute(attribute, "insert")) {
                    ContainerUtil.addIfNotNull((Collection)templateSelectExpressions, (Object)ThymeleafCommonUtil.getAttributeExpression(attribute, ThymesTemplateSelectionExpression.class));
                }
            }

            private static boolean isThymeleafTemplateSelectAttribute(XmlAttribute attribute, String inclusionType) {
                String localName = attribute.getLocalName();
                return (localName.equals(inclusionType) || localName.endsWith("-" + inclusionType)) && inclusionType.equals(ThymeleafExpressionsInjector.getThymeleafAttrName(attribute));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil$1", "visitXmlAttribute"));
            }
        });
        ArrayList<ThymesTemplateSelectionExpression> arrayList = templateSelectExpressions;
        if (arrayList == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    @Nullable
    public static String getPrefixByThymeleafNamespace(@NotNull XmlTag tag) {
        if (tag == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(30);
        }
        for (String uri : ThymeleafCommonUtil.getThymeleafNamespaces(tag.getProject())) {
            String prefixByNamespace = tag.getPrefixByNamespace(uri);
            if (prefixByNamespace == null) continue;
            return prefixByNamespace;
        }
        return ThymeleafCommonUtil.getDefaultPrefixIfThymeleafPrologDefined(tag);
    }

    @Nullable
    private static String getDefaultPrefixIfThymeleafPrologDefined(XmlTag tag) {
        XmlProlog prolog;
        XmlDocument document;
        PsiFile file = tag.getContainingFile();
        if (file instanceof XmlFile && (document = ((XmlFile)file).getDocument()) != null && (prolog = document.getProlog()) != null && prolog.getText().contains("www.thymeleaf.org")) {
            return "th";
        }
        return null;
    }

    @Nullable
    public static String getPrefixByThymeleafNamespace(@NotNull XmlTag tag, String ... uris) {
        if (tag == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(31);
        }
        if (uris == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(32);
        }
        for (String uri : uris) {
            String prefixByNamespace = tag.getPrefixByNamespace(uri);
            if (prefixByNamespace == null) continue;
            return prefixByNamespace;
        }
        return null;
    }

    public static boolean isThymeleafPrefix(XmlTag context, String prefixByQualifiedName) {
        String namespaceByPrefix = context.getNamespaceByPrefix(prefixByQualifiedName);
        return ThymeleafCommonUtil.isThymeleafNamespace(namespaceByPrefix, context.getProject()) || "th".equals(prefixByQualifiedName) && StringUtil.isEmptyOrSpaces((String)namespaceByPrefix) && ThymeleafCommonUtil.hasThymeleafLibrary(context.getProject());
    }

    public static boolean isThymeleafNamespace(@NotNull String ns, @Nullable Project project) {
        if (ns == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(33);
        }
        if (project != null && !DumbService.isDumb((Project)project)) {
            for (String uri : ThymeleafCommonUtil.getThymeleafNamespaces(project)) {
                if (!uri.equals(ns)) continue;
                return true;
            }
        }
        return ThymeleafDialects.getImplicitNamespaces().contains(ns);
    }

    @Nullable
    public static XmlAttribute findThymeleafAttribute(@NotNull XmlTag tag, @NotNull String attrName) {
        XmlAttribute attribute;
        if (tag == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(34);
        }
        if (attrName == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(35);
        }
        if ((attribute = ThymeleafCommonUtil.findThymeleafAttribute(tag, attrName, ThymeleafNamespaceConstants.THYMELEAF_URIS)) != null) {
            return attribute;
        }
        return ThymeleafCommonUtil.findDefaultNamespaceAttribute(tag, attrName);
    }

    @Nullable
    public static XmlAttribute findThymeleafAttribute(@NotNull XmlTag tag, @NotNull String attrName, String ... uris) {
        if (tag == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(36);
        }
        if (attrName == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(37);
        }
        for (String uri : uris) {
            XmlAttribute attribute = tag.getAttribute(attrName, uri);
            if (attribute == null) continue;
            return attribute;
        }
        return null;
    }

    @Nullable
    private static XmlAttribute findDefaultNamespaceAttribute(@NotNull XmlTag tag, @NotNull String attrName) {
        XmlAttribute xmlAttribute;
        if (tag == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(38);
        }
        if (attrName == null) {
            ThymeleafCommonUtil.$$$reportNull$$$0(39);
        }
        if ((xmlAttribute = tag.getAttribute("th:" + attrName)) != null) {
            return xmlAttribute;
        }
        return tag.getAttribute("data-th-" + attrName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 14, 27, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 14: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrNames";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 23: 
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrName";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextAttribute";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlTag";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFile";
                break;
            }
            case 30: 
            case 31: 
            case 34: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uris";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/lang/support/utils/ThymeleafCommonUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getThymeleafNamespaces";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllParentTagExpressions";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "findIncludedTemplates";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTemplateSelections";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getThymeleafNamespaces";
                break;
            }
            case 1: 
            case 14: 
            case 27: 
            case 29: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findObjectExpression";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findEachExpressions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFragmentExpression";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFirstParentTagsExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findWithExpressions";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findParentTagExpression";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findAllParentTagExpressions";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processParentTagExpressions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getContextAttribute";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getLocalName";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAttribute";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeExpression";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findIncludedTemplates";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "collectTemplateSelections";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixByThymeleafNamespace";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isThymeleafNamespace";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findThymeleafAttribute";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findDefaultNamespaceAttribute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 14, 27, 29 -> new IllegalStateException(string);
        };
    }
}

