/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang.support.utils;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.thymeleaf.lang.psi.ThymeleafReference;
import com.intellij.thymeleaf.lang.psi.ThymesELMethodCallExpression;
import com.intellij.thymeleaf.lang.psi.ThymesELMultiSelectExpression;
import com.intellij.thymeleaf.lang.psi.ThymesELSelectExpression;
import com.intellij.thymeleaf.lang.psi.ThymesELVariable;
import com.intellij.thymeleaf.lang.psi.ThymesElExpression;
import com.intellij.thymeleaf.lang.psi.ThymesElStaticMemberSelectExpression;
import com.intellij.thymeleaf.lang.psi.ThymesOgnlExpression;
import com.intellij.thymeleaf.lang.psi.ThymesOgnlPreprocessingExpression;
import com.intellij.thymeleaf.lang.psi.ThymesSelectionsExpression;
import com.intellij.thymeleaf.lang.support.ThymeleafContextVariablesProvider;
import com.intellij.thymeleaf.lang.support.ThymeleafElementProcessor;
import com.intellij.thymeleaf.lang.support.beans.ThymeleafExpressionVariable;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafCommonUtil;
import java.util.Arrays;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ThymeleafResolveUtil {
    public static void processReference(@NotNull ThymeleafReference reference, @NotNull ThymeleafElementProcessor processor) {
        PsiElement element;
        ThymesElExpression context;
        if (reference == null) {
            ThymeleafResolveUtil.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            ThymeleafResolveUtil.$$$reportNull$$$0(1);
        }
        if ((context = ThymeleafResolveUtil.getContextElement(element = reference.getElement())) == null || context == element || ThymeleafResolveUtil.isVariableMap(context) || ThymeleafResolveUtil.isIContext(context)) {
            for (ThymeleafContextVariablesProvider provider : ThymeleafContextVariablesProvider.EP_NAME.getExtensionList()) {
                PsiMethod psiMethod;
                for (PsiVariable psiVariable : provider.getContextVariables(element)) {
                    if (!processor.processVariable(psiVariable, PsiSubstitutor.EMPTY)) break;
                }
                Iterator<? extends PsiVariable> iterator = provider.getContextMethods(element).iterator();
                while (iterator.hasNext() && processor.processMethod(psiMethod = (PsiMethod)iterator.next(), PsiSubstitutor.EMPTY)) {
                }
            }
            ThymeleafResolveUtil.processDefaultPackages(processor, element);
        } else {
            ThymeleafResolveUtil.processDeclarations(processor, context, element);
        }
    }

    private static boolean processDefaultPackages(@NotNull ThymeleafElementProcessor processor, @Nullable PsiElement element) {
        if (processor == null) {
            ThymeleafResolveUtil.$$$reportNull$$$0(2);
        }
        if (element == null) {
            return true;
        }
        GlobalSearchScope scope = ThymeleafResolveUtil.getResolveScope(element);
        if (!ThymeleafResolveUtil.processPackage(processor, JavaPsiFacade.getInstance((Project)element.getProject()).findPackage(""), scope)) {
            return false;
        }
        return ThymeleafResolveUtil.processPackage(processor, JavaPsiFacade.getInstance((Project)element.getProject()).findPackage("java.lang"), scope);
    }

    @NotNull
    private static GlobalSearchScope getResolveScope(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            ThymeleafResolveUtil.$$$reportNull$$$0(3);
        }
        GlobalSearchScope globalSearchScope = (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module) : GlobalSearchScope.allScope((Project)element.getProject());
        if (globalSearchScope == null) {
            ThymeleafResolveUtil.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    private static boolean processPackage(@NotNull ThymeleafElementProcessor processor, @Nullable PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (processor == null) {
            ThymeleafResolveUtil.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            ThymeleafResolveUtil.$$$reportNull$$$0(6);
        }
        if (psiPackage != null) {
            for (PsiPackage psiPackage2 : psiPackage.getSubPackages(scope)) {
                if (processor.processPackage(psiPackage2)) continue;
                return false;
            }
            for (PsiPackage psiPackage3 : psiPackage.getClasses(scope)) {
                if (processor.processClass((PsiClass)psiPackage3)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isVariableMap(@NotNull ThymesElExpression context) {
        PsiType contextType;
        if (context == null) {
            ThymeleafResolveUtil.$$$reportNull$$$0(7);
        }
        if ((contextType = context.getType()) instanceof PsiClassType && contextType.isValid()) {
            return InheritanceUtil.isInheritor((PsiType)contextType, (String)"org.thymeleaf.context.VariablesMap");
        }
        return false;
    }

    private static boolean isIContext(@NotNull ThymesElExpression context) {
        PsiType contextType;
        if (context == null) {
            ThymeleafResolveUtil.$$$reportNull$$$0(8);
        }
        return (contextType = context.getType()) != null && contextType.isValid() && "org.thymeleaf.context.IContext".equals(contextType.getCanonicalText());
    }

    private static boolean processDeclarations(@NotNull ThymeleafElementProcessor processor, @NotNull ThymesElExpression context, @NotNull PsiElement element) {
        if (processor == null) {
            ThymeleafResolveUtil.$$$reportNull$$$0(9);
        }
        if (context == null) {
            ThymeleafResolveUtil.$$$reportNull$$$0(10);
        }
        if (element == null) {
            ThymeleafResolveUtil.$$$reportNull$$$0(11);
        }
        for (PsiReference ref : context.getReferences()) {
            if (!(ref instanceof ThymeleafReference)) continue;
            ResolveResult[] resolveResultArray = ((ThymeleafReference)ref).multiResolve(false);
            int n = resolveResultArray.length;
            for (int i = 0; i < n; ++i) {
                ResolveResult result = resolveResultArray[i];
                PsiElement resolve = result.getElement();
                if (!(resolve instanceof ThymeleafExpressionVariable ? !((ThymeleafExpressionVariable)resolve).processDeclarations(processor) : resolve instanceof PsiPackage && !ThymeleafResolveUtil.processPackage(processor, (PsiPackage)resolve, ThymeleafResolveUtil.getResolveScope(element)))) continue;
                return false;
            }
        }
        PsiType contextType = context.getType();
        PsiClass psiClass = ThymeleafResolveUtil.getContextClass(contextType, element);
        if (psiClass != null && psiClass.isValid()) {
            PsiSubstitutor substitutor = ThymeleafResolveUtil.getSubstitutor(contextType);
            for (PsiMethod psiMethod : psiClass.getAllMethods()) {
                PsiClass containingClass = psiMethod.getContainingClass();
                if (containingClass != null && "java.lang.Object".equals(containingClass.getQualifiedName()) || psiMethod.isConstructor() || !psiMethod.hasModifierProperty("public") || processor.processMethod(psiMethod, substitutor)) continue;
                return false;
            }
            for (PsiMethod psiMethod : psiClass.getAllFields()) {
                PsiModifierList modifierList = psiMethod.getModifierList();
                if (modifierList == null || !modifierList.hasModifierProperty("public") || processor.processVariable((PsiVariable)psiMethod, substitutor)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static PsiSubstitutor getSubstitutor(PsiType contextType) {
        if (contextType instanceof PsiClassType) {
            PsiSubstitutor psiSubstitutor = ((PsiClassType)contextType).resolveGenerics().getSubstitutor();
            if (psiSubstitutor == null) {
                ThymeleafResolveUtil.$$$reportNull$$$0(12);
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
        if (psiSubstitutor == null) {
            ThymeleafResolveUtil.$$$reportNull$$$0(13);
        }
        return psiSubstitutor;
    }

    @Nullable
    private static PsiClass getContextClass(@Nullable PsiType type, @NotNull PsiElement psiElement) {
        if (psiElement == null) {
            ThymeleafResolveUtil.$$$reportNull$$$0(14);
        }
        if (type == null || !type.isValid()) {
            return null;
        }
        if (type instanceof PsiWildcardType) {
            type = ((PsiWildcardType)type).getExtendsBound();
        }
        if (psiElement.getParent() instanceof ThymesELMultiSelectExpression) {
            PsiType itType = null;
            if (type instanceof PsiClassType) {
                itType = PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.Collection", (int)0, (boolean)false);
            } else if (type instanceof PsiArrayType) {
                itType = ((PsiArrayType)type).getComponentType();
            }
            if (itType instanceof PsiClassType) {
                return ((PsiClassType)itType).resolve();
            }
        }
        if (type instanceof PsiClassType) {
            return ((PsiClassType)type).resolve();
        }
        return null;
    }

    @Nullable
    private static ThymesElExpression getContextElement(@Nullable PsiElement psiElement) {
        PsiElement grandParent;
        if (psiElement == null || ThymeleafResolveUtil.isExpressionUtilVariable(psiElement)) {
            return null;
        }
        PsiElement parent = psiElement.getParent();
        if (parent instanceof ThymesELSelectExpression && ((ThymesELSelectExpression)parent).getField() == psiElement) {
            return ThymeleafResolveUtil.getContextSelectExpression((ThymesELSelectExpression)parent);
        }
        if (psiElement instanceof ThymesELSelectExpression) {
            return ((ThymesELSelectExpression)psiElement).getField();
        }
        if (parent instanceof ThymesElStaticMemberSelectExpression) {
            return ((ThymesElStaticMemberSelectExpression)parent).getElStaticSelection().getElExpression();
        }
        if (parent instanceof ThymesELMethodCallExpression && (grandParent = parent.getParent()) instanceof ThymesElStaticMemberSelectExpression) {
            return ((ThymesElStaticMemberSelectExpression)grandParent).getElStaticSelection().getElExpression();
        }
        if (psiElement instanceof ThymesSelectionsExpression) {
            ThymesElExpression thymesElExpression = ThymeleafCommonUtil.findObjectExpression(psiElement);
            if (thymesElExpression instanceof ThymesOgnlExpression) {
                ThymesElExpression expression = ((ThymesOgnlExpression)thymesElExpression).getElExpression();
                return expression instanceof ThymesELVariable ? expression : ThymeleafResolveUtil.getContextElement(expression);
            }
            if (thymesElExpression instanceof ThymesSelectionsExpression) {
                ThymesElExpression expression = ((ThymesSelectionsExpression)thymesElExpression).getElExpression();
                return expression instanceof ThymesELVariable ? expression : ThymeleafResolveUtil.getContextElement(expression);
            }
        }
        if (parent instanceof ThymesELMultiSelectExpression) {
            return ThymeleafResolveUtil.getContextElement(parent);
        }
        ThymesSelectionsExpression expression = (ThymesSelectionsExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, ThymesSelectionsExpression.class, (boolean)true, (Class[])new Class[]{ThymesOgnlExpression.class, ThymesOgnlPreprocessingExpression.class});
        if (expression != null) {
            return ThymeleafResolveUtil.getContextElement(expression);
        }
        return null;
    }

    @Nullable
    private static ThymesElExpression getContextSelectExpression(@NotNull ThymesELSelectExpression psiElement) {
        ThymesElExpression from;
        if (psiElement == null) {
            ThymeleafResolveUtil.$$$reportNull$$$0(15);
        }
        return (from = psiElement.getFrom()) instanceof ThymesELSelectExpression ? ((ThymesELSelectExpression)from).getField() : from;
    }

    private static boolean isExpressionUtilVariable(PsiElement element) {
        return element instanceof ThymesELVariable && element.getText().startsWith("#");
    }

    public static GlobalSearchScope getThymeleafFilesScope(@NotNull Project project, @NotNull GlobalSearchScope effectiveSearchScope) {
        if (project == null) {
            ThymeleafResolveUtil.$$$reportNull$$$0(16);
        }
        if (effectiveSearchScope == null) {
            ThymeleafResolveUtil.$$$reportNull$$$0(17);
        }
        GlobalSearchScope types = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)effectiveSearchScope, (FileType[])new FileType[]{XmlFileType.INSTANCE, XHtmlFileType.INSTANCE, HtmlFileType.INSTANCE});
        return (GlobalSearchScope)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> {
            CacheManager cacheManager = CacheManager.getInstance((Project)project);
            VirtualFile[] files = cacheManager.getVirtualFilesWithWord("thymeleaf", (short)255, types, true);
            return GlobalSearchScope.filesScope((Project)project, Arrays.asList(files));
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/lang/support/utils/ThymeleafResolveUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "effectiveSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/lang/support/utils/ThymeleafResolveUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processReference";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processDefaultPackages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScope";
                break;
            }
            case 4: 
            case 12: 
            case 13: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processPackage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isVariableMap";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isIContext";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getContextClass";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getContextSelectExpression";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getThymeleafFilesScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 12, 13 -> new IllegalStateException(string);
        };
    }
}

