/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.references.paths;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.thymeleaf.references.paths.ThymeleafViewResolverHelper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Plow;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;

public class ThymeleafTemplateResolverMethodsSearchHelper
extends ThymeleafViewResolverHelper {
    @Override
    @NotNull
    public Set<String> getTemplateResolverPrefixes(@NotNull Module module) {
        if (module == null) {
            ThymeleafTemplateResolverMethodsSearchHelper.$$$reportNull$$$0(0);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesScope((Module)module);
            PsiClass aClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("org.thymeleaf.templateresolver.TemplateResolver", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
            return CachedValueProvider.Result.create(ThymeleafTemplateResolverMethodsSearchHelper.getTemplateResolverPrefixes(aClass, (SearchScope)scope), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (set == null) {
            ThymeleafTemplateResolverMethodsSearchHelper.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public static Set<String> getTemplateResolverPrefixes(@Nullable PsiClass resolverClass, @NotNull SearchScope scope) {
        if (scope == null) {
            ThymeleafTemplateResolverMethodsSearchHelper.$$$reportNull$$$0(2);
        }
        return ThymeleafTemplateResolverMethodsSearchHelper.getTemplateResolverPrefixes(resolverClass, "setPrefix", scope);
    }

    @NotNull
    public static Set<String> getTemplateResolverPrefixes(@Nullable PsiClass resolverClass, @NotNull String methodName, @NotNull SearchScope scope) {
        if (methodName == null) {
            ThymeleafTemplateResolverMethodsSearchHelper.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            ThymeleafTemplateResolverMethodsSearchHelper.$$$reportNull$$$0(4);
        }
        Set<Pair<PsiElement, String>> expressions = ThymeleafTemplateResolverMethodsSearchHelper.getTemplateResolverPrefixExpressions(resolverClass, methodName, scope);
        Set set = expressions.stream().filter(pair -> StringUtil.isNotEmpty((String)((String)pair.second))).map(pair -> (String)pair.second).collect(Collectors.toCollection(HashSet::new));
        if (set == null) {
            ThymeleafTemplateResolverMethodsSearchHelper.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public static Set<Pair<PsiElement, String>> getTemplateResolverPrefixExpressions(@Nullable PsiClass resolverClass, @NotNull String methodName, @NotNull SearchScope scope) {
        PsiMethod[] methods;
        if (methodName == null) {
            ThymeleafTemplateResolverMethodsSearchHelper.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            ThymeleafTemplateResolverMethodsSearchHelper.$$$reportNull$$$0(7);
        }
        if (resolverClass != null && (methods = resolverClass.findMethodsByName(methodName, false)).length == 1) {
            Set set = Plow.of(processor -> MethodReferencesSearch.search((PsiMethod)methods[0], (SearchScope)scope, (boolean)false).forEach(processor)).mapNotNull(reference -> {
                PsiElement element = reference.getElement();
                UExpression callExpression = (UExpression)UastUtils.findAnyContaining((PsiElement)element, (int)3, (Class[])new Class[]{UCallExpression.class, UBinaryExpression.class});
                if (callExpression == null) {
                    return null;
                }
                String argument = null;
                if (callExpression instanceof UCallExpression) {
                    argument = (String)ObjectUtils.doIfNotNull((Object)((UCallExpression)callExpression).getArgumentForParameter(0), UastUtils::evaluateString);
                } else if (callExpression instanceof UBinaryExpression) {
                    argument = (String)ObjectUtils.doIfNotNull((Object)((UBinaryExpression)callExpression).getRightOperand(), UastUtils::evaluateString);
                }
                if (argument == null) {
                    return null;
                }
                return Pair.create((Object)element, (Object)argument);
            }).toSet();
            if (set == null) {
                ThymeleafTemplateResolverMethodsSearchHelper.$$$reportNull$$$0(8);
            }
            return set;
        }
        Set<Pair<PsiElement, String>> set = Collections.emptySet();
        if (set == null) {
            ThymeleafTemplateResolverMethodsSearchHelper.$$$reportNull$$$0(9);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/thymeleaf/references/paths/ThymeleafTemplateResolverMethodsSearchHelper";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/thymeleaf/references/paths/ThymeleafTemplateResolverMethodsSearchHelper";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateResolverPrefixes";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateResolverPrefixExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateResolverPrefixes";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateResolverPrefixExpressions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 8, 9 -> new IllegalStateException(string);
        };
    }
}

