/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.frontend.codeInsight.highlighting;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.ide.model.highlighterRegistration.TextAttributesKeyModel;
import com.jetbrains.rd.ide.model.DefaultLineMarkerRendererModel;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.ide.model.LineMarkerHighlighterModel;
import com.jetbrains.rd.ide.model.LineMarkerRendererModel;
import com.jetbrains.rdclient.daemon.FrontendHighlighterSuppressionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.lexer.KtTokens;

public class KotlinBraceHighlightingSuppressionHandler
implements FrontendHighlighterSuppressionHandler {
    public boolean shouldSuppress(@NotNull HighlighterModel highlighterModel, @NotNull Document document) {
        VirtualFile file;
        if (highlighterModel == null) {
            KotlinBraceHighlightingSuppressionHandler.$$$reportNull$$$0(0);
        }
        if (document == null) {
            KotlinBraceHighlightingSuppressionHandler.$$$reportNull$$$0(1);
        }
        if ((file = FileDocumentManager.getInstance().getFile(document)) == null) {
            return false;
        }
        if (file.getFileType() != KotlinFileType.INSTANCE) {
            return false;
        }
        return KotlinBraceHighlightingSuppressionHandler.isLineMarker(highlighterModel, file) || KotlinBraceHighlightingSuppressionHandler.isBraceHighlighting(highlighterModel, file);
    }

    private static boolean isBraceHighlighting(@NotNull HighlighterModel highlighterModel, @NotNull VirtualFile file) {
        TextAttributesKeyModel attributesKey;
        if (highlighterModel == null) {
            KotlinBraceHighlightingSuppressionHandler.$$$reportNull$$$0(2);
        }
        if (file == null) {
            KotlinBraceHighlightingSuppressionHandler.$$$reportNull$$$0(3);
        }
        if ((attributesKey = highlighterModel.getTextAttributesKey()) == null) {
            return false;
        }
        PsiFile psiFile = KotlinBraceHighlightingSuppressionHandler.findPsiFile(file);
        if (psiFile == null) {
            return false;
        }
        if (highlighterModel.getEnd() - highlighterModel.getStart() != 1) {
            return false;
        }
        PsiElement element = psiFile.findElementAt(highlighterModel.getStart());
        if (element == null || element.getNode() == null) {
            return false;
        }
        IElementType elementType = element.getNode().getElementType();
        return KotlinBraceHighlightingSuppressionHandler.isAnyBraces(elementType);
    }

    private static boolean isAnyBraces(@Nullable IElementType elementType) {
        return elementType == KtTokens.RBRACE || elementType == KtTokens.LBRACE || elementType == KtTokens.RBRACKET || elementType == KtTokens.LBRACKET || elementType == KtTokens.RPAR || elementType == KtTokens.LPAR;
    }

    @Nullable
    private static PsiFile findPsiFile(@NotNull VirtualFile file) {
        Project currentProject;
        if (file == null) {
            KotlinBraceHighlightingSuppressionHandler.$$$reportNull$$$0(4);
        }
        if ((currentProject = KotlinBraceHighlightingSuppressionHandler.findProject(file)) == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)currentProject).findFile(file);
        if (psiFile == null) {
            return null;
        }
        return psiFile;
    }

    @Nullable
    private static Project findProject(@NotNull VirtualFile file) {
        if (file == null) {
            KotlinBraceHighlightingSuppressionHandler.$$$reportNull$$$0(5);
        }
        Project currentProject = null;
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            FileEditor[] editors = FileEditorManager.getInstance((Project)project).getEditors(file);
            if (editors.length == 0) continue;
            currentProject = project;
            break;
        }
        if (currentProject == null) {
            return null;
        }
        return currentProject;
    }

    private static boolean isLineMarker(@NotNull HighlighterModel model, @NotNull VirtualFile file) {
        if (model == null) {
            KotlinBraceHighlightingSuppressionHandler.$$$reportNull$$$0(6);
        }
        if (file == null) {
            KotlinBraceHighlightingSuppressionHandler.$$$reportNull$$$0(7);
        }
        if (!(model instanceof LineMarkerHighlighterModel)) {
            return false;
        }
        LineMarkerHighlighterModel lineMarkerHighlighterModel = (LineMarkerHighlighterModel)model;
        LineMarkerRendererModel renderer = lineMarkerHighlighterModel.getRenderer();
        if (!(renderer instanceof DefaultLineMarkerRendererModel)) {
            return false;
        }
        DefaultLineMarkerRendererModel defaultLineMarkerRendererModel = (DefaultLineMarkerRendererModel)renderer;
        TextAttributesKeyModel attributesKey = defaultLineMarkerRendererModel.getRendererTextAttributesKey();
        if (attributesKey == null) {
            return false;
        }
        if (!CodeInsightColors.MATCHED_BRACE_ATTRIBUTES.getExternalName().equals(attributesKey.getExternalName()) && !CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES.getExternalName().equals(attributesKey.getExternalName())) {
            return false;
        }
        PsiFile psiFile = KotlinBraceHighlightingSuppressionHandler.findPsiFile(file);
        return psiFile != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighterModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/frontend/codeInsight/highlighting/KotlinBraceHighlightingSuppressionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldSuppress";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isBraceHighlighting";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findPsiFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findProject";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isLineMarker";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

