/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.async;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.target.RunTargetsEnabled;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfigurations;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.profiler.ultimate.NewProcessStartedOnTargetCommunicator;
import com.intellij.profiler.ultimate.NewProcessStartedWithProfilerCommunicator;
import com.intellij.profiler.ultimate.ProfilerProcessCommunicator;
import com.intellij.profiler.ultimate.async.UtilsKt;
import com.intellij.profiler.ultimate.async.configurations.AsyncProfilerConfigurationStateBase;
import com.intellij.profiler.ultimate.async.extractor.AsyncProfilerExtractor;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openjdk.jmc.common.IMCFrame;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\b\u001a\u00020\tH\u0000\u001a\u001c\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a2\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0010\b\u0002\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u001cH\u0000\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\u00a8\u0006\u001e"}, d2={"FRAME_TYPE_NATIVE", "", "getFRAME_TYPE_NATIVE", "()Ljava/lang/String;", "FRAME_TYPE_CPP", "getFRAME_TYPE_CPP", "FRAME_TYPE_KERNEL", "getFRAME_TYPE_KERNEL", "dtraceProfilerAvailable", "", "getNativeAgentPath", "settings", "Lcom/intellij/profiler/ultimate/async/configurations/AsyncProfilerConfigurationStateBase;", "platform", "Lcom/intellij/execution/Platform;", "tryToHandleSpacesInAgentPath", "path", "willRunOnTarget", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "isProjectUnderWsl", "doCreateProfilerCommunicator", "Lcom/intellij/profiler/ultimate/ProfilerProcessCommunicator;", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "handler", "Lcom/intellij/execution/process/OSProcessHandler;", "targetEnvironmentProvider", "Lkotlin/Function0;", "Lcom/intellij/execution/target/TargetEnvironment;", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/intellij/profiler/ultimate/async/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final String FRAME_TYPE_NATIVE = IMCFrame.Type.NATIVE.toString();
    @NotNull
    private static final String FRAME_TYPE_CPP = IMCFrame.Type.CPP.toString();
    @NotNull
    private static final String FRAME_TYPE_KERNEL = IMCFrame.Type.KERNEL.toString();

    @NotNull
    public static final String getFRAME_TYPE_NATIVE() {
        return FRAME_TYPE_NATIVE;
    }

    @NotNull
    public static final String getFRAME_TYPE_CPP() {
        return FRAME_TYPE_CPP;
    }

    @NotNull
    public static final String getFRAME_TYPE_KERNEL() {
        return FRAME_TYPE_KERNEL;
    }

    public static final boolean dtraceProfilerAvailable() {
        return SystemInfo.isMac && Registry.Companion.is("idea.profiler.jvm.dtrace", false);
    }

    @NotNull
    public static final String getNativeAgentPath(@NotNull AsyncProfilerConfigurationStateBase settings, @Nullable Platform platform) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        String string = settings.getAgentPath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            if (((CharSequence)it).length() > 0) {
                return it;
            }
        }
        return AsyncProfilerExtractor.INSTANCE.getNativeAgentPath(platform);
    }

    public static /* synthetic */ String getNativeAgentPath$default(AsyncProfilerConfigurationStateBase asyncProfilerConfigurationStateBase, Platform platform, int n, Object object) {
        if ((n & 2) != 0) {
            platform = null;
        }
        return UtilsKt.getNativeAgentPath(asyncProfilerConfigurationStateBase, platform);
    }

    @NotNull
    public static final String tryToHandleSpacesInAgentPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String absolutePath = new File(path).getAbsolutePath();
        String string = JavaExecutionUtil.handleSpacesInAgentPath((String)absolutePath, (String)"asyncProfiler", null);
        if (string == null) {
            Intrinsics.checkNotNull((Object)absolutePath);
            string = absolutePath;
        }
        return string;
    }

    public static final boolean willRunOnTarget(@NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return RunTargetsEnabled.get() && profile instanceof TargetEnvironmentAwareRunProfile && (TargetEnvironmentConfigurations.getEffectiveTargetName$default((TargetEnvironmentAwareRunProfile)((TargetEnvironmentAwareRunProfile)profile), null, (int)1, null) != null || UtilsKt.isProjectUnderWsl(profile));
    }

    private static final boolean isProjectUnderWsl(RunProfile profile) {
        RunConfigurationBase runConfigurationBase = profile instanceof RunConfigurationBase ? (RunConfigurationBase)profile : null;
        if (runConfigurationBase == null || (runConfigurationBase = runConfigurationBase.getProject()) == null) {
            return false;
        }
        RunConfigurationBase project = runConfigurationBase;
        Object object = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (object == null || (object = object.getHomePath()) == null) {
            return false;
        }
        Object projectSdkHomePath = object;
        return WslPath.Companion.isWslUncPath((String)projectSdkHomePath);
    }

    @NotNull
    public static final ProfilerProcessCommunicator<?> doCreateProfilerCommunicator(@NotNull RunConfigurationBase<?> runConfiguration, @NotNull OSProcessHandler handler, @NotNull Function0<? extends TargetEnvironment> targetEnvironmentProvider) {
        Intrinsics.checkNotNullParameter(runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter(targetEnvironmentProvider, (String)"targetEnvironmentProvider");
        if (UtilsKt.willRunOnTarget((RunProfile)runConfiguration)) {
            String string = runConfiguration.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return new NewProcessStartedOnTargetCommunicator(string, targetEnvironmentProvider, (BaseOSProcessHandler)handler);
        }
        String string = runConfiguration.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new NewProcessStartedWithProfilerCommunicator(string, (BaseOSProcessHandler)handler);
    }

    public static /* synthetic */ ProfilerProcessCommunicator doCreateProfilerCommunicator$default(RunConfigurationBase runConfigurationBase, OSProcessHandler oSProcessHandler, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            function0 = doCreateProfilerCommunicator.1.INSTANCE;
        }
        return UtilsKt.doCreateProfilerCommunicator(runConfigurationBase, oSProcessHandler, (Function0<? extends TargetEnvironment>)function0);
    }
}

