/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof;

import com.intellij.diagnostic.hprof.parser.HProfVisitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Disposer;
import com.intellij.profiler.api.ProfilerData;
import com.intellij.profiler.api.ProfilerDumpFileParser;
import com.intellij.profiler.api.ProfilerDumpFileParsingResult;
import com.intellij.profiler.api.Success;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.hprof.HprofProfilerData;
import com.intellij.profiler.ultimate.hprof.impl.HprofDump;
import com.intellij.profiler.ultimate.hprof.ui.ProgressBarWatcherVisitor;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/profiler/ultimate/hprof/HprofFileParser;", "Lcom/intellij/profiler/api/ProfilerDumpFileParser;", "<init>", "()V", "parse", "Lcom/intellij/profiler/api/ProfilerDumpFileParsingResult;", "file", "Ljava/io/File;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "helpId", "", "getHelpId", "()Ljava/lang/String;", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nHProfDumpParserProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HProfDumpParserProvider.kt\ncom/intellij/profiler/ultimate/hprof/HprofFileParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,115:1\n1#2:116\n18817#3,2:117\n14#4:119\n*S KotlinDebug\n*F\n+ 1 HProfDumpParserProvider.kt\ncom/intellij/profiler/ultimate/hprof/HprofFileParser\n*L\n56#1:117,2\n67#1:119\n*E\n"})
final class HprofFileParser
implements ProfilerDumpFileParser {
    @NotNull
    private final String helpId;

    public HprofFileParser() {
        this.helpId = "profiler.hprof";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ProfilerDumpFileParsingResult parse(@NotNull File file, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Path path = file.toPath();
        Intrinsics.checkNotNull((Object)path);
        HprofDump hprof = new HprofDump(path);
        indicator.setIndeterminate(false);
        indicator.setText(UltimateProfilerBundleKt.profilerMessage("hprof.status.parse", new Object[0]));
        try {
            Object[] headers;
            Object[] objectArray = new String[]{"JAVA PROFILE 1.0.2", "JAVA PROFILE 1.0.1"};
            Object object = headers = objectArray;
            if (((String[])object).length == 0) {
                throw new NoSuchElementException();
            }
            String it = object[0];
            int n = 0;
            int n2 = it.length();
            n = 1;
            int n3 = ArraysKt.getLastIndex((Object[])object);
            if (n <= n3) {
                while (true) {
                    Object it22 = object[n];
                    boolean bl3 = false;
                    int it22 = ((String)it22).length();
                    if (n2 < it22) {
                        n2 = it22;
                    }
                    if (n == n3) break;
                    ++n;
                }
            }
            int headerLength = n2;
            object = new DataInputStream(new FileInputStream(file));
            Throwable throwable = null;
            try {
                boolean bl;
                String fileHeader;
                block15: {
                    DataInputStream dis = (DataInputStream)object;
                    boolean bl2 = false;
                    byte[] data = new byte[headerLength];
                    dis.read(data);
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    Charset bl3 = charset;
                    fileHeader = new String(data, bl3);
                    Object[] $this$none$iv = headers;
                    boolean $i$f$none = false;
                    int n4 = $this$none$iv.length;
                    for (int i = 0; i < n4; ++i) {
                        Object element$iv;
                        Object it2 = element$iv = $this$none$iv[i];
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it2, (Object)fileHeader)) continue;
                        bl = false;
                        break block15;
                    }
                    bl = true;
                }
                if (bl) {
                    Object[] objectArray2 = new Object[]{fileHeader};
                    ProfilerDumpFileParsingResult profilerDumpFileParsingResult = (ProfilerDumpFileParsingResult)new Success((ProfilerData)new HprofProfilerData(hprof, new IllegalArgumentException(UltimateProfilerBundleKt.profilerMessage("hprof.load.error.unsupportedFormat", objectArray2))));
                    return profilerDumpFileParsingResult;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = new HProfVisitor[]{new ProgressBarWatcherVisitor(path, indicator, 0, 4, null)};
            hprof.loadGeneralInfo(indicator, (HProfVisitor[])object);
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                Disposer.dispose((Disposable)hprof);
                throw e;
            }
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(HprofFileParser.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)e);
            return (ProfilerDumpFileParsingResult)new Success((ProfilerData)new HprofProfilerData(hprof, e));
        }
        return (ProfilerDumpFileParsingResult)new Success((ProfilerData)new HprofProfilerData(hprof, null, 2, null));
    }

    @NotNull
    public String getHelpId() {
        return this.helpId;
    }
}

