/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.ui;

import com.intellij.diagnostic.hprof.parser.Type;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.hprof.api.MuiArray;
import com.intellij.profiler.ultimate.hprof.api.MuiField;
import com.intellij.profiler.ultimate.hprof.api.MuiInstance;
import com.intellij.profiler.ultimate.hprof.api.MuiPage;
import com.intellij.profiler.ultimate.hprof.api.MuiRecord;
import com.intellij.profiler.ultimate.hprof.api.MuiSnapshot;
import com.intellij.profiler.ultimate.hprof.api.MuiType;
import com.intellij.profiler.ultimate.hprof.api.MuiTypes;
import com.intellij.profiler.ultimate.hprof.api.MuiValue;
import com.intellij.profiler.ultimate.hprof.ui.TextFragment;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006H\u0000\u001a\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0003\u001a.\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00122\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0000\u001a \u0010\u0015\u001a\u00020\u00112\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0000\u001a\"\u0010\u0016\u001a\u00020\u000e2\b\b\u0001\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0001\u001a\u001a\u0010\u001b\u001a\u00020\u000e2\b\b\u0001\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0019H\u0001\u001a\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u000eH\u0003\u001a\u0012\u0010\u001e\u001a\u00020\b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002\u001a(\u0010\u001f\u001a\u00020\u00112\b\b\u0001\u0010\u0017\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0014H\u0002\"\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"createTextFragments", "", "Lcom/intellij/profiler/ultimate/hprof/ui/TextFragment;", "value", "", "snapshot", "Lcom/intellij/profiler/ultimate/hprof/api/MuiSnapshot;", "includeObjectAddress", "", "getIncludeObjectAddress", "()Z", "includeObjectAddress$delegate", "Lkotlin/Lazy;", "typeString", "", "Lcom/intellij/diagnostic/hprof/parser/Type;", "appendObjectValue", "", "Lcom/intellij/profiler/ultimate/hprof/api/MuiInstance;", "fragments", "", "appendFieldValue", "substring", "text", "from", "", "to", "repeat", "times", "formatHexValue", "isIntegerValue", "appendFragment", "attributes", "Lcom/intellij/ui/SimpleTextAttributes;", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nRenderUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderUtils.kt\ncom/intellij/profiler/ultimate/hprof/ui/RenderUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,175:1\n1#2:176\n*E\n"})
public final class RenderUtilsKt {
    @NotNull
    private static final Lazy includeObjectAddress$delegate = LazyKt.lazy(RenderUtilsKt::includeObjectAddress_delegate$lambda$1);

    @NotNull
    public static final List<TextFragment> createTextFragments(@Nullable Object value, @NotNull MuiSnapshot<?, ?> snapshot) {
        List list;
        Intrinsics.checkNotNullParameter(snapshot, (String)"snapshot");
        List $this$createTextFragments_u24lambda_u240 = list = (List)new ArrayList();
        boolean bl = false;
        if (value instanceof MuiType) {
            String prettyName;
            int index;
            String string = ((MuiType)value).getName();
            if (string == null) {
                string = "";
            }
            if ((index = StringUtil.lastIndexOf((CharSequence)(prettyName = string), (char)'.', (int)0, (int)prettyName.length())) > 0) {
                String packageName = RenderUtilsKt.substring(prettyName, 0, index + 1);
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
                RenderUtilsKt.appendFragment(packageName, simpleTextAttributes, $this$createTextFragments_u24lambda_u240);
            }
            String className = RenderUtilsKt.substring(prettyName, index + 1, prettyName.length());
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_BOLD_ATTRIBUTES");
            RenderUtilsKt.appendFragment(className, simpleTextAttributes, $this$createTextFragments_u24lambda_u240);
        } else if (value instanceof MuiInstance && ((MuiInstance)value).getId() < 0L && ((MuiInstance)value).getPrettyName() != null) {
            String string = ((MuiInstance)value).getPrettyName();
            Intrinsics.checkNotNull((Object)string);
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"GRAYED_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string, simpleTextAttributes, $this$createTextFragments_u24lambda_u240);
        } else if (value instanceof MuiInstance) {
            RenderUtilsKt.appendObjectValue((MuiInstance)value, snapshot, $this$createTextFragments_u24lambda_u240);
        } else if (value instanceof MuiValue && RenderUtilsKt.isIntegerValue(((MuiValue)value).getValue())) {
            RenderUtilsKt.appendFieldValue(((MuiValue)value).getValue(), $this$createTextFragments_u24lambda_u240);
        } else if (value instanceof MuiValue && ((MuiValue)value).getValue() instanceof Character) {
            String string = "'" + ((MuiValue)value).getValue() + "'";
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string, simpleTextAttributes, $this$createTextFragments_u24lambda_u240);
        } else if (value instanceof MuiValue) {
            String string = String.valueOf(((MuiValue)value).getValue());
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string, simpleTextAttributes, $this$createTextFragments_u24lambda_u240);
        } else if (value instanceof MuiField) {
            if (((MuiField)value).isStatic()) {
                String string = UltimateProfilerBundleKt.profilerMessage("hprof.render.utils.modificators.static", new Object[0]) + " ";
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"GRAYED_ATTRIBUTES");
                RenderUtilsKt.appendFragment(string, simpleTextAttributes, $this$createTextFragments_u24lambda_u240);
            }
            String string = ((MuiField)value).getName() + " = ";
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string, simpleTextAttributes, $this$createTextFragments_u24lambda_u240);
            if (((MuiField)value).getValue() instanceof MuiInstance) {
                Object object = ((MuiField)value).getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.profiler.ultimate.hprof.api.MuiInstance");
                RenderUtilsKt.appendObjectValue((MuiInstance)object, snapshot, $this$createTextFragments_u24lambda_u240);
            } else if (((MuiField)value).getType() != Type.OBJECT && RenderUtilsKt.isIntegerValue(((MuiField)value).getValue())) {
                RenderUtilsKt.appendFieldValue(((MuiField)value).getValue(), $this$createTextFragments_u24lambda_u240);
                String string2 = " " + RenderUtilsKt.typeString(((MuiField)value).getType());
                SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"GRAYED_ATTRIBUTES");
                RenderUtilsKt.appendFragment(string2, simpleTextAttributes2, $this$createTextFragments_u24lambda_u240);
            } else {
                Object object = ((MuiField)value).getValue();
                if (object == null) {
                    object = "null";
                }
                String string3 = String.valueOf(object);
                SimpleTextAttributes simpleTextAttributes3 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes3, (String)"REGULAR_ATTRIBUTES");
                RenderUtilsKt.appendFragment(string3, simpleTextAttributes3, $this$createTextFragments_u24lambda_u240);
                String string4 = " " + RenderUtilsKt.typeString(((MuiField)value).getType());
                SimpleTextAttributes simpleTextAttributes4 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes4, (String)"GRAYED_ATTRIBUTES");
                RenderUtilsKt.appendFragment(string4, simpleTextAttributes4, $this$createTextFragments_u24lambda_u240);
            }
        } else if (value instanceof MuiPage) {
            String string = ((MuiPage)value).getText();
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"GRAYED_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string, simpleTextAttributes, $this$createTextFragments_u24lambda_u240);
        } else {
            String string = String.valueOf(value);
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"GRAYED_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string, simpleTextAttributes, $this$createTextFragments_u24lambda_u240);
        }
        return list;
    }

    private static final boolean getIncludeObjectAddress() {
        Lazy lazy = includeObjectAddress$delegate;
        return (Boolean)lazy.getValue();
    }

    @NlsSafe
    private static final String typeString(Type $this$typeString) {
        String string = $this$typeString.name().toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return string;
    }

    public static final void appendObjectValue(@NotNull MuiInstance value, @NotNull MuiSnapshot<?, ?> snapshot, @NotNull List<TextFragment> fragments) {
        block18: {
            Unit unit;
            String it;
            block13: {
                int index;
                String prettyName;
                MuiType type;
                block15: {
                    Object object;
                    block17: {
                        block16: {
                            block14: {
                                block12: {
                                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                                    Intrinsics.checkNotNullParameter(snapshot, (String)"snapshot");
                                    Intrinsics.checkNotNullParameter(fragments, (String)"fragments");
                                    type = value.getType();
                                    if (value.getPrettyName() == null) break block12;
                                    String string = value.getPrettyName();
                                    Intrinsics.checkNotNull((Object)string);
                                    SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
                                    RenderUtilsKt.appendFragment(string, simpleTextAttributes, fragments);
                                    break block13;
                                }
                                if (type.getId() != snapshot.getIdOfType(MuiTypes.CLASS)) break block14;
                                Object obj = snapshot.getTypeById(value.getId());
                                String string = prettyName = obj != null ? obj.getName() : null;
                                if (prettyName == null) {
                                    MuiRecord muiRecord = value instanceof MuiRecord ? (MuiRecord)value : null;
                                    Object object2 = muiRecord != null ? muiRecord.getFieldValue("name") : null;
                                    Object object3 = object2 instanceof MuiRecord ? (MuiRecord)object2 : null;
                                    if ((object3 == null || (object3 = MuiRecord.getStringValue$default((MuiRecord)object3, "value", 0, 2, null)) == null) && (object3 = value.getType().getName()) == null) {
                                        object3 = UltimateProfilerBundleKt.profilerMessage("hprof.stub.unknown.type", new Object[0]);
                                    }
                                    Object t = object3;
                                    SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"GRAYED_ATTRIBUTES");
                                    RenderUtilsKt.appendFragment((String)t, simpleTextAttributes, fragments);
                                } else {
                                    int index2 = StringUtil.lastIndexOf((CharSequence)prettyName, (char)'.', (int)0, (int)prettyName.length());
                                    if (index2 > 0) {
                                        String packageName = RenderUtilsKt.substring(prettyName, 0, index2 + 1);
                                        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                                        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"GRAYED_ATTRIBUTES");
                                        RenderUtilsKt.appendFragment(packageName, simpleTextAttributes, fragments);
                                    }
                                    String className = RenderUtilsKt.substring(prettyName, index2 + 1, prettyName.length());
                                    SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
                                    RenderUtilsKt.appendFragment(className, simpleTextAttributes, fragments);
                                }
                                break block13;
                            }
                            if (type.getId() != snapshot.getIdOfType(MuiTypes.STRING)) break block15;
                            String stringValue = ((MuiRecord)value).getStringValue("value", 250);
                            object = stringValue;
                            if (object == null) break block16;
                            it = object;
                            boolean bl = false;
                            String string = "'" + it + "'";
                            object = string;
                            if (string != null) break block17;
                        }
                        object = "";
                    }
                    SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
                    RenderUtilsKt.appendFragment((String)object, simpleTextAttributes, fragments);
                    String string = " " + type.getName();
                    SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"GRAYED_ATTRIBUTES");
                    RenderUtilsKt.appendFragment(string, simpleTextAttributes2, fragments);
                    break block13;
                }
                String string = type.getName();
                if (string == null) {
                    string = "";
                }
                if ((index = StringUtil.lastIndexOf((CharSequence)(prettyName = string), (char)'.', (int)0, (int)prettyName.length())) > 0) {
                    String packageName = RenderUtilsKt.substring(prettyName, 0, index + 1);
                    SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"GRAYED_ATTRIBUTES");
                    RenderUtilsKt.appendFragment(packageName, simpleTextAttributes, fragments);
                }
                if (value instanceof MuiArray) {
                    int bracketStartIndex = StringsKt.indexOf$default((CharSequence)prettyName, (char)'[', (int)0, (boolean)false, (int)6, null);
                    String prettyNameWithCount = RenderUtilsKt.substring(prettyName, index + 1, bracketStartIndex);
                    SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
                    RenderUtilsKt.appendFragment(prettyNameWithCount, simpleTextAttributes, fragments);
                    int arrayDimension = (prettyName.length() - bracketStartIndex) / 2;
                    String brackets = RenderUtilsKt.repeat("[]", arrayDimension - 1);
                    String string2 = "[" + ((MuiArray)value).getValueCount() + "]" + brackets;
                    SimpleTextAttributes simpleTextAttributes3 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes3, (String)"GRAYED_ATTRIBUTES");
                    RenderUtilsKt.appendFragment(string2, simpleTextAttributes3, fragments);
                } else {
                    String className = RenderUtilsKt.substring(prettyName, index + 1, prettyName.length());
                    SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
                    RenderUtilsKt.appendFragment(className, simpleTextAttributes, fragments);
                }
            }
            Unit $this$appendObjectValue_u24lambda_u244 = unit = Unit.INSTANCE;
            boolean bl = false;
            if (RenderUtilsKt.getIncludeObjectAddress()) {
                String string = Long.toHexString(value.getId());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(...)");
                String string3 = ", " + RenderUtilsKt.formatHexValue(string);
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"GRAYED_ATTRIBUTES");
                RenderUtilsKt.appendFragment(string3, simpleTextAttributes, fragments);
            }
            String string = snapshot.getRootReason(value.getId());
            if (string == null) break block18;
            it = string;
            boolean bl2 = false;
            Object[] objectArray = new Object[]{it};
            String string4 = ", " + UltimateProfilerBundleKt.profilerMessage("hprof.render.utils.modificators.gcroot", objectArray);
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"GRAYED_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string4, simpleTextAttributes, fragments);
        }
    }

    public static final void appendFieldValue(@Nullable Object value, @NotNull List<TextFragment> fragments) {
        Intrinsics.checkNotNullParameter(fragments, (String)"fragments");
        Object object = value;
        if (object instanceof Byte) {
            String string = String.valueOf(((Number)value).intValue());
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string, simpleTextAttributes, fragments);
            String string2 = "%02X";
            Object[] objectArray = new Object[]{value};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            String string4 = " " + RenderUtilsKt.formatHexValue(string3);
            SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"GRAYED_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string4, simpleTextAttributes2, fragments);
            String string5 = " '" + (char)((Number)value).byteValue() + "'";
            SimpleTextAttributes simpleTextAttributes3 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes3, (String)"GRAYED_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string5, simpleTextAttributes3, fragments);
        } else if (object instanceof Short) {
            String string = String.valueOf(((Number)value).intValue());
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string, simpleTextAttributes, fragments);
            String string6 = "%04X";
            Object[] objectArray = new Object[]{value};
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
            String string8 = " " + RenderUtilsKt.formatHexValue(string7) + " ";
            SimpleTextAttributes simpleTextAttributes4 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes4, (String)"GRAYED_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string8, simpleTextAttributes4, fragments);
        } else if (object instanceof Integer) {
            String string = String.valueOf(((Number)value).intValue());
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string, simpleTextAttributes, fragments);
            String string9 = "%08X";
            Object[] objectArray = new Object[]{value};
            String string10 = String.format(string9, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"format(...)");
            String string11 = " " + RenderUtilsKt.formatHexValue(string10) + " ";
            SimpleTextAttributes simpleTextAttributes5 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes5, (String)"GRAYED_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string11, simpleTextAttributes5, fragments);
        } else if (object instanceof Long) {
            String string = String.valueOf(((Number)value).longValue());
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string, simpleTextAttributes, fragments);
            String string12 = "%016X";
            Object[] objectArray = new Object[]{value};
            String string13 = String.format(string12, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"format(...)");
            String string14 = " " + RenderUtilsKt.formatHexValue(string13) + " ";
            SimpleTextAttributes simpleTextAttributes6 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes6, (String)"GRAYED_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string14, simpleTextAttributes6, fragments);
        } else {
            String string = String.valueOf(value);
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
            RenderUtilsKt.appendFragment(string, simpleTextAttributes, fragments);
        }
    }

    @NlsSafe
    @NotNull
    public static final String substring(@NlsSafe @NotNull String text, int from, int to) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = text.substring(from, to);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @NlsSafe
    @NotNull
    public static final String repeat(@NlsSafe @NotNull String text, int times) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return StringsKt.repeat((CharSequence)text, (int)times);
    }

    @NlsSafe
    private static final String formatHexValue(String value) {
        return "0x" + value;
    }

    private static final boolean isIntegerValue(Object value) {
        Object object = value;
        return object instanceof Byte ? true : (object instanceof Short ? true : (object instanceof Integer ? true : object instanceof Long));
    }

    private static final void appendFragment(@Nls String text, SimpleTextAttributes attributes, List<TextFragment> fragments) {
        ((Collection)fragments).add(new TextFragment(text, attributes));
    }

    private static final boolean includeObjectAddress_delegate$lambda$1() {
        return Registry.Companion.is("idea.profiler.hprof.show.objectAddress", false);
    }
}

