/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.ui.sunburst;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.ultimate.hprof.ui.sunburst.SunburstPanelElement;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.hover.ListHoverListener;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J:\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/profiler/ultimate/hprof/ui/sunburst/MyRenderer;", "Lcom/intellij/ui/CellRendererPanel;", "Ljavax/swing/ListCellRenderer;", "Lcom/intellij/profiler/ultimate/hprof/ui/sunburst/SunburstPanelElement;", "<init>", "()V", "displayName", "Lcom/intellij/ui/SimpleColoredComponent;", "getDisplayName", "()Lcom/intellij/ui/SimpleColoredComponent;", "size", "Lcom/intellij/ui/components/JBLabel;", "getSize", "()Lcom/intellij/ui/components/JBLabel;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "intellij.profiler.ultimate"})
final class MyRenderer
extends CellRendererPanel
implements ListCellRenderer<SunburstPanelElement> {
    @NotNull
    private final SimpleColoredComponent displayName = new SimpleColoredComponent();
    @NotNull
    private final JBLabel size = new JBLabel();

    public MyRenderer() {
        this.setLayout(new BorderLayout());
        this.displayName.setOpaque(false);
        this.add((Component)this.displayName, "Center");
        this.add((Component)this.size, "East");
    }

    @NotNull
    public final SimpleColoredComponent getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public final JBLabel getSize() {
        return this.size;
    }

    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends SunburstPanelElement> list, @Nullable SunburstPanelElement value, int index, boolean isSelected, boolean cellHasFocus) {
        String string;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Color color = RenderingUtil.getForeground(list, (boolean)isSelected);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getForeground(...)");
        Color foreground = color;
        this.displayName.setForeground(foreground);
        this.size.setForeground(foreground);
        this.displayName.clear();
        this.size.setText("");
        if (value != null) {
            if (index == 0) {
                this.displayName.append(value.getShortName(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                this.size.setFont(UIUtil.getListFont().deriveFont(1));
                this.setBorder(JBUI.Borders.empty((int)4));
            } else if (value.getParent() == null) {
                this.displayName.append(value.getShortName(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                this.size.setForeground(UIUtil.getLabelDisabledForeground());
                this.setBorder((Border)JBUI.Borders.empty((int)4, (int)4, (int)4, (int)4));
            } else {
                this.displayName.append(value.getShortName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                this.size.setFont(UIUtil.getListFont());
                this.setBorder((Border)JBUI.Borders.empty((int)1, (int)4, (int)1, (int)4));
            }
            this.size.setText(StringUtil.formatFileSize((long)value.getSize()));
        }
        if (ListHoverListener.getHoveredIndex(list) == index) {
            SunburstPanelElement sunburstPanelElement = value;
            string = sunburstPanelElement != null ? sunburstPanelElement.getTooltip() : null;
        } else {
            string = null;
        }
        this.setToolTipText(string);
        return (Component)((Object)this);
    }
}

