/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profiler.actions.ImportProfilerResultAction;
import com.intellij.profiler.fileTypes.AbstractSnapshotFileType;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JfrFileType
extends AbstractSnapshotFileType {
    public static final JfrFileType INSTANCE = new JfrFileType();

    private JfrFileType() {
    }

    @NonNls
    @NotNull
    public String getName() {
        return "JFR";
    }

    @NlsContexts.Label
    @NotNull
    public String getDescription() {
        String string = UltimateProfilerBundleKt.profilerMessage("filetype.jfr.dump.description", new Object[0]);
        if (string == null) {
            JfrFileType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = UltimateProfilerBundleKt.profilerMessage("filetype.jfr.dump.display.name", new Object[0]);
        if (string == null) {
            JfrFileType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public String getDefaultExtension() {
        return "jfr";
    }

    public Icon getIcon() {
        return AllIcons.FileTypes.Jfr;
    }

    public boolean openFileInAssociatedApplication(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            JfrFileType.$$$reportNull$$$0(2);
        }
        if (!this.checkBinaryHeader("FLR", file)) {
            return false;
        }
        ImportProfilerResultAction.Companion.importProfilerDumpAsAssociated(project, file.toNioPath().toFile());
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profiler/ultimate/jfr/JfrFileType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profiler/ultimate/jfr/JfrFileType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "openFileInAssociatedApplication";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

