/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr.events;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.profiler.DummyCallTreeBuilder;
import com.intellij.profiler.PerformanceHintsManager;
import com.intellij.profiler.Stack;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.SamplesCountMetric;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.model.JVMThread;
import com.intellij.profiler.model.ThreadInfo;
import com.intellij.profiler.ultimate.jfr.JFRMethodCall;
import com.intellij.profiler.ultimate.jfr.KotlinInlineJFRMethodCall;
import com.intellij.profiler.ultimate.jfr.MultipleStepsProgressTracker;
import com.intellij.profiler.ultimate.jfr.SDEStorage;
import com.intellij.profiler.ultimate.jfr.events.JfrEvent;
import com.intellij.profiler.ultimate.jfr.events.JfrEventGroup;
import com.intellij.profiler.ultimate.jfr.events.JfrEventTypesBuilder;
import com.intellij.profiler.ultimate.jfr.events.JfrEvents;
import com.intellij.profiler.ultimate.jfr.events.JfrSamplingEvents;
import com.intellij.profiler.ultimate.jfr.events.JfrThreadTimelineData;
import com.intellij.profiler.ultimate.jfr.events.JfrThreadTimestampInfoStorage;
import com.intellij.profiler.ultimate.jfr.events.JfrTimelineEvents;
import com.intellij.profiler.ultimate.jfr.ui.JfrTimelineEventKind;
import com.intellij.profiler.ultimate.model.BaseJavaCall;
import com.intellij.profiler.ultimate.model.BaseJavaMethodCall;
import com.intellij.profiler.ultimate.model.JavaCachingStackElementReader;
import com.intellij.profiler.ultimate.model.OtherJavaCall;
import com.intellij.profiler.ultimate.ui.grouping.DefaultJavaProjectCodeGrouper;
import com.intellij.profiler.ultimate.ui.grouping.JavaNonProjectCodeGrouper;
import com.intellij.profiler.ultimate.util.Deduplicator;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.Interner;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.IMCThreadGroup;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.parser.ValueField;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001:\u0005efghiBQ\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013B#\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0015J\u001b\u00100\u001a\u0010\u0012\u0004\u0012\u00020 \u0012\u0006\u0012\u0004\u0018\u00010201H\u0000\u00a2\u0006\u0002\b3J#\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u000e\u0010<\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010>0=\u00a2\u0006\u0002\u0010?J%\u0010F\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020;2\u000e\u0010<\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010>0=H\u0014\u00a2\u0006\u0002\u0010GJ'\u0010H\u001a\u0004\u0018\u00010/2\u0006\u0010:\u001a\u00020;2\u000e\u0010<\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010>0=H\u0014\u00a2\u0006\u0002\u0010IJ%\u0010J\u001a\u0002052\u0006\u0010:\u001a\u00020;2\u000e\u0010<\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010>0=H\u0014\u00a2\u0006\u0002\u0010KJ%\u0010L\u001a\u00020M2\u0006\u0010:\u001a\u00020;2\u000e\u0010<\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010>0=H\u0014\u00a2\u0006\u0002\u0010NJ\u0016\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020TJ\\\u0010U\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0W\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0X\u0018\u00010V*\b\u0012\u0004\u0012\u00020\u000b0Y2\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020/2\u0006\u0010]\u001a\u0002052\u0006\u0010^\u001a\u00020\u001b2\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020bH\u0002J\u0016\u0010c\u001a\u00020\u001b2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020\u000b0XH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001bX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0#8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b$\u0010%R*\u0010(\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\tj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e`)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010*\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030,0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020/0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\u0002058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u001a\u0010@\u001a\u00020AX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010E\u00a8\u0006j"}, d2={"Lcom/intellij/profiler/ultimate/jfr/events/JfrSamplingSingleEventTypeBuilder;", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEventTypesBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "group", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEventGroup;", "cachingReader", "Lcom/intellij/profiler/ultimate/model/JavaCachingStackElementReader;", "nativeCallsCache", "Ljava/util/HashMap;", "", "Lcom/intellij/profiler/api/BaseCallStackElement;", "jfrMethodCallCache", "", "Lorg/openjdk/jmc/common/IMCFrame;", "Lcom/intellij/profiler/ultimate/jfr/JFRMethodCall;", "timelineEventKind", "Lcom/intellij/profiler/ultimate/jfr/ui/JfrTimelineEventKind;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/ultimate/jfr/events/JfrEventGroup;Lcom/intellij/profiler/ultimate/model/JavaCachingStackElementReader;Ljava/util/HashMap;Ljava/util/Map;Lcom/intellij/profiler/ultimate/jfr/ui/JfrTimelineEventKind;)V", "timelineEvent", "(Lcom/intellij/profiler/ultimate/jfr/events/JfrEventGroup;Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/ultimate/jfr/ui/JfrTimelineEventKind;)V", "getGroup", "()Lcom/intellij/profiler/ultimate/jfr/events/JfrEventGroup;", "setGroup", "(Lcom/intellij/profiler/ultimate/jfr/events/JfrEventGroup;)V", "areEventsDurational", "", "getAreEventsDurational", "()Z", "sampling", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/openjdk/jmc/common/IMCThread;", "Lcom/intellij/profiler/ultimate/jfr/events/JfrSamplingSingleEventTypeBuilder$ThreadData;", "allFrames", "", "getAllFrames", "()Ljava/util/Set;", "allFrames$delegate", "Lkotlin/Lazy;", "maybeResolvedNativeFrames", "Lkotlin/collections/HashMap;", "timeAccessor", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEventTypesBuilder$DataStructureAccessorProvider$AccessorInfo;", "Lorg/openjdk/jmc/common/unit/ITypedQuantity;", "threadAccessor", "stackAccessor", "Lorg/openjdk/jmc/common/IMCStackTrace;", "getTimestampStatistics", "", "Lcom/intellij/profiler/ultimate/jfr/events/JfrSamplingSingleEventTypeBuilder$PerThreadTimestampsStatistics;", "getTimestampStatistics$intellij_profiler_ultimate", "size", "", "getSize", "()J", "addEvent", "", "event", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEvent;", "values", "", "", "(Lcom/intellij/profiler/ultimate/jfr/events/JfrEvent;[Ljava/lang/Object;)V", "valueMetric", "Lcom/intellij/profiler/api/ValueMetric;", "getValueMetric", "()Lcom/intellij/profiler/api/ValueMetric;", "setValueMetric", "(Lcom/intellij/profiler/api/ValueMetric;)V", "validate", "(Lcom/intellij/profiler/ultimate/jfr/events/JfrEvent;[Ljava/lang/Object;)Z", "getStack", "(Lcom/intellij/profiler/ultimate/jfr/events/JfrEvent;[Ljava/lang/Object;)Lorg/openjdk/jmc/common/IMCStackTrace;", "increment", "(Lcom/intellij/profiler/ultimate/jfr/events/JfrEvent;[Ljava/lang/Object;)J", "duration", "", "(Lcom/intellij/profiler/ultimate/jfr/events/JfrEvent;[Ljava/lang/Object;)I", "create", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEvents;", "progressTracker", "Lcom/intellij/profiler/ultimate/jfr/MultipleStepsProgressTracker;", "context", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEventTypesBuilder$Context;", "addStack", "Lkotlin/Pair;", "Lcom/intellij/profiler/model/CallTreeNode;", "", "Lcom/intellij/profiler/DummyCallTreeBuilder;", "thread", "Lcom/intellij/profiler/model/ThreadInfo;", "stack", "value", "ignoreNativeStacks", "sdeStorage", "Lcom/intellij/profiler/ultimate/jfr/SDEStorage;", "deduplicator", "Lcom/intellij/profiler/ultimate/util/Deduplicator;", "startsWithNativeFrame", "frames", "JFRStackTraceWrapper", "PerThreadTimestampsStatistics", "ThreadData", "StackTraceData", "NullThread", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nJfrEventType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JfrEventType.kt\ncom/intellij/profiler/ultimate/jfr/events/JfrSamplingSingleEventTypeBuilder\n+ 2 JfrEventType.kt\ncom/intellij/profiler/ultimate/jfr/events/JfrEventTypesBuilder\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 JfrEventType.kt\ncom/intellij/profiler/ultimate/jfr/events/JfrSamplingSingleEventTypeBuilder$StackTraceData\n*L\n1#1,713:1\n132#2:714\n131#2,2:715\n131#2,2:717\n462#3:719\n412#3:720\n381#3,7:747\n1246#4,2:721\n1249#4:724\n1557#4:744\n1628#4,2:745\n1630#4:754\n1557#4:755\n1628#4,3:756\n1454#4,5:759\n1#5:723\n216#6:725\n216#6:726\n217#6:742\n217#6:743\n481#7,15:727\n*S KotlinDebug\n*F\n+ 1 JfrEventType.kt\ncom/intellij/profiler/ultimate/jfr/events/JfrSamplingSingleEventTypeBuilder\n*L\n285#1:714\n289#1:715,2\n290#1:717,2\n292#1:719\n292#1:720\n404#1:747,7\n292#1:721,2\n292#1:724\n394#1:744\n394#1:745,2\n394#1:754\n279#1:755\n279#1:756,3\n281#1:759,5\n356#1:725\n368#1:726\n368#1:742\n356#1:743\n376#1:727,15\n*E\n"})
public class JfrSamplingSingleEventTypeBuilder
extends JfrEventTypesBuilder {
    @Nullable
    private final Project project;
    @NotNull
    private JfrEventGroup group;
    @NotNull
    private final JavaCachingStackElementReader cachingReader;
    @NotNull
    private final HashMap<String, BaseCallStackElement> nativeCallsCache;
    @NotNull
    private final Map<IMCFrame, JFRMethodCall> jfrMethodCallCache;
    @NotNull
    private final JfrTimelineEventKind timelineEventKind;
    private final boolean areEventsDurational;
    @NotNull
    private final ConcurrentHashMap<IMCThread, ThreadData> sampling;
    @NotNull
    private final Lazy allFrames$delegate;
    @NotNull
    private HashMap<IMCFrame, IMCFrame> maybeResolvedNativeFrames;
    @NotNull
    private final JfrEventTypesBuilder.DataStructureAccessorProvider.AccessorInfo<ITypedQuantity<?>> timeAccessor;
    @NotNull
    private final JfrEventTypesBuilder.DataStructureAccessorProvider.AccessorInfo<IMCThread> threadAccessor;
    @NotNull
    private final JfrEventTypesBuilder.DataStructureAccessorProvider.AccessorInfo<IMCStackTrace> stackAccessor;
    @NotNull
    private ValueMetric valueMetric;

    public JfrSamplingSingleEventTypeBuilder(@Nullable Project project, @NotNull JfrEventGroup group, @NotNull JavaCachingStackElementReader cachingReader, @NotNull HashMap<String, BaseCallStackElement> nativeCallsCache, @NotNull Map<IMCFrame, JFRMethodCall> jfrMethodCallCache, @NotNull JfrTimelineEventKind timelineEventKind) {
        JfrEventTypesBuilder this_$iv$iv;
        JfrEventTypesBuilder this_$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
        Intrinsics.checkNotNullParameter((Object)((Object)cachingReader), (String)"cachingReader");
        Intrinsics.checkNotNullParameter(nativeCallsCache, (String)"nativeCallsCache");
        Intrinsics.checkNotNullParameter(jfrMethodCallCache, (String)"jfrMethodCallCache");
        Intrinsics.checkNotNullParameter((Object)((Object)timelineEventKind), (String)"timelineEventKind");
        this.project = project;
        this.group = group;
        this.cachingReader = cachingReader;
        this.nativeCallsCache = nativeCallsCache;
        this.jfrMethodCallCache = jfrMethodCallCache;
        this.timelineEventKind = timelineEventKind;
        this.sampling = new ConcurrentHashMap();
        this.allFrames$delegate = LazyKt.lazy(() -> JfrSamplingSingleEventTypeBuilder.allFrames_delegate$lambda$3(this));
        this.maybeResolvedNativeFrames = new HashMap();
        JfrEventTypesBuilder jfrEventTypesBuilder = this;
        Object[] objectArray = new Function1[]{JfrSamplingSingleEventTypeBuilder::timeAccessor$lambda$4, JfrSamplingSingleEventTypeBuilder::timeAccessor$lambda$5};
        List predicates$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$accessor = false;
        this.timeAccessor = JfrEventTypesBuilder.access$getAccessorProvider(this_$iv).create(ITypedQuantity.class, predicates$iv);
        this_$iv = this;
        Function1 predicate$iv = JfrSamplingSingleEventTypeBuilder::threadAccessor$lambda$6;
        $i$f$accessor = false;
        JfrEventTypesBuilder jfrEventTypesBuilder2 = this_$iv;
        List predicates$iv$iv = CollectionsKt.listOf((Object)predicate$iv);
        boolean $i$f$accessor2 = false;
        this.threadAccessor = JfrEventTypesBuilder.access$getAccessorProvider(this_$iv$iv).create(IMCThread.class, predicates$iv$iv);
        this_$iv = this;
        predicate$iv = JfrSamplingSingleEventTypeBuilder::stackAccessor$lambda$7;
        $i$f$accessor = false;
        this_$iv$iv = this_$iv;
        predicates$iv$iv = CollectionsKt.listOf((Object)predicate$iv);
        $i$f$accessor2 = false;
        this.stackAccessor = JfrEventTypesBuilder.access$getAccessorProvider(this_$iv$iv).create(IMCStackTrace.class, predicates$iv$iv);
        this.valueMetric = (ValueMetric)SamplesCountMetric.INSTANCE;
    }

    @NotNull
    public final JfrEventGroup getGroup() {
        return this.group;
    }

    public final void setGroup(@NotNull JfrEventGroup jfrEventGroup) {
        Intrinsics.checkNotNullParameter((Object)((Object)jfrEventGroup), (String)"<set-?>");
        this.group = jfrEventGroup;
    }

    public JfrSamplingSingleEventTypeBuilder(@NotNull JfrEventGroup group, @Nullable Project project, @NotNull JfrTimelineEventKind timelineEvent) {
        Intrinsics.checkNotNullParameter((Object)((Object)group), (String)"group");
        Intrinsics.checkNotNullParameter((Object)((Object)timelineEvent), (String)"timelineEvent");
        JavaCachingStackElementReader javaCachingStackElementReader = JavaCachingStackElementReader.Companion.getOrCreate(project);
        HashMap<String, BaseCallStackElement> hashMap = new HashMap<String, BaseCallStackElement>();
        Map map = CollectionFactory.createCustomHashingStrategyMap((HashingStrategy)HashingStrategy.identity());
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createCustomHashingStrategyMap(...)");
        this(project, group, javaCachingStackElementReader, hashMap, map, timelineEvent);
    }

    protected boolean getAreEventsDurational() {
        return this.areEventsDurational;
    }

    @Override
    @NotNull
    public Set<IMCFrame> getAllFrames() {
        Lazy lazy = this.allFrames$delegate;
        return (Set)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<IMCThread, PerThreadTimestampsStatistics> getTimestampStatistics$intellij_profiler_ultimate() {
        void $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv = this.sampling;
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            PerThreadTimestampsStatistics perThreadTimestampsStatistics;
            long l;
            Iterator iterator2;
            void thread;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Collection<StackTraceData> values = ((ThreadData)thread.getValue()).getStacks().values();
            Iterable iterable = values;
            long l2 = 0L;
            for (Object object : iterable) {
                void it;
                iterator2 = (StackTraceData)object;
                l = l2;
                boolean bl3 = false;
                long l3 = it.getValue();
                l2 = l + l3;
            }
            long count = l2;
            if (count == 0L) {
                perThreadTimestampsStatistics = null;
            } else {
                Object object;
                Iterable iterable2 = values;
                l = ((ThreadData)thread.getValue()).getPivot();
                Iterator iterator3 = iterable2.iterator();
                if (!iterator3.hasNext()) {
                    throw new NoSuchElementException();
                }
                StackTraceData it = (StackTraceData)iterator3.next();
                boolean bl4 = false;
                int n = it.getMaxRelativeTimestampEnd();
                while (iterator3.hasNext()) {
                    StackTraceData it2 = (StackTraceData)iterator3.next();
                    $i$a$-maxOf-JfrSamplingSingleEventTypeBuilder$getTimestampStatistics$1$maxEventTime$1 = false;
                    int n2 = it2.getMaxRelativeTimestampEnd();
                    if (n >= n2) continue;
                    n = n2;
                }
                int n3 = n;
                long maxEventTime = l + (long)n3;
                object = values;
                l = ((ThreadData)thread.getValue()).getPivot();
                iterator2 = object.iterator();
                if (!iterator2.hasNext()) {
                    throw new NoSuchElementException();
                }
                StackTraceData it3 = (StackTraceData)iterator2.next();
                boolean bl5 = false;
                int n4 = it3.getMinRelativeTimestampStart();
                while (iterator2.hasNext()) {
                    StackTraceData it4 = (StackTraceData)iterator2.next();
                    $i$a$-minOf-JfrSamplingSingleEventTypeBuilder$getTimestampStatistics$1$minEventTime$1 = false;
                    int n5 = it4.getMinRelativeTimestampStart();
                    if (n4 <= n5) continue;
                    n4 = n5;
                }
                n3 = n4;
                long minEventTime = l + (long)n3;
                perThreadTimestampsStatistics = new PerThreadTimestampsStatistics(minEventTime, maxEventTime, count);
            }
            PerThreadTimestampsStatistics perThreadTimestampsStatistics2 = perThreadTimestampsStatistics;
            map3.put(k, perThreadTimestampsStatistics2);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getSize() {
        Collection<ThreadData> collection = this.sampling.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable iterable = collection;
        long l = 0L;
        for (Object t : iterable) {
            void it;
            ThreadData threadData = (ThreadData)t;
            long l2 = l;
            boolean bl = false;
            long l3 = it.getStacks().size();
            l = l2 + l3;
        }
        return l;
    }

    @Override
    public final void addEvent(@NotNull JfrEvent event, @NotNull Object[] values) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        if (!this.validate(event, values)) {
            return;
        }
        IMCStackTrace iMCStackTrace = this.getStack(event, values);
        if (iMCStackTrace == null) {
            return;
        }
        IMCStackTrace stack = iMCStackTrace;
        ITypedQuantity<?> iTypedQuantity = this.timeAccessor.invoke(event).get(values);
        if (iTypedQuantity == null) {
            return;
        }
        long timeMs = iTypedQuantity.clampedLongValueIn(UnitLookup.EPOCH_MS);
        IMCThread thread = this.threadAccessor.invoke(event).get(values);
        IMCThread iMCThread = thread;
        if (iMCThread == null) {
            iMCThread = NullThread.INSTANCE;
        }
        ThreadData threadData = this.sampling.computeIfAbsent(iMCThread, arg_0 -> JfrSamplingSingleEventTypeBuilder.addEvent$lambda$14(JfrSamplingSingleEventTypeBuilder::addEvent$lambda$13, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)threadData, (String)"computeIfAbsent(...)");
        ThreadData threadData2 = threadData;
        long increment = this.increment(event, values);
        int duration = this.duration(event, values);
        threadData2.add(stack, timeMs, duration, increment);
    }

    @NotNull
    public final ValueMetric getValueMetric() {
        return this.valueMetric;
    }

    public final void setValueMetric(@NotNull ValueMetric valueMetric) {
        Intrinsics.checkNotNullParameter((Object)valueMetric, (String)"<set-?>");
        this.valueMetric = valueMetric;
    }

    protected boolean validate(@NotNull JfrEvent event, @NotNull Object[] values) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return true;
    }

    @Nullable
    protected IMCStackTrace getStack(@NotNull JfrEvent event, @NotNull Object[] values) {
        JFRStackTraceWrapper jFRStackTraceWrapper;
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        IMCStackTrace iMCStackTrace = this.stackAccessor.invoke(event).get(values);
        if (iMCStackTrace != null) {
            IMCStackTrace it = iMCStackTrace;
            boolean bl = false;
            jFRStackTraceWrapper = new JFRStackTraceWrapper(it);
        } else {
            jFRStackTraceWrapper = null;
        }
        return jFRStackTraceWrapper;
    }

    protected long increment(@NotNull JfrEvent event, @NotNull Object[] values) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return 1L;
    }

    protected int duration(@NotNull JfrEvent event, @NotNull Object[] values) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public final JfrEvents create(@NotNull MultipleStepsProgressTracker progressTracker, @NotNull JfrEventTypesBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)progressTracker, (String)"progressTracker");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.maybeResolvedNativeFrames = context.getMaybeResolvedNativeFrames();
        $this$create_u24lambda_u2416 = var4_3 = CollectionsKt.createListBuilder();
        $i$a$-buildList-JfrSamplingSingleEventTypeBuilder$create$groupers$1 = false;
        if (this.project != null && Registry.Companion.is("idea.profiler.folding.foldNonProjectNodes", true)) {
            $this$create_u24lambda_u2416.add(new JavaNonProjectCodeGrouper(this.project));
        }
        $this$create_u24lambda_u2416.add(new DefaultJavaProjectCodeGrouper(this.project));
        groupers = CollectionsKt.build((List)var4_3);
        $this$create_u24lambda_u2416 = Registry.Companion.is("profiler.drop.frames.with.generated.names", false);
        if ($this$create_u24lambda_u2416) {
            v0 = (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, create$lambda$17(com.intellij.profiler.api.BaseCallStackElement ), (Lcom/intellij/profiler/api/BaseCallStackElement;)Ljava/lang/Boolean;)();
        } else if (!$this$create_u24lambda_u2416) {
            v0 = (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, create$lambda$18(com.intellij.profiler.api.BaseCallStackElement ), (Lcom/intellij/profiler/api/BaseCallStackElement;)Ljava/lang/Boolean;)();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        filter = v0;
        $this$create_u24lambda_u2419 = $i$a$-buildList-JfrSamplingSingleEventTypeBuilder$create$groupers$1 = new DummyCallTreeBuilder(groupers, filter);
        $i$a$-apply-JfrSamplingSingleEventTypeBuilder$create$tree$1 = false;
        $this$create_u24lambda_u2419.setMetric(this.valueMetric);
        tree = $i$a$-buildList-JfrSamplingSingleEventTypeBuilder$create$groupers$1;
        timelineData = new LinkedHashMap<K, V>();
        sdeStorage = new SDEStorage(this.project);
        deduplicator = new Deduplicator();
        needRawStacks = this.project == null || PerformanceHintsManager.Companion.getInstance(this.project).hasListeners() != false;
        rawStacks = needRawStacks != false ? (List)new ArrayList<E>() : null;
        $this$forEach$iv = this.sampling;
        $i$f$forEach = false;
        var13_17 = $this$forEach$iv.entrySet().iterator();
        while (var13_17.hasNext()) {
            var15_19 = element$iv = var13_17.next();
            $i$a$-forEach-JfrSamplingSingleEventTypeBuilder$create$1 = false;
            thread = (IMCThread)var15_19.getKey();
            threadSampling = (ThreadData)var15_19.getValue();
            v1 = thread.getThreadId();
            if (v1 == null) ** GOTO lbl-1000
            var19_24 = v1;
            it = ((Number)var19_24).longValue();
            $i$a$-takeIf-JfrSamplingSingleEventTypeBuilder$create$1$threadInfo$1 = false;
            v1 = it > 0L != false ? var19_24 : null;
            if (v1 != null) {
                v2 = v1.toString();
            } else lbl-1000:
            // 2 sources

            {
                v2 = v3 = null;
            }
            if (v2 == null) {
                v3 = "";
            }
            if ((v4 = thread.getThreadName()) == null) {
                v4 = "Unknown Thread";
            }
            var51_57 = v4;
            var52_58 = v3;
            threadInfo = new JVMThread(var52_58, var51_57);
            var25_31 = threadSampling.getStacks().values();
            var19_23 = 0;
            for (T var27_33 : var25_31) {
                $i$a$-takeIf-JfrSamplingSingleEventTypeBuilder$create$1$threadInfo$1 = (StackTraceData)var27_33;
                var23_29 = var19_23;
                $i$a$-sumOfInt-JfrSamplingSingleEventTypeBuilder$create$1$timestamps$1 = false;
                var29_35 = it.getSize();
                var19_23 = var23_29 + var29_35;
            }
            var53_59 = (Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, create$lambda$26$lambda$22(com.intellij.profiler.ultimate.jfr.events.JfrSamplingSingleEventTypeBuilder com.intellij.profiler.ultimate.jfr.events.JfrEventTypesBuilder$Context com.intellij.profiler.model.CallTreeNode ), (Lcom/intellij/profiler/model/CallTreeNode;)Ljava/lang/Integer;)((JfrSamplingSingleEventTypeBuilder)this, (JfrEventTypesBuilder.Context)context);
            var54_60 = this.getAreEventsDurational();
            var55_61 = var19_23;
            timestamps = new JfrThreadTimestampInfoStorage<CallTreeNode<BaseCallStackElement>>(var55_61, var54_60, var53_59);
            $this$forEach$iv = threadSampling.getStacks();
            $i$f$forEach = false;
            var26_32 = $this$forEach$iv.entrySet().iterator();
            while (var26_32.hasNext()) {
                var22_28 = element$iv = (Map.Entry)var26_32.next();
                $i$a$-forEach-JfrSamplingSingleEventTypeBuilder$create$1$1 = false;
                stack = (IMCStackTrace)var22_28.getKey();
                data = (StackTraceData)var22_28.getValue();
                progressTracker.checkCanceled();
                value = 0L;
                value = data.getValue();
                if (this.isCpuEvent() && context.getWallClockIntervalMs() != null && value > 0L) {
                    value = Math.max(1L, MathKt.roundToLong((double)((double)value * context.getWallClockIntervalMs())));
                }
                if (this.addStack((DummyCallTreeBuilder<BaseCallStackElement>)tree, (ThreadInfo)threadInfo, stack, value, context.getIgnoreNativeStacks(), sdeStorage, deduplicator) != null) {
                    var34_40 = var33_39;
                    $i$a$-also-JfrSamplingSingleEventTypeBuilder$create$1$1$1 = false;
                    top = (CallTreeNode)var34_40.component1();
                    stack = (List)var34_40.component2();
                    v5 = rawStacks;
                    if (v5 != null) {
                        v5.add(new Stack((ThreadInfo)threadInfo, stack, value));
                    }
                    this_$iv = data;
                    $i$f$forEachTimestamp = false;
                    idx$iv = 0;
                    currentEndIterator$iv = StackTraceData.access$getRelativeTimestampEndIndices$p(this_$iv).intIterator();
                    currentEnd$iv = currentEndIterator$iv.hasNext() != false ? Integer.valueOf(currentEndIterator$iv.nextInt()) : null;
                    var44_50 = ((Collection)StackTraceData.access$getRelativeTimestamps$p(this_$iv)).size();
                    for (i$iv = 0; i$iv < var44_50; ++i$iv) {
                        start$iv = StackTraceData.access$getRelativeTimestamps$p(this_$iv).getInt(i$iv);
                        v6 = currentEnd$iv;
                        var46_52 = i$iv;
                        if (v6 != null && v6 == var46_52) {
                            currentEnd$iv = currentEndIterator$iv.hasNext() != false ? Integer.valueOf(currentEndIterator$iv.nextInt()) : null;
                            v7 = StackTraceData.access$getRelativeTimestampEnds$p(this_$iv).getInt(idx$iv++);
                        } else {
                            v7 = start$iv;
                        }
                        var48_54 = end$iv = v7;
                        start = start$iv;
                        $i$a$-forEachTimestamp-JfrSamplingSingleEventTypeBuilder$create$1$1$1$1 = false;
                        timestamps.set(start, (int)end, (CallTreeNode<BaseCallStackElement>)top);
                    }
                }
                progressTracker.addProgress(1L);
            }
            if (timestamps.isEmpty()) continue;
            timelineData.put(threadInfo, new JfrThreadTimelineData(this.timelineEventKind, threadSampling.getPivot(), timestamps));
        }
        return new JfrEvents(CollectionsKt.listOf((Object)new JfrSamplingEvents(this.group, (DummyCallTreeBuilder<BaseCallStackElement>)tree, rawStacks)), CollectionsKt.listOf((Object)new JfrTimelineEvents(this.timelineEventKind, timelineData)));
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<CallTreeNode<BaseCallStackElement>, List<BaseCallStackElement>> addStack(DummyCallTreeBuilder<BaseCallStackElement> $this$addStack, ThreadInfo thread, IMCStackTrace stack, long value, boolean ignoreNativeStacks, SDEStorage sdeStorage, Deduplicator deduplicator) {
        void $this$mapTo$iv$iv;
        List<? extends IMCFrame> list = stack.getFrames();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getFrames(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            BaseCallStackElement baseCallStackElement;
            void frame;
            IMCFrame iMCFrame = (IMCFrame)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IMCFrame.Type type = frame.getType();
            switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    String string;
                    if (Intrinsics.areEqual((Object)frame.getMethod().getMethodName(), (Object)"new")) {
                        string = frame.getMethod().getType().getFullName();
                    } else {
                        IMCFrame iMCFrame2 = this.maybeResolvedNativeFrames.get(frame);
                        if (iMCFrame2 == null) {
                            iMCFrame2 = frame;
                        }
                        string = iMCFrame2.getMethod().getMethodName();
                    }
                    String symbol = string;
                    baseCallStackElement = this.nativeCallsCache.computeIfAbsent(symbol, arg_0 -> JfrSamplingSingleEventTypeBuilder.addStack$lambda$31$lambda$28(arg_0 -> JfrSamplingSingleEventTypeBuilder.addStack$lambda$31$lambda$27(this, symbol, (IMCFrame)frame, arg_0), arg_0));
                    break;
                }
                default: {
                    JFRMethodCall jFRMethodCall;
                    Map<IMCFrame, JFRMethodCall> $this$getOrPut$iv = this.jfrMethodCallCache;
                    boolean $i$f$getOrPut = false;
                    JFRMethodCall value$iv = $this$getOrPut$iv.get(frame);
                    if (value$iv == null) {
                        String[] stringArray;
                        boolean bl2 = false;
                        if (frame.getMethod().getFormalDescriptor() != null) {
                            String it;
                            boolean bl3 = false;
                            stringArray = BaseJavaMethodCall.Companion.signatureFromDescriptor(it, (Interner<String>)this.cachingReader.getStringsInterner());
                        } else {
                            stringArray = null;
                        }
                        String[] argumentTypes = stringArray;
                        Intrinsics.checkNotNull((Object)frame);
                        KotlinInlineJFRMethodCall kotlinInlineJFRMethodCall = KotlinInlineJFRMethodCall.Companion.read(sdeStorage, deduplicator, (IMCFrame)frame, argumentTypes);
                        JFRMethodCall answer$iv = kotlinInlineJFRMethodCall != null ? (JFRMethodCall)kotlinInlineJFRMethodCall : new JFRMethodCall((IMCFrame)frame, argumentTypes);
                        $this$getOrPut$iv.put((IMCFrame)frame, answer$iv);
                        jFRMethodCall = answer$iv;
                    } else {
                        jFRMethodCall = value$iv;
                    }
                    baseCallStackElement = jFRMethodCall;
                }
            }
            collection.add(baseCallStackElement);
        }
        List preparedFrames = CollectionsKt.asReversed((List)((List)destination$iv$iv));
        if (ignoreNativeStacks && this.startsWithNativeFrame(preparedFrames)) {
            return null;
        }
        List stackElements = stack.getTruncationState() == IMCStackTrace.TruncationState.TRUNCATED ? CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.cachingReader.intern(new OtherJavaCall("[truncated]"))), (Iterable)preparedFrames) : preparedFrames;
        CallTreeNode callTreeNode = $this$addStack.addStackAndGetTop(thread, stackElements, value);
        if (callTreeNode == null) {
            return null;
        }
        CallTreeNode top = callTreeNode;
        return TuplesKt.to((Object)top, (Object)stackElements);
    }

    private final boolean startsWithNativeFrame(List<? extends BaseCallStackElement> frames) {
        BaseCallStackElement baseCallStackElement = (BaseCallStackElement)CollectionsKt.firstOrNull(frames);
        if (baseCallStackElement == null) {
            return true;
        }
        BaseCallStackElement firstFrame = baseCallStackElement;
        return !(firstFrame instanceof BaseJavaCall);
    }

    private static final Iterable allFrames_delegate$lambda$3$lambda$1$lambda$0(IMCStackTrace stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        List<? extends IMCFrame> list = stack.getFrames();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getFrames(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final HashSet allFrames_delegate$lambda$3(JfrSamplingSingleEventTypeBuilder this$0) {
        void var2_3;
        void $this$flatMapTo$iv;
        void $this$mapTo$iv$iv;
        Collection<ThreadData> collection = this$0.sampling.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ThreadData threadData = (ThreadData)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(SequencesKt.toHashSet((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)it.getStacks().keySet()), JfrSamplingSingleEventTypeBuilder::allFrames_delegate$lambda$3$lambda$1$lambda$0)));
        }
        $this$map$iv = (List)destination$iv$iv;
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            HashSet it = (HashSet)element$iv;
            boolean bl = false;
            Iterable list$iv = it;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (HashSet)var2_3;
    }

    private static final boolean timeAccessor$lambda$4(ValueField it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.matches(JfrAttributes.START_TIME);
    }

    private static final boolean timeAccessor$lambda$5(ValueField it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.matches(JfrAttributes.END_TIME);
    }

    private static final boolean threadAccessor$lambda$6(ValueField it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.matches(JfrAttributes.EVENT_THREAD);
    }

    private static final boolean stackAccessor$lambda$7(ValueField it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.matches(JfrAttributes.EVENT_STACKTRACE);
    }

    private static final ThreadData addEvent$lambda$13(IMCThread it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ThreadData(null, 1, null);
    }

    private static final ThreadData addEvent$lambda$14(Function1 $tmp0, Object p0) {
        return (ThreadData)$tmp0.invoke(p0);
    }

    private static final boolean create$lambda$17(BaseCallStackElement frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        return !(frame instanceof BaseJavaMethodCall) || Intrinsics.areEqual((Object)BaseJavaMethodCall.Companion.simplifyGeneratedClassName(((BaseJavaMethodCall)frame).getClassName()), (Object)((BaseJavaMethodCall)frame).getClassName());
    }

    private static final boolean create$lambda$18(BaseCallStackElement baseCallStackElement) {
        Intrinsics.checkNotNullParameter((Object)baseCallStackElement, (String)"<unused var>");
        return true;
    }

    private static final int create$lambda$26$lambda$22(JfrSamplingSingleEventTypeBuilder this$0, JfrEventTypesBuilder.Context $context, CallTreeNode it) {
        int n;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.isCpuEvent()) {
            Double d = $context.getWallClockIntervalMs();
            n = d != null ? (int)d.doubleValue() : 0;
        } else {
            n = 0;
        }
        return n;
    }

    private static final BaseCallStackElement addStack$lambda$31$lambda$27(JfrSamplingSingleEventTypeBuilder this$0, String $symbol, IMCFrame $frame, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JavaCachingStackElementReader javaCachingStackElementReader = this$0.cachingReader;
        Intrinsics.checkNotNull((Object)$symbol);
        return javaCachingStackElementReader.parseNativeCall($symbol, $frame.getType().toString());
    }

    private static final BaseCallStackElement addStack$lambda$31$lambda$28(Function1 $tmp0, Object p0) {
        return (BaseCallStackElement)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J6\u0010\u000b\u001a*\u0012\u000e\b\u0001\u0012\n \u000e*\u0004\u0018\u00010\r0\r \u000e*\u0014\u0012\u000e\b\u0001\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0018\u00010\u000f0\fH\u0096\u0001\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\n \u000e*\u0004\u0018\u00010\u00120\u0012H\u0096\u0001\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/profiler/ultimate/jfr/events/JfrSamplingSingleEventTypeBuilder$JFRStackTraceWrapper;", "Lorg/openjdk/jmc/common/IMCStackTrace;", "base", "<init>", "(Lorg/openjdk/jmc/common/IMCStackTrace;)V", "hashCode", "", "equals", "", "other", "", "getFrames", "", "Lorg/openjdk/jmc/common/IMCFrame;", "kotlin.jvm.PlatformType", "", "()Ljava/util/List;", "getTruncationState", "Lorg/openjdk/jmc/common/IMCStackTrace$TruncationState;", "()Lorg/openjdk/jmc/common/IMCStackTrace$TruncationState;", "intellij.profiler.ultimate"})
    private static final class JFRStackTraceWrapper
    implements IMCStackTrace {
        @NotNull
        private final IMCStackTrace base;

        public JFRStackTraceWrapper(@NotNull IMCStackTrace base) {
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            this.base = base;
        }

        public int hashCode() {
            return System.identityHashCode(this.base);
        }

        public boolean equals(@Nullable Object other) {
            if (other == this) {
                return true;
            }
            return other instanceof JFRStackTraceWrapper && ((JFRStackTraceWrapper)other).base == this.base;
        }

        @Override
        public List<? extends IMCFrame> getFrames() {
            return this.base.getFrames();
        }

        @Override
        public IMCStackTrace.TruncationState getTruncationState() {
            return this.base.getTruncationState();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/ultimate/jfr/events/JfrSamplingSingleEventTypeBuilder$NullThread;", "Lorg/openjdk/jmc/common/IMCThread;", "<init>", "()V", "getThreadId", "", "()Ljava/lang/Long;", "getThreadName", "", "getThreadGroup", "Lorg/openjdk/jmc/common/IMCThreadGroup;", "intellij.profiler.ultimate"})
    private static final class NullThread
    implements IMCThread {
        @NotNull
        public static final NullThread INSTANCE = new NullThread();

        private NullThread() {
        }

        @Override
        @NotNull
        public Long getThreadId() {
            return 0L;
        }

        @Override
        @NotNull
        public String getThreadName() {
            return "null";
        }

        @Override
        @Nullable
        public IMCThreadGroup getThreadGroup() {
            return null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/intellij/profiler/ultimate/jfr/events/JfrSamplingSingleEventTypeBuilder$PerThreadTimestampsStatistics;", "", "minEventTime", "", "maxEventTime", "count", "<init>", "(JJJ)V", "getMinEventTime", "()J", "getMaxEventTime", "getCount", "intellij.profiler.ultimate"})
    public static final class PerThreadTimestampsStatistics {
        private final long minEventTime;
        private final long maxEventTime;
        private final long count;

        public PerThreadTimestampsStatistics(long minEventTime, long maxEventTime, long count) {
            this.minEventTime = minEventTime;
            this.maxEventTime = maxEventTime;
            this.count = count;
        }

        public final long getMinEventTime() {
            return this.minEventTime;
        }

        public final long getMaxEventTime() {
            return this.maxEventTime;
        }

        public final long getCount() {
            return this.count;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005JD\u0010\u0018\u001a\u00020\u001526\u0010\u0019\u001a2\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u00150\u001aH\u0086\b\u00f8\u0001\u0000R\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0012\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\r\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001f"}, d2={"Lcom/intellij/profiler/ultimate/jfr/events/JfrSamplingSingleEventTypeBuilder$StackTraceData;", "", "<init>", "()V", "value", "", "getValue", "()J", "relativeTimestamps", "Lit/unimi/dsi/fastutil/ints/IntList;", "size", "", "getSize", "()I", "relativeTimestampEnds", "relativeTimestampEndIndices", "minRelativeTimestampStart", "getMinRelativeTimestampStart", "maxRelativeTimestampEnd", "getMaxRelativeTimestampEnd", "addTimestamp", "", "timestampStart", "duration", "forEachTimestamp", "consume", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "start", "end", "intellij.profiler.ultimate"})
    private static final class StackTraceData {
        private long value;
        @NotNull
        private final IntList relativeTimestamps = (IntList)new IntArrayList();
        @NotNull
        private final IntList relativeTimestampEnds = (IntList)new IntArrayList();
        @NotNull
        private final IntList relativeTimestampEndIndices = (IntList)new IntArrayList();

        public final long getValue() {
            return this.value;
        }

        public final int getSize() {
            return this.relativeTimestamps.size();
        }

        public final int getMinRelativeTimestampStart() {
            Comparable comparable = CollectionsKt.minOrThrow((Iterable)((Iterable)this.relativeTimestamps));
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"min(...)");
            return ((Number)((Object)comparable)).intValue();
        }

        public final int getMaxRelativeTimestampEnd() {
            int n;
            if (this.relativeTimestampEnds.isEmpty()) {
                Comparable comparable = CollectionsKt.maxOrThrow((Iterable)((Iterable)this.relativeTimestamps));
                Intrinsics.checkNotNull((Object)comparable);
                n = ((Number)((Object)comparable)).intValue();
            } else {
                Comparable comparable = CollectionsKt.maxOrThrow((Iterable)((Iterable)this.relativeTimestampEnds));
                Intrinsics.checkNotNull((Object)comparable);
                n = ((Number)((Object)comparable)).intValue();
            }
            return n;
        }

        public final void addTimestamp(int timestampStart, int duration, long value) {
            this.value += value;
            Integer n = timestampStart;
            ((Collection)this.relativeTimestamps).add(n);
            if (duration > 0) {
                ((Collection)this.relativeTimestampEnds).add(timestampStart + duration);
                ((Collection)this.relativeTimestampEndIndices).add(this.relativeTimestamps.size() - 1);
            }
        }

        public final void forEachTimestamp(@NotNull Function2<? super Integer, ? super Integer, Unit> consume) {
            Intrinsics.checkNotNullParameter(consume, (String)"consume");
            boolean $i$f$forEachTimestamp = false;
            int idx = 0;
            IntIterator currentEndIterator = this.relativeTimestampEndIndices.intIterator();
            Integer currentEnd = currentEndIterator.hasNext() ? Integer.valueOf(currentEndIterator.nextInt()) : null;
            int n = ((Collection)this.relativeTimestamps).size();
            for (int i = 0; i < n; ++i) {
                int n2;
                int start2 = this.relativeTimestamps.getInt(i);
                Integer n3 = currentEnd;
                int n4 = i;
                if (n3 != null && n3 == n4) {
                    currentEnd = currentEndIterator.hasNext() ? Integer.valueOf(currentEndIterator.nextInt()) : null;
                    n2 = this.relativeTimestampEnds.getInt(idx++);
                } else {
                    n2 = start2;
                }
                int end = n2;
                consume.invoke((Object)start2, (Object)end);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rJ\u0015\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\u0018\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/intellij/profiler/ultimate/jfr/events/JfrSamplingSingleEventTypeBuilder$ThreadData;", "", "stacks", "", "Lorg/openjdk/jmc/common/IMCStackTrace;", "Lcom/intellij/profiler/ultimate/jfr/events/JfrSamplingSingleEventTypeBuilder$StackTraceData;", "<init>", "(Ljava/util/Map;)V", "getStacks", "()Ljava/util/Map;", "_pivot", "Ljava/util/concurrent/atomic/AtomicLong;", "pivot", "", "getPivot", "()J", "add", "", "stack", "timestampStart", "duration", "", "increment", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.profiler.ultimate"})
    private static final class ThreadData {
        @NotNull
        private final Map<IMCStackTrace, StackTraceData> stacks;
        @NotNull
        private AtomicLong _pivot;

        public ThreadData(@NotNull Map<IMCStackTrace, StackTraceData> stacks) {
            Intrinsics.checkNotNullParameter(stacks, (String)"stacks");
            this.stacks = stacks;
            this._pivot = new AtomicLong(0L);
        }

        public /* synthetic */ ThreadData(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                map = CollectionFactory.createSmallMemoryFootprintMap();
            }
            this(map);
        }

        @NotNull
        public final Map<IMCStackTrace, StackTraceData> getStacks() {
            return this.stacks;
        }

        public final long getPivot() {
            return this._pivot.get();
        }

        public final synchronized void add(@NotNull IMCStackTrace stack, long timestampStart, int duration, long increment) {
            StackTraceData stackTraceData;
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            this._pivot.compareAndSet(0L, timestampStart);
            StackTraceData $this$add_u24lambda_u241 = stackTraceData = this.stacks.computeIfAbsent(stack, ThreadData::add$lambda$0);
            boolean bl = false;
            int relativeStart = (int)(timestampStart - this.getPivot());
            $this$add_u24lambda_u241.addTimestamp(relativeStart, duration, increment);
        }

        @NotNull
        public final Map<IMCStackTrace, StackTraceData> component1() {
            return this.stacks;
        }

        @NotNull
        public final ThreadData copy(@NotNull Map<IMCStackTrace, StackTraceData> stacks) {
            Intrinsics.checkNotNullParameter(stacks, (String)"stacks");
            return new ThreadData(stacks);
        }

        public static /* synthetic */ ThreadData copy$default(ThreadData threadData, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                map = threadData.stacks;
            }
            return threadData.copy(map);
        }

        @NotNull
        public String toString() {
            return "ThreadData(stacks=" + this.stacks + ")";
        }

        public int hashCode() {
            return ((Object)this.stacks).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ThreadData)) {
                return false;
            }
            ThreadData threadData = (ThreadData)other;
            return Intrinsics.areEqual(this.stacks, threadData.stacks);
        }

        private static final StackTraceData add$lambda$0(IMCStackTrace it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new StackTraceData();
        }

        public ThreadData() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IMCFrame.Type.values().length];
            try {
                nArray[IMCFrame.Type.CPP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IMCFrame.Type.NATIVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IMCFrame.Type.KERNEL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IMCFrame.Type.UNKNOWN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

