/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.snapshots;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.SnapshotFile;
import com.intellij.profiler.UtilsKt;
import com.intellij.profiler.api.ProfilerDumpWriterBase;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.snapshots.SnapshotFolderValidator;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00132\u0016\b\u0002\u0010\u0017\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00190\u0018J\u001c\u0010\u001a\u001a\u00020\u001b2\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00190\u0018R(\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u00058F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Lcom/intellij/profiler/ultimate/snapshots/SnapshotFolder;", "", "<init>", "()V", "value", "Ljava/nio/file/Path;", "path", "getPath", "()Ljava/nio/file/Path;", "setPath", "(Ljava/nio/file/Path;)V", "tryCreateFile", "Lcom/intellij/profiler/SnapshotFile;", "name", "", "timestampMs", "", "fileExtension", "project", "Lcom/intellij/openapi/project/Project;", "fileName", "chooseViaDialog", "", "onFolderChange", "Lkotlin/Function1;", "", "createChooseFolderAction", "Lcom/intellij/openapi/project/DumbAwareAction;", "onAction", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nSnapshotFolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnapshotFolder.kt\ncom/intellij/profiler/ultimate/snapshots/SnapshotFolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1#2:122\n*E\n"})
public final class SnapshotFolder {
    @NotNull
    public static final SnapshotFolder INSTANCE = new SnapshotFolder();

    private SnapshotFolder() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Path getPath() {
        String string;
        String string2 = ((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getSnapshotOptions().getFolder();
        String string3 = string2;
        if (string2 == null) return null;
        String p0 = string = string3;
        boolean $i$f$_get_path_$stub_for_inlining = false;
        boolean bl = false;
        if (StringsKt.isBlank((CharSequence)p0)) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        String string4 = string;
        string3 = string4;
        if (string4 == null) return null;
        p0 = string3;
        boolean bl3 = false;
        Path path = Path.of(p0, new String[0]);
        return path;
    }

    private final void setPath(Path value) {
        Path path;
        ((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getSnapshotOptions().setFolder((path = value) != null && (path = path.toAbsolutePath()) != null ? ((Object)path).toString() : null);
    }

    @NotNull
    public final SnapshotFile tryCreateFile(@NotNull String name, long timestampMs, @NotNull String fileExtension, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)fileExtension, (String)"fileExtension");
        String fileName2 = new ProfilerDumpWriterBase(name, timestampMs){

            public void writeDump(File outputFile, ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            }
        }.getDumpFileName();
        return this.tryCreateFile(fileName2, fileExtension, project);
    }

    @NotNull
    public final SnapshotFile tryCreateFile(@NotNull String fileName2, @NotNull String fileExtension, @Nullable Project project) {
        Path snapshotsFolder;
        SnapshotFolderValidator.ValidationResult validationResult;
        Intrinsics.checkNotNullParameter((Object)fileName2, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)fileExtension, (String)"fileExtension");
        boolean temp = false;
        File dumpFile = null;
        Path path = this.getPath();
        if (path == null) {
            Path path2;
            Path it = path2 = UtilsKt.getDefaultSnapshotFolder();
            boolean bl = false;
            Files.createDirectories(it, new FileAttribute[0]);
            path = path2;
        }
        if ((validationResult = new SnapshotFolderValidator().validate(snapshotsFolder = path)) instanceof SnapshotFolderValidator.ValidationFailure) {
            if (project != null) {
                ((SnapshotFolderValidator.ValidationFailure)validationResult).notifyCreateInTempDirectory(project);
            }
            ProfilerUsageTriggerCollector.INSTANCE.logBadSnapshotFolder(project, ((SnapshotFolderValidator.ValidationFailure)validationResult).getFolderState());
            temp = true;
            dumpFile = FileUtil.createTempFile((File)new File(FileUtil.getTempDirectory()), (String)fileName2, (String)("." + fileExtension), (boolean)false, (boolean)false);
        } else {
            temp = ApplicationManager.getApplication().isUnitTestMode();
            dumpFile = FileUtil.findSequentNonexistentFile((File)snapshotsFolder.toFile(), (String)FileUtil.sanitizeFileName((String)fileName2), (String)fileExtension);
        }
        return new SnapshotFile(dumpFile, temp);
    }

    public final boolean chooseViaDialog(@NotNull Project project, @NotNull Function1<? super Path, Unit> onFolderChange) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(onFolderChange, (String)"onFolderChange");
        TextFieldWithBrowseButton.NoPathCompletion browseField = new TextFieldWithBrowseButton.NoPathCompletion();
        Object object2 = browseField.getTextField();
        JBTextField jBTextField = object2 instanceof JBTextField ? (JBTextField)object2 : null;
        if (jBTextField != null) {
            JBTextField it = jBTextField;
            boolean bl = false;
            it.getEmptyText().setText(((Object)UtilsKt.getDefaultSnapshotFolder()).toString());
        }
        if ((object = this.getPath()) == null || (object = object.toAbsolutePath()) == null || (object = object.toString()) == null) {
            object = "";
        }
        browseField.setText((String)object);
        browseField.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFolderDescriptor(), project));
        object2 = UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.snapshots.noFolder.title", new Object[0]);
        JTextField jTextField = browseField.getTextField();
        DialogPanel bl = BuilderKt.panel(arg_0 -> SnapshotFolder.chooseViaDialog$lambda$4(browseField, arg_0));
        DialogWrapper dialog = ComponentsKt.dialog$default((String)object2, (JComponent)((JComponent)bl), (boolean)false, (JComponent)jTextField, (boolean)false, null, null, null, null, null, () -> SnapshotFolder.chooseViaDialog$lambda$5(browseField), (int)1012, null);
        boolean answer = dialog.showAndGet();
        if (answer) {
            String string = browseField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.isBlank((CharSequence)string)) {
                this.setPath(null);
                onFolderChange.invoke(null);
            } else {
                Path it = Path.of(browseField.getText(), new String[0]);
                boolean bl2 = false;
                INSTANCE.setPath(it);
                onFolderChange.invoke((Object)it);
            }
        }
        return answer;
    }

    public static /* synthetic */ boolean chooseViaDialog$default(SnapshotFolder snapshotFolder, Project project, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = SnapshotFolder::chooseViaDialog$lambda$1;
        }
        return snapshotFolder.chooseViaDialog(project, (Function1<? super Path, Unit>)function1);
    }

    @NotNull
    public final DumbAwareAction createChooseFolderAction(@NotNull Function1<? super Project, Unit> onAction) {
        Intrinsics.checkNotNullParameter(onAction, (String)"onAction");
        DumbAwareAction dumbAwareAction = DumbAwareAction.create((String)UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.snapshots.setFolder", new Object[0]), arg_0 -> SnapshotFolder.createChooseFolderAction$lambda$9(arg_0 -> SnapshotFolder.createChooseFolderAction$lambda$8(onAction, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction, (String)"create(...)");
        return dumbAwareAction;
    }

    public static /* synthetic */ DumbAwareAction createChooseFolderAction$default(SnapshotFolder snapshotFolder, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = SnapshotFolder::createChooseFolderAction$lambda$7;
        }
        return snapshotFolder.createChooseFolderAction((Function1<? super Project, Unit>)function1);
    }

    private static final Unit chooseViaDialog$lambda$1(Path it) {
        return Unit.INSTANCE;
    }

    private static final Unit chooseViaDialog$lambda$4$lambda$3(TextFieldWithBrowseButton.NoPathCompletion $browseField, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldWithBrowseButtonKt.columns((Cell)Cell.comment$default((Cell)$this$row.cell((JComponent)$browseField).label(UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.snapshots.noFolder.label.text", new Object[0]), LabelPosition.TOP), (String)UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.snapshots.noFolder.comment.text", new Object[0]), (int)0, null, (int)6, null).align((Align)AlignX.FILL.INSTANCE), (int)36);
        return Unit.INSTANCE;
    }

    private static final Unit chooseViaDialog$lambda$4(TextFieldWithBrowseButton.NoPathCompletion $browseField, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> SnapshotFolder.chooseViaDialog$lambda$4$lambda$3($browseField, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final List chooseViaDialog$lambda$5(TextFieldWithBrowseButton.NoPathCompletion $browseField) {
        String string = $browseField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        List result = null;
        if (!StringsKt.isBlank((CharSequence)text)) {
            SnapshotFolderValidator snapshotFolderValidator = new SnapshotFolderValidator();
            Path path = Path.of(text, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            SnapshotFolderValidator.ValidationResult validationResult = snapshotFolderValidator.validate(path);
            if (validationResult instanceof SnapshotFolderValidator.ValidationFailure) {
                result = CollectionsKt.listOf((Object)new ValidationInfo(((SnapshotFolderValidator.ValidationFailure)validationResult).getMessage(), (JComponent)$browseField.getTextField()));
            }
        }
        return result;
    }

    private static final Unit createChooseFolderAction$lambda$7(Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit createChooseFolderAction$lambda$8(Function1 $onAction, AnActionEvent it) {
        Project project = it.getProject();
        if (project != null) {
            $onAction.invoke((Object)project);
            SnapshotFolder.chooseViaDialog$default(INSTANCE, project, null, 2, null);
        }
        return Unit.INSTANCE;
    }

    private static final void createChooseFolderAction$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

