/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.ui;

import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.ui.flamechart.FlameChartColorScheme;
import com.intellij.profiler.ultimate.JavaCallStackElementRenderer;
import com.intellij.profiler.ultimate.JavaFlameChartColorScheme;
import com.intellij.profiler.ultimate.model.BaseJavaMethodCall;
import com.intellij.profiler.ultimate.ui.JavaProjectCodeDetector;
import com.intellij.ui.SimpleTextAttributes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/profiler/ultimate/ui/ProjectCodeAwareJavaCallStackElementRenderer;", "Lcom/intellij/profiler/ultimate/JavaCallStackElementRenderer;", "projectCodeDetector", "Lcom/intellij/profiler/ultimate/ui/JavaProjectCodeDetector;", "<init>", "(Lcom/intellij/profiler/ultimate/ui/JavaProjectCodeDetector;)V", "getColorScheme", "Lcom/intellij/profiler/ui/flamechart/FlameChartColorScheme;", "node", "Lcom/intellij/profiler/api/BaseCallStackElement;", "getRegularAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "getBoldAttributes", "intellij.profiler.ultimate"})
public final class ProjectCodeAwareJavaCallStackElementRenderer
extends JavaCallStackElementRenderer {
    @NotNull
    private final JavaProjectCodeDetector projectCodeDetector;

    public ProjectCodeAwareJavaCallStackElementRenderer(@NotNull JavaProjectCodeDetector projectCodeDetector) {
        Intrinsics.checkNotNullParameter((Object)projectCodeDetector, (String)"projectCodeDetector");
        this.projectCodeDetector = projectCodeDetector;
    }

    @Override
    @NotNull
    public FlameChartColorScheme getColorScheme(@NotNull BaseCallStackElement node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return !(node instanceof BaseJavaMethodCall) ? (FlameChartColorScheme)JavaFlameChartColorScheme.NATIVE.INSTANCE : (this.projectCodeDetector.isInProjectFast((BaseJavaMethodCall)node) ? (FlameChartColorScheme)JavaFlameChartColorScheme.PROJECT.INSTANCE : (FlameChartColorScheme)JavaFlameChartColorScheme.LIBRARY.INSTANCE);
    }

    @Override
    @NotNull
    public SimpleTextAttributes getRegularAttributes(@NotNull BaseCallStackElement node) {
        SimpleTextAttributes simpleTextAttributes;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!(node instanceof BaseJavaMethodCall)) {
            SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            simpleTextAttributes = simpleTextAttributes2;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"GRAYED_ATTRIBUTES");
        } else if (this.projectCodeDetector.isInProjectFast((BaseJavaMethodCall)node)) {
            SimpleTextAttributes simpleTextAttributes3 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            simpleTextAttributes = simpleTextAttributes3;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes3, (String)"REGULAR_ATTRIBUTES");
        } else {
            SimpleTextAttributes simpleTextAttributes4 = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            simpleTextAttributes = simpleTextAttributes4;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes4, (String)"GRAYED_ATTRIBUTES");
        }
        return simpleTextAttributes;
    }

    @Override
    @NotNull
    public SimpleTextAttributes getBoldAttributes(@NotNull BaseCallStackElement node) {
        SimpleTextAttributes simpleTextAttributes;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!(node instanceof BaseJavaMethodCall)) {
            SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES;
            simpleTextAttributes = simpleTextAttributes2;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"GRAYED_BOLD_ATTRIBUTES");
        } else if (this.projectCodeDetector.isInProjectFast((BaseJavaMethodCall)node)) {
            SimpleTextAttributes simpleTextAttributes3 = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            simpleTextAttributes = simpleTextAttributes3;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes3, (String)"REGULAR_BOLD_ATTRIBUTES");
        } else {
            SimpleTextAttributes simpleTextAttributes4 = SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES;
            simpleTextAttributes = simpleTextAttributes4;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes4, (String)"GRAYED_BOLD_ATTRIBUTES");
        }
        return simpleTextAttributes;
    }
}

