/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.welcome;

import com.intellij.profiler.CommonProfilerUISettings;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.ui.ProfilerUIUtilsKt;
import com.intellij.profiler.ultimate.JavaTargetProcess;
import com.intellij.profiler.ultimate.welcome.MyProcess;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBTreeTable;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a\u001a\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0012H\u0002\u001a\u0015\u0010\u0013\u001a\n \u0014*\u0004\u0018\u00010\u00040\u0004H\u0002\u00a2\u0006\u0002\u0010\u0015\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"highlightColor", "Lcom/intellij/ui/JBColor;", "Lorg/jetbrains/annotations/NotNull;", "getBackgroundColor", "Ljava/awt/Color;", "process", "Lcom/intellij/profiler/ultimate/welcome/MyProcess;", "isSelected", "", "getProcessForRow", "table", "Ljavax/swing/JTable;", "row", "", "ideProcessList", "", "", "isIdeProcess", "Lcom/intellij/profiler/ultimate/JavaTargetProcess;", "getHoverColor", "kotlin.jvm.PlatformType", "()Ljava/awt/Color;", "intellij.profiler.ultimate"})
public final class WelcomeScreenPanelKt {
    @NotNull
    private static final JBColor highlightColor;
    @NotNull
    private static final Set<String> ideProcessList;

    private static final Color getBackgroundColor(MyProcess process, boolean isSelected) {
        Color color;
        if (!isSelected && process != null && ((CommonProfilerUiOptions)CommonProfilerUISettings.Companion.getInstance().getState()).getProcessOptions().getHighlightIdeProcesses() && (process.isCurrentProcess() || process.isStartedFromCurrentProcess())) {
            return (Color)highlightColor;
        }
        if (isSelected) {
            Color color2 = WelcomeScreenPanelKt.getHoverColor();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getHoverColor(...)");
        } else {
            color = ProfilerUIUtilsKt.BACKGROUND;
        }
        return color;
    }

    private static final MyProcess getProcessForRow(JTable table2, int row) {
        Object object = (JBTreeTable)ComponentUtil.getParentOfType(JBTreeTable.class, (Component)table2);
        Object object2 = object != null && (object = object.getTree()) != null && (object = object.getPathForRow(row)) != null ? ((TreePath)object).getLastPathComponent() : null;
        return object2 instanceof MyProcess ? (MyProcess)object2 : null;
    }

    private static final boolean isIdeProcess(JavaTargetProcess process) {
        return ideProcessList.contains(process.getFullName());
    }

    private static final Color getHoverColor() {
        return ExperimentalUI.Companion.isNewUI() ? JBUI.CurrentTheme.List.Tag.BACKGROUND : JBUI.CurrentTheme.Table.Hover.background((boolean)true);
    }

    private static final Color highlightColor$lambda$0() {
        Color color = WelcomeScreenPanelKt.getHoverColor();
        return ColorUtil.toAlpha((Color)color, (int)((int)((double)color.getAlpha() * 0.5)));
    }

    public static final /* synthetic */ Color access$getBackgroundColor(MyProcess process, boolean isSelected) {
        return WelcomeScreenPanelKt.getBackgroundColor(process, isSelected);
    }

    public static final /* synthetic */ Color access$getHoverColor() {
        return WelcomeScreenPanelKt.getHoverColor();
    }

    public static final /* synthetic */ MyProcess access$getProcessForRow(JTable table2, int row) {
        return WelcomeScreenPanelKt.getProcessForRow(table2, row);
    }

    public static final /* synthetic */ boolean access$isIdeProcess(JavaTargetProcess process) {
        return WelcomeScreenPanelKt.isIdeProcess(process);
    }

    static {
        JBColor jBColor = JBColor.lazy(WelcomeScreenPanelKt::highlightColor$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"lazy(...)");
        highlightColor = jBColor;
        Object[] objectArray = new String[]{"jetbrains-toolbox", "jetbrains-toolbox.exe", "idea", "idea.exe", "idea64.exe", "org.jetbrains.kotlin.daemon.KotlinCompileDaemon", "org.jetbrains.jps.cmdline.Launcher", "org.jetbrains.idea.maven.server.RemoteMavenServer36", "com.intellij.maven.server.m40.RemoteMavenServer40", "org.gradle.launcher.daemon.bootstrap.GradleDaemon", "com.intellij.idea.Main"};
        ideProcessList = SetsKt.setOf((Object[])objectArray);
    }
}

