/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.beans;

import com.intellij.cdi.beans.CdiAnnotationsProvider;
import com.intellij.cdi.beans.CdiCustomizationProvider;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UDeclaration;

public final class CdiCustomizationManager {
    private static final ExtensionPointName<CdiCustomizationProvider> CUSTOMIZATION_EP_NAME = ExtensionPointName.create((String)"com.intellij.cdi.customizationProvider");
    private static final ExtensionPointName<CdiAnnotationsProvider> ANNOTATIONS_EP_NAME = ExtensionPointName.create((String)"com.intellij.cdi.annotationsProvider");

    @Nullable
    public static CdiCustomizationProvider getCustomization(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            CdiCustomizationManager.$$$reportNull$$$0(0);
        }
        return (CdiCustomizationProvider)CachedValuesManager.getCachedValue((PsiElement)psiElement, () -> {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
            return CachedValueProvider.Result.create((Object)CdiCustomizationManager.getCustomization(module), (Object[])new Object[]{JavaLibraryModificationTracker.getInstance((Project)psiElement.getProject())});
        });
    }

    @Nullable
    public static CdiCustomizationProvider getCustomization(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        return (CdiCustomizationProvider)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create((Object)CdiCustomizationManager.findCustomization(module), (Object[])new Object[]{JavaLibraryModificationTracker.getInstance((Project)module.getProject())}));
    }

    @Nullable
    private static CdiCustomizationProvider findCustomization(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        return (CdiCustomizationProvider)CUSTOMIZATION_EP_NAME.findFirstSafe(provider -> provider.isInstalled(module));
    }

    @NotNull
    public static List<String> getCustomBeanAnnotations(@NotNull Project project) {
        if (project == null) {
            CdiCustomizationManager.$$$reportNull$$$0(1);
        }
        List list = (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            DumbService dumbService = DumbService.getInstance((Project)project);
            if (dumbService.isDumb()) {
                return CachedValueProvider.Result.create(Collections.emptyList(), (Object[])new Object[]{dumbService});
            }
            List<String> availableAnnotations = CdiCustomizationManager.getAvailableCustomAnnotations(project, GlobalSearchScope.allScope((Project)project));
            return CachedValueProvider.Result.createSingleDependency(availableAnnotations, (Object)JavaLibraryModificationTracker.getInstance((Project)project));
        });
        if (list == null) {
            CdiCustomizationManager.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static List<String> getCustomBeanAnnotations(@NotNull Module module) {
        if (module == null) {
            CdiCustomizationManager.$$$reportNull$$$0(3);
        }
        List list = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            DumbService dumbService = DumbService.getInstance((Project)module.getProject());
            if (dumbService.isDumb()) {
                return CachedValueProvider.Result.createSingleDependency(Collections.emptyList(), (Object)dumbService);
            }
            List<String> availableAnnotations = CdiCustomizationManager.getAvailableCustomAnnotations(module.getProject(), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
            return CachedValueProvider.Result.createSingleDependency(availableAnnotations, (Object)JavaLibraryModificationTracker.getInstance((Project)module.getProject()));
        });
        if (list == null) {
            CdiCustomizationManager.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static List<String> getAvailableCustomAnnotations(Project project, GlobalSearchScope scope) {
        JavaPsiFacade javaPsi = JavaPsiFacade.getInstance((Project)project);
        List<String> list = ANNOTATIONS_EP_NAME.getExtensionList().stream().flatMap(provider -> provider.getCustomBeanAnnotations().stream()).filter(annotation -> javaPsi.findClass(annotation, scope) != null).collect(Collectors.toList());
        if (list == null) {
            CdiCustomizationManager.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static List<String> getCustomAlternativeAnnotations(@NotNull Module module) {
        if (module == null) {
            CdiCustomizationManager.$$$reportNull$$$0(6);
        }
        List list = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            DumbService dumbService = DumbService.getInstance((Project)module.getProject());
            if (dumbService.isDumb()) {
                return CachedValueProvider.Result.create(Collections.emptyList(), (Object[])new Object[]{dumbService});
            }
            JavaPsiFacade javaPsi = JavaPsiFacade.getInstance((Project)module.getProject());
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            List availableAnnotations = ANNOTATIONS_EP_NAME.getExtensionList().stream().flatMap(provider -> {
                String annotation = provider.getCustomAlternativeAnnotation();
                return Stream.ofNullable(annotation);
            }).filter(annotation -> javaPsi.findClass(annotation, scope) != null).collect(Collectors.toList());
            return CachedValueProvider.Result.createSingleDependency(availableAnnotations, (Object)JavaLibraryModificationTracker.getInstance((Project)module.getProject()));
        });
        if (list == null) {
            CdiCustomizationManager.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    public static Pair<String, String> getQualifierAnnotationMapping(@NotNull Project project, String qualifierAnnotation) {
        Map customMappings;
        String mapping;
        if (project == null) {
            CdiCustomizationManager.$$$reportNull$$$0(8);
        }
        return (mapping = (String)(customMappings = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            HashMap<String, String> mappings = new HashMap<String, String>();
            for (CdiAnnotationsProvider provider : ANNOTATIONS_EP_NAME.getExtensionList()) {
                mappings.putAll(provider.getCustomQualifierMappings());
            }
            return CachedValueProvider.Result.createSingleDependency(mappings, (Object)JavaLibraryModificationTracker.getInstance((Project)project));
        })).get(qualifierAnnotation)) != null ? new Pair((Object)qualifierAnnotation, (Object)mapping) : null;
    }

    public static boolean hasDefaultBeanAnnotation(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            CdiCustomizationManager.$$$reportNull$$$0(9);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)element, CdiCustomizationManager.getDefaultAnnotations(element.getProject()), (int)0);
    }

    public static boolean hasDefaultBeanAnnotation(@NotNull UDeclaration uDeclaration) {
        PsiElement psi;
        if (uDeclaration == null) {
            CdiCustomizationManager.$$$reportNull$$$0(10);
        }
        if ((psi = uDeclaration.getJavaPsi()) == null) {
            return false;
        }
        return ContainerUtil.exists((Iterable)uDeclaration.getUAnnotations(), uAnno -> ContainerUtil.exists(CdiCustomizationManager.getDefaultAnnotations(psi.getProject()), anno -> Objects.equals(anno, uAnno.getQualifiedName())));
    }

    public static boolean hasMockAnnotation(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            CdiCustomizationManager.$$$reportNull$$$0(11);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)element, CdiCustomizationManager.getMockAnnotations(element.getProject()), (int)0);
    }

    public static boolean hasExtendedInjectionAnnotation(@NotNull PsiModifierListOwner element) {
        if (element == null) {
            CdiCustomizationManager.$$$reportNull$$$0(12);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)element, CdiCustomizationManager.getExtendedInjectionQualifiers(element.getProject()), (int)0);
    }

    public static List<String> getExternalListenerAnnotations(@NotNull Project project) {
        if (project == null) {
            CdiCustomizationManager.$$$reportNull$$$0(13);
        }
        if (DumbService.isDumb((Project)project)) {
            return Collections.emptyList();
        }
        return (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            List availableAnnotations = ANNOTATIONS_EP_NAME.getExtensionList().stream().flatMap(p -> p.getExternalListenerAnnotations().stream()).collect(Collectors.toList());
            return CachedValueProvider.Result.createSingleDependency(availableAnnotations, (Object)JavaLibraryModificationTracker.getInstance((Project)project));
        });
    }

    public static List<PsiClass> getCustomQualifiers(@Nullable Module module) {
        if (module == null) {
            return Collections.emptyList();
        }
        return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            List qualifierFqns = ContainerUtil.flatMap((Iterable)ANNOTATIONS_EP_NAME.getExtensionList(), CdiAnnotationsProvider::getCustomQualifiers);
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
            List customQualifiers = ContainerUtil.mapNotNull((Collection)qualifierFqns, fqn -> javaPsiFacade.findClass(fqn, scope));
            return CachedValueProvider.Result.createSingleDependency((Object)customQualifiers, (Object)JavaLibraryModificationTracker.getInstance((Project)module.getProject()));
        });
    }

    @NotNull
    public static JvmModifier getFieldInjectionAccessModifier(@NotNull Module module) {
        CdiCustomizationProvider customization;
        if (module == null) {
            CdiCustomizationManager.$$$reportNull$$$0(14);
        }
        JvmModifier jvmModifier = (customization = CdiCustomizationManager.getCustomization(module)) == null ? JvmModifier.PRIVATE : customization.getFieldInjectionAccessModifier();
        if (jvmModifier == null) {
            CdiCustomizationManager.$$$reportNull$$$0(15);
        }
        return jvmModifier;
    }

    private static List<String> getDefaultAnnotations(Project project) {
        return (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            Set defaultAnnotations = ContainerUtil.map2SetNotNull((Collection)ANNOTATIONS_EP_NAME.getExtensionList(), CdiAnnotationsProvider::getDefaultAnnotation);
            return CachedValueProvider.Result.createSingleDependency(CdiCustomizationManager.filterExistingAnnotations(project, defaultAnnotations), (Object)JavaLibraryModificationTracker.getInstance((Project)project));
        });
    }

    private static List<String> getMockAnnotations(Project project) {
        return (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            Set mockAnnotations = ContainerUtil.map2SetNotNull((Collection)ANNOTATIONS_EP_NAME.getExtensionList(), CdiAnnotationsProvider::getMockAnnotation);
            return CachedValueProvider.Result.createSingleDependency(CdiCustomizationManager.filterExistingAnnotations(project, mockAnnotations), (Object)JavaLibraryModificationTracker.getInstance((Project)project));
        });
    }

    private static List<String> getExtendedInjectionQualifiers(Project project) {
        return (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            Set<String> customAnnotations = ANNOTATIONS_EP_NAME.getExtensionList().stream().flatMap(ext -> ext.getExtendedInjectionQualifiers().stream()).collect(Collectors.toSet());
            return CachedValueProvider.Result.createSingleDependency(CdiCustomizationManager.filterExistingAnnotations(project, customAnnotations), (Object)JavaLibraryModificationTracker.getInstance((Project)project));
        });
    }

    private static List<String> filterExistingAnnotations(@NotNull Project project, @NotNull Set<String> annotationFqns) {
        if (project == null) {
            CdiCustomizationManager.$$$reportNull$$$0(16);
        }
        if (annotationFqns == null) {
            CdiCustomizationManager.$$$reportNull$$$0(17);
        }
        JavaPsiFacade javaPsi = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        return ContainerUtil.filter(annotationFqns, a -> javaPsi.findClass(a, scope) != null);
    }

    public static boolean isNonInjectableBean(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiCustomizationManager.$$$reportNull$$$0(18);
        }
        return ContainerUtil.exists((Iterable)ANNOTATIONS_EP_NAME.getExtensionList(), provider -> provider.isNonInjectableBean(psiClass));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 7, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/beans/CdiCustomizationManager";
                break;
            }
            case 3: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uDeclaration";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFqns";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/beans/CdiCustomizationManager";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomBeanAnnotations";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableCustomAnnotations";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomAlternativeAnnotations";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldInjectionAccessModifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomization";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCustomBeanAnnotations";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCustomAlternativeAnnotations";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierAnnotationMapping";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasDefaultBeanAnnotation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasMockAnnotation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasExtendedInjectionAnnotation";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getExternalListenerAnnotations";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFieldInjectionAccessModifier";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "filterExistingAnnotations";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isNonInjectableBean";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 7, 15 -> new IllegalStateException(string);
        };
    }
}

