/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.diagram.managers;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.CdiBeanPsiClassDescriptor;
import com.intellij.cdi.diagram.edges.CdiInjectionPointEdge;
import com.intellij.cdi.diagram.edges.CdiProducerEdge;
import com.intellij.cdi.diagram.utils.CdiDiagramCommonUtils;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.actions.DiagramAddElementAction;
import com.intellij.diagram.actions.DiagramDefaultAddElementAction;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.extras.providers.DiagramDnDProvider;
import com.intellij.diagram.util.DiagramSelectionService;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
public final class CdiDiagramExtras
extends DiagramExtras<CdiBeanDescriptor<?>> {
    public void uiDataSnapshot(@NotNull DataSink sink, @NotNull List<DiagramNode<CdiBeanDescriptor<?>>> nodes, @NotNull DiagramBuilder builder) {
        if (sink == null) {
            CdiDiagramExtras.$$$reportNull$$$0(0);
        }
        if (nodes == null) {
            CdiDiagramExtras.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            CdiDiagramExtras.$$$reportNull$$$0(2);
        }
        sink.lazy(CommonDataKeys.NAVIGATABLE, () -> {
            if (!nodes.isEmpty()) {
                CdiBeanDescriptor wrapper = (CdiBeanDescriptor)((DiagramNode)nodes.get(0)).getIdentifyingElement();
                Object wrapped = wrapper.getIdentifyingElement();
                if (wrapped instanceof Navigatable) {
                    Navigatable o = (Navigatable)wrapped;
                    return o;
                }
            } else {
                List edges = DiagramSelectionService.getInstance().getSelectedEdges(builder);
                if (edges.size() == 1) {
                    DiagramEdge edge = (DiagramEdge)edges.get(0);
                    PsiModifierListOwner psiElement = null;
                    if (edge instanceof CdiInjectionPointEdge) {
                        psiElement = ((CdiInjectionPointEdge)edge).getInjectionPointDescriptor().getOwner();
                    }
                    if (edge instanceof CdiProducerEdge) {
                        psiElement = ((CdiProducerEdge)edge).getPsiMember();
                    }
                    if (psiElement instanceof Navigatable) {
                        Navigatable o = (Navigatable)psiElement;
                        return o;
                    }
                }
            }
            return null;
        });
    }

    public String suggestDiagramFileName(CdiBeanDescriptor element) {
        return CdiDiagramCommonUtils.getNodeName(element);
    }

    public DiagramAddElementAction getAddElementHandler() {
        return new DiagramDefaultAddElementAction(){

            @NotNull
            protected Object convertElement(@NotNull Object element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof PsiClass) {
                    CdiBeanPsiClassDescriptor cdiBeanPsiClassDescriptor = CdiDescriptorsFactory.createCdiBeanDescriptor((PsiClass)element);
                    if (cdiBeanPsiClassDescriptor == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return cdiBeanPsiClassDescriptor;
                }
                Object object = super.convertElement(element);
                if (object == null) {
                    1.$$$reportNull$$$0(2);
                }
                return object;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/cdi/diagram/managers/CdiDiagramExtras$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/cdi/diagram/managers/CdiDiagramExtras$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "convertElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "convertElement";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    public DiagramDnDProvider<CdiBeanDescriptor<?>> getDnDProvider() {
        return new DiagramDnDProvider<CdiBeanDescriptor<?>>(){

            public boolean isAcceptedForDnD(Object o, Project project) {
                return o instanceof PsiClass;
            }

            public CdiBeanDescriptor<?>[] wrapToModelObject(Object o, Project project) {
                if (o instanceof PsiClass) {
                    return new CdiBeanDescriptor[]{CdiDescriptorsFactory.createCdiBeanDescriptor((PsiClass)o)};
                }
                return null;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sink";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "nodes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "builder";
                break;
            }
        }
        objectArray[1] = "com/intellij/cdi/diagram/managers/CdiDiagramExtras";
        objectArray[2] = "uiDataSnapshot";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

