/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.gutter;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0017\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0000\u001a\u0017\u0010\u0005\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0017\u0010\u0006\u001a\t\u0018\u00010\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a8\u0006\t"}, d2={"getElementText", "", "Lcom/intellij/openapi/util/NlsSafe;", "element", "Lcom/intellij/psi/PsiMethodCallExpression;", "getContainerText", "getMethodFqn", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "intellij.javaee.cdi"})
public final class CdiGutterUtilsKt {
    @NotNull
    public static final String getElementText(@Nullable PsiMethodCallExpression element) {
        PsiMethodCallExpression psiMethodCallExpression = element;
        Intrinsics.checkNotNull((Object)psiMethodCallExpression);
        String text = SymbolPresentationUtil.getSymbolPresentableText((PsiElement)((PsiElement)psiMethodCallExpression));
        Intrinsics.checkNotNull((Object)text);
        CharSequence charSequence = text;
        Regex regex = new Regex(" ");
        String string = "";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("\n");
        string = "";
        return regex.replace(charSequence, string);
    }

    @Nullable
    public static final String getContainerText(@NotNull PsiMethodCallExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element), PsiMethod.class);
        if (psiMethod == null) {
            return null;
        }
        PsiMethod psiMethod2 = psiMethod;
        String string = CdiGutterUtilsKt.getMethodFqn(psiMethod2);
        if (string == null) {
            string = SymbolPresentationUtil.getSymbolContainerText((PsiElement)((PsiElement)element));
        }
        return string;
    }

    @Nullable
    public static final String getMethodFqn(@NotNull PsiMethod psiMethod) {
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass == null) {
            return null;
        }
        PsiClass containingClass = psiClass;
        StringBuilder sb = new StringBuilder();
        sb.append(SymbolPresentationUtil.getSymbolPresentableText((PsiElement)((PsiElement)containingClass))).append(".");
        sb.append(SymbolPresentationUtil.getSymbolPresentableText((PsiElement)((PsiElement)psiMethod)));
        return sb.toString();
    }
}

