/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CdiAlternativeInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(@NotNull PsiClass psiClass, @NotNull ProblemsHolder holder, @NotNull Module module) {
        PsiAnnotation alternativeAnnotation;
        if (psiClass == null) {
            CdiAlternativeInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            CdiAlternativeInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            CdiAlternativeInspection.$$$reportNull$$$0(2);
        }
        if ((alternativeAnnotation = CdiAlternativeInspection.getAlternativeAnnotation(psiClass)) != null && CdiInjectionUtils.isVetoedClass(module, psiClass)) {
            CdiAlternativeInspection.registerProblem(holder, CdiAlternativeInspection.getIdentifyingElement(alternativeAnnotation), CdiInspectionBundle.message("alternative.bean.should.not.be.vetoed", new Object[0]));
        }
    }

    @Nullable
    private static PsiAnnotation getAlternativeAnnotation(@NotNull PsiClass psiClass) {
        PsiAnnotation annotation;
        if (psiClass == null) {
            CdiAlternativeInspection.$$$reportNull$$$0(3);
        }
        if ((annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{CdiAnnoConstants.ALTERNATIVE_ANNOTATION.fqn((PsiElement)psiClass)})) != null) {
            return annotation;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module != null) {
            return AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getAlternativeStereotypeAnnotationClasses(module)));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cdi/highlighting/CdiAlternativeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getAlternativeAnnotation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

