/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.utils;

import com.intellij.cdi.beans.CdiCustomizationManager;
import com.intellij.cdi.beans.CdiCustomizationProvider;
import com.intellij.cdi.beans.CdiExtensionBeanDescriptor;
import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.javaee.ejb.EjbHelper;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CdiManagedBeanValidationUtils {
    private static final String[] DISALLOWED_ANCESTORS = new String[]{"javax.ejb.EnterpriseBean"};
    @NonNls
    private static final JavaeeClass PERSISTENCE_ENTITY_ANNO = JavaeeClass.create((String)"javax.persistence.Entity");

    private CdiManagedBeanValidationUtils() {
    }

    public static boolean isManagedBean(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiManagedBeanValidationUtils.$$$reportNull$$$0(0);
        }
        return !CdiManagedBeanValidationUtils.isParameterizedType(psiClass) && (CdiManagedBeanValidationUtils.isConcreteClass(psiClass) || CdiManagedBeanValidationUtils.isDecoratorClass(psiClass) || CdiManagedBeanValidationUtils.isAnnotatedAsCustomBean(psiClass)) && !CdiManagedBeanValidationUtils.isNonStaticInner(psiClass) && CdiManagedBeanValidationUtils.hasAppropriateConstructor(psiClass) && !CdiManagedBeanValidationUtils.hasDisallowedAncestor(psiClass) && !CdiManagedBeanValidationUtils.isEjbBean(psiClass) && !CdiManagedBeanValidationUtils.isJpaEntity(psiClass);
    }

    public static boolean isJpaEntity(PsiClass psiClass) {
        return PERSISTENCE_ENTITY_ANNO.isAnnotated(psiClass, 0);
    }

    public static boolean isEjbBean(PsiClass psiClass) {
        EjbHelper helper = EjbHelper.getEjbHelper();
        return helper != null && helper.getEjbRoles(psiClass).length > 0;
    }

    public static boolean hasAppropriateConstructor(@NotNull PsiClass psiClass) {
        PsiMethod[] constructors;
        if (psiClass == null) {
            CdiManagedBeanValidationUtils.$$$reportNull$$$0(1);
        }
        if ((constructors = psiClass.getConstructors()).length == 0) {
            return true;
        }
        for (PsiMethod psiMethod : constructors) {
            if (psiMethod.getParameterList().getParametersCount() == 0 || AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)CdiAnnoConstants.INJECT_ANNOTATION.fqn((PsiElement)psiClass), (int)1)) {
                return true;
            }
            CdiCustomizationProvider customization = CdiCustomizationManager.getCustomization((PsiElement)psiClass);
            if (customization == null || !customization.isImplicitInjectionToConstructorEnabled()) continue;
            return true;
        }
        return CdiManagedBeanValidationUtils.isInstantiatedViaExtensions(psiClass);
    }

    private static boolean isInstantiatedViaExtensions(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiManagedBeanValidationUtils.$$$reportNull$$$0(2);
        }
        PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createType(psiClass);
        for (CdiExtensionBeanDescriptor descriptor : CdiManagedBeanValidationUtils.collectExtensionBeanDescriptors(psiClass)) {
            for (PsiType psiType : descriptor.getSupportedTypes()) {
                if (!psiClassType.isAssignableFrom(psiType)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static Collection<CdiExtensionBeanDescriptor> collectExtensionBeanDescriptors(@NotNull PsiClass psiClass) {
        Module module;
        if (psiClass == null) {
            CdiManagedBeanValidationUtils.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass)) != null) {
            Set<CdiExtensionBeanDescriptor> set = CdiCommonUtils.collectExtensionBeanDescriptors(module);
            if (set == null) {
                CdiManagedBeanValidationUtils.$$$reportNull$$$0(4);
            }
            return set;
        }
        Set<CdiExtensionBeanDescriptor> set = CdiCommonUtils.collectExtensionBeanDescriptors(psiClass.getProject());
        if (set == null) {
            CdiManagedBeanValidationUtils.$$$reportNull$$$0(5);
        }
        return set;
    }

    public static boolean hasDisallowedAncestor(PsiClass psiClass) {
        return CdiManagedBeanValidationUtils.getDisallowedAncestor(psiClass) != null;
    }

    @Nullable
    public static String getDisallowedAncestor(PsiClass psiClass) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)psiClass.getProject());
        for (String ancestorFQN : DISALLOWED_ANCESTORS) {
            PsiClass ancestorClass = psiFacade.findClass(ancestorFQN, GlobalSearchScope.allScope((Project)psiClass.getProject()));
            if (ancestorClass == null || !psiClass.isInheritor(ancestorClass, true)) continue;
            return ancestorFQN;
        }
        return null;
    }

    public static boolean isNonStaticInner(PsiClass psiClass) {
        return !psiClass.hasModifierProperty("static") && psiClass.getContainingClass() != null;
    }

    public static boolean isConcreteClass(PsiClass psiClass) {
        return !psiClass.isInterface() && !psiClass.isEnum() && !psiClass.isAnnotationType() && !(psiClass instanceof PsiAnonymousClass) && !psiClass.hasModifierProperty("abstract");
    }

    public static boolean isDecoratorClass(PsiClass psiClass) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)CdiAnnoConstants.DECORATOR_ANNOTATION.fqn((PsiElement)psiClass), (int)0);
    }

    public static boolean isParameterizedType(@Nullable PsiClass psiClass) {
        return psiClass != null && psiClass.hasTypeParameters();
    }

    public static boolean isPassivisingScopeDeclared(PsiModifierListOwner owner) {
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{CdiAnnoConstants.SESSION_SCOPED_ANNOTATION.fqn((PsiElement)owner), CdiAnnoConstants.CONVERSATION_SCOPED_ANNOTATION.fqn((PsiElement)owner)}) != null;
    }

    public static boolean isAnnotatedAsCustomBean(PsiClass psiClass) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, CdiCustomizationManager.getCustomBeanAnnotations(psiClass.getProject()), (int)0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/utils/CdiManagedBeanValidationUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/utils/CdiManagedBeanValidationUtils";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExtensionBeanDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isManagedBean";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasAppropriateConstructor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInstantiatedViaExtensions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectExtensionBeanDescriptors";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

